/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.workflow;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.support.PlainActionFuture;
import org.opensearch.core.action.ActionListener;
import org.opensearch.flowframework.common.FlowFrameworkSettings;
import org.opensearch.flowframework.common.WorkflowResources;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.indices.FlowFrameworkIndicesHandler;
import org.opensearch.flowframework.util.ParseUtils;
import org.opensearch.flowframework.workflow.AbstractRetryableWorkflowStep;
import org.opensearch.flowframework.workflow.WorkflowData;
import org.opensearch.ml.client.MachineLearningNodeClient;
import org.opensearch.ml.common.MLTask;
import org.opensearch.ml.common.transport.deploy.MLDeployModelResponse;
import org.opensearch.threadpool.ThreadPool;

public class DeployModelStep
extends AbstractRetryableWorkflowStep {
    private static final Logger logger = LogManager.getLogger(DeployModelStep.class);
    private final MachineLearningNodeClient mlClient;
    private final FlowFrameworkIndicesHandler flowFrameworkIndicesHandler;
    public static final String NAME = "deploy_model";

    public DeployModelStep(ThreadPool threadPool, MachineLearningNodeClient mlClient, FlowFrameworkIndicesHandler flowFrameworkIndicesHandler, FlowFrameworkSettings flowFrameworkSettings) {
        super(threadPool, mlClient, flowFrameworkIndicesHandler, flowFrameworkSettings);
        this.mlClient = mlClient;
        this.flowFrameworkIndicesHandler = flowFrameworkIndicesHandler;
    }

    @Override
    public PlainActionFuture<WorkflowData> execute(final String currentNodeId, final WorkflowData currentNodeInputs, Map<String, WorkflowData> outputs, Map<String, String> previousNodeInputs) {
        final PlainActionFuture deployModelFuture = PlainActionFuture.newFuture();
        ActionListener<MLDeployModelResponse> actionListener = new ActionListener<MLDeployModelResponse>(){

            public void onResponse(MLDeployModelResponse mlDeployModelResponse) {
                logger.info("Model deployment state {}", (Object)mlDeployModelResponse.getStatus());
                String taskId = mlDeployModelResponse.getTaskId();
                DeployModelStep.this.retryableGetMlTask(currentNodeInputs.getWorkflowId(), currentNodeId, (PlainActionFuture<WorkflowData>)deployModelFuture, taskId, "Deploy model", (ActionListener<MLTask>)ActionListener.wrap(mlTask -> {
                    String resourceName = WorkflowResources.getResourceByWorkflowStep(DeployModelStep.this.getName());
                    String id = DeployModelStep.this.getResourceId((MLTask)mlTask);
                    deployModelFuture.onResponse((Object)new WorkflowData(Map.ofEntries(Map.entry(resourceName, id), Map.entry("register_model_status", mlTask.getState().name())), currentNodeInputs.getWorkflowId(), currentNodeId));
                }, e -> deployModelFuture.onFailure((Exception)new FlowFrameworkException(e.getMessage(), ExceptionsHelper.status((Throwable)e)))));
            }

            public void onFailure(Exception e) {
                logger.error("Failed to deploy model");
                deployModelFuture.onFailure((Exception)new FlowFrameworkException(e.getMessage(), ExceptionsHelper.status((Throwable)e)));
            }
        };
        Set<String> requiredKeys = Set.of("model_id");
        Set<String> optionalKeys = Collections.emptySet();
        try {
            Map<String, Object> inputs = ParseUtils.getInputsFromPreviousSteps(requiredKeys, optionalKeys, currentNodeInputs, outputs, previousNodeInputs);
            String modelId = (String)inputs.get("model_id");
            this.mlClient.deploy(modelId, (ActionListener)actionListener);
        }
        catch (FlowFrameworkException e) {
            deployModelFuture.onFailure((Exception)e);
        }
        return deployModelFuture;
    }

    @Override
    protected String getResourceId(MLTask response) {
        return response.getModelId();
    }

    @Override
    public String getName() {
        return NAME;
    }
}

