/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.workflow;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.support.PlainActionFuture;
import org.opensearch.core.action.ActionListener;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.util.ParseUtils;
import org.opensearch.flowframework.workflow.WorkflowData;
import org.opensearch.flowframework.workflow.WorkflowStep;
import org.opensearch.ml.client.MachineLearningNodeClient;

public class DeleteModelStep
implements WorkflowStep {
    private static final Logger logger = LogManager.getLogger(DeleteModelStep.class);
    private MachineLearningNodeClient mlClient;
    public static final String NAME = "delete_model";

    public DeleteModelStep(MachineLearningNodeClient mlClient) {
        this.mlClient = mlClient;
    }

    @Override
    public PlainActionFuture<WorkflowData> execute(String currentNodeId, final WorkflowData currentNodeInputs, Map<String, WorkflowData> outputs, Map<String, String> previousNodeInputs) {
        final PlainActionFuture deleteModelFuture = PlainActionFuture.newFuture();
        ActionListener<DeleteResponse> actionListener = new ActionListener<DeleteResponse>(){

            public void onResponse(DeleteResponse deleteResponse) {
                deleteModelFuture.onResponse((Object)new WorkflowData(Map.ofEntries(Map.entry("model_id", deleteResponse.getId())), currentNodeInputs.getWorkflowId(), currentNodeInputs.getNodeId()));
            }

            public void onFailure(Exception e) {
                logger.error("Failed to delete model");
                deleteModelFuture.onFailure((Exception)new FlowFrameworkException(e.getMessage(), ExceptionsHelper.status((Throwable)e)));
            }
        };
        Set<String> requiredKeys = Set.of("model_id");
        Set<String> optionalKeys = Collections.emptySet();
        try {
            Map<String, Object> inputs = ParseUtils.getInputsFromPreviousSteps(requiredKeys, optionalKeys, currentNodeInputs, outputs, previousNodeInputs);
            String modelId = inputs.get("model_id").toString();
            this.mlClient.deleteModel(modelId, (ActionListener)actionListener);
        }
        catch (FlowFrameworkException e) {
            deleteModelFuture.onFailure((Exception)e);
        }
        return deleteModelFuture;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

