/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.workflow;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.ingest.PutPipelineRequest;
import org.opensearch.action.support.PlainActionFuture;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.client.Client;
import org.opensearch.client.ClusterAdminClient;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.flowframework.common.WorkflowResources;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.indices.FlowFrameworkIndicesHandler;
import org.opensearch.flowframework.workflow.WorkflowData;
import org.opensearch.flowframework.workflow.WorkflowStep;

public class CreateIngestPipelineStep
implements WorkflowStep {
    private static final Logger logger = LogManager.getLogger(CreateIngestPipelineStep.class);
    public static final String NAME = "create_ingest_pipeline";
    private final ClusterAdminClient clusterAdminClient;
    private final FlowFrameworkIndicesHandler flowFrameworkIndicesHandler;

    public CreateIngestPipelineStep(Client client, FlowFrameworkIndicesHandler flowFrameworkIndicesHandler) {
        this.clusterAdminClient = client.admin().cluster();
        this.flowFrameworkIndicesHandler = flowFrameworkIndicesHandler;
    }

    @Override
    public PlainActionFuture<WorkflowData> execute(String currentNodeId, WorkflowData currentNodeInputs, Map<String, WorkflowData> outputs, Map<String, String> previousNodeInputs) {
        PlainActionFuture createIngestPipelineFuture = PlainActionFuture.newFuture();
        String pipelineId = null;
        String description = null;
        String type = null;
        String modelId = null;
        String inputFieldName = null;
        String outputFieldName = null;
        BytesReference configuration = null;
        ArrayList<WorkflowData> data = new ArrayList<WorkflowData>();
        data.add(currentNodeInputs);
        data.addAll(outputs.values());
        for (WorkflowData workflowData : data) {
            Map<String, Object> content = workflowData.getContent();
            for (Map.Entry<String, Object> entry : content.entrySet()) {
                switch (entry.getKey()) {
                    case "id": {
                        pipelineId = (String)content.get("id");
                        break;
                    }
                    case "description": {
                        description = (String)content.get("description");
                        break;
                    }
                    case "type": {
                        type = (String)content.get("type");
                        break;
                    }
                    case "model_id": {
                        modelId = (String)content.get("model_id");
                        break;
                    }
                    case "input_field_name": {
                        inputFieldName = (String)content.get("input_field_name");
                        break;
                    }
                    case "output_field_name": {
                        outputFieldName = (String)content.get("output_field_name");
                        break;
                    }
                }
            }
            if (!Stream.of(pipelineId, description, modelId, type, inputFieldName, outputFieldName).allMatch(x -> x != null)) continue;
            try {
                configuration = BytesReference.bytes((XContentBuilder)this.buildIngestPipelineRequestContent(description, modelId, type, inputFieldName, outputFieldName));
            }
            catch (IOException e) {
                logger.error("Failed to create ingest pipeline configuration: " + e.getMessage());
                createIngestPipelineFuture.onFailure((Exception)e);
            }
            break;
        }
        if (configuration == null) {
            createIngestPipelineFuture.onFailure((Exception)new IllegalArgumentException("Failed to create ingest pipeline, required inputs not found"));
        } else {
            PutPipelineRequest putPipelineRequest = new PutPipelineRequest(pipelineId, configuration, (MediaType)XContentType.JSON);
            this.clusterAdminClient.putPipeline(putPipelineRequest, ActionListener.wrap(response -> {
                logger.info("Created ingest pipeline : " + putPipelineRequest.getId());
                try {
                    String resourceName = WorkflowResources.getResourceByWorkflowStep(this.getName());
                    this.flowFrameworkIndicesHandler.updateResourceInStateIndex(currentNodeInputs.getWorkflowId(), currentNodeId, this.getName(), putPipelineRequest.getId(), (ActionListener<UpdateResponse>)ActionListener.wrap(updateResponse -> {
                        logger.info("successfully updated resources created in state index: {}", (Object)updateResponse.getIndex());
                        createIngestPipelineFuture.onResponse((Object)new WorkflowData(Map.of(resourceName, putPipelineRequest.getId()), currentNodeInputs.getWorkflowId(), currentNodeInputs.getNodeId()));
                    }, exception -> {
                        logger.error("Failed to update new created resource", (Throwable)exception);
                        createIngestPipelineFuture.onFailure((Exception)new FlowFrameworkException(exception.getMessage(), ExceptionsHelper.status((Throwable)exception)));
                    }));
                }
                catch (Exception e) {
                    logger.error("Failed to parse and update new created resource", (Throwable)e);
                    createIngestPipelineFuture.onFailure((Exception)new FlowFrameworkException(e.getMessage(), ExceptionsHelper.status((Throwable)e)));
                }
            }, exception -> {
                logger.error("Failed to create ingest pipeline : " + exception.getMessage());
                createIngestPipelineFuture.onFailure(exception);
            }));
        }
        return createIngestPipelineFuture;
    }

    @Override
    public String getName() {
        return NAME;
    }

    private XContentBuilder buildIngestPipelineRequestContent(String description, String modelId, String type, String inputFieldName, String outputFieldName) throws IOException {
        return XContentFactory.jsonBuilder().startObject().field("description", description).startArray("processors").startObject().startObject(type).field("model_id", modelId).startObject("field_map").field(inputFieldName, outputFieldName).endObject().endObject().endObject().endArray().endObject();
    }
}

