/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.workflow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.support.PlainActionFuture;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.action.ActionListener;
import org.opensearch.flowframework.common.WorkflowResources;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.indices.FlowFrameworkIndicesHandler;
import org.opensearch.flowframework.workflow.WorkflowData;
import org.opensearch.flowframework.workflow.WorkflowStep;

public class CreateIndexStep
implements WorkflowStep {
    private static final Logger logger = LogManager.getLogger(CreateIndexStep.class);
    private final ClusterService clusterService;
    private final Client client;
    private final FlowFrameworkIndicesHandler flowFrameworkIndicesHandler;
    public static final String NAME = "create_index";
    static Map<String, AtomicBoolean> indexMappingUpdated = new HashMap<String, AtomicBoolean>();

    public CreateIndexStep(ClusterService clusterService, Client client, FlowFrameworkIndicesHandler flowFrameworkIndicesHandler) {
        this.clusterService = clusterService;
        this.client = client;
        this.flowFrameworkIndicesHandler = flowFrameworkIndicesHandler;
    }

    @Override
    public PlainActionFuture<WorkflowData> execute(final String currentNodeId, final WorkflowData currentNodeInputs, Map<String, WorkflowData> outputs, Map<String, String> previousNodeInputs) {
        final PlainActionFuture createIndexFuture = PlainActionFuture.newFuture();
        ActionListener<CreateIndexResponse> actionListener = new ActionListener<CreateIndexResponse>(){

            public void onResponse(CreateIndexResponse createIndexResponse) {
                try {
                    String resourceName = WorkflowResources.getResourceByWorkflowStep(CreateIndexStep.this.getName());
                    logger.info("created index: {}", (Object)createIndexResponse.index());
                    CreateIndexStep.this.flowFrameworkIndicesHandler.updateResourceInStateIndex(currentNodeInputs.getWorkflowId(), currentNodeId, CreateIndexStep.this.getName(), createIndexResponse.index(), (ActionListener<UpdateResponse>)ActionListener.wrap(response -> {
                        logger.info("successfully updated resource created in state index: {}", (Object)response.getIndex());
                        createIndexFuture.onResponse((Object)new WorkflowData(Map.of(resourceName, createIndexResponse.index()), currentNodeInputs.getWorkflowId(), currentNodeId));
                    }, exception -> {
                        logger.error("Failed to update new created resource", (Throwable)exception);
                        createIndexFuture.onFailure((Exception)new FlowFrameworkException(exception.getMessage(), ExceptionsHelper.status((Throwable)exception)));
                    }));
                }
                catch (Exception e) {
                    logger.error("Failed to parse and update new created resource", (Throwable)e);
                    createIndexFuture.onFailure((Exception)new FlowFrameworkException(e.getMessage(), ExceptionsHelper.status((Throwable)e)));
                }
            }

            public void onFailure(Exception e) {
                logger.error("Failed to create an index", (Throwable)e);
                createIndexFuture.onFailure(e);
            }
        };
        String index = null;
        String defaultMappingOption = null;
        Object settings = null;
        ArrayList<WorkflowData> data = new ArrayList<WorkflowData>();
        data.add(currentNodeInputs);
        data.addAll(outputs.values());
        try {
            for (WorkflowData workflowData : data) {
                Map<String, Object> content = workflowData.getContent();
                index = (String)content.get(WorkflowResources.getResourceByWorkflowStep(this.getName()));
                defaultMappingOption = (String)content.get("default_mapping_option");
                if (index == null || defaultMappingOption == null || settings == null) continue;
                break;
            }
        }
        catch (Exception e) {
            logger.error("Failed to find the correct resource for the workflow step", (Throwable)e);
            createIndexFuture.onFailure((Exception)new FlowFrameworkException(e.getMessage(), ExceptionsHelper.status((Throwable)e)));
        }
        try {
            CreateIndexRequest request = new CreateIndexRequest(index).mapping(FlowFrameworkIndicesHandler.getIndexMappings("mappings/" + defaultMappingOption + ".json"), JsonXContent.jsonXContent.mediaType());
            this.client.admin().indices().create(request, (ActionListener)actionListener);
        }
        catch (Exception e) {
            logger.error("Failed to find the right mapping for the index", (Throwable)e);
        }
        return createIndexFuture;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

