/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.workflow;

import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.support.PlainActionFuture;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.flowframework.common.FlowFrameworkSettings;
import org.opensearch.flowframework.common.WorkflowResources;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.indices.FlowFrameworkIndicesHandler;
import org.opensearch.flowframework.util.ParseUtils;
import org.opensearch.flowframework.workflow.AbstractRetryableWorkflowStep;
import org.opensearch.flowframework.workflow.WorkflowData;
import org.opensearch.ml.client.MachineLearningNodeClient;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.MLTask;
import org.opensearch.ml.common.model.MLModelConfig;
import org.opensearch.ml.common.model.MLModelFormat;
import org.opensearch.ml.common.model.TextEmbeddingModelConfig;
import org.opensearch.ml.common.transport.register.MLRegisterModelInput;
import org.opensearch.threadpool.ThreadPool;

public abstract class AbstractRegisterLocalModelStep
extends AbstractRetryableWorkflowStep {
    private static final Logger logger = LogManager.getLogger(AbstractRegisterLocalModelStep.class);
    private final MachineLearningNodeClient mlClient;
    private final FlowFrameworkIndicesHandler flowFrameworkIndicesHandler;

    protected AbstractRegisterLocalModelStep(ThreadPool threadPool, MachineLearningNodeClient mlClient, FlowFrameworkIndicesHandler flowFrameworkIndicesHandler, FlowFrameworkSettings flowFrameworkSettings) {
        super(threadPool, mlClient, flowFrameworkIndicesHandler, flowFrameworkSettings);
        this.mlClient = mlClient;
        this.flowFrameworkIndicesHandler = flowFrameworkIndicesHandler;
    }

    @Override
    public PlainActionFuture<WorkflowData> execute(String currentNodeId, WorkflowData currentNodeInputs, Map<String, WorkflowData> outputs, Map<String, String> previousNodeInputs) {
        PlainActionFuture registerLocalModelFuture = PlainActionFuture.newFuture();
        try {
            Map<String, Object> inputs = ParseUtils.getInputsFromPreviousSteps(this.getRequiredKeys(), this.getOptionalKeys(), currentNodeInputs, outputs, previousNodeInputs);
            String modelName = (String)inputs.get("name");
            String modelVersion = (String)inputs.get("version");
            String modelFormat = (String)inputs.get("model_format");
            String functionName = (String)inputs.get("function_name");
            String modelContentHashValue = (String)inputs.get("model_content_hash_value");
            String url = (String)inputs.get("url");
            String modelType = (String)inputs.get("model_type");
            String embeddingDimension = (String)inputs.get("embedding_dimension");
            String frameworkType = (String)inputs.get("framework_type");
            String description = (String)inputs.get("description");
            String modelGroupId = (String)inputs.get("model_group_id");
            String allConfig = (String)inputs.get("all_config");
            Boolean deploy = (Boolean)inputs.get("deploy");
            MLRegisterModelInput.MLRegisterModelInputBuilder mlInputBuilder = MLRegisterModelInput.builder().modelName(modelName).version(modelVersion).modelFormat(MLModelFormat.from((String)modelFormat));
            if (functionName != null) {
                mlInputBuilder.functionName(FunctionName.from((String)functionName));
            }
            if (modelContentHashValue != null) {
                mlInputBuilder.hashValue(modelContentHashValue);
            }
            if (url != null) {
                mlInputBuilder.url(url);
            }
            if (Stream.of(modelType, embeddingDimension, frameworkType).allMatch(x -> x != null)) {
                TextEmbeddingModelConfig.TextEmbeddingModelConfigBuilder mlConfigBuilder = TextEmbeddingModelConfig.builder().modelType(modelType).embeddingDimension(Integer.valueOf(embeddingDimension)).frameworkType(TextEmbeddingModelConfig.FrameworkType.from((String)frameworkType));
                if (allConfig != null) {
                    mlConfigBuilder.allConfig(allConfig);
                }
                mlInputBuilder.modelConfig((MLModelConfig)mlConfigBuilder.build());
            }
            if (description != null) {
                mlInputBuilder.description(description);
            }
            if (modelGroupId != null) {
                mlInputBuilder.modelGroupId(modelGroupId);
            }
            if (deploy != null) {
                mlInputBuilder.deployModel(deploy.booleanValue());
            }
            MLRegisterModelInput mlInput = mlInputBuilder.build();
            this.mlClient.register(mlInput, ActionListener.wrap(response -> {
                logger.info("Local Model registration task creation successful");
                String taskId = response.getTaskId();
                this.retryableGetMlTask(currentNodeInputs.getWorkflowId(), currentNodeId, (PlainActionFuture<WorkflowData>)registerLocalModelFuture, taskId, "Local model registration", (ActionListener<MLTask>)ActionListener.wrap(mlTask -> {
                    String resourceName = WorkflowResources.getResourceByWorkflowStep(this.getName());
                    String id = this.getResourceId((MLTask)mlTask);
                    if (Boolean.TRUE.equals(deploy)) {
                        this.flowFrameworkIndicesHandler.updateResourceInStateIndex(currentNodeInputs.getWorkflowId(), currentNodeId, "deploy_model", id, (ActionListener<UpdateResponse>)ActionListener.wrap(deployUpdateResponse -> {
                            logger.info("successfully updated resources created in state index: {}", (Object)deployUpdateResponse.getIndex());
                            registerLocalModelFuture.onResponse((Object)new WorkflowData(Map.ofEntries(Map.entry(resourceName, id), Map.entry("register_model_status", mlTask.getState().name())), currentNodeInputs.getWorkflowId(), currentNodeId));
                        }, deployUpdateException -> {
                            logger.error("Failed to update simulated deploy step resource", (Throwable)deployUpdateException);
                            registerLocalModelFuture.onFailure((Exception)new FlowFrameworkException(deployUpdateException.getMessage(), ExceptionsHelper.status((Throwable)deployUpdateException)));
                        }));
                    } else {
                        registerLocalModelFuture.onResponse((Object)new WorkflowData(Map.ofEntries(Map.entry(resourceName, id), Map.entry("register_model_status", mlTask.getState().name())), currentNodeInputs.getWorkflowId(), currentNodeId));
                    }
                }, exception -> registerLocalModelFuture.onFailure(exception)));
            }, exception -> {
                logger.error("Failed to register local model");
                registerLocalModelFuture.onFailure((Exception)new FlowFrameworkException(exception.getMessage(), ExceptionsHelper.status((Throwable)exception)));
            }));
        }
        catch (FlowFrameworkException e) {
            registerLocalModelFuture.onFailure((Exception)e);
        }
        return registerLocalModelFuture;
    }

    protected abstract Set<String> getRequiredKeys();

    protected abstract Set<String> getOptionalKeys();
}

