/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.client.Client;
import org.opensearch.common.io.Streams;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.workflow.WorkflowData;
import org.opensearch.ml.common.agent.LLMSpec;

public class ParseUtils {
    private static final Logger logger = LogManager.getLogger(ParseUtils.class);
    private static final Pattern SUBSTITUTION_PATTERN = Pattern.compile("\\$\\{\\{\\s*(.+)\\.(.+?)\\s*\\}\\}");

    private ParseUtils() {
    }

    public static XContentParser jsonToParser(String json) throws IOException {
        XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, json);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        return parser;
    }

    public static String resourceToString(String path) throws IOException {
        try (InputStream is = ParseUtils.class.getResourceAsStream(path);){
            if (is == null) {
                throw new FileNotFoundException("Resource [" + path + "] not found in classpath");
            }
            StringBuilder sb = new StringBuilder();
            Streams.readAllLines((InputStream)is, sb::append);
            String string = sb.toString();
            return string;
        }
    }

    public static void buildStringToStringMap(XContentBuilder xContentBuilder, Map<?, ?> map) throws IOException {
        xContentBuilder.startObject();
        for (Map.Entry<?, ?> e : map.entrySet()) {
            xContentBuilder.field((String)e.getKey(), (String)e.getValue());
        }
        xContentBuilder.endObject();
    }

    public static void buildStringToObjectMap(XContentBuilder xContentBuilder, Map<?, ?> map) throws IOException {
        xContentBuilder.startObject();
        for (Map.Entry<?, ?> e : map.entrySet()) {
            if (e.getValue() instanceof String) {
                xContentBuilder.field((String)e.getKey(), (String)e.getValue());
                continue;
            }
            xContentBuilder.field((String)e.getKey(), e.getValue());
        }
        xContentBuilder.endObject();
    }

    public static void buildLLMMap(XContentBuilder xContentBuilder, LLMSpec llm) throws IOException {
        String modelId = llm.getModelId();
        Map parameters = llm.getParameters();
        xContentBuilder.field("model_id", modelId);
        xContentBuilder.field("parameters");
        ParseUtils.buildStringToStringMap(xContentBuilder, parameters);
    }

    public static Map<String, String> parseStringToStringMap(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        HashMap<String, String> map = new HashMap<String, String>();
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            map.put(fieldName, parser.text());
        }
        return map;
    }

    public static Map<String, Object> parseStringToObjectMap(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        HashMap<String, Object> map = new HashMap<String, Object>();
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                map.put(fieldName, ParseUtils.parseStringToStringMap(parser));
                continue;
            }
            map.put(fieldName, parser.text());
        }
        return map;
    }

    public static Instant parseInstant(XContentParser parser) throws IOException {
        if (parser.currentToken() != null && parser.currentToken().isValue() && parser.currentToken() != XContentParser.Token.VALUE_NULL) {
            return Instant.ofEpochMilli(parser.longValue());
        }
        return null;
    }

    public static User getUserContext(Client client) {
        String userStr = (String)client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info");
        logger.debug("Filtering result by " + userStr);
        return User.parse((String)userStr);
    }

    public static XContentParser createXContentParserFromRegistry(NamedXContentRegistry xContentRegistry, BytesReference bytesReference) throws IOException {
        return XContentHelper.createParser((NamedXContentRegistry)xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)bytesReference, (MediaType)XContentType.JSON);
    }

    public static Map<String, String> getStringToStringMap(Object map, String fieldName) {
        if (map instanceof Map) {
            return (Map)map;
        }
        throw new IllegalArgumentException("[" + fieldName + "] must be a key-value map.");
    }

    public static Map<String, Object> getInputsFromPreviousSteps(Set<String> requiredInputKeys, Set<String> optionalInputKeys, WorkflowData currentNodeInputs, Map<String, WorkflowData> outputs, Map<String, String> previousNodeInputs) {
        HashSet<String> requiredKeys = new HashSet<String>(requiredInputKeys);
        HashSet<String> keys = new HashSet<String>(requiredInputKeys);
        keys.addAll(optionalInputKeys);
        HashMap<String, Object> inputs = new HashMap<String, Object>();
        for (String key : keys) {
            Optional<Object> matchedValue;
            WorkflowData previousNodeOutput;
            Object value = null;
            Optional<String> previousNodeForKey = previousNodeInputs.entrySet().stream().filter(e -> key.equals(e.getValue())).map(Map.Entry::getKey).findAny();
            if (previousNodeForKey.isPresent() && (previousNodeOutput = outputs.get(previousNodeForKey.get())) != null) {
                value = previousNodeOutput.getContent().get(key);
            }
            if (value == null) {
                value = currentNodeInputs.getParams().get(key);
            }
            if (value == null) {
                value = currentNodeInputs.getContent().get(key);
            }
            if (value == null && (matchedValue = outputs.values().stream().map(WorkflowData::getContent).filter(m -> m.containsKey(key)).map(m -> m.get(key)).findAny()).isPresent()) {
                value = matchedValue.get();
            }
            if (value == null) continue;
            if (value instanceof Map) {
                Map valueMap = (Map)value;
                value = valueMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ParseUtils.conditionallySubstitute(e.getValue(), outputs)));
            } else {
                value = value instanceof List ? ((List)value).stream().map(v -> ParseUtils.conditionallySubstitute(v, outputs)).collect(Collectors.toList()) : ParseUtils.conditionallySubstitute(value, outputs);
            }
            inputs.put(key, value);
            requiredKeys.remove(key);
        }
        if (!requiredKeys.isEmpty()) {
            throw new FlowFrameworkException("Missing required inputs " + String.valueOf(requiredKeys) + " in workflow [" + currentNodeInputs.getWorkflowId() + "] node [" + currentNodeInputs.getNodeId() + "]", RestStatus.BAD_REQUEST);
        }
        return inputs;
    }

    private static Object conditionallySubstitute(Object value, Map<String, WorkflowData> outputs) {
        WorkflowData data;
        Matcher m;
        if (value instanceof String && (m = SUBSTITUTION_PATTERN.matcher((String)value)).matches() && (data = outputs.get(m.group(1))) != null && data.getContent().containsKey(m.group(2))) {
            return data.getContent().get(m.group(2));
        }
        return value;
    }
}

