/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.transport;

import java.io.IOException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.common.Nullable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.flowframework.model.Template;

public class WorkflowRequest
extends ActionRequest {
    @Nullable
    private String workflowId;
    @Nullable
    private Template template;
    private String[] validation;
    private boolean provision;

    public WorkflowRequest(@Nullable String workflowId, @Nullable Template template) {
        this(workflowId, template, new String[]{"all"}, false);
    }

    public WorkflowRequest(@Nullable String workflowId, @Nullable Template template, String[] validation, boolean provision) {
        this.workflowId = workflowId;
        this.template = template;
        this.validation = validation;
        this.provision = provision;
    }

    public WorkflowRequest(StreamInput in) throws IOException {
        super(in);
        this.workflowId = in.readOptionalString();
        String templateJson = in.readOptionalString();
        this.template = templateJson == null ? null : Template.parse(templateJson);
        this.validation = in.readStringArray();
        this.provision = in.readBoolean();
    }

    @Nullable
    public String getWorkflowId() {
        return this.workflowId;
    }

    @Nullable
    public Template getTemplate() {
        return this.template;
    }

    public String[] getValidation() {
        return this.validation;
    }

    public boolean isProvision() {
        return this.provision;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.workflowId);
        out.writeOptionalString(this.template == null ? null : this.template.toJson());
        out.writeStringArray(this.validation);
        out.writeBoolean(this.provision);
    }

    public ActionRequestValidationException validate() {
        return null;
    }
}

