/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.transport;

import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class SearchWorkflowStateTransportAction
extends HandledTransportAction<SearchRequest, SearchResponse> {
    private Client client;

    @Inject
    public SearchWorkflowStateTransportAction(TransportService transportService, ActionFilters actionFilters, Client client) {
        super("cluster:admin/opensearch/flow_framework/workflow_state/search", transportService, actionFilters, SearchRequest::new);
        this.client = client;
    }

    protected void doExecute(Task task, SearchRequest request, ActionListener<SearchResponse> actionListener) {
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.client.search(request, ActionListener.runBefore(actionListener, () -> ((ThreadContext.StoredContext)context).restore()));
        }
        catch (Exception e) {
            actionListener.onFailure(e);
        }
    }
}

