/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.transport;

import java.time.Instant;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.PlainActionFuture;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.client.Client;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.indices.FlowFrameworkIndicesHandler;
import org.opensearch.flowframework.model.ProvisioningProgress;
import org.opensearch.flowframework.model.State;
import org.opensearch.flowframework.model.Template;
import org.opensearch.flowframework.model.Workflow;
import org.opensearch.flowframework.transport.WorkflowRequest;
import org.opensearch.flowframework.transport.WorkflowResponse;
import org.opensearch.flowframework.util.EncryptorUtils;
import org.opensearch.flowframework.workflow.ProcessNode;
import org.opensearch.flowframework.workflow.WorkflowData;
import org.opensearch.flowframework.workflow.WorkflowProcessSorter;
import org.opensearch.plugins.PluginsService;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class ProvisionWorkflowTransportAction
extends HandledTransportAction<WorkflowRequest, WorkflowResponse> {
    private final Logger logger = LogManager.getLogger(ProvisionWorkflowTransportAction.class);
    private final ThreadPool threadPool;
    private final Client client;
    private final WorkflowProcessSorter workflowProcessSorter;
    private final FlowFrameworkIndicesHandler flowFrameworkIndicesHandler;
    private final EncryptorUtils encryptorUtils;
    private final PluginsService pluginsService;

    @Inject
    public ProvisionWorkflowTransportAction(TransportService transportService, ActionFilters actionFilters, ThreadPool threadPool, Client client, WorkflowProcessSorter workflowProcessSorter, FlowFrameworkIndicesHandler flowFrameworkIndicesHandler, EncryptorUtils encryptorUtils, PluginsService pluginsService) {
        super("cluster:admin/opensearch/flow_framework/workflow/provision", transportService, actionFilters, WorkflowRequest::new);
        this.threadPool = threadPool;
        this.client = client;
        this.workflowProcessSorter = workflowProcessSorter;
        this.flowFrameworkIndicesHandler = flowFrameworkIndicesHandler;
        this.encryptorUtils = encryptorUtils;
        this.pluginsService = pluginsService;
    }

    protected void doExecute(Task task, WorkflowRequest request, ActionListener<WorkflowResponse> listener) {
        String workflowId = request.getWorkflowId();
        GetRequest getRequest = new GetRequest(".plugins-flow-framework-templates", workflowId);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.client.get(getRequest, ActionListener.wrap(response -> {
                context.restore();
                if (!response.isExists()) {
                    listener.onFailure((Exception)new FlowFrameworkException("Failed to retrieve template (" + workflowId + ") from global context.", RestStatus.NOT_FOUND));
                    return;
                }
                Template template = Template.parse(response.getSourceAsString());
                template = this.encryptorUtils.decryptTemplateCredentials(template);
                Workflow provisionWorkflow = template.workflows().get("provision");
                List<ProcessNode> provisionProcessSequence = this.workflowProcessSorter.sortProcessNodes(provisionWorkflow, workflowId);
                this.workflowProcessSorter.validate(provisionProcessSequence, this.pluginsService);
                this.flowFrameworkIndicesHandler.isWorkflowNotStarted(workflowId, workflowIsNotStarted -> {
                    if (workflowIsNotStarted.booleanValue()) {
                        this.flowFrameworkIndicesHandler.updateFlowFrameworkSystemIndexDoc(workflowId, Map.ofEntries(Map.entry("state", State.PROVISIONING), Map.entry("provisioning_progress", ProvisioningProgress.IN_PROGRESS), Map.entry("provision_start_time", Instant.now().toEpochMilli()), Map.entry("resources_created", Collections.emptyList())), (ActionListener<UpdateResponse>)ActionListener.wrap(updateResponse -> {
                            this.logger.info("updated workflow {} state to {}", (Object)request.getWorkflowId(), (Object)State.PROVISIONING);
                            this.executeWorkflowAsync(workflowId, provisionProcessSequence, listener);
                            listener.onResponse((Object)new WorkflowResponse(workflowId));
                        }, exception -> {
                            String errorMessage = "Failed to update wowrfow state: " + workflowId;
                            this.logger.error(errorMessage, (Throwable)exception);
                            listener.onFailure((Exception)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)exception)));
                        }));
                    } else {
                        String errorMessage = "The template has already been provisioned: " + workflowId;
                        this.logger.error(errorMessage);
                        listener.onFailure((Exception)new FlowFrameworkException(errorMessage, RestStatus.BAD_REQUEST));
                    }
                }, listener);
            }, exception -> {
                if (exception instanceof FlowFrameworkException) {
                    this.logger.error("Workflow validation failed for workflow : " + workflowId);
                    listener.onFailure(exception);
                } else {
                    this.logger.error("Failed to retrieve template from global context.", (Throwable)exception);
                    listener.onFailure((Exception)new FlowFrameworkException(exception.getMessage(), ExceptionsHelper.status((Throwable)exception)));
                }
            }));
        }
        catch (Exception e) {
            this.logger.error("Failed to retrieve template from global context.", (Throwable)e);
            listener.onFailure((Exception)new FlowFrameworkException(e.getMessage(), ExceptionsHelper.status((Throwable)e)));
        }
    }

    private void executeWorkflowAsync(String workflowId, List<ProcessNode> workflowSequence, ActionListener<WorkflowResponse> listener) {
        try {
            this.threadPool.executor("opensearch_provision_workflow").execute(() -> this.executeWorkflow(workflowSequence, workflowId));
        }
        catch (Exception exception) {
            listener.onFailure((Exception)new FlowFrameworkException(exception.getMessage(), ExceptionsHelper.status((Throwable)exception)));
        }
    }

    private void executeWorkflow(List<ProcessNode> workflowSequence, String workflowId) {
        String currentStepId = "";
        try {
            LinkedHashMap<String, PlainActionFuture<WorkflowData>> workflowFutureMap = new LinkedHashMap<String, PlainActionFuture<WorkflowData>>();
            for (ProcessNode processNode : workflowSequence) {
                List<ProcessNode> predecessors = processNode.predecessors();
                this.logger.info("Queueing process [{}].{}", (Object)processNode.id(), (Object)(predecessors.isEmpty() ? " Can start immediately!" : String.format(Locale.getDefault(), " Must wait for [%s] to complete first.", predecessors.stream().map(p -> p.id()).collect(Collectors.joining(", ")))));
                workflowFutureMap.put(processNode.id(), processNode.execute());
            }
            for (Map.Entry entry : workflowFutureMap.entrySet()) {
                currentStepId = (String)entry.getKey();
                ((PlainActionFuture)entry.getValue()).actionGet();
            }
            this.logger.info("Provisioning completed successfully for workflow {}", (Object)workflowId);
            this.flowFrameworkIndicesHandler.updateFlowFrameworkSystemIndexDoc(workflowId, Map.ofEntries(Map.entry("state", State.COMPLETED), Map.entry("provisioning_progress", ProvisioningProgress.DONE), Map.entry("provision_end_time", Instant.now().toEpochMilli())), (ActionListener<UpdateResponse>)ActionListener.wrap(updateResponse -> this.logger.info("updated workflow {} state to {}", (Object)workflowId, (Object)State.COMPLETED), exception -> this.logger.error("Failed to update workflow state : {}", (Object)exception.getMessage(), exception)));
        }
        catch (Exception ex) {
            this.logger.error("Provisioning failed for workflow {} during step {}.", (Object)workflowId, (Object)currentStepId, (Object)ex);
            String errorMessage = (ex.getCause() == null ? ex.getClass().getName() : ex.getCause().getClass().getName()) + " during step " + currentStepId;
            this.flowFrameworkIndicesHandler.updateFlowFrameworkSystemIndexDoc(workflowId, Map.ofEntries(Map.entry("state", State.FAILED), Map.entry("error", errorMessage), Map.entry("provisioning_progress", ProvisioningProgress.FAILED), Map.entry("provision_end_time", Instant.now().toEpochMilli())), (ActionListener<UpdateResponse>)ActionListener.wrap(updateResponse -> this.logger.info("updated workflow {} state to {}", (Object)workflowId, (Object)State.FAILED), exceptionState -> this.logger.error("Failed to update workflow state : {}", (Object)exceptionState.getMessage(), (Object)ex)));
        }
    }
}

