/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.transport;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.model.WorkflowValidator;
import org.opensearch.flowframework.transport.GetWorkflowStepResponse;
import org.opensearch.flowframework.transport.WorkflowRequest;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class GetWorkflowStepTransportAction
extends HandledTransportAction<ActionRequest, GetWorkflowStepResponse> {
    private final Logger logger = LogManager.getLogger(GetWorkflowStepTransportAction.class);

    @Inject
    public GetWorkflowStepTransportAction(TransportService transportService, ActionFilters actionFilters) {
        super("cluster:admin/opensearch/flow_framework/workflow_step/get", transportService, actionFilters, WorkflowRequest::new);
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<GetWorkflowStepResponse> listener) {
        try {
            listener.onResponse((Object)new GetWorkflowStepResponse(WorkflowValidator.parse("mappings/workflow-steps.json")));
        }
        catch (Exception e) {
            this.logger.error("Failed to retrieve workflow step json.", (Throwable)e);
            listener.onFailure((Exception)new FlowFrameworkException(e.getMessage(), ExceptionsHelper.status((Throwable)e)));
        }
    }
}

