/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.transport;

import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.indices.FlowFrameworkIndicesHandler;
import org.opensearch.flowframework.transport.WorkflowRequest;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class DeleteWorkflowTransportAction
extends HandledTransportAction<WorkflowRequest, DeleteResponse> {
    private final FlowFrameworkIndicesHandler flowFrameworkIndicesHandler;
    private final Client client;

    @Inject
    public DeleteWorkflowTransportAction(TransportService transportService, ActionFilters actionFilters, FlowFrameworkIndicesHandler flowFrameworkIndicesHandler, Client client) {
        super("cluster:admin/opensearch/flow_framework/workflow/delete", transportService, actionFilters, WorkflowRequest::new);
        this.flowFrameworkIndicesHandler = flowFrameworkIndicesHandler;
        this.client = client;
    }

    protected void doExecute(Task task, WorkflowRequest request, ActionListener<DeleteResponse> listener) {
        if (this.flowFrameworkIndicesHandler.doesIndexExist(".plugins-flow-framework-templates")) {
            String workflowId = request.getWorkflowId();
            DeleteRequest deleteRequest = new DeleteRequest(".plugins-flow-framework-templates", workflowId);
            ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();
            this.client.delete(deleteRequest, ActionListener.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore()));
        } else {
            listener.onFailure((Exception)new FlowFrameworkException("There are no templates in the global context.", RestStatus.NOT_FOUND));
        }
    }
}

