/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.transport;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.client.Client;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.flowframework.common.FlowFrameworkSettings;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.indices.FlowFrameworkIndicesHandler;
import org.opensearch.flowframework.model.ProvisioningProgress;
import org.opensearch.flowframework.model.State;
import org.opensearch.flowframework.model.Template;
import org.opensearch.flowframework.model.Workflow;
import org.opensearch.flowframework.transport.ProvisionWorkflowAction;
import org.opensearch.flowframework.transport.WorkflowRequest;
import org.opensearch.flowframework.transport.WorkflowResponse;
import org.opensearch.flowframework.util.ParseUtils;
import org.opensearch.flowframework.workflow.ProcessNode;
import org.opensearch.flowframework.workflow.WorkflowProcessSorter;
import org.opensearch.index.query.MatchAllQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.plugins.PluginsService;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class CreateWorkflowTransportAction
extends HandledTransportAction<WorkflowRequest, WorkflowResponse> {
    private final Logger logger = LogManager.getLogger(CreateWorkflowTransportAction.class);
    private final WorkflowProcessSorter workflowProcessSorter;
    private final FlowFrameworkIndicesHandler flowFrameworkIndicesHandler;
    private final Client client;
    private final FlowFrameworkSettings flowFrameworkSettings;
    private final PluginsService pluginsService;

    @Inject
    public CreateWorkflowTransportAction(TransportService transportService, ActionFilters actionFilters, WorkflowProcessSorter workflowProcessSorter, FlowFrameworkIndicesHandler flowFrameworkIndicesHandler, FlowFrameworkSettings flowFrameworkSettings, Client client, PluginsService pluginsService) {
        super("cluster:admin/opensearch/flow_framework/workflow/create", transportService, actionFilters, WorkflowRequest::new);
        this.workflowProcessSorter = workflowProcessSorter;
        this.flowFrameworkIndicesHandler = flowFrameworkIndicesHandler;
        this.flowFrameworkSettings = flowFrameworkSettings;
        this.client = client;
        this.pluginsService = pluginsService;
    }

    protected void doExecute(Task task, WorkflowRequest request, ActionListener<WorkflowResponse> listener) {
        User user = ParseUtils.getUserContext(this.client);
        Template templateWithUser = new Template(request.getTemplate().name(), request.getTemplate().description(), request.getTemplate().useCase(), request.getTemplate().templateVersion(), request.getTemplate().compatibilityVersion(), request.getTemplate().workflows(), request.getTemplate().getUiMetadata(), user);
        Object[] validateAll = new String[]{"all"};
        if (Arrays.equals(request.getValidation(), validateAll)) {
            try {
                this.validateWorkflows(templateWithUser);
            }
            catch (Exception e2) {
                this.logger.error("Workflow validation failed for template: {}", (Object)templateWithUser.name());
                listener.onFailure(e2 instanceof FlowFrameworkException ? e2 : new FlowFrameworkException(e2.getMessage(), ExceptionsHelper.status((Throwable)e2)));
                return;
            }
        }
        if (request.getWorkflowId() == null) {
            this.checkMaxWorkflows(this.flowFrameworkSettings.getRequestTimeout(), this.flowFrameworkSettings.getMaxWorkflows(), (ActionListener<Boolean>)ActionListener.wrap(max -> {
                if (!max.booleanValue()) {
                    String errorMessage = "Maximum workflows limit reached " + this.flowFrameworkSettings.getMaxWorkflows();
                    this.logger.error(errorMessage);
                    FlowFrameworkException ffe = new FlowFrameworkException(errorMessage, RestStatus.BAD_REQUEST);
                    listener.onFailure((Exception)ffe);
                    return;
                }
                this.flowFrameworkIndicesHandler.initializeConfigIndex((ActionListener<Boolean>)ActionListener.wrap(isInitialized -> {
                    if (!isInitialized.booleanValue()) {
                        listener.onFailure((Exception)new FlowFrameworkException("Failed to initalize config index", RestStatus.INTERNAL_SERVER_ERROR));
                    } else {
                        this.flowFrameworkIndicesHandler.putTemplateToGlobalContext(templateWithUser, (ActionListener<IndexResponse>)ActionListener.wrap(globalContextResponse -> this.flowFrameworkIndicesHandler.putInitialStateToWorkflowState(globalContextResponse.getId(), user, (ActionListener<IndexResponse>)ActionListener.wrap(stateResponse -> {
                            this.logger.info("create state workflow doc");
                            if (request.isProvision()) {
                                this.logger.info("provision parameter");
                                WorkflowRequest workflowRequest = new WorkflowRequest(globalContextResponse.getId(), null);
                                this.client.execute((ActionType)ProvisionWorkflowAction.INSTANCE, (ActionRequest)workflowRequest, ActionListener.wrap(provisionResponse -> listener.onResponse((Object)new WorkflowResponse(provisionResponse.getWorkflowId())), exception -> {
                                    if (exception instanceof FlowFrameworkException) {
                                        listener.onFailure(exception);
                                    } else {
                                        listener.onFailure((Exception)new FlowFrameworkException(exception.getMessage(), RestStatus.BAD_REQUEST));
                                    }
                                    this.logger.error("Failed to send back provision workflow exception", (Throwable)exception);
                                }));
                            } else {
                                listener.onResponse((Object)new WorkflowResponse(globalContextResponse.getId()));
                            }
                        }, exception -> {
                            this.logger.error("Failed to save workflow state : {}", (Object)exception.getMessage());
                            if (exception instanceof FlowFrameworkException) {
                                listener.onFailure(exception);
                            } else {
                                listener.onFailure((Exception)new FlowFrameworkException(exception.getMessage(), RestStatus.BAD_REQUEST));
                            }
                        })), exception -> {
                            this.logger.error("Failed to save use case template : {}", (Object)exception.getMessage());
                            if (exception instanceof FlowFrameworkException) {
                                listener.onFailure(exception);
                            } else {
                                listener.onFailure((Exception)new FlowFrameworkException(exception.getMessage(), ExceptionsHelper.status((Throwable)exception)));
                            }
                        }));
                    }
                }, exception -> {
                    this.logger.error("Failed to initialize config index : {}", (Object)exception.getMessage());
                    if (exception instanceof FlowFrameworkException) {
                        listener.onFailure(exception);
                    } else {
                        listener.onFailure((Exception)new FlowFrameworkException(exception.getMessage(), ExceptionsHelper.status((Throwable)exception)));
                    }
                }));
            }, e -> {
                this.logger.error("Failed to updated use case template {} : {}", (Object)request.getWorkflowId(), (Object)e.getMessage());
                if (e instanceof FlowFrameworkException) {
                    listener.onFailure(e);
                } else {
                    listener.onFailure((Exception)new FlowFrameworkException(e.getMessage(), ExceptionsHelper.status((Throwable)e)));
                }
            }));
        } else {
            this.flowFrameworkIndicesHandler.updateTemplateInGlobalContext(request.getWorkflowId(), request.getTemplate(), (ActionListener<IndexResponse>)ActionListener.wrap(response -> this.flowFrameworkIndicesHandler.updateFlowFrameworkSystemIndexDoc(request.getWorkflowId(), Map.ofEntries(Map.entry("state", State.NOT_STARTED), Map.entry("provisioning_progress", ProvisioningProgress.NOT_STARTED)), (ActionListener<UpdateResponse>)ActionListener.wrap(updateResponse -> {
                this.logger.info("updated workflow {} state to {}", (Object)request.getWorkflowId(), (Object)State.NOT_STARTED.name());
                listener.onResponse((Object)new WorkflowResponse(request.getWorkflowId()));
            }, exception -> {
                this.logger.error("Failed to update workflow in template index: ", (Throwable)exception);
                if (exception instanceof FlowFrameworkException) {
                    listener.onFailure(exception);
                } else {
                    listener.onFailure((Exception)new FlowFrameworkException(exception.getMessage(), ExceptionsHelper.status((Throwable)exception)));
                }
            })), exception -> {
                this.logger.error("Failed to updated use case template {} : {}", (Object)request.getWorkflowId(), (Object)exception.getMessage());
                if (exception instanceof FlowFrameworkException) {
                    listener.onFailure(exception);
                } else {
                    listener.onFailure((Exception)new FlowFrameworkException(exception.getMessage(), ExceptionsHelper.status((Throwable)exception)));
                }
            }));
        }
    }

    void checkMaxWorkflows(TimeValue requestTimeOut, Integer maxWorkflow, ActionListener<Boolean> internalListener) {
        if (!this.flowFrameworkIndicesHandler.doesIndexExist(".plugins-flow-framework-templates")) {
            internalListener.onResponse((Object)true);
        } else {
            MatchAllQueryBuilder query = QueryBuilders.matchAllQuery();
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)query).size(0).timeout(requestTimeOut);
            SearchRequest searchRequest = new SearchRequest(new String[]{".plugins-flow-framework-templates"}).source(searchSourceBuilder);
            try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                this.client.search(searchRequest, ActionListener.wrap(searchResponse -> internalListener.onResponse((Object)(searchResponse.getHits().getTotalHits().value < (long)maxWorkflow.intValue() ? 1 : 0)), exception -> {
                    this.logger.error("Unable to fetch the workflows", (Throwable)exception);
                    internalListener.onFailure((Exception)new FlowFrameworkException("Unable to fetch the workflows", RestStatus.BAD_REQUEST));
                }));
            }
            catch (Exception e) {
                this.logger.error("Unable to fetch the workflows", (Throwable)e);
                internalListener.onFailure((Exception)new FlowFrameworkException(e.getMessage(), ExceptionsHelper.status((Throwable)e)));
            }
        }
    }

    private void validateWorkflows(Template template) throws Exception {
        for (Workflow workflow : template.workflows().values()) {
            List<ProcessNode> sortedNodes = this.workflowProcessSorter.sortProcessNodes(workflow, null);
            this.workflowProcessSorter.validate(sortedNodes, this.pluginsService);
        }
    }
}

