/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.rest;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.flowframework.common.FlowFrameworkSettings;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.transport.ProvisionWorkflowAction;
import org.opensearch.flowframework.transport.WorkflowRequest;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;

public class RestProvisionWorkflowAction
extends BaseRestHandler {
    private static final Logger logger = LogManager.getLogger(RestProvisionWorkflowAction.class);
    private static final String PROVISION_WORKFLOW_ACTION = "provision_workflow_action";
    private FlowFrameworkSettings flowFrameworkFeatureEnabledSetting;

    public RestProvisionWorkflowAction(FlowFrameworkSettings flowFrameworkFeatureEnabledSetting) {
        this.flowFrameworkFeatureEnabledSetting = flowFrameworkFeatureEnabledSetting;
    }

    public String getName() {
        return PROVISION_WORKFLOW_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/{%s}/%s", "/_plugins/_flow_framework/workflow", "workflow_id", "_provision")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String workflowId = request.param("workflow_id");
        try {
            if (!this.flowFrameworkFeatureEnabledSetting.isFlowFrameworkEnabled()) {
                throw new FlowFrameworkException("This API is disabled. To enable it, update the setting [" + FlowFrameworkSettings.FLOW_FRAMEWORK_ENABLED.getKey() + "] to true.", RestStatus.FORBIDDEN);
            }
            if (request.hasContent()) {
                return channel -> channel.sendResponse(null);
            }
            if (workflowId == null) {
                throw new FlowFrameworkException("workflow_id cannot be null", RestStatus.BAD_REQUEST);
            }
            WorkflowRequest workflowRequest = new WorkflowRequest(workflowId, null);
            return channel -> client.execute((ActionType)ProvisionWorkflowAction.INSTANCE, (ActionRequest)workflowRequest, ActionListener.wrap(response -> {
                XContentBuilder builder = response.toXContent(channel.newBuilder(), ToXContent.EMPTY_PARAMS);
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, builder));
            }, exception -> {
                try {
                    FlowFrameworkException ex = exception instanceof FlowFrameworkException ? (FlowFrameworkException)exception : new FlowFrameworkException(exception.getMessage(), ExceptionsHelper.status((Throwable)exception));
                    XContentBuilder exceptionBuilder = ex.toXContent(channel.newErrorBuilder(), ToXContent.EMPTY_PARAMS);
                    channel.sendResponse((RestResponse)new BytesRestResponse(ex.getRestStatus(), exceptionBuilder));
                }
                catch (IOException e) {
                    logger.error("Failed to send back provision workflow exception", (Throwable)e);
                    channel.sendResponse((RestResponse)new BytesRestResponse(ExceptionsHelper.status((Throwable)e), e.getMessage()));
                }
            }));
        }
        catch (FlowFrameworkException ex) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(ex.getRestStatus(), ex.toXContent(channel.newErrorBuilder(), ToXContent.EMPTY_PARAMS)));
        }
    }
}

