/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.rest;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.flowframework.common.FlowFrameworkSettings;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.transport.GetWorkflowStepAction;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;

public class RestGetWorkflowStepAction
extends BaseRestHandler {
    private static final String GET_WORKFLOW_STEP_ACTION = "get_workflow_step";
    private static final Logger logger = LogManager.getLogger(RestGetWorkflowStepAction.class);
    private FlowFrameworkSettings flowFrameworkSettings;

    public RestGetWorkflowStepAction(FlowFrameworkSettings flowFrameworkSettings) {
        this.flowFrameworkSettings = flowFrameworkSettings;
    }

    public String getName() {
        return GET_WORKFLOW_STEP_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, String.format(Locale.ROOT, "%s/%s", "/_plugins/_flow_framework/workflow", "_steps")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        try {
            if (!this.flowFrameworkSettings.isFlowFrameworkEnabled()) {
                throw new FlowFrameworkException("This API is disabled. To enable it, update the setting [" + FlowFrameworkSettings.FLOW_FRAMEWORK_ENABLED.getKey() + "] to true.", RestStatus.FORBIDDEN);
            }
            ActionRequest request = new ActionRequest(){

                public ActionRequestValidationException validate() {
                    return null;
                }
            };
            return channel -> client.execute((ActionType)GetWorkflowStepAction.INSTANCE, request, ActionListener.wrap(response -> {
                XContentBuilder builder = response.toXContent(channel.newBuilder(), ToXContent.EMPTY_PARAMS);
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, builder));
            }, exception -> {
                try {
                    FlowFrameworkException ex = exception instanceof FlowFrameworkException ? (FlowFrameworkException)exception : new FlowFrameworkException(exception.getMessage(), ExceptionsHelper.status((Throwable)exception));
                    XContentBuilder exceptionBuilder = ex.toXContent(channel.newErrorBuilder(), ToXContent.EMPTY_PARAMS);
                    channel.sendResponse((RestResponse)new BytesRestResponse(ex.getRestStatus(), exceptionBuilder));
                }
                catch (IOException e) {
                    logger.error("Failed to send back get workflow step exception", (Throwable)e);
                    channel.sendResponse((RestResponse)new BytesRestResponse(ExceptionsHelper.status((Throwable)e), e.getMessage()));
                }
            }));
        }
        catch (FlowFrameworkException ex) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(ex.getRestStatus(), ex.toXContent(channel.newErrorBuilder(), ToXContent.EMPTY_PARAMS)));
        }
    }
}

