/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.rest;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.flowframework.common.FlowFrameworkSettings;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.model.Template;
import org.opensearch.flowframework.transport.CreateWorkflowAction;
import org.opensearch.flowframework.transport.WorkflowRequest;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;

public class RestCreateWorkflowAction
extends BaseRestHandler {
    private static final Logger logger = LogManager.getLogger(RestCreateWorkflowAction.class);
    private static final String CREATE_WORKFLOW_ACTION = "create_workflow_action";
    private FlowFrameworkSettings flowFrameworkSettings;

    public RestCreateWorkflowAction(FlowFrameworkSettings flowFrameworkSettings) {
        this.flowFrameworkSettings = flowFrameworkSettings;
    }

    public String getName() {
        return CREATE_WORKFLOW_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s", "/_plugins/_flow_framework/workflow")), new RestHandler.Route(RestRequest.Method.PUT, String.format(Locale.ROOT, "%s/{%s}", "/_plugins/_flow_framework/workflow", "workflow_id")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String workflowId = request.param("workflow_id");
        String[] validation = request.paramAsStringArray("validation", new String[]{"all"});
        boolean provision = request.paramAsBoolean("provision", false);
        if (!this.flowFrameworkSettings.isFlowFrameworkEnabled()) {
            FlowFrameworkException ffe = new FlowFrameworkException("This API is disabled. To enable it, set [" + FlowFrameworkSettings.FLOW_FRAMEWORK_ENABLED.getKey() + "] to true.", RestStatus.FORBIDDEN);
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(ffe.getRestStatus(), ffe.toXContent(channel.newErrorBuilder(), ToXContent.EMPTY_PARAMS)));
        }
        try {
            XContentParser parser = request.contentParser();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
            Template template = Template.parse(parser);
            WorkflowRequest workflowRequest = new WorkflowRequest(workflowId, template, validation, provision);
            return channel -> client.execute((ActionType)CreateWorkflowAction.INSTANCE, (ActionRequest)workflowRequest, ActionListener.wrap(response -> {
                XContentBuilder builder = response.toXContent(channel.newBuilder(), ToXContent.EMPTY_PARAMS);
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.CREATED, builder));
            }, exception -> {
                try {
                    FlowFrameworkException ex = exception instanceof FlowFrameworkException ? (FlowFrameworkException)exception : new FlowFrameworkException(exception.getMessage(), ExceptionsHelper.status((Throwable)exception));
                    XContentBuilder exceptionBuilder = ex.toXContent(channel.newErrorBuilder(), ToXContent.EMPTY_PARAMS);
                    channel.sendResponse((RestResponse)new BytesRestResponse(ex.getRestStatus(), exceptionBuilder));
                }
                catch (IOException e) {
                    logger.error("Failed to send back provision workflow exception", (Throwable)e);
                    channel.sendResponse((RestResponse)new BytesRestResponse(ExceptionsHelper.status((Throwable)e), e.getMessage()));
                }
            }));
        }
        catch (Exception e) {
            FlowFrameworkException ex = new FlowFrameworkException(e.getMessage(), RestStatus.BAD_REQUEST);
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(ex.getRestStatus(), ex.toXContent(channel.newErrorBuilder(), ToXContent.EMPTY_PARAMS)));
        }
    }
}

