/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.model;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.flowframework.model.WorkflowStepValidator;
import org.opensearch.flowframework.util.ParseUtils;

public class WorkflowValidator
implements ToXContentObject {
    private Map<String, WorkflowStepValidator> workflowStepValidators;

    public WorkflowValidator(Map<String, WorkflowStepValidator> workflowStepValidators) {
        this.workflowStepValidators = workflowStepValidators;
    }

    public static WorkflowValidator parse(XContentParser parser) throws IOException {
        HashMap<String, WorkflowStepValidator> workflowStepValidators = new HashMap<String, WorkflowStepValidator>();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String type = parser.currentName();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
            workflowStepValidators.put(type, WorkflowStepValidator.parse(parser));
        }
        return new WorkflowValidator(workflowStepValidators);
    }

    public static WorkflowValidator parse(String file) throws IOException {
        String json = ParseUtils.resourceToString("/" + file);
        return WorkflowValidator.parse(ParseUtils.jsonToParser(json));
    }

    public String toJson() {
        try {
            XContentBuilder builder = JsonXContent.contentBuilder();
            return this.toXContent(builder, EMPTY_PARAMS).toString();
        }
        catch (IOException e) {
            return "{\"error\": \"couldn't create JSON: " + e.getMessage() + "\"}";
        }
    }

    public Map<String, WorkflowStepValidator> getWorkflowStepValidators() {
        return Map.copyOf(this.workflowStepValidators);
    }

    public XContentBuilder toXContent(XContentBuilder xContentBuilder, ToXContent.Params params) throws IOException {
        return xContentBuilder.map(this.workflowStepValidators);
    }
}

