/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.flowframework.exception.FlowFrameworkException;

public class WorkflowStepValidator
implements ToXContentObject {
    private static final Logger logger = LogManager.getLogger(WorkflowStepValidator.class);
    private static final String INPUTS_FIELD = "inputs";
    private static final String OUTPUTS_FIELD = "outputs";
    private static final String REQUIRED_PLUGINS = "required_plugins";
    private static final String TIMEOUT = "timeout";
    private List<String> inputs;
    private List<String> outputs;
    private List<String> requiredPlugins;
    private TimeValue timeout;

    public WorkflowStepValidator(List<String> inputs, List<String> outputs, List<String> requiredPlugins, TimeValue timeout) {
        this.inputs = inputs;
        this.outputs = outputs;
        this.requiredPlugins = requiredPlugins;
        this.timeout = timeout;
    }

    public static WorkflowStepValidator parse(XContentParser parser) throws IOException {
        ArrayList<String> parsedInputs = new ArrayList<String>();
        ArrayList<String> parsedOutputs = new ArrayList<String>();
        ArrayList<String> requiredPlugins = new ArrayList<String>();
        TimeValue timeout = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block14: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "inputs": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        parsedInputs.add(parser.text());
                    }
                    continue block14;
                }
                case "outputs": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        parsedOutputs.add(parser.text());
                    }
                    continue block14;
                }
                case "required_plugins": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        requiredPlugins.add(parser.text());
                    }
                    continue block14;
                }
                case "timeout": {
                    try {
                        timeout = TimeValue.parseTimeValue((String)parser.text(), (String)TIMEOUT);
                        continue block14;
                    }
                    catch (IllegalArgumentException e) {
                        logger.error("Failed to parse TIMEOUT value for field [{}]", (Object)fieldName, (Object)e);
                        throw new FlowFrameworkException("Failed to parse workflow-step.json file for field [" + fieldName + "]", RestStatus.INTERNAL_SERVER_ERROR);
                    }
                }
            }
            throw new FlowFrameworkException("Unable to parse field [" + fieldName + "] in a WorkflowStepValidator object.", RestStatus.BAD_REQUEST);
        }
        return new WorkflowStepValidator(parsedInputs, parsedOutputs, requiredPlugins, timeout);
    }

    public List<String> getInputs() {
        return List.copyOf(this.inputs);
    }

    public List<String> getOutputs() {
        return List.copyOf(this.outputs);
    }

    public List<String> getRequiredPlugins() {
        return List.copyOf(this.requiredPlugins);
    }

    public TimeValue getTimeout() {
        return this.timeout;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject();
        xContentBuilder.startArray(INPUTS_FIELD);
        for (String input : this.inputs) {
            xContentBuilder.value(input);
        }
        xContentBuilder.endArray();
        xContentBuilder.startArray(OUTPUTS_FIELD);
        for (String output : this.outputs) {
            xContentBuilder.value(output);
        }
        xContentBuilder.endArray();
        xContentBuilder.startArray(REQUIRED_PLUGINS);
        for (String rp : this.requiredPlugins) {
            xContentBuilder.value(rp);
        }
        xContentBuilder.endArray();
        if (this.timeout != null) {
            xContentBuilder.field(TIMEOUT, (Object)this.timeout);
        }
        return xContentBuilder.endObject();
    }
}

