/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.model;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParseException;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.model.ResourceCreated;
import org.opensearch.flowframework.util.ParseUtils;

public class WorkflowState
implements ToXContentObject,
Writeable {
    private String workflowId;
    private String error;
    private String state;
    private String provisioningProgress;
    private Instant provisionStartTime;
    private Instant provisionEndTime;
    private User user;
    private Map<String, Object> userOutputs;
    private List<ResourceCreated> resourcesCreated;

    public WorkflowState(String workflowId, String error, String state, String provisioningProgress, Instant provisionStartTime, Instant provisionEndTime, User user, Map<String, Object> userOutputs, List<ResourceCreated> resourcesCreated) {
        this.workflowId = workflowId;
        this.error = error;
        this.state = state;
        this.provisioningProgress = provisioningProgress;
        this.provisionStartTime = provisionStartTime;
        this.provisionEndTime = provisionEndTime;
        this.user = user;
        this.userOutputs = Map.copyOf(userOutputs);
        this.resourcesCreated = List.copyOf(resourcesCreated);
    }

    private WorkflowState() {
    }

    public WorkflowState(StreamInput input) throws IOException {
        this.workflowId = input.readString();
        this.error = input.readOptionalString();
        this.state = input.readOptionalString();
        this.provisioningProgress = input.readOptionalString();
        this.provisionStartTime = input.readOptionalInstant();
        this.provisionEndTime = input.readOptionalInstant();
        this.user = input.readBoolean() ? new User(input) : null;
        this.userOutputs = input.readBoolean() ? input.readMap() : null;
        int resourceCount = input.readVInt();
        this.resourcesCreated = new ArrayList<ResourceCreated>(resourceCount);
        for (int r = 0; r < resourceCount; ++r) {
            this.resourcesCreated.add(new ResourceCreated(input));
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject();
        if (this.workflowId != null) {
            xContentBuilder.field("workflow_id", this.workflowId);
        }
        if (this.error != null) {
            xContentBuilder.field("error", this.error);
        }
        if (this.state != null) {
            xContentBuilder.field("state", this.state);
        }
        if (this.provisioningProgress != null) {
            xContentBuilder.field("provisioning_progress", this.provisioningProgress);
        }
        if (this.provisionStartTime != null) {
            xContentBuilder.field("provision_start_time", this.provisionStartTime.toEpochMilli());
        }
        if (this.provisionEndTime != null) {
            xContentBuilder.field("provision_end_time", this.provisionEndTime.toEpochMilli());
        }
        if (this.user != null) {
            xContentBuilder.field("user", (ToXContent)this.user);
        }
        if (this.userOutputs != null && !this.userOutputs.isEmpty()) {
            xContentBuilder.field("user_outputs", this.userOutputs);
        }
        if (this.resourcesCreated != null && !this.resourcesCreated.isEmpty()) {
            xContentBuilder.field("resources_created", (Object)this.resourcesCreated.toArray());
        }
        return xContentBuilder.endObject();
    }

    public void writeTo(StreamOutput output) throws IOException {
        output.writeString(this.workflowId);
        output.writeOptionalString(this.error);
        output.writeOptionalString(this.state);
        output.writeOptionalString(this.provisioningProgress);
        output.writeOptionalInstant(this.provisionStartTime);
        output.writeOptionalInstant(this.provisionEndTime);
        if (this.user != null) {
            output.writeBoolean(true);
            this.user.writeTo(output);
        } else {
            output.writeBoolean(false);
        }
        if (this.userOutputs != null) {
            output.writeBoolean(true);
            output.writeMap(this.userOutputs);
        } else {
            output.writeBoolean(false);
        }
        output.writeVInt(this.resourcesCreated.size());
        for (ResourceCreated resource : this.resourcesCreated) {
            resource.writeTo(output);
        }
    }

    public static WorkflowState parse(XContentParser parser) throws IOException {
        String workflowId = null;
        String error = null;
        String state = null;
        String provisioningProgress = null;
        Instant provisionStartTime = null;
        Instant provisionEndTime = null;
        User user = null;
        HashMap<String, Object> userOutputs = new HashMap<String, Object>();
        ArrayList<ResourceCreated> resourcesCreated = new ArrayList<ResourceCreated>();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block28: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "workflow_id": {
                    workflowId = parser.text();
                    break;
                }
                case "error": {
                    error = parser.text();
                    break;
                }
                case "state": {
                    state = parser.text();
                    break;
                }
                case "provisioning_progress": {
                    provisioningProgress = parser.text();
                    break;
                }
                case "provision_start_time": {
                    provisionStartTime = ParseUtils.parseInstant(parser);
                    break;
                }
                case "provision_end_time": {
                    provisionEndTime = ParseUtils.parseInstant(parser);
                    break;
                }
                case "user": {
                    user = User.parse((XContentParser)parser);
                    break;
                }
                case "user_outputs": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    block29: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                        String userOutputsFieldName = parser.currentName();
                        switch (parser.nextToken()) {
                            case VALUE_STRING: {
                                userOutputs.put(userOutputsFieldName, parser.text());
                                continue block29;
                            }
                            case START_OBJECT: {
                                userOutputs.put(userOutputsFieldName, ParseUtils.parseStringToStringMap(parser));
                                continue block29;
                            }
                        }
                        throw new FlowFrameworkException("Unable to parse field [" + userOutputsFieldName + "] in a user_outputs object.", RestStatus.BAD_REQUEST);
                    }
                    continue block28;
                }
                case "resources_created": {
                    try {
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                            resourcesCreated.add(ResourceCreated.parse(parser));
                        }
                        continue block28;
                    }
                    catch (Exception e) {
                        if (e instanceof ParsingException || e instanceof XContentParseException) {
                            throw new FlowFrameworkException("Error parsing newly created resources", RestStatus.INTERNAL_SERVER_ERROR);
                        }
                        throw e;
                    }
                }
                default: {
                    throw new FlowFrameworkException("Unable to parse field [" + fieldName + "] in a workflowState object.", RestStatus.BAD_REQUEST);
                }
            }
        }
        return new Builder().workflowId(workflowId).error(error).state(state).provisioningProgress(provisioningProgress).provisionStartTime(provisionStartTime).provisionEndTime(provisionEndTime).user(user).userOutputs(userOutputs).resourcesCreated(resourcesCreated).build();
    }

    public static WorkflowState parse(String json) throws IOException {
        XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, json);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        return WorkflowState.parse(parser);
    }

    public String getWorkflowId() {
        return this.workflowId;
    }

    public String getError() {
        return this.error;
    }

    public String getState() {
        return this.state;
    }

    public String getProvisioningProgress() {
        return this.provisioningProgress;
    }

    public Instant getProvisionStartTime() {
        return this.provisionStartTime;
    }

    public Instant getProvisionEndTime() {
        return this.provisionEndTime;
    }

    public User getUser() {
        return this.user;
    }

    public Map<String, Object> userOutputs() {
        return this.userOutputs;
    }

    public List<ResourceCreated> resourcesCreated() {
        return this.resourcesCreated;
    }

    public String toString() {
        return "WorkflowState [workflowId=" + this.workflowId + ", error=" + this.error + ", state=" + this.state + ", provisioningProgress=" + this.provisioningProgress + ", userOutputs=" + String.valueOf(this.userOutputs) + ", resourcesCreated=" + String.valueOf(this.resourcesCreated) + "]";
    }

    public static class Builder {
        private String workflowId = null;
        private String error = null;
        private String state = null;
        private String provisioningProgress = null;
        private Instant provisionStartTime = null;
        private Instant provisionEndTime = null;
        private User user = null;
        private Map<String, Object> userOutputs = null;
        private List<ResourceCreated> resourcesCreated = null;

        public Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public Builder error(String error) {
            this.error = error;
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            return this;
        }

        public Builder provisioningProgress(String provisioningProgress) {
            this.provisioningProgress = provisioningProgress;
            return this;
        }

        public Builder provisionStartTime(Instant provisionStartTime) {
            this.provisionStartTime = provisionStartTime;
            return this;
        }

        public Builder provisionEndTime(Instant provisionEndTime) {
            this.provisionEndTime = provisionEndTime;
            return this;
        }

        public Builder user(User user) {
            this.user = user;
            return this;
        }

        public Builder userOutputs(Map<String, Object> userOutputs) {
            this.userOutputs = userOutputs;
            return this;
        }

        public Builder resourcesCreated(List<ResourceCreated> resourcesCreated) {
            this.resourcesCreated = resourcesCreated;
            return this;
        }

        public WorkflowState build() {
            WorkflowState workflowState = new WorkflowState();
            workflowState.workflowId = this.workflowId;
            workflowState.error = this.error;
            workflowState.state = this.state;
            workflowState.provisioningProgress = this.provisioningProgress;
            workflowState.provisionStartTime = this.provisionStartTime;
            workflowState.provisionEndTime = this.provisionEndTime;
            workflowState.user = this.user;
            workflowState.userOutputs = this.userOutputs;
            workflowState.resourcesCreated = this.resourcesCreated;
            return workflowState;
        }
    }
}

