/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.Version;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.common.xcontent.yaml.YamlXContent;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.model.Workflow;

public class Template
implements ToXContentObject {
    public static final String WORKFLOWS_FIELD = "workflows";
    public static final String COMPATIBILITY_FIELD = "compatibility";
    public static final String TEMPLATE_FIELD = "template";
    public static final String USE_CASE_FIELD = "use_case";
    private String name;
    private String description;
    private String useCase;
    private Version templateVersion;
    private List<Version> compatibilityVersion;
    private Map<String, Workflow> workflows;
    private Map<String, Object> uiMetadata;
    private User user;

    public Template(String name, String description, String useCase, Version templateVersion, List<Version> compatibilityVersion, Map<String, Workflow> workflows, Map<String, Object> uiMetadata, User user) {
        this.name = name;
        this.description = description;
        this.useCase = useCase;
        this.templateVersion = templateVersion;
        this.compatibilityVersion = List.copyOf(compatibilityVersion);
        this.workflows = Map.copyOf(workflows);
        this.uiMetadata = uiMetadata;
        this.user = user;
    }

    private Template() {
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject();
        xContentBuilder.field("name", this.name);
        xContentBuilder.field("description", this.description);
        xContentBuilder.field(USE_CASE_FIELD, this.useCase);
        if (this.templateVersion != null || !this.compatibilityVersion.isEmpty()) {
            xContentBuilder.startObject("version");
            if (this.templateVersion != null) {
                xContentBuilder.field(TEMPLATE_FIELD, (ToXContent)this.templateVersion);
            }
            if (!this.compatibilityVersion.isEmpty()) {
                xContentBuilder.startArray(COMPATIBILITY_FIELD);
                for (Version v : this.compatibilityVersion) {
                    xContentBuilder.value((Object)v);
                }
                xContentBuilder.endArray();
            }
            xContentBuilder.endObject();
        }
        xContentBuilder.startObject(WORKFLOWS_FIELD);
        for (Map.Entry<String, Workflow> e : this.workflows.entrySet()) {
            xContentBuilder.field(e.getKey(), (ToXContent)e.getValue(), params);
        }
        xContentBuilder.endObject();
        if (this.uiMetadata != null && !this.uiMetadata.isEmpty()) {
            xContentBuilder.field("ui_metadata", this.uiMetadata);
        }
        if (this.user != null) {
            xContentBuilder.field("user", (ToXContent)this.user);
        }
        return xContentBuilder.endObject();
    }

    public static Template parse(XContentParser parser) throws IOException {
        String name = null;
        String description = "";
        String useCase = "";
        Version templateVersion = null;
        ArrayList<Version> compatibilityVersion = new ArrayList<Version>();
        HashMap<String, Workflow> workflows = new HashMap<String, Workflow>();
        Map uiMetadata = null;
        User user = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block26: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "name": {
                    name = parser.text();
                    continue block26;
                }
                case "description": {
                    description = parser.text();
                    continue block26;
                }
                case "use_case": {
                    useCase = parser.text();
                    continue block26;
                }
                case "version": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    block27: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                        String versionFieldName = parser.currentName();
                        parser.nextToken();
                        switch (versionFieldName) {
                            case "template": {
                                templateVersion = Version.fromString((String)parser.text());
                                continue block27;
                            }
                            case "compatibility": {
                                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                                while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                                    compatibilityVersion.add(Version.fromString((String)parser.text()));
                                }
                                continue block27;
                            }
                        }
                        throw new FlowFrameworkException("Unable to parse field [" + fieldName + "] in a version object.", RestStatus.BAD_REQUEST);
                    }
                    continue block26;
                }
                case "workflows": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                        String workflowFieldName = parser.currentName();
                        parser.nextToken();
                        workflows.put(workflowFieldName, Workflow.parse(parser));
                    }
                    continue block26;
                }
                case "ui_metadata": {
                    uiMetadata = parser.map();
                    continue block26;
                }
                case "user": {
                    user = User.parse((XContentParser)parser);
                    continue block26;
                }
            }
            throw new FlowFrameworkException("Unable to parse field [" + fieldName + "] in a template object.", RestStatus.BAD_REQUEST);
        }
        if (name == null) {
            throw new FlowFrameworkException("A template object requires a name.", RestStatus.BAD_REQUEST);
        }
        return new Builder().name(name).description(description).useCase(useCase).templateVersion(templateVersion).compatibilityVersion(compatibilityVersion).workflows(workflows).uiMetadata(uiMetadata).user(user).build();
    }

    public static Template parse(String json) throws IOException {
        try (XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, json);){
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
            Template template = Template.parse(parser);
            return template;
        }
    }

    public String toJson() {
        try {
            XContentBuilder builder = JsonXContent.contentBuilder();
            return this.toXContent(builder, EMPTY_PARAMS).toString();
        }
        catch (IOException e) {
            return "{\"error\": \"couldn't create JSON: " + e.getMessage() + "\"}";
        }
    }

    public String toYaml() {
        try {
            XContentBuilder builder = YamlXContent.contentBuilder();
            return this.toXContent(builder, EMPTY_PARAMS).toString();
        }
        catch (IOException e) {
            return "error: couldn't create YAML: " + e.getMessage();
        }
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String useCase() {
        return this.useCase;
    }

    public Version templateVersion() {
        return this.templateVersion;
    }

    public List<Version> compatibilityVersion() {
        return this.compatibilityVersion;
    }

    public Map<String, Workflow> workflows() {
        return this.workflows;
    }

    public Map<String, Object> getUiMetadata() {
        return this.uiMetadata;
    }

    public User getUser() {
        return this.user;
    }

    public String toString() {
        return "Template [name=" + this.name + ", description=" + this.description + ", useCase=" + this.useCase + ", templateVersion=" + String.valueOf(this.templateVersion) + ", compatibilityVersion=" + String.valueOf(this.compatibilityVersion) + ", workflows=" + String.valueOf(this.workflows) + ", uiMedata=" + String.valueOf(this.uiMetadata) + "]";
    }

    public static class Builder {
        private String name = null;
        private String description = "";
        private String useCase = "";
        private Version templateVersion = null;
        private List<Version> compatibilityVersion = new ArrayList<Version>();
        private Map<String, Workflow> workflows = new HashMap<String, Workflow>();
        private Map<String, Object> uiMetadata = null;
        private User user = null;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder useCase(String useCase) {
            this.useCase = useCase;
            return this;
        }

        public Builder templateVersion(Version templateVersion) {
            this.templateVersion = templateVersion;
            return this;
        }

        public Builder compatibilityVersion(List<Version> compatibilityVersion) {
            this.compatibilityVersion = compatibilityVersion;
            return this;
        }

        public Builder workflows(Map<String, Workflow> workflows) {
            this.workflows = workflows;
            return this;
        }

        public Builder uiMetadata(Map<String, Object> uiMetadata) {
            this.uiMetadata = uiMetadata;
            return this;
        }

        public Builder user(User user) {
            this.user = user;
            return this;
        }

        public Template build() {
            Template template = new Template();
            template.name = this.name;
            template.description = this.description;
            template.useCase = this.useCase;
            template.templateVersion = this.templateVersion;
            template.compatibilityVersion = this.compatibilityVersion;
            template.workflows = this.workflows;
            template.uiMetadata = this.uiMetadata;
            template.user = this.user;
            return template;
        }
    }
}

