/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.indices;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.opensearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.client.Client;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.flowframework.common.CommonValue;
import org.opensearch.flowframework.common.WorkflowResources;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.indices.FlowFrameworkIndex;
import org.opensearch.flowframework.model.ProvisioningProgress;
import org.opensearch.flowframework.model.ResourceCreated;
import org.opensearch.flowframework.model.State;
import org.opensearch.flowframework.model.Template;
import org.opensearch.flowframework.model.WorkflowState;
import org.opensearch.flowframework.util.EncryptorUtils;
import org.opensearch.flowframework.util.ParseUtils;
import org.opensearch.script.Script;
import org.opensearch.script.ScriptType;

public class FlowFrameworkIndicesHandler {
    private static final Logger logger = LogManager.getLogger(FlowFrameworkIndicesHandler.class);
    private final Client client;
    private final ClusterService clusterService;
    private final EncryptorUtils encryptorUtils;
    private static final Map<String, AtomicBoolean> indexMappingUpdated = new HashMap<String, AtomicBoolean>();
    private static final Map<String, Object> indexSettings = Map.of("index.auto_expand_replicas", "0-1");
    private final NamedXContentRegistry xContentRegistry;

    public FlowFrameworkIndicesHandler(Client client, ClusterService clusterService, EncryptorUtils encryptorUtils, NamedXContentRegistry xContentRegistry) {
        this.client = client;
        this.clusterService = clusterService;
        this.encryptorUtils = encryptorUtils;
        for (FlowFrameworkIndex mlIndex : FlowFrameworkIndex.values()) {
            indexMappingUpdated.put(mlIndex.getIndexName(), new AtomicBoolean(false));
        }
        this.xContentRegistry = xContentRegistry;
    }

    public static String getGlobalContextMappings() throws IOException {
        return FlowFrameworkIndicesHandler.getIndexMappings("mappings/global-context.json");
    }

    public static String getWorkflowStateMappings() throws IOException {
        return FlowFrameworkIndicesHandler.getIndexMappings("mappings/workflow-state.json");
    }

    public static String getConfigIndexMappings() throws IOException {
        return FlowFrameworkIndicesHandler.getIndexMappings("mappings/config.json");
    }

    public void initGlobalContextIndexIfAbsent(ActionListener<Boolean> listener) {
        this.initFlowFrameworkIndexIfAbsent(FlowFrameworkIndex.GLOBAL_CONTEXT, listener);
    }

    public void initWorkflowStateIndexIfAbsent(ActionListener<Boolean> listener) {
        this.initFlowFrameworkIndexIfAbsent(FlowFrameworkIndex.WORKFLOW_STATE, listener);
    }

    public void initConfigIndexIfAbsent(ActionListener<Boolean> listener) {
        this.initFlowFrameworkIndexIfAbsent(FlowFrameworkIndex.CONFIG, listener);
    }

    public boolean doesIndexExist(String indexName) {
        return this.clusterService.state().metadata().hasIndex(indexName);
    }

    public void initFlowFrameworkIndexIfAbsent(FlowFrameworkIndex index, ActionListener<Boolean> listener) {
        String indexName = index.getIndexName();
        String mapping = index.getMapping();
        try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener internalListener = ActionListener.runBefore(listener, () -> ((ThreadContext.StoredContext)threadContext).restore());
            if (!this.clusterService.state().metadata().hasIndex(indexName)) {
                ActionListener actionListener = ActionListener.wrap(r -> {
                    if (r.isAcknowledged()) {
                        logger.info("create index:{}", (Object)indexName);
                        internalListener.onResponse((Object)true);
                    } else {
                        internalListener.onResponse((Object)false);
                    }
                }, e -> {
                    logger.error("Failed to create index {}", (Object)indexName, e);
                    internalListener.onFailure((Exception)new FlowFrameworkException(e.getMessage(), ExceptionsHelper.status((Throwable)e)));
                });
                CreateIndexRequest request = new CreateIndexRequest(indexName).mapping(mapping).settings(indexSettings);
                this.client.admin().indices().create(request, actionListener);
            } else {
                logger.debug("index:{} is already created", (Object)indexName);
                if (indexMappingUpdated.containsKey(indexName) && !indexMappingUpdated.get(indexName).get()) {
                    this.shouldUpdateIndex(indexName, index.getVersion(), (ActionListener<Boolean>)ActionListener.wrap(r -> {
                        if (r.booleanValue()) {
                            this.client.admin().indices().putMapping(new PutMappingRequest().indices(new String[]{indexName}).source(mapping, (MediaType)XContentType.JSON), ActionListener.wrap(response -> {
                                if (response.isAcknowledged()) {
                                    UpdateSettingsRequest updateSettingRequest = new UpdateSettingsRequest();
                                    updateSettingRequest.indices(new String[]{indexName}).settings(indexSettings);
                                    this.client.admin().indices().updateSettings(updateSettingRequest, ActionListener.wrap(updateResponse -> {
                                        if (response.isAcknowledged()) {
                                            indexMappingUpdated.get(indexName).set(true);
                                            internalListener.onResponse((Object)true);
                                        } else {
                                            internalListener.onFailure((Exception)new FlowFrameworkException("Failed to update index setting for: " + indexName, RestStatus.INTERNAL_SERVER_ERROR));
                                        }
                                    }, exception -> {
                                        String errorMessage = "Failed to update index setting for: " + indexName;
                                        logger.error(errorMessage, (Throwable)exception);
                                        internalListener.onFailure((Exception)new FlowFrameworkException(errorMessage + " : " + exception.getMessage(), ExceptionsHelper.status((Throwable)exception)));
                                    }));
                                } else {
                                    internalListener.onFailure((Exception)new FlowFrameworkException("Failed to update index: " + indexName, RestStatus.INTERNAL_SERVER_ERROR));
                                }
                            }, exception -> {
                                String errorMessage = "Failed to update index " + indexName;
                                logger.error(errorMessage, (Throwable)exception);
                                internalListener.onFailure((Exception)new FlowFrameworkException(errorMessage + " : " + exception.getMessage(), ExceptionsHelper.status((Throwable)exception)));
                            }));
                        } else {
                            indexMappingUpdated.get(indexName).set(true);
                            internalListener.onResponse((Object)true);
                        }
                    }, e -> {
                        String errorMessage = "Failed to update index mapping";
                        logger.error(errorMessage, (Throwable)e);
                        internalListener.onFailure((Exception)new FlowFrameworkException(errorMessage + " : " + e.getMessage(), ExceptionsHelper.status((Throwable)e)));
                    }));
                } else {
                    internalListener.onResponse((Object)true);
                }
            }
        }
        catch (Exception e2) {
            String errorMessage = "Failed to init index " + indexName;
            logger.error(errorMessage, (Throwable)e2);
            listener.onFailure((Exception)new FlowFrameworkException(errorMessage + " : " + e2.getMessage(), ExceptionsHelper.status((Throwable)e2)));
        }
    }

    private void shouldUpdateIndex(String indexName, Integer newVersion, ActionListener<Boolean> listener) {
        Map metaMapping;
        Object schemaVersion;
        IndexMetadata indexMetaData = (IndexMetadata)this.clusterService.state().getMetadata().indices().get(indexName);
        if (indexMetaData == null) {
            listener.onResponse((Object)Boolean.FALSE);
            return;
        }
        Integer oldVersion = CommonValue.NO_SCHEMA_VERSION;
        Map indexMapping = indexMetaData.mapping().getSourceAsMap();
        Object meta = indexMapping.get("_meta");
        if (meta instanceof Map && (schemaVersion = (metaMapping = (Map)meta).get("schema_version")) instanceof Integer) {
            oldVersion = (Integer)schemaVersion;
        }
        listener.onResponse((Object)(newVersion > oldVersion ? 1 : 0));
    }

    public static String getIndexMappings(String mapping) throws IOException {
        return ParseUtils.resourceToString("/" + mapping);
    }

    public void putTemplateToGlobalContext(Template template, ActionListener<IndexResponse> listener) {
        this.initGlobalContextIndexIfAbsent((ActionListener<Boolean>)ActionListener.wrap(indexCreated -> {
            if (!indexCreated.booleanValue()) {
                listener.onFailure((Exception)new FlowFrameworkException("No response to create global_context index", RestStatus.INTERNAL_SERVER_ERROR));
                return;
            }
            IndexRequest request = new IndexRequest(".plugins-flow-framework-templates");
            try (XContentBuilder builder = XContentFactory.jsonBuilder();
                 ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                Template templateWithEncryptedCredentials = this.encryptorUtils.encryptTemplateCredentials(template);
                request.source(templateWithEncryptedCredentials.toXContent(builder, ToXContent.EMPTY_PARAMS)).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                this.client.index(request, ActionListener.runBefore((ActionListener)listener, () -> ((ThreadContext.StoredContext)context).restore()));
            }
            catch (Exception e) {
                String errorMessage = "Failed to index global_context index";
                logger.error(errorMessage);
                listener.onFailure((Exception)new FlowFrameworkException(errorMessage + " : " + e.getMessage(), ExceptionsHelper.status((Throwable)e)));
            }
        }, e -> {
            logger.error("Failed to create global_context index", (Throwable)e);
            listener.onFailure(e);
        }));
    }

    public void initializeConfigIndex(ActionListener<Boolean> listener) {
        this.initConfigIndexIfAbsent((ActionListener<Boolean>)ActionListener.wrap(indexCreated -> {
            if (!indexCreated.booleanValue()) {
                listener.onFailure((Exception)new FlowFrameworkException("No response to create config index", RestStatus.INTERNAL_SERVER_ERROR));
                return;
            }
            this.encryptorUtils.initializeMasterKey(listener);
        }, createIndexException -> {
            logger.error("Failed to create config index", (Throwable)createIndexException);
            listener.onFailure(createIndexException);
        }));
    }

    public void putInitialStateToWorkflowState(String workflowId, User user, ActionListener<IndexResponse> listener) {
        WorkflowState state = new WorkflowState.Builder().workflowId(workflowId).state(State.NOT_STARTED.name()).provisioningProgress(ProvisioningProgress.NOT_STARTED.name()).user(user).resourcesCreated(Collections.emptyList()).userOutputs(Collections.emptyMap()).build();
        this.initWorkflowStateIndexIfAbsent((ActionListener<Boolean>)ActionListener.wrap(indexCreated -> {
            if (!indexCreated.booleanValue()) {
                listener.onFailure((Exception)new FlowFrameworkException("No response to create workflow_state index", RestStatus.INTERNAL_SERVER_ERROR));
                return;
            }
            IndexRequest request = new IndexRequest(".plugins-flow-framework-state");
            try (XContentBuilder builder = XContentFactory.jsonBuilder();
                 ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                request.source(state.toXContent(builder, ToXContent.EMPTY_PARAMS)).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                request.id(workflowId);
                this.client.index(request, ActionListener.runBefore((ActionListener)listener, () -> ((ThreadContext.StoredContext)context).restore()));
            }
            catch (Exception e) {
                String errorMessage = "Failed to put state index document";
                logger.error(errorMessage, (Throwable)e);
                listener.onFailure((Exception)new FlowFrameworkException(errorMessage + " : " + e.getMessage(), ExceptionsHelper.status((Throwable)e)));
            }
        }, e -> {
            String errorMessage = "Failed to create workflow_state index";
            logger.error(errorMessage, (Throwable)e);
            listener.onFailure((Exception)new FlowFrameworkException(errorMessage + " : " + e.getMessage(), ExceptionsHelper.status((Throwable)e)));
        }));
    }

    public void updateTemplateInGlobalContext(String documentId, Template template, ActionListener<IndexResponse> listener) {
        if (!this.doesIndexExist(".plugins-flow-framework-templates")) {
            String exceptionMessage = "Failed to update template for workflow_id : " + documentId + ", global_context index does not exist.";
            logger.error(exceptionMessage);
            listener.onFailure((Exception)new FlowFrameworkException(exceptionMessage, RestStatus.BAD_REQUEST));
            return;
        }
        this.doesTemplateExist(documentId, templateExists -> {
            if (templateExists.booleanValue()) {
                this.isWorkflowNotStarted(documentId, workflowIsNotStarted -> {
                    if (workflowIsNotStarted.booleanValue()) {
                        IndexRequest request = new IndexRequest(".plugins-flow-framework-templates").id(documentId);
                        try (XContentBuilder builder = XContentFactory.jsonBuilder();
                             ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                            Template encryptedTemplate = this.encryptorUtils.encryptTemplateCredentials(template);
                            request.source(encryptedTemplate.toXContent(builder, ToXContent.EMPTY_PARAMS)).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                            this.client.index(request, ActionListener.runBefore((ActionListener)listener, () -> ((ThreadContext.StoredContext)context).restore()));
                        }
                        catch (Exception e) {
                            String errorMessage = "Failed to update global_context entry : " + documentId;
                            logger.error(errorMessage, (Throwable)e);
                            listener.onFailure((Exception)new FlowFrameworkException(errorMessage + " : " + e.getMessage(), ExceptionsHelper.status((Throwable)e)));
                        }
                    } else {
                        String errorMessage = "The template has already been provisioned so it can't be updated: " + documentId;
                        logger.error(errorMessage);
                        listener.onFailure((Exception)new FlowFrameworkException(errorMessage, RestStatus.BAD_REQUEST));
                    }
                }, listener);
            } else {
                String errorMessage = "Failed to get template: " + documentId;
                logger.error(errorMessage);
                listener.onFailure((Exception)new FlowFrameworkException(errorMessage, RestStatus.BAD_REQUEST));
            }
        }, listener);
    }

    public <T> void doesTemplateExist(String documentId, Consumer<Boolean> booleanResultConsumer, ActionListener<T> listener) {
        GetRequest getRequest = new GetRequest(".plugins-flow-framework-templates", documentId);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.client.get(getRequest, ActionListener.wrap(response -> booleanResultConsumer.accept(response.isExists()), exception -> {
                context.restore();
                logger.error("Failed to get template " + documentId, (Throwable)exception);
                listener.onFailure((Exception)new FlowFrameworkException(exception.getMessage(), ExceptionsHelper.status((Throwable)exception)));
            }));
        }
        catch (Exception e) {
            logger.error("Failed to retrieve template from global context.", (Throwable)e);
            listener.onFailure((Exception)new FlowFrameworkException(e.getMessage(), ExceptionsHelper.status((Throwable)e)));
        }
    }

    public <T> void isWorkflowNotStarted(String documentId, Consumer<Boolean> booleanResultConsumer, ActionListener<T> listener) {
        GetRequest getRequest = new GetRequest(".plugins-flow-framework-state", documentId);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.client.get(getRequest, ActionListener.wrap(response -> {
                context.restore();
                if (!response.isExists()) {
                    booleanResultConsumer.accept(false);
                    return;
                }
                try (XContentParser parser = ParseUtils.createXContentParserFromRegistry(this.xContentRegistry, response.getSourceAsBytesRef());){
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                    WorkflowState workflowState = WorkflowState.parse(parser);
                    booleanResultConsumer.accept(workflowState.getProvisioningProgress().equals(ProvisioningProgress.NOT_STARTED.name()));
                }
                catch (Exception e) {
                    String message = "Failed to parse workflow state " + documentId;
                    logger.error(message, (Throwable)e);
                    listener.onFailure((Exception)new FlowFrameworkException(message, RestStatus.INTERNAL_SERVER_ERROR));
                }
            }, exception -> {
                logger.error("Failed to get workflow state " + documentId, (Throwable)exception);
                booleanResultConsumer.accept(false);
            }));
        }
        catch (Exception e) {
            logger.error("Failed to retrieve workflow state to check provisioning status", (Throwable)e);
            listener.onFailure((Exception)new FlowFrameworkException(e.getMessage(), ExceptionsHelper.status((Throwable)e)));
        }
    }

    public void updateFlowFrameworkSystemIndexDoc(String documentId, Map<String, Object> updatedFields, ActionListener<UpdateResponse> listener) {
        if (!this.doesIndexExist(".plugins-flow-framework-state")) {
            String exceptionMessage = "Failed to update document for given workflow due to missing .plugins-flow-framework-state index";
            logger.error(exceptionMessage);
            listener.onFailure((Exception)new FlowFrameworkException(exceptionMessage, RestStatus.BAD_REQUEST));
        } else {
            try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                UpdateRequest updateRequest = new UpdateRequest(".plugins-flow-framework-state", documentId);
                HashMap<String, Object> updatedContent = new HashMap<String, Object>(updatedFields);
                updateRequest.doc(updatedContent);
                updateRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                updateRequest.retryOnConflict(5);
                this.client.update(updateRequest, ActionListener.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore()));
            }
            catch (Exception e) {
                String errorMessage = "Failed to update .plugins-flow-framework-state entry : " + documentId;
                logger.error(errorMessage, (Throwable)e);
                listener.onFailure((Exception)new FlowFrameworkException(errorMessage + " : " + e.getMessage(), ExceptionsHelper.status((Throwable)e)));
            }
        }
    }

    public void updateFlowFrameworkSystemIndexDocWithScript(String indexName, String documentId, Script script, ActionListener<UpdateResponse> listener) {
        if (!this.doesIndexExist(indexName)) {
            String exceptionMessage = "Failed to update document for given workflow due to missing " + indexName + " index";
            logger.error(exceptionMessage);
            listener.onFailure(new Exception(exceptionMessage));
        } else {
            try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                UpdateRequest updateRequest = new UpdateRequest(indexName, documentId);
                updateRequest.script(script);
                updateRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                updateRequest.retryOnConflict(3);
                this.client.update(updateRequest, ActionListener.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore()));
            }
            catch (Exception e) {
                logger.error("Failed to update {} entry : {}. {}", (Object)indexName, (Object)documentId, (Object)e.getMessage());
                listener.onFailure((Exception)new FlowFrameworkException("Failed to update " + indexName + "entry: " + documentId, ExceptionsHelper.status((Throwable)e)));
            }
        }
    }

    public void updateResourceInStateIndex(String workflowId, String nodeId, String workflowStepName, String resourceId, ActionListener<UpdateResponse> listener) throws IOException {
        ResourceCreated newResource = new ResourceCreated(workflowStepName, nodeId, WorkflowResources.getResourceByWorkflowStep(workflowStepName), resourceId);
        Script script = new Script(ScriptType.INLINE, "painless", "ctx._source.resources_created.add(params.newResource)", Collections.singletonMap("newResource", newResource.resourceMap()));
        this.updateFlowFrameworkSystemIndexDocWithScript(".plugins-flow-framework-state", workflowId, script, (ActionListener<UpdateResponse>)ActionListener.wrap(updateResponse -> {
            logger.info("updated resources created of {}", (Object)workflowId);
            listener.onResponse(updateResponse);
        }, exception -> listener.onFailure(exception)));
    }

    static {
        for (FlowFrameworkIndex mlIndex : FlowFrameworkIndex.values()) {
            indexMappingUpdated.put(mlIndex.getIndexName(), new AtomicBoolean(false));
        }
    }
}

