/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.task.index;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.shard.ShardId;
import org.opensearch.persistent.PersistentTasksCustomMetadata;
import org.opensearch.replication.task.ReplicationState;
import org.opensearch.replication.task.index.IndexReplicationState;
import org.opensearch.replication.task.shard.ShardReplicationParams;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B'\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001b\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u000bH\u00c6\u0003J/\u0010\u0013\u001a\u00020\u00002\u001a\b\u0002\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00062\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u000bH\u00d6\u0001J\u001a\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR#\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006$"}, d2={"Lorg/opensearch/replication/task/index/FailedState;", "Lorg/opensearch/replication/task/index/IndexReplicationState;", "inp", "Lorg/opensearch/common/io/stream/StreamInput;", "(Lorg/opensearch/common/io/stream/StreamInput;)V", "failedShards", "", "Lorg/opensearch/index/shard/ShardId;", "Lorg/opensearch/persistent/PersistentTasksCustomMetadata$PersistentTask;", "Lorg/opensearch/replication/task/shard/ShardReplicationParams;", "errorMsg", "", "(Ljava/util/Map;Ljava/lang/String;)V", "getErrorMsg", "()Ljava/lang/String;", "getFailedShards", "()Ljava/util/Map;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/common/io/stream/StreamOutput;", "opensearch-cross-cluster-replication"})
public final class FailedState
extends IndexReplicationState {
    @NotNull
    private final Map<ShardId, PersistentTasksCustomMetadata.PersistentTask<ShardReplicationParams>> failedShards;
    @NotNull
    private final String errorMsg;

    public FailedState(@NotNull Map<ShardId, ? extends PersistentTasksCustomMetadata.PersistentTask<ShardReplicationParams>> failedShards, @NotNull String errorMsg) {
        Intrinsics.checkNotNullParameter(failedShards, (String)"failedShards");
        Intrinsics.checkNotNullParameter((Object)errorMsg, (String)"errorMsg");
        super(ReplicationState.FAILED, null);
        this.failedShards = failedShards;
        this.errorMsg = errorMsg;
    }

    @NotNull
    public final Map<ShardId, PersistentTasksCustomMetadata.PersistentTask<ShardReplicationParams>> getFailedShards() {
        return this.failedShards;
    }

    @NotNull
    public final String getErrorMsg() {
        return this.errorMsg;
    }

    public FailedState(@NotNull StreamInput inp) {
        Intrinsics.checkNotNullParameter((Object)inp, (String)"inp");
        Map map = inp.readMap(ShardId::new, PersistentTasksCustomMetadata.PersistentTask::new);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"inp.readMap(::ShardId, ::PersistentTask)");
        this(map, "");
    }

    @Override
    public void writeTo(@NotNull StreamOutput out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        super.writeTo(out);
        out.writeMap(this.failedShards, FailedState::writeTo$lambda-0, FailedState::writeTo$lambda-1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @Nullable ToXContent.Params params) {
        void $this$mapKeysTo$iv$iv;
        void $this$mapKeys$iv;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Map<ShardId, PersistentTasksCustomMetadata.PersistentTask<ShardReplicationParams>> map = this.failedShards;
        XContentBuilder xContentBuilder = builder.startObject().field("error_message", this.errorMsg).field("failed_shard_replication_tasks");
        boolean $i$f$mapKeys = false;
        void var6_6 = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            void it;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            String string = ((ShardId)it.getKey()).toString();
            Map map3 = map2;
            boolean bl2 = false;
            entry = it$iv$iv.getValue();
            map3.put(string, entry);
        }
        XContentBuilder xContentBuilder2 = xContentBuilder.map(destination$iv$iv).field("state", (ToXContent)this.getState()).endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder2, (String)"builder.startObject()\n  \u2026             .endObject()");
        return xContentBuilder2;
    }

    @NotNull
    public final Map<ShardId, PersistentTasksCustomMetadata.PersistentTask<ShardReplicationParams>> component1() {
        return this.failedShards;
    }

    @NotNull
    public final String component2() {
        return this.errorMsg;
    }

    @NotNull
    public final FailedState copy(@NotNull Map<ShardId, ? extends PersistentTasksCustomMetadata.PersistentTask<ShardReplicationParams>> failedShards, @NotNull String errorMsg) {
        Intrinsics.checkNotNullParameter(failedShards, (String)"failedShards");
        Intrinsics.checkNotNullParameter((Object)errorMsg, (String)"errorMsg");
        return new FailedState(failedShards, errorMsg);
    }

    public static /* synthetic */ FailedState copy$default(FailedState failedState, Map map, String string, int n, Object object) {
        if ((n & 1) != 0) {
            map = failedState.failedShards;
        }
        if ((n & 2) != 0) {
            string = failedState.errorMsg;
        }
        return failedState.copy(map, string);
    }

    @NotNull
    public String toString() {
        return "FailedState(failedShards=" + this.failedShards + ", errorMsg=" + this.errorMsg + ')';
    }

    public int hashCode() {
        int result = ((Object)this.failedShards).hashCode();
        result = result * 31 + this.errorMsg.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FailedState)) {
            return false;
        }
        FailedState failedState = (FailedState)other;
        if (!Intrinsics.areEqual(this.failedShards, failedState.failedShards)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.errorMsg, (Object)failedState.errorMsg);
    }

    private static final void writeTo$lambda-0(StreamOutput o, ShardId k) {
        k.writeTo(o);
    }

    private static final void writeTo$lambda-1(StreamOutput o, PersistentTasksCustomMetadata.PersistentTask v) {
        v.writeTo(o);
    }
}

