/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.repository;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.store.IndexInput;
import org.jetbrains.annotations.NotNull;
import org.opensearch.OpenSearchException;
import org.opensearch.action.support.single.shard.SingleShardRequest;
import org.opensearch.client.Client;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.component.AbstractLifecycleComponent;
import org.opensearch.common.concurrent.GatedCloseable;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.inject.Singleton;
import org.opensearch.common.lucene.store.InputStreamIndexInput;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.store.Store;
import org.opensearch.indices.IndicesService;
import org.opensearch.replication.action.repository.RemoteClusterRepositoryRequest;
import org.opensearch.replication.repository.RemoteClusterRestoreLeaderService;
import org.opensearch.replication.repository.RestoreContext;
import org.opensearch.replication.seqno.RemoteClusterRetentionLeaseHelper;
import org.opensearch.replication.util.ExtensionsKt;

@Singleton
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J.\u0010\u000e\u001a\u00020\r\"\u0010\b\u0000\u0010\u000f*\n\u0012\u0004\u0012\u0002H\u000f\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0013J0\u0010\u0014\u001a\u00020\r\"\u0010\b\u0000\u0010\u000f*\n\u0012\u0004\u0012\u0002H\u000f\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0013H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0016H\u0014J\b\u0010\u0018\u001a\u00020\u0016H\u0014J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\fH\u0002J>\u0010\u001a\u001a\u00020\u001b\"\u0010\b\u0000\u0010\u000f*\n\u0012\u0004\u0012\u0002H\u000f\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00132\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\fR\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/opensearch/replication/repository/RemoteClusterRestoreLeaderService;", "Lorg/opensearch/common/component/AbstractLifecycleComponent;", "indicesService", "Lorg/opensearch/indices/IndicesService;", "nodeClient", "Lorg/opensearch/client/node/NodeClient;", "(Lorg/opensearch/indices/IndicesService;Lorg/opensearch/client/node/NodeClient;)V", "closableResources", "", "Ljava/io/Closeable;", "onGoingRestores", "", "", "Lorg/opensearch/replication/repository/RestoreContext;", "addLeaderClusterRestore", "T", "Lorg/opensearch/action/support/single/shard/SingleShardRequest;", "restoreUUID", "request", "Lorg/opensearch/replication/action/repository/RemoteClusterRepositoryRequest;", "constructRestoreContext", "doClose", "", "doStart", "doStop", "getLeaderClusterRestore", "openInputStream", "Lorg/opensearch/common/lucene/store/InputStreamIndexInput;", "fileName", "length", "", "removeLeaderClusterRestore", "opensearch-cross-cluster-replication"})
public final class RemoteClusterRestoreLeaderService
extends AbstractLifecycleComponent {
    @NotNull
    private final IndicesService indicesService;
    @NotNull
    private final NodeClient nodeClient;
    @NotNull
    private final Map<String, RestoreContext> onGoingRestores;
    @NotNull
    private final List<Closeable> closableResources;

    @Inject
    public RemoteClusterRestoreLeaderService(@NotNull IndicesService indicesService, @NotNull NodeClient nodeClient) {
        Intrinsics.checkNotNullParameter((Object)indicesService, (String)"indicesService");
        Intrinsics.checkNotNullParameter((Object)nodeClient, (String)"nodeClient");
        this.indicesService = indicesService;
        this.nodeClient = nodeClient;
        this.onGoingRestores = new LinkedHashMap();
        this.closableResources = new ArrayList();
    }

    protected void doStart() {
    }

    protected void doStop() {
    }

    protected void doClose() {
        IOUtils.close((Iterable)this.closableResources);
    }

    @NotNull
    public final synchronized <T extends SingleShardRequest<T>> RestoreContext addLeaderClusterRestore(@NotNull String restoreUUID, @NotNull RemoteClusterRepositoryRequest<T> request) {
        RestoreContext restoreContext;
        Intrinsics.checkNotNullParameter((Object)restoreUUID, (String)"restoreUUID");
        Intrinsics.checkNotNullParameter(request, (String)"request");
        Map<String, RestoreContext> $this$getOrPut$iv = this.onGoingRestores;
        boolean $i$f$getOrPut = false;
        RestoreContext value$iv = $this$getOrPut$iv.get(restoreUUID);
        if (value$iv == null) {
            boolean bl = false;
            RestoreContext answer$iv = this.constructRestoreContext(restoreUUID, request);
            $this$getOrPut$iv.put(restoreUUID, answer$iv);
            restoreContext = answer$iv;
        } else {
            restoreContext = value$iv;
        }
        return restoreContext;
    }

    private final RestoreContext getLeaderClusterRestore(String restoreUUID) {
        RestoreContext restoreContext = this.onGoingRestores.get(restoreUUID);
        if (restoreContext == null) {
            throw new IllegalStateException("missing restoreContext");
        }
        return restoreContext;
    }

    @NotNull
    public final synchronized <T extends SingleShardRequest<T>> InputStreamIndexInput openInputStream(@NotNull String restoreUUID, @NotNull RemoteClusterRepositoryRequest<T> request, @NotNull String fileName, long length) {
        Intrinsics.checkNotNullParameter((Object)restoreUUID, (String)"restoreUUID");
        Intrinsics.checkNotNullParameter(request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        IndexShard indexShard = (IndexShard)this.indicesService.getShardOrNull(request.getLeaderShardId());
        if (indexShard == null) {
            throw new OpenSearchException("Shard [" + request + ".leaderShardId] missing", new Object[0]);
        }
        IndexShard leaderIndexShard = indexShard;
        Store store = leaderIndexShard.store();
        RestoreContext restoreContext = this.getLeaderClusterRestore(restoreUUID);
        Intrinsics.checkNotNullExpressionValue((Object)store, (String)"store");
        IndexInput indexInput = restoreContext.openInput(store, fileName);
        return new InputStreamIndexInput(indexInput, length){
            final /* synthetic */ IndexInput $indexInput;
            final /* synthetic */ long $length;
            {
                this.$indexInput = $indexInput;
                this.$length = $length;
                super($indexInput, $length);
            }

            public void close() throws IOException {
                Closeable[] closeableArray = new Closeable[]{(Closeable)this.$indexInput, () -> openInputStream.1.close$lambda-0(this)};
                IOUtils.close((Closeable[])closeableArray);
            }

            private static final void close$lambda-0(openInputStream.1 this$0) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                super.close();
            }
        };
    }

    private final <T extends SingleShardRequest<T>> RestoreContext constructRestoreContext(String restoreUUID, RemoteClusterRepositoryRequest<T> request) {
        IndexShard indexShard = (IndexShard)this.indicesService.getShardOrNull(request.getLeaderShardId());
        if (indexShard == null) {
            throw new OpenSearchException("Shard [" + request + ".leaderShardId] missing", new Object[0]);
        }
        IndexShard leaderIndexShard = indexShard;
        RemoteClusterRetentionLeaseHelper retentionLeaseHelper = new RemoteClusterRetentionLeaseHelper(request.getFollowerCluster(), (Client)this.nodeClient);
        Closeable retentionLock = leaderIndexShard.acquireHistoryRetentionLock();
        Intrinsics.checkNotNullExpressionValue((Object)retentionLock, (String)"retentionLock");
        this.closableResources.add(retentionLock);
        GatedCloseable indexCommitRef = leaderIndexShard.acquireSafeIndexCommit();
        Store store = leaderIndexShard.store();
        Ref.ObjectRef metadataSnapshot = new Ref.ObjectRef();
        metadataSnapshot.element = Store.MetadataSnapshot.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)store, (String)"store");
        ExtensionsKt.performOp$default(store, (Function0)new Function0<Unit>((Ref.ObjectRef<Store.MetadataSnapshot>)metadataSnapshot, store, (GatedCloseable<IndexCommit>)indexCommitRef){
            final /* synthetic */ Ref.ObjectRef<Store.MetadataSnapshot> $metadataSnapshot;
            final /* synthetic */ Store $store;
            final /* synthetic */ GatedCloseable<IndexCommit> $indexCommitRef;
            {
                this.$metadataSnapshot = $metadataSnapshot;
                this.$store = $store;
                this.$indexCommitRef = $indexCommitRef;
                super(0);
            }

            public final void invoke() {
                this.$metadataSnapshot.element = this.$store.getMetadata((IndexCommit)this.$indexCommitRef.get());
            }
        }, null, 2, null);
        long fromSeqNo = -1L;
        retentionLeaseHelper.addRetentionLease(request.getLeaderShardId(), fromSeqNo, request.getFollowerShardId(), 60000L);
        retentionLock.close();
        Intrinsics.checkNotNullExpressionValue((Object)indexCommitRef, (String)"indexCommitRef");
        Object object = metadataSnapshot.element;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"metadataSnapshot");
        RestoreContext restoreContext = new RestoreContext(restoreUUID, leaderIndexShard, (GatedCloseable<IndexCommit>)indexCommitRef, (Store.MetadataSnapshot)object, fromSeqNo);
        this.onGoingRestores.put(restoreUUID, restoreContext);
        this.closableResources.add(restoreContext);
        return restoreContext;
    }

    public final synchronized void removeLeaderClusterRestore(@NotNull String restoreUUID) {
        RestoreContext restoreContext;
        Intrinsics.checkNotNullParameter((Object)restoreUUID, (String)"restoreUUID");
        RestoreContext restoreContext2 = restoreContext = this.onGoingRestores.remove(restoreUUID);
        if (restoreContext2 != null) {
            restoreContext2.close();
        }
    }
}

