/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.action.stats;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.nodes.BaseNodesResponse;
import org.opensearch.cluster.ClusterName;
import org.opensearch.common.Strings;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.shard.ShardId;
import org.opensearch.replication.action.stats.FollowerNodeStatsResponse;
import org.opensearch.replication.metadata.ReplicationOverallState;
import org.opensearch.replication.metadata.state.ReplicationStateMetadata;
import org.opensearch.replication.task.shard.FollowerShardMetric;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 C2\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00012\u00020\u0003:\u0001CB\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B;\b\u0016\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\n\u0012\u0010\u0010\u000b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\f\u0018\u00010\n\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0016\u00107\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\u0004\u001a\u00020\u0005H\u0014J\b\u00108\u001a\u00020\u001bH\u0016J\u001a\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020:2\b\u0010<\u001a\u0004\u0018\u00010=H\u0016J\"\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020A2\u0010\u0010B\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0018\u00010\nH\u0014R\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R&\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0013\"\u0004\b#\u0010\u0015R\u001a\u0010$\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0013\"\u0004\b&\u0010\u0015R&\u0010'\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\u001c0\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u001e\"\u0004\b*\u0010 R\u001a\u0010+\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u0013\"\u0004\b-\u0010\u0015R\u001a\u0010.\u001a\u00020/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u001a\u00104\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\u0013\"\u0004\b6\u0010\u0015\u00a8\u0006D"}, d2={"Lorg/opensearch/replication/action/stats/FollowerStatsResponse;", "Lorg/opensearch/action/support/nodes/BaseNodesResponse;", "Lorg/opensearch/replication/action/stats/FollowerNodeStatsResponse;", "Lorg/opensearch/core/xcontent/ToXContentObject;", "inp", "Lorg/opensearch/common/io/stream/StreamInput;", "(Lorg/opensearch/common/io/stream/StreamInput;)V", "clusterName", "Lorg/opensearch/cluster/ClusterName;", "followerNodeResponse", "", "failures", "Lorg/opensearch/action/FailedNodeException;", "metadata", "Lorg/opensearch/replication/metadata/state/ReplicationStateMetadata;", "(Lorg/opensearch/cluster/ClusterName;Ljava/util/List;Ljava/util/List;Lorg/opensearch/replication/metadata/state/ReplicationStateMetadata;)V", "bootstrappingIndices", "", "getBootstrappingIndices", "()I", "setBootstrappingIndices", "(I)V", "failedIndices", "getFailedIndices", "setFailedIndices", "indexStats", "", "", "Lorg/opensearch/replication/task/shard/FollowerShardMetric$FollowerStats;", "getIndexStats", "()Ljava/util/Map;", "setIndexStats", "(Ljava/util/Map;)V", "indexTaskCount", "getIndexTaskCount", "setIndexTaskCount", "pausedIndices", "getPausedIndices", "setPausedIndices", "shardStats", "Lorg/opensearch/index/shard/ShardId;", "getShardStats", "setShardStats", "shardTaskCount", "getShardTaskCount", "setShardTaskCount", "stats", "Lorg/opensearch/replication/task/shard/FollowerShardMetric$FollowerStatsFragment;", "getStats", "()Lorg/opensearch/replication/task/shard/FollowerShardMetric$FollowerStatsFragment;", "setStats", "(Lorg/opensearch/replication/task/shard/FollowerShardMetric$FollowerStatsFragment;)V", "syncingIndices", "getSyncingIndices", "setSyncingIndices", "readNodesFrom", "toString", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeNodesTo", "", "out", "Lorg/opensearch/common/io/stream/StreamOutput;", "leaderNodeRespons", "Companion", "opensearch-cross-cluster-replication"})
public final class FollowerStatsResponse
extends BaseNodesResponse<FollowerNodeStatsResponse>
implements ToXContentObject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Map<ShardId, FollowerShardMetric.FollowerStats> shardStats;
    @NotNull
    private Map<String, FollowerShardMetric.FollowerStats> indexStats;
    @NotNull
    private FollowerShardMetric.FollowerStatsFragment stats;
    private int pausedIndices;
    private int failedIndices;
    private int bootstrappingIndices;
    private int syncingIndices;
    private int shardTaskCount;
    private int indexTaskCount;
    private static final Logger log = LogManager.getLogger(FollowerStatsResponse.class);

    @NotNull
    public final Map<ShardId, FollowerShardMetric.FollowerStats> getShardStats() {
        return this.shardStats;
    }

    public final void setShardStats(@NotNull Map<ShardId, FollowerShardMetric.FollowerStats> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.shardStats = map;
    }

    @NotNull
    public final Map<String, FollowerShardMetric.FollowerStats> getIndexStats() {
        return this.indexStats;
    }

    public final void setIndexStats(@NotNull Map<String, FollowerShardMetric.FollowerStats> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.indexStats = map;
    }

    @NotNull
    public final FollowerShardMetric.FollowerStatsFragment getStats() {
        return this.stats;
    }

    public final void setStats(@NotNull FollowerShardMetric.FollowerStatsFragment followerStatsFragment) {
        Intrinsics.checkNotNullParameter((Object)followerStatsFragment, (String)"<set-?>");
        this.stats = followerStatsFragment;
    }

    public final int getPausedIndices() {
        return this.pausedIndices;
    }

    public final void setPausedIndices(int n) {
        this.pausedIndices = n;
    }

    public final int getFailedIndices() {
        return this.failedIndices;
    }

    public final void setFailedIndices(int n) {
        this.failedIndices = n;
    }

    public final int getBootstrappingIndices() {
        return this.bootstrappingIndices;
    }

    public final void setBootstrappingIndices(int n) {
        this.bootstrappingIndices = n;
    }

    public final int getSyncingIndices() {
        return this.syncingIndices;
    }

    public final void setSyncingIndices(int n) {
        this.syncingIndices = n;
    }

    public final int getShardTaskCount() {
        return this.shardTaskCount;
    }

    public final void setShardTaskCount(int n) {
        this.shardTaskCount = n;
    }

    public final int getIndexTaskCount() {
        return this.indexTaskCount;
    }

    public final void setIndexTaskCount(int n) {
        this.indexTaskCount = n;
    }

    public FollowerStatsResponse(@NotNull StreamInput inp) {
        Intrinsics.checkNotNullParameter((Object)inp, (String)"inp");
        super(inp);
        this.shardStats = new LinkedHashMap();
        this.indexStats = new LinkedHashMap();
        this.stats = new FollowerShardMetric.FollowerStatsFragment();
        Map map = inp.readMap(ShardId::new, FollowerShardMetric.FollowerStats::new);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"inp.readMap(::ShardId, ::FollowerStats)");
        this.shardStats = map;
    }

    public FollowerStatsResponse(@Nullable ClusterName clusterName, @Nullable List<FollowerNodeStatsResponse> followerNodeResponse, @Nullable List<? extends FailedNodeException> failures, @NotNull ReplicationStateMetadata metadata) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        super(clusterName, followerNodeResponse, failures);
        this.shardStats = new LinkedHashMap();
        this.indexStats = new LinkedHashMap();
        this.stats = new FollowerShardMetric.FollowerStatsFragment();
        Set syncing = new LinkedHashSet();
        if (followerNodeResponse != null) {
            for (FollowerNodeStatsResponse response2 : followerNodeResponse) {
                this.shardStats.putAll(response2.getStats());
                for (Map.Entry<ShardId, FollowerShardMetric.FollowerStats> i : response2.getStats().entrySet()) {
                    String string = i.getKey().getIndexName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"i.key.indexName");
                    syncing.add(string);
                    if (!this.indexStats.containsKey(i.getKey().getIndexName())) {
                        String string2 = i.getKey().getIndexName();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"i.key.indexName");
                        this.indexStats.put(string2, new FollowerShardMetric.FollowerStats(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 511, null));
                    }
                    FollowerShardMetric.FollowerStats followerStats = this.indexStats.get(i.getKey().getIndexName());
                    Intrinsics.checkNotNull((Object)followerStats);
                    followerStats.add(i.getValue());
                    this.stats.add(i.getValue());
                }
            }
        }
        int totalRunning = 0;
        for (Map.Entry<String, Map<String, String>> entry : metadata.getReplicationDetails().entrySet()) {
            int n;
            String string = entry.getValue().get("REPLICATION_LAST_KNOWN_OVERALL_STATE");
            if (Intrinsics.areEqual((Object)string, (Object)ReplicationOverallState.RUNNING.name())) {
                n = totalRunning;
                totalRunning = n + 1;
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)ReplicationOverallState.FAILED.name())) {
                n = this.failedIndices;
                this.failedIndices = n + 1;
                continue;
            }
            if (!Intrinsics.areEqual((Object)string, (Object)ReplicationOverallState.PAUSED.name())) continue;
            n = this.pausedIndices;
            this.pausedIndices = n + 1;
        }
        this.syncingIndices = syncing.size();
        this.bootstrappingIndices = totalRunning - this.syncingIndices;
        this.shardTaskCount = this.shardStats.size();
        this.indexTaskCount = totalRunning;
    }

    @NotNull
    protected List<FollowerNodeStatsResponse> readNodesFrom(@NotNull StreamInput inp) throws IOException {
        Intrinsics.checkNotNullParameter((Object)inp, (String)"inp");
        List list = inp.readList(arg_0 -> FollowerStatsResponse.readNodesFrom$lambda-0(inp, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"inp.readList { FollowerNodeStatsResponse(inp) }");
        return list;
    }

    protected void writeNodesTo(@NotNull StreamOutput out, @Nullable List<FollowerNodeStatsResponse> leaderNodeRespons) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeList(leaderNodeRespons);
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @Nullable ToXContent.Params params) throws IOException {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.startObject();
        builder.field("num_syncing_indices", this.syncingIndices);
        builder.field("num_bootstrapping_indices", this.bootstrappingIndices);
        builder.field("num_paused_indices", this.pausedIndices);
        builder.field("num_failed_indices", this.failedIndices);
        builder.field("num_shard_tasks", this.shardTaskCount);
        builder.field("num_index_tasks", this.indexTaskCount);
        this.stats.toXContent(builder, params);
        builder.field("index_stats").map(this.indexStats);
        builder.endObject();
        return builder;
    }

    @NotNull
    public String toString() {
        Object object = XContentFactory.jsonBuilder().prettyPrint();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jsonBuilder().prettyPrint()");
        XContentBuilder builder = object;
        this.toXContent(builder, ToXContent.EMPTY_PARAMS);
        object = Strings.toString((XContentBuilder)builder);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"toString(builder)");
        return object;
    }

    private static final FollowerNodeStatsResponse readNodesFrom$lambda-0(StreamInput $inp, StreamInput it) {
        Intrinsics.checkNotNullParameter((Object)$inp, (String)"$inp");
        return new FollowerNodeStatsResponse($inp);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/opensearch/replication/action/stats/FollowerStatsResponse$Companion;", "", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "opensearch-cross-cluster-replication"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

