/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.Client;
import org.opensearch.cluster.NamedDiff;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.metadata.RepositoryMetadata;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.lifecycle.LifecycleComponent;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.IndexScopedSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.settings.SettingsFilter;
import org.opensearch.common.settings.SettingsModule;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.OpenSearchExecutors;
import org.opensearch.commons.utils.OpenForTesting;
import org.opensearch.core.ParseField;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.unit.ByteSizeUnit;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.env.Environment;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.index.IndexModule;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.engine.Engine;
import org.opensearch.index.engine.EngineConfig;
import org.opensearch.index.engine.EngineFactory;
import org.opensearch.index.engine.NRTReplicationEngine;
import org.opensearch.index.shard.IndexEventListener;
import org.opensearch.index.translog.ReplicationTranslogDeletionPolicy;
import org.opensearch.index.translog.TranslogDeletionPolicy;
import org.opensearch.index.translog.TranslogDeletionPolicyFactory;
import org.opensearch.indices.SystemIndexDescriptor;
import org.opensearch.indices.recovery.RecoverySettings;
import org.opensearch.persistent.PersistentTaskParams;
import org.opensearch.persistent.PersistentTaskState;
import org.opensearch.persistent.PersistentTasksExecutor;
import org.opensearch.plugins.ActionPlugin;
import org.opensearch.plugins.EnginePlugin;
import org.opensearch.plugins.PersistentTaskPlugin;
import org.opensearch.plugins.Plugin;
import org.opensearch.plugins.RepositoryPlugin;
import org.opensearch.plugins.SystemIndexPlugin;
import org.opensearch.replication.ReplicationEngine;
import org.opensearch.replication.ReplicationSettings;
import org.opensearch.replication.action.autofollow.AutoFollowClusterManagerNodeAction;
import org.opensearch.replication.action.autofollow.TransportAutoFollowClusterManagerNodeAction;
import org.opensearch.replication.action.autofollow.TransportUpdateAutoFollowPatternAction;
import org.opensearch.replication.action.autofollow.UpdateAutoFollowPatternAction;
import org.opensearch.replication.action.changes.GetChangesAction;
import org.opensearch.replication.action.changes.TransportGetChangesAction;
import org.opensearch.replication.action.index.ReplicateIndexAction;
import org.opensearch.replication.action.index.ReplicateIndexClusterManagerNodeAction;
import org.opensearch.replication.action.index.TransportReplicateIndexAction;
import org.opensearch.replication.action.index.TransportReplicateIndexClusterManagerNodeAction;
import org.opensearch.replication.action.index.block.TransportUpddateIndexBlockAction;
import org.opensearch.replication.action.index.block.UpdateIndexBlockAction;
import org.opensearch.replication.action.pause.PauseIndexReplicationAction;
import org.opensearch.replication.action.pause.TransportPauseIndexReplicationAction;
import org.opensearch.replication.action.replay.ReplayChangesAction;
import org.opensearch.replication.action.replay.TransportReplayChangesAction;
import org.opensearch.replication.action.replicationstatedetails.TransportUpdateReplicationStateDetails;
import org.opensearch.replication.action.replicationstatedetails.UpdateReplicationStateAction;
import org.opensearch.replication.action.repository.GetFileChunkAction;
import org.opensearch.replication.action.repository.GetStoreMetadataAction;
import org.opensearch.replication.action.repository.ReleaseLeaderResourcesAction;
import org.opensearch.replication.action.repository.TransportGetFileChunkAction;
import org.opensearch.replication.action.repository.TransportGetStoreMetadataAction;
import org.opensearch.replication.action.repository.TransportReleaseLeaderResourcesAction;
import org.opensearch.replication.action.resume.ResumeIndexReplicationAction;
import org.opensearch.replication.action.resume.TransportResumeIndexReplicationAction;
import org.opensearch.replication.action.setup.SetupChecksAction;
import org.opensearch.replication.action.setup.TransportSetupChecksAction;
import org.opensearch.replication.action.setup.TransportValidatePermissionsAction;
import org.opensearch.replication.action.setup.ValidatePermissionsAction;
import org.opensearch.replication.action.stats.AutoFollowStatsAction;
import org.opensearch.replication.action.stats.FollowerStatsAction;
import org.opensearch.replication.action.stats.LeaderStatsAction;
import org.opensearch.replication.action.stats.TransportAutoFollowStatsAction;
import org.opensearch.replication.action.stats.TransportFollowerStatsAction;
import org.opensearch.replication.action.stats.TransportLeaderStatsAction;
import org.opensearch.replication.action.status.ReplicationStatusAction;
import org.opensearch.replication.action.status.ShardsInfoAction;
import org.opensearch.replication.action.status.TranportShardsInfoAction;
import org.opensearch.replication.action.status.TransportReplicationStatusAction;
import org.opensearch.replication.action.stop.StopIndexReplicationAction;
import org.opensearch.replication.action.stop.TransportStopIndexReplicationAction;
import org.opensearch.replication.action.update.TransportUpdateIndexReplicationAction;
import org.opensearch.replication.action.update.UpdateIndexReplicationAction;
import org.opensearch.replication.metadata.ReplicationMetadataManager;
import org.opensearch.replication.metadata.TransportUpdateMetadataAction;
import org.opensearch.replication.metadata.UpdateMetadataAction;
import org.opensearch.replication.metadata.state.ReplicationStateMetadata;
import org.opensearch.replication.metadata.store.ReplicationMetadataStore;
import org.opensearch.replication.repository.RemoteClusterRepositoriesService;
import org.opensearch.replication.repository.RemoteClusterRepository;
import org.opensearch.replication.repository.RemoteClusterRestoreLeaderService;
import org.opensearch.replication.rest.AutoFollowStatsHandler;
import org.opensearch.replication.rest.FollowerStatsHandler;
import org.opensearch.replication.rest.LeaderStatsHandler;
import org.opensearch.replication.rest.PauseIndexReplicationHandler;
import org.opensearch.replication.rest.ReplicateIndexHandler;
import org.opensearch.replication.rest.ReplicationStatusHandler;
import org.opensearch.replication.rest.ResumeIndexReplicationHandler;
import org.opensearch.replication.rest.StopIndexReplicationHandler;
import org.opensearch.replication.rest.UpdateAutoFollowPatternsHandler;
import org.opensearch.replication.rest.UpdateIndexHandler;
import org.opensearch.replication.seqno.RemoteClusterStats;
import org.opensearch.replication.seqno.RemoteClusterTranslogService;
import org.opensearch.replication.task.IndexCloseListener;
import org.opensearch.replication.task.autofollow.AutoFollowExecutor;
import org.opensearch.replication.task.autofollow.AutoFollowParams;
import org.opensearch.replication.task.autofollow.AutoFollowStat;
import org.opensearch.replication.task.index.IndexReplicationExecutor;
import org.opensearch.replication.task.index.IndexReplicationParams;
import org.opensearch.replication.task.index.IndexReplicationState;
import org.opensearch.replication.task.shard.FollowerClusterStats;
import org.opensearch.replication.task.shard.ShardReplicationExecutor;
import org.opensearch.replication.task.shard.ShardReplicationParams;
import org.opensearch.replication.task.shard.ShardReplicationState;
import org.opensearch.replication.util.Injectables;
import org.opensearch.replication.util.ValidationUtil;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.repositories.Repository;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.script.ScriptService;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ExecutorBuilder;
import org.opensearch.threadpool.FixedExecutorBuilder;
import org.opensearch.threadpool.ScalingExecutorBuilder;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.watcher.ResourceWatcherService;

@OpenForTesting
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 e2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u00052\u00020\u0006:\u0001eB\u0005\u00a2\u0006\u0002\u0010\u0007Jl\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&H\u0016J\f\u0010(\u001a\u0006\u0012\u0002\b\u00030)H\u0002J\u001e\u0010*\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0006\b\u0001\u0012\u00020-\u0012\u0006\b\u0001\u0012\u00020.0,0+H\u0016J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u00020100H\u0016J\u0016\u00102\u001a\b\u0012\u0004\u0012\u000203002\u0006\u00104\u001a\u000205H\u0016J\u001a\u00106\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030)0+2\u0006\u00107\u001a\u000208H\u0016J\u0016\u00109\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020;0:0\u0015H\u0016J4\u0010<\u001a\u000e\u0012\u0004\u0012\u00020>\u0012\u0004\u0012\u00020?0=2\u0006\u0010@\u001a\u00020\u001e2\u0006\u0010A\u001a\u00020\u001c2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010B\u001a\u00020CH\u0016J\u000e\u0010D\u001a\b\u0012\u0004\u0012\u00020E0+H\u0016J\u000e\u0010F\u001a\b\u0012\u0004\u0012\u00020G0+H\u0016J:\u0010H\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030I0+2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020$H\u0016JP\u0010M\u001a\b\u0012\u0004\u0012\u00020N0+2\u0006\u00107\u001a\u0002082\u0006\u0010O\u001a\u00020P2\b\u0010Q\u001a\u0004\u0018\u00010R2\u0006\u0010S\u001a\u00020T2\b\u0010U\u001a\u0004\u0018\u00010V2\u0006\u0010#\u001a\u00020$2\f\u0010W\u001a\b\u0012\u0004\u0012\u00020X0&H\u0016J\u0012\u0010Y\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030Z0+H\u0016J\u0016\u0010[\u001a\b\u0012\u0004\u0012\u00020\\0\u00152\u0006\u00107\u001a\u000208H\u0016J\u0014\u0010]\u001a\u0006\u0012\u0002\b\u00030)2\u0006\u00107\u001a\u000208H\u0002J\u0010\u0010^\u001a\u00020_2\u0006\u0010`\u001a\u00020_H\u0002J\u0010\u0010a\u001a\u00020b2\u0006\u0010c\u001a\u00020dH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006f"}, d2={"Lorg/opensearch/replication/ReplicationPlugin;", "Lorg/opensearch/plugins/Plugin;", "Lorg/opensearch/plugins/ActionPlugin;", "Lorg/opensearch/plugins/PersistentTaskPlugin;", "Lorg/opensearch/plugins/RepositoryPlugin;", "Lorg/opensearch/plugins/EnginePlugin;", "Lorg/opensearch/plugins/SystemIndexPlugin;", "()V", "client", "Lorg/opensearch/client/Client;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "followerClusterStats", "Lorg/opensearch/replication/task/shard/FollowerClusterStats;", "replicationMetadataManager", "Lorg/opensearch/replication/metadata/ReplicationMetadataManager;", "replicationSettings", "Lorg/opensearch/replication/ReplicationSettings;", "threadPool", "Lorg/opensearch/threadpool/ThreadPool;", "createComponents", "", "", "resourceWatcherService", "Lorg/opensearch/watcher/ResourceWatcherService;", "scriptService", "Lorg/opensearch/script/ScriptService;", "xContentRegistry", "Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "environment", "Lorg/opensearch/env/Environment;", "nodeEnvironment", "Lorg/opensearch/env/NodeEnvironment;", "namedWriteableRegistry", "Lorg/opensearch/core/common/io/stream/NamedWriteableRegistry;", "indexNameExpressionResolver", "Lorg/opensearch/cluster/metadata/IndexNameExpressionResolver;", "repositoriesService", "Ljava/util/function/Supplier;", "Lorg/opensearch/repositories/RepositoriesService;", "followerExecutorBuilder", "Lorg/opensearch/threadpool/ExecutorBuilder;", "getActions", "", "Lorg/opensearch/plugins/ActionPlugin$ActionHandler;", "Lorg/opensearch/action/ActionRequest;", "Lorg/opensearch/core/action/ActionResponse;", "getCustomTranslogDeletionPolicyFactory", "Ljava/util/Optional;", "Lorg/opensearch/index/translog/TranslogDeletionPolicyFactory;", "getEngineFactory", "Lorg/opensearch/index/engine/EngineFactory;", "indexSettings", "Lorg/opensearch/index/IndexSettings;", "getExecutorBuilders", "settings", "Lorg/opensearch/common/settings/Settings;", "getGuiceServiceClasses", "Ljava/lang/Class;", "Lorg/opensearch/common/lifecycle/LifecycleComponent;", "getInternalRepositories", "", "", "Lorg/opensearch/repositories/Repository$Factory;", "env", "namedXContentRegistry", "recoverySettings", "Lorg/opensearch/indices/recovery/RecoverySettings;", "getNamedWriteables", "Lorg/opensearch/core/common/io/stream/NamedWriteableRegistry$Entry;", "getNamedXContent", "Lorg/opensearch/core/xcontent/NamedXContentRegistry$Entry;", "getPersistentTasksExecutor", "Lorg/opensearch/persistent/PersistentTasksExecutor;", "settingsModule", "Lorg/opensearch/common/settings/SettingsModule;", "expressionResolver", "getRestHandlers", "Lorg/opensearch/rest/RestHandler;", "restController", "Lorg/opensearch/rest/RestController;", "clusterSettings", "Lorg/opensearch/common/settings/ClusterSettings;", "indexScopedSettings", "Lorg/opensearch/common/settings/IndexScopedSettings;", "settingsFilter", "Lorg/opensearch/common/settings/SettingsFilter;", "nodesInCluster", "Lorg/opensearch/cluster/node/DiscoveryNodes;", "getSettings", "Lorg/opensearch/common/settings/Setting;", "getSystemIndexDescriptors", "Lorg/opensearch/indices/SystemIndexDescriptor;", "leaderExecutorBuilder", "leaderThreadPoolSize", "", "allocatedProcessors", "onIndexModule", "", "indexModule", "Lorg/opensearch/index/IndexModule;", "Companion", "opensearch-cross-cluster-replication"})
public final class ReplicationPlugin
extends Plugin
implements ActionPlugin,
PersistentTaskPlugin,
RepositoryPlugin,
EnginePlugin,
SystemIndexPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private Client client;
    private ClusterService clusterService;
    private ThreadPool threadPool;
    private ReplicationMetadataManager replicationMetadataManager;
    private ReplicationSettings replicationSettings;
    @NotNull
    private FollowerClusterStats followerClusterStats = new FollowerClusterStats();
    @NotNull
    public static final String KNN_INDEX_SETTING = "index.knn";
    @NotNull
    public static final String KNN_PLUGIN_PRESENT_SETTING = "knn.plugin.enabled";
    @NotNull
    public static final String REPLICATION_EXECUTOR_NAME_LEADER = "replication_leader";
    @NotNull
    public static final String REPLICATION_EXECUTOR_NAME_FOLLOWER = "replication_follower";
    @NotNull
    private static final Setting<String> REPLICATED_INDEX_SETTING;
    @NotNull
    private static final Setting<Integer> REPLICATION_FOLLOWER_OPS_BATCH_SIZE;
    @NotNull
    private static final Setting<Integer> REPLICATION_LEADER_THREADPOOL_SIZE;
    @NotNull
    private static final Setting<Integer> REPLICATION_LEADER_THREADPOOL_QUEUE_SIZE;
    @NotNull
    private static final Setting<ByteSizeValue> REPLICATION_FOLLOWER_RECOVERY_CHUNK_SIZE;
    @NotNull
    private static final Setting<Integer> REPLICATION_FOLLOWER_RECOVERY_PARALLEL_CHUNKS;
    private static final Setting<Integer> REPLICATION_FOLLOWER_CONCURRENT_READERS_PER_SHARD;
    private static final Setting<Integer> REPLICATION_FOLLOWER_CONCURRENT_WRITERS_PER_SHARD;
    private static final Setting<TimeValue> REPLICATION_PARALLEL_READ_POLL_INTERVAL;
    private static final Setting<TimeValue> REPLICATION_AUTOFOLLOW_REMOTE_INDICES_POLL_INTERVAL;
    private static final Setting<TimeValue> REPLICATION_AUTOFOLLOW_REMOTE_INDICES_RETRY_POLL_INTERVAL;
    private static final Setting<TimeValue> REPLICATION_METADATA_SYNC_INTERVAL;
    private static final Setting<TimeValue> REPLICATION_RETENTION_LEASE_MAX_FAILURE_DURATION;
    @NotNull
    private static final Setting<Boolean> REPLICATION_INDEX_TRANSLOG_PRUNING_ENABLED_SETTING;
    @NotNull
    private static final Setting<ByteSizeValue> REPLICATION_INDEX_TRANSLOG_RETENTION_SIZE;
    @NotNull
    private static final Setting<Boolean> REPLICATION_FOLLOWER_BLOCK_START;
    @NotNull
    private static final Setting<Integer> REPLICATION_AUTOFOLLOW_CONCURRENT_REPLICATION_JOBS_TRIGGER_SIZE;

    @NotNull
    public Collection<Object> createComponents(@NotNull Client client, @NotNull ClusterService clusterService, @NotNull ThreadPool threadPool, @NotNull ResourceWatcherService resourceWatcherService, @NotNull ScriptService scriptService, @NotNull NamedXContentRegistry xContentRegistry, @NotNull Environment environment, @NotNull NodeEnvironment nodeEnvironment, @NotNull NamedWriteableRegistry namedWriteableRegistry, @NotNull IndexNameExpressionResolver indexNameExpressionResolver, @NotNull Supplier<RepositoriesService> repositoriesService) {
        ReplicationSettings replicationSettings;
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)threadPool, (String)"threadPool");
        Intrinsics.checkNotNullParameter((Object)resourceWatcherService, (String)"resourceWatcherService");
        Intrinsics.checkNotNullParameter((Object)scriptService, (String)"scriptService");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)nodeEnvironment, (String)"nodeEnvironment");
        Intrinsics.checkNotNullParameter((Object)namedWriteableRegistry, (String)"namedWriteableRegistry");
        Intrinsics.checkNotNullParameter((Object)indexNameExpressionResolver, (String)"indexNameExpressionResolver");
        Intrinsics.checkNotNullParameter(repositoriesService, (String)"repositoriesService");
        this.client = client;
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.replicationMetadataManager = new ReplicationMetadataManager(clusterService, client, new ReplicationMetadataStore(client, clusterService, xContentRegistry));
        this.replicationSettings = new ReplicationSettings(clusterService);
        Object[] objectArray = new Object[4];
        objectArray[0] = new RemoteClusterRepositoriesService(repositoriesService, clusterService);
        Object object = this.replicationMetadataManager;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"replicationMetadataManager");
            object = objectArray[1] = null;
        }
        if ((replicationSettings = this.replicationSettings) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"replicationSettings");
            replicationSettings = null;
        }
        objectArray[2] = replicationSettings;
        objectArray[3] = this.followerClusterStats;
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public Collection<Class<? extends LifecycleComponent>> getGuiceServiceClasses() {
        Object[] objectArray = new Class[]{Injectables.class, RemoteClusterStats.class, RemoteClusterRestoreLeaderService.class, RemoteClusterTranslogService.class};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        Object[] objectArray = new ActionPlugin.ActionHandler[]{new ActionPlugin.ActionHandler((ActionType)GetChangesAction.Companion.getINSTANCE(), TransportGetChangesAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ReplicateIndexAction.Companion.getINSTANCE(), TransportReplicateIndexAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ReplicateIndexClusterManagerNodeAction.Companion.getINSTANCE(), TransportReplicateIndexClusterManagerNodeAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ReplayChangesAction.Companion.getINSTANCE(), TransportReplayChangesAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetStoreMetadataAction.Companion.getINSTANCE(), TransportGetStoreMetadataAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetFileChunkAction.Companion.getINSTANCE(), TransportGetFileChunkAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)UpdateAutoFollowPatternAction.Companion.getINSTANCE(), TransportUpdateAutoFollowPatternAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)AutoFollowClusterManagerNodeAction.Companion.getINSTANCE(), TransportAutoFollowClusterManagerNodeAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)StopIndexReplicationAction.Companion.getINSTANCE(), TransportStopIndexReplicationAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)PauseIndexReplicationAction.Companion.getINSTANCE(), TransportPauseIndexReplicationAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ResumeIndexReplicationAction.Companion.getINSTANCE(), TransportResumeIndexReplicationAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)UpdateIndexReplicationAction.Companion.getINSTANCE(), TransportUpdateIndexReplicationAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)UpdateIndexBlockAction.Companion.getINSTANCE(), TransportUpddateIndexBlockAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ReleaseLeaderResourcesAction.Companion.getINSTANCE(), TransportReleaseLeaderResourcesAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)UpdateMetadataAction.Companion.getINSTANCE(), TransportUpdateMetadataAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ValidatePermissionsAction.Companion.getINSTANCE(), TransportValidatePermissionsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SetupChecksAction.Companion.getINSTANCE(), TransportSetupChecksAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)UpdateReplicationStateAction.Companion.getINSTANCE(), TransportUpdateReplicationStateDetails.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ShardsInfoAction.Companion.getINSTANCE(), TranportShardsInfoAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ReplicationStatusAction.Companion.getINSTANCE(), TransportReplicationStatusAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)LeaderStatsAction.Companion.getINSTANCE(), TransportLeaderStatsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)FollowerStatsAction.Companion.getINSTANCE(), TransportFollowerStatsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)AutoFollowStatsAction.Companion.getINSTANCE(), TransportAutoFollowStatsAction.class, new Class[0])};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public List<RestHandler> getRestHandlers(@NotNull Settings settings, @NotNull RestController restController, @Nullable ClusterSettings clusterSettings, @NotNull IndexScopedSettings indexScopedSettings, @Nullable SettingsFilter settingsFilter, @NotNull IndexNameExpressionResolver indexNameExpressionResolver, @NotNull Supplier<DiscoveryNodes> nodesInCluster) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)restController, (String)"restController");
        Intrinsics.checkNotNullParameter((Object)indexScopedSettings, (String)"indexScopedSettings");
        Intrinsics.checkNotNullParameter((Object)indexNameExpressionResolver, (String)"indexNameExpressionResolver");
        Intrinsics.checkNotNullParameter(nodesInCluster, (String)"nodesInCluster");
        Object[] objectArray = new BaseRestHandler[]{new ReplicateIndexHandler(), new UpdateAutoFollowPatternsHandler(), new PauseIndexReplicationHandler(), new ResumeIndexReplicationHandler(), new UpdateIndexHandler(), new StopIndexReplicationHandler(), new ReplicationStatusHandler(), new LeaderStatsHandler(), new FollowerStatsHandler(), new AutoFollowStatsHandler()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public List<ExecutorBuilder<?>> getExecutorBuilders(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Object[] objectArray = new ExecutorBuilder[]{this.followerExecutorBuilder(), this.leaderExecutorBuilder(settings)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final ExecutorBuilder<?> followerExecutorBuilder() {
        return (ExecutorBuilder)new ScalingExecutorBuilder(REPLICATION_EXECUTOR_NAME_FOLLOWER, 1, 10, TimeValue.timeValueMinutes((long)1L), REPLICATION_EXECUTOR_NAME_FOLLOWER);
    }

    private final ExecutorBuilder<?> leaderExecutorBuilder(Settings settings) {
        Integer leaderThreadPoolSize;
        int availableProcessors = OpenSearchExecutors.allocatedProcessors((Settings)settings);
        Integer leaderThreadPoolQueueSize = (Integer)REPLICATION_LEADER_THREADPOOL_QUEUE_SIZE.get(settings);
        Integer n = leaderThreadPoolSize = (Integer)REPLICATION_LEADER_THREADPOOL_SIZE.get(settings);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"leaderThreadPoolSize");
        Integer n2 = leaderThreadPoolSize = ((Number)n).intValue() > 0 ? leaderThreadPoolSize : Integer.valueOf(this.leaderThreadPoolSize(availableProcessors));
        Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"leaderThreadPoolSize");
        int n3 = ((Number)n2).intValue();
        Intrinsics.checkNotNullExpressionValue((Object)leaderThreadPoolQueueSize, (String)"leaderThreadPoolQueueSize");
        return (ExecutorBuilder)new FixedExecutorBuilder(settings, REPLICATION_EXECUTOR_NAME_LEADER, n3, leaderThreadPoolQueueSize.intValue(), REPLICATION_EXECUTOR_NAME_LEADER);
    }

    private final int leaderThreadPoolSize(int allocatedProcessors) {
        return allocatedProcessors * 3 / 2 + 1;
    }

    @NotNull
    public List<PersistentTasksExecutor<?>> getPersistentTasksExecutor(@NotNull ClusterService clusterService, @NotNull ThreadPool threadPool, @NotNull Client client, @NotNull SettingsModule settingsModule, @NotNull IndexNameExpressionResolver expressionResolver) {
        ReplicationSettings replicationSettings;
        ReplicationSettings replicationSettings2;
        ReplicationSettings replicationSettings3;
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)threadPool, (String)"threadPool");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)settingsModule, (String)"settingsModule");
        Intrinsics.checkNotNullParameter((Object)expressionResolver, (String)"expressionResolver");
        Object[] objectArray = new PersistentTasksExecutor[3];
        ReplicationMetadataManager replicationMetadataManager = this.replicationMetadataManager;
        if (replicationMetadataManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"replicationMetadataManager");
            replicationMetadataManager = null;
        }
        if ((replicationSettings3 = this.replicationSettings) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"replicationSettings");
            replicationSettings3 = null;
        }
        objectArray[0] = new ShardReplicationExecutor(REPLICATION_EXECUTOR_NAME_FOLLOWER, clusterService, threadPool, client, replicationMetadataManager, replicationSettings3, this.followerClusterStats);
        ReplicationMetadataManager replicationMetadataManager2 = this.replicationMetadataManager;
        if (replicationMetadataManager2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"replicationMetadataManager");
            replicationMetadataManager2 = null;
        }
        if ((replicationSettings2 = this.replicationSettings) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"replicationSettings");
            replicationSettings2 = null;
        }
        objectArray[1] = new IndexReplicationExecutor(REPLICATION_EXECUTOR_NAME_FOLLOWER, clusterService, threadPool, client, replicationMetadataManager2, replicationSettings2, settingsModule);
        ReplicationMetadataManager replicationMetadataManager3 = this.replicationMetadataManager;
        if (replicationMetadataManager3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"replicationMetadataManager");
            replicationMetadataManager3 = null;
        }
        if ((replicationSettings = this.replicationSettings) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"replicationSettings");
            replicationSettings = null;
        }
        objectArray[2] = new AutoFollowExecutor(REPLICATION_EXECUTOR_NAME_FOLLOWER, clusterService, threadPool, client, replicationMetadataManager3, replicationSettings);
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        Object[] objectArray = new NamedWriteableRegistry.Entry[]{new NamedWriteableRegistry.Entry(PersistentTaskParams.class, "cluster:indices/shards/replication", ReplicationPlugin::getNamedWriteables$lambda$0), new NamedWriteableRegistry.Entry(PersistentTaskState.class, "cluster:indices/shards/replication", ReplicationPlugin::getNamedWriteables$lambda$1), new NamedWriteableRegistry.Entry(PersistentTaskParams.class, "cluster:indices/admin/replication", ReplicationPlugin::getNamedWriteables$lambda$2), new NamedWriteableRegistry.Entry(PersistentTaskState.class, "cluster:indices/admin/replication", ReplicationPlugin::getNamedWriteables$lambda$3), new NamedWriteableRegistry.Entry(PersistentTaskParams.class, "cluster:admin/plugins/replication/autofollow", ReplicationPlugin::getNamedWriteables$lambda$4), new NamedWriteableRegistry.Entry(Metadata.Custom.class, "replication_metadata", ReplicationPlugin::getNamedWriteables$lambda$5), new NamedWriteableRegistry.Entry(NamedDiff.class, "replication_metadata", ReplicationPlugin::getNamedWriteables$lambda$6), new NamedWriteableRegistry.Entry(Task.Status.class, AutoFollowStat.Companion.getNAME(), ReplicationPlugin::getNamedWriteables$lambda$7)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        Object[] objectArray = new NamedXContentRegistry.Entry[]{new NamedXContentRegistry.Entry(PersistentTaskParams.class, new ParseField("cluster:indices/admin/replication", new String[0]), ReplicationPlugin::getNamedXContent$lambda$8), new NamedXContentRegistry.Entry(PersistentTaskState.class, new ParseField("cluster:indices/admin/replication", new String[0]), ReplicationPlugin::getNamedXContent$lambda$9), new NamedXContentRegistry.Entry(PersistentTaskParams.class, new ParseField("cluster:indices/shards/replication", new String[0]), ReplicationPlugin::getNamedXContent$lambda$10), new NamedXContentRegistry.Entry(PersistentTaskState.class, new ParseField("cluster:indices/shards/replication", new String[0]), ReplicationPlugin::getNamedXContent$lambda$11), new NamedXContentRegistry.Entry(PersistentTaskParams.class, new ParseField("cluster:admin/plugins/replication/autofollow", new String[0]), ReplicationPlugin::getNamedXContent$lambda$12), new NamedXContentRegistry.Entry(Metadata.Custom.class, new ParseField("replication_metadata", new String[0]), ReplicationPlugin::getNamedXContent$lambda$13)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public List<Setting<?>> getSettings() {
        Object[] objectArray = new Setting[]{REPLICATED_INDEX_SETTING, REPLICATION_FOLLOWER_OPS_BATCH_SIZE, REPLICATION_LEADER_THREADPOOL_SIZE, REPLICATION_LEADER_THREADPOOL_QUEUE_SIZE, REPLICATION_FOLLOWER_CONCURRENT_READERS_PER_SHARD, REPLICATION_FOLLOWER_RECOVERY_CHUNK_SIZE, REPLICATION_FOLLOWER_RECOVERY_PARALLEL_CHUNKS, REPLICATION_PARALLEL_READ_POLL_INTERVAL, REPLICATION_AUTOFOLLOW_REMOTE_INDICES_POLL_INTERVAL, REPLICATION_AUTOFOLLOW_REMOTE_INDICES_RETRY_POLL_INTERVAL, REPLICATION_METADATA_SYNC_INTERVAL, REPLICATION_RETENTION_LEASE_MAX_FAILURE_DURATION, REPLICATION_INDEX_TRANSLOG_PRUNING_ENABLED_SETTING, REPLICATION_INDEX_TRANSLOG_RETENTION_SIZE, REPLICATION_FOLLOWER_BLOCK_START, REPLICATION_AUTOFOLLOW_CONCURRENT_REPLICATION_JOBS_TRIGGER_SIZE, REPLICATION_FOLLOWER_CONCURRENT_WRITERS_PER_SHARD};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public Map<String, Repository.Factory> getInternalRepositories(@NotNull Environment env, @NotNull NamedXContentRegistry namedXContentRegistry, @NotNull ClusterService clusterService, @NotNull RecoverySettings recoverySettings) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)namedXContentRegistry, (String)"namedXContentRegistry");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)recoverySettings, (String)"recoverySettings");
        Repository.Factory repoFactory = arg_0 -> ReplicationPlugin.getInternalRepositories$lambda$14(this, clusterService, recoverySettings, arg_0);
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"replication-remote-repository", (Object)repoFactory));
    }

    @NotNull
    public Optional<EngineFactory> getEngineFactory(@NotNull IndexSettings indexSettings) {
        Optional<EngineFactory> optional;
        Intrinsics.checkNotNullParameter((Object)indexSettings, (String)"indexSettings");
        if (indexSettings.getSettings().get(REPLICATED_INDEX_SETTING.getKey()) != null) {
            Optional<EngineFactory> optional2 = Optional.of(ReplicationPlugin::getEngineFactory$lambda$15);
            optional = optional2;
            Intrinsics.checkNotNullExpressionValue(optional2, (String)"{\n            Optional.o\u2026\n            })\n        }");
        } else {
            Optional optional3 = Optional.empty();
            optional = optional3;
            Intrinsics.checkNotNullExpressionValue(optional3, (String)"{\n            Optional.empty()\n        }");
        }
        return optional;
    }

    @NotNull
    public Optional<TranslogDeletionPolicyFactory> getCustomTranslogDeletionPolicyFactory() {
        Optional<TranslogDeletionPolicyFactory> optional;
        ClusterService clusterService = this.clusterService;
        if (clusterService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"clusterService");
            clusterService = null;
        }
        if (!ValidationUtil.INSTANCE.isRemoteStoreEnabledCluster(clusterService)) {
            Optional<TranslogDeletionPolicyFactory> optional2 = Optional.of(ReplicationPlugin::getCustomTranslogDeletionPolicyFactory$lambda$16);
            optional = optional2;
            Intrinsics.checkNotNullExpressionValue(optional2, (String)"{\n            Optional.o\u2026\n            })\n        }");
        } else {
            Optional optional3 = Optional.empty();
            optional = optional3;
            Intrinsics.checkNotNullExpressionValue(optional3, (String)"{\n            Optional.empty()\n        }");
        }
        return optional;
    }

    public void onIndexModule(@NotNull IndexModule indexModule) {
        Intrinsics.checkNotNullParameter((Object)indexModule, (String)"indexModule");
        super.onIndexModule(indexModule);
        if (indexModule.getSettings().get(REPLICATED_INDEX_SETTING.getKey()) != null) {
            indexModule.addIndexEventListener((IndexEventListener)IndexCloseListener.INSTANCE);
        }
    }

    @NotNull
    public Collection<SystemIndexDescriptor> getSystemIndexDescriptors(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return CollectionsKt.listOf((Object)new SystemIndexDescriptor(".replication-metadata-store", "System Index for storing cross cluster replication configuration."));
    }

    private static final ShardReplicationParams getNamedWriteables$lambda$0(StreamInput inp) {
        Intrinsics.checkNotNullExpressionValue((Object)inp, (String)"inp");
        return new ShardReplicationParams(inp);
    }

    private static final ShardReplicationState getNamedWriteables$lambda$1(StreamInput inp) {
        Intrinsics.checkNotNullExpressionValue((Object)inp, (String)"inp");
        return ShardReplicationState.Companion.reader(inp);
    }

    private static final IndexReplicationParams getNamedWriteables$lambda$2(StreamInput inp) {
        Intrinsics.checkNotNullExpressionValue((Object)inp, (String)"inp");
        return new IndexReplicationParams(inp);
    }

    private static final IndexReplicationState getNamedWriteables$lambda$3(StreamInput inp) {
        Intrinsics.checkNotNullExpressionValue((Object)inp, (String)"inp");
        return IndexReplicationState.Companion.reader(inp);
    }

    private static final AutoFollowParams getNamedWriteables$lambda$4(StreamInput inp) {
        Intrinsics.checkNotNullExpressionValue((Object)inp, (String)"inp");
        return new AutoFollowParams(inp);
    }

    private static final ReplicationStateMetadata getNamedWriteables$lambda$5(StreamInput inp) {
        Intrinsics.checkNotNullExpressionValue((Object)inp, (String)"inp");
        return new ReplicationStateMetadata(inp);
    }

    private static final ReplicationStateMetadata.Diff getNamedWriteables$lambda$6(StreamInput inp) {
        Intrinsics.checkNotNullExpressionValue((Object)inp, (String)"inp");
        return new ReplicationStateMetadata.Diff(inp);
    }

    private static final AutoFollowStat getNamedWriteables$lambda$7(StreamInput inp) {
        Intrinsics.checkNotNullExpressionValue((Object)inp, (String)"inp");
        return new AutoFollowStat(inp);
    }

    private static final IndexReplicationParams getNamedXContent$lambda$8(XContentParser parser) {
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        return IndexReplicationParams.Companion.fromXContent(parser);
    }

    private static final IndexReplicationState getNamedXContent$lambda$9(XContentParser parser) {
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        return IndexReplicationState.Companion.fromXContent(parser);
    }

    private static final ShardReplicationParams getNamedXContent$lambda$10(XContentParser parser) {
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        return ShardReplicationParams.Companion.fromXContent(parser);
    }

    private static final ShardReplicationState getNamedXContent$lambda$11(XContentParser parser) {
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        return ShardReplicationState.Companion.fromXContent(parser);
    }

    private static final AutoFollowParams getNamedXContent$lambda$12(XContentParser parser) {
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        return AutoFollowParams.Companion.fromXContent(parser);
    }

    private static final ReplicationStateMetadata getNamedXContent$lambda$13(XContentParser parser) {
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        return ReplicationStateMetadata.Companion.fromXContent(parser);
    }

    private static final Repository getInternalRepositories$lambda$14(ReplicationPlugin this$0, ClusterService $clusterService, RecoverySettings $recoverySettings, RepositoryMetadata repoMetadata) {
        ReplicationSettings replicationSettings;
        ReplicationMetadataManager replicationMetadataManager;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$clusterService, (String)"$clusterService");
        Intrinsics.checkNotNullParameter((Object)$recoverySettings, (String)"$recoverySettings");
        Intrinsics.checkNotNullParameter((Object)repoMetadata, (String)"repoMetadata");
        Client client = this$0.client;
        if (client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            client = null;
        }
        if ((replicationMetadataManager = this$0.replicationMetadataManager) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"replicationMetadataManager");
            replicationMetadataManager = null;
        }
        if ((replicationSettings = this$0.replicationSettings) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"replicationSettings");
            replicationSettings = null;
        }
        return new RemoteClusterRepository(repoMetadata, client, $clusterService, $recoverySettings, replicationMetadataManager, replicationSettings);
    }

    private static final Engine getEngineFactory$lambda$15(EngineConfig config) {
        Engine engine;
        if (config.isReadOnlyReplica()) {
            engine = (Engine)new NRTReplicationEngine(config);
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)config, (String)"config");
            engine = (Engine)new ReplicationEngine(config);
        }
        return engine;
    }

    private static final TranslogDeletionPolicy getCustomTranslogDeletionPolicyFactory$lambda$16(IndexSettings indexSettings, Supplier retentionLeasesSupplier) {
        Intrinsics.checkNotNullExpressionValue((Object)indexSettings, (String)"indexSettings");
        Intrinsics.checkNotNullExpressionValue((Object)retentionLeasesSupplier, (String)"retentionLeasesSupplier");
        return new ReplicationTranslogDeletionPolicy(indexSettings, retentionLeasesSupplier);
    }

    static {
        Setting.Property[] propertyArray = new Setting.Property[]{Setting.Property.InternalIndex, Setting.Property.IndexScope};
        Setting setting = Setting.simpleString((String)"index.plugins.replication.follower.leader_index", (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)setting, (String)"simpleString(\"index.plug\u2026ting.Property.IndexScope)");
        REPLICATED_INDEX_SETTING = setting;
        propertyArray = new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope};
        Setting setting2 = Setting.intSetting((String)"plugins.replication.follower.index.ops_batch_size", (int)50000, (int)16, (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)setting2, (String)"intSetting(\"plugins.repl\u2026tting.Property.NodeScope)");
        REPLICATION_FOLLOWER_OPS_BATCH_SIZE = setting2;
        propertyArray = new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope};
        Setting setting3 = Setting.intSetting((String)"plugins.replication.leader.thread_pool.size", (int)0, (int)0, (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)setting3, (String)"intSetting(\"plugins.repl\u2026tting.Property.NodeScope)");
        REPLICATION_LEADER_THREADPOOL_SIZE = setting3;
        propertyArray = new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope};
        Setting setting4 = Setting.intSetting((String)"plugins.replication.leader.thread_pool.queue_size", (int)1000, (int)0, (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)setting4, (String)"intSetting(\"plugins.repl\u2026tting.Property.NodeScope)");
        REPLICATION_LEADER_THREADPOOL_QUEUE_SIZE = setting4;
        propertyArray = new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope};
        Setting setting5 = Setting.byteSizeSetting((String)"plugins.replication.follower.index.recovery.chunk_size", (ByteSizeValue)new ByteSizeValue(10L, ByteSizeUnit.MB), (ByteSizeValue)new ByteSizeValue(1L, ByteSizeUnit.MB), (ByteSizeValue)new ByteSizeValue(1L, ByteSizeUnit.GB), (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)setting5, (String)"byteSizeSetting(\"plugins\u2026tting.Property.NodeScope)");
        REPLICATION_FOLLOWER_RECOVERY_CHUNK_SIZE = setting5;
        propertyArray = new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope};
        Setting setting6 = Setting.intSetting((String)"plugins.replication.follower.index.recovery.max_concurrent_file_chunks", (int)5, (int)1, (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)setting6, (String)"intSetting(\"plugins.repl\u2026tting.Property.NodeScope)");
        REPLICATION_FOLLOWER_RECOVERY_PARALLEL_CHUNKS = setting6;
        Setting.Property[] propertyArray2 = new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope};
        REPLICATION_FOLLOWER_CONCURRENT_READERS_PER_SHARD = Setting.intSetting((String)"plugins.replication.follower.concurrent_readers_per_shard", (int)2, (int)1, (Setting.Property[])propertyArray2);
        propertyArray2 = new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope};
        REPLICATION_FOLLOWER_CONCURRENT_WRITERS_PER_SHARD = Setting.intSetting((String)"plugins.replication.follower.concurrent_writers_per_shard", (int)2, (int)1, (Setting.Property[])propertyArray2);
        propertyArray2 = new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope};
        REPLICATION_PARALLEL_READ_POLL_INTERVAL = Setting.timeSetting((String)"plugins.replication.follower.poll_interval", (TimeValue)TimeValue.timeValueMillis((long)50L), (TimeValue)TimeValue.timeValueMillis((long)1L), (TimeValue)TimeValue.timeValueSeconds((long)1L), (Setting.Property[])propertyArray2);
        propertyArray2 = new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope};
        REPLICATION_AUTOFOLLOW_REMOTE_INDICES_POLL_INTERVAL = Setting.timeSetting((String)"plugins.replication.autofollow.fetch_poll_interval", (TimeValue)TimeValue.timeValueSeconds((long)30L), (TimeValue)TimeValue.timeValueSeconds((long)30L), (TimeValue)TimeValue.timeValueHours((long)1L), (Setting.Property[])propertyArray2);
        propertyArray2 = new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope};
        REPLICATION_AUTOFOLLOW_REMOTE_INDICES_RETRY_POLL_INTERVAL = Setting.timeSetting((String)"plugins.replication.autofollow.retry_poll_interval", (TimeValue)TimeValue.timeValueHours((long)1L), (TimeValue)TimeValue.timeValueMinutes((long)1L), (TimeValue)TimeValue.timeValueHours((long)4L), (Setting.Property[])propertyArray2);
        propertyArray2 = new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope};
        REPLICATION_METADATA_SYNC_INTERVAL = Setting.timeSetting((String)"plugins.replication.follower.metadata_sync_interval", (TimeValue)TimeValue.timeValueSeconds((long)60L), (TimeValue)TimeValue.timeValueSeconds((long)5L), (Setting.Property[])propertyArray2);
        propertyArray2 = new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope};
        REPLICATION_RETENTION_LEASE_MAX_FAILURE_DURATION = Setting.timeSetting((String)"plugins.replication.follower.retention_lease_max_failure_duration", (TimeValue)TimeValue.timeValueHours((long)1L), (TimeValue)TimeValue.timeValueSeconds((long)1L), (TimeValue)TimeValue.timeValueHours((long)12L), (Setting.Property[])propertyArray2);
        propertyArray = new Setting.Property[]{Setting.Property.IndexScope, Setting.Property.Dynamic};
        Setting setting7 = Setting.boolSetting((String)"index.plugins.replication.translog.retention_lease.pruning.enabled", (boolean)false, (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)setting7, (String)"boolSetting(\"index.plugi\u2026Setting.Property.Dynamic)");
        REPLICATION_INDEX_TRANSLOG_PRUNING_ENABLED_SETTING = setting7;
        propertyArray = new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.IndexScope};
        Setting setting8 = Setting.byteSizeSetting((String)"index.plugins.replication.translog.retention_size", (ByteSizeValue)new ByteSizeValue(512L, ByteSizeUnit.MB), (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)setting8, (String)"byteSizeSetting(\"index.p\u2026ting.Property.IndexScope)");
        REPLICATION_INDEX_TRANSLOG_RETENTION_SIZE = setting8;
        propertyArray = new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope};
        Setting setting9 = Setting.boolSetting((String)"plugins.replication.follower.block.start", (boolean)false, (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)setting9, (String)"boolSetting(\"plugins.rep\u2026tting.Property.NodeScope)");
        REPLICATION_FOLLOWER_BLOCK_START = setting9;
        propertyArray = new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope};
        Setting setting10 = Setting.intSetting((String)"plugins.replication.autofollow.concurrent_replication_jobs_trigger_size", (int)3, (int)1, (int)10, (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)setting10, (String)"intSetting(\"plugins.repl\u2026tting.Property.NodeScope)");
        REPLICATION_AUTOFOLLOW_CONCURRENT_REPLICATION_JOBS_TRIGGER_SIZE = setting10;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR5\u0010\r\u001a&\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e \u000f*\u0012\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u00070\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\tR5\u0010\u0011\u001a&\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e \u000f*\u0012\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u00070\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\tR\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\tR5\u0010\u0018\u001a&\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000b0\u000b \u000f*\u0012\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000b0\u000b\u0018\u00010\u00070\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\tR5\u0010\u001a\u001a&\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000b0\u000b \u000f*\u0012\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000b0\u000b\u0018\u00010\u00070\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\tR\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\tR\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\tR\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\tR\u0017\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00160\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\tR\u0017\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\tR\u0017\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\tR\u0017\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\tR5\u0010+\u001a&\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e \u000f*\u0012\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u00070\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\tR5\u0010-\u001a&\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e \u000f*\u0012\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u00070\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\tR5\u0010/\u001a&\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e \u000f*\u0012\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u00070\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\t\u00a8\u00061"}, d2={"Lorg/opensearch/replication/ReplicationPlugin$Companion;", "", "()V", "KNN_INDEX_SETTING", "", "KNN_PLUGIN_PRESENT_SETTING", "REPLICATED_INDEX_SETTING", "Lorg/opensearch/common/settings/Setting;", "getREPLICATED_INDEX_SETTING", "()Lorg/opensearch/common/settings/Setting;", "REPLICATION_AUTOFOLLOW_CONCURRENT_REPLICATION_JOBS_TRIGGER_SIZE", "", "getREPLICATION_AUTOFOLLOW_CONCURRENT_REPLICATION_JOBS_TRIGGER_SIZE", "REPLICATION_AUTOFOLLOW_REMOTE_INDICES_POLL_INTERVAL", "Lorg/opensearch/common/unit/TimeValue;", "kotlin.jvm.PlatformType", "getREPLICATION_AUTOFOLLOW_REMOTE_INDICES_POLL_INTERVAL", "REPLICATION_AUTOFOLLOW_REMOTE_INDICES_RETRY_POLL_INTERVAL", "getREPLICATION_AUTOFOLLOW_REMOTE_INDICES_RETRY_POLL_INTERVAL", "REPLICATION_EXECUTOR_NAME_FOLLOWER", "REPLICATION_EXECUTOR_NAME_LEADER", "REPLICATION_FOLLOWER_BLOCK_START", "", "getREPLICATION_FOLLOWER_BLOCK_START", "REPLICATION_FOLLOWER_CONCURRENT_READERS_PER_SHARD", "getREPLICATION_FOLLOWER_CONCURRENT_READERS_PER_SHARD", "REPLICATION_FOLLOWER_CONCURRENT_WRITERS_PER_SHARD", "getREPLICATION_FOLLOWER_CONCURRENT_WRITERS_PER_SHARD", "REPLICATION_FOLLOWER_OPS_BATCH_SIZE", "getREPLICATION_FOLLOWER_OPS_BATCH_SIZE", "REPLICATION_FOLLOWER_RECOVERY_CHUNK_SIZE", "Lorg/opensearch/core/common/unit/ByteSizeValue;", "getREPLICATION_FOLLOWER_RECOVERY_CHUNK_SIZE", "REPLICATION_FOLLOWER_RECOVERY_PARALLEL_CHUNKS", "getREPLICATION_FOLLOWER_RECOVERY_PARALLEL_CHUNKS", "REPLICATION_INDEX_TRANSLOG_PRUNING_ENABLED_SETTING", "getREPLICATION_INDEX_TRANSLOG_PRUNING_ENABLED_SETTING", "REPLICATION_INDEX_TRANSLOG_RETENTION_SIZE", "getREPLICATION_INDEX_TRANSLOG_RETENTION_SIZE", "REPLICATION_LEADER_THREADPOOL_QUEUE_SIZE", "getREPLICATION_LEADER_THREADPOOL_QUEUE_SIZE", "REPLICATION_LEADER_THREADPOOL_SIZE", "getREPLICATION_LEADER_THREADPOOL_SIZE", "REPLICATION_METADATA_SYNC_INTERVAL", "getREPLICATION_METADATA_SYNC_INTERVAL", "REPLICATION_PARALLEL_READ_POLL_INTERVAL", "getREPLICATION_PARALLEL_READ_POLL_INTERVAL", "REPLICATION_RETENTION_LEASE_MAX_FAILURE_DURATION", "getREPLICATION_RETENTION_LEASE_MAX_FAILURE_DURATION", "opensearch-cross-cluster-replication"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Setting<String> getREPLICATED_INDEX_SETTING() {
            return REPLICATED_INDEX_SETTING;
        }

        @NotNull
        public final Setting<Integer> getREPLICATION_FOLLOWER_OPS_BATCH_SIZE() {
            return REPLICATION_FOLLOWER_OPS_BATCH_SIZE;
        }

        @NotNull
        public final Setting<Integer> getREPLICATION_LEADER_THREADPOOL_SIZE() {
            return REPLICATION_LEADER_THREADPOOL_SIZE;
        }

        @NotNull
        public final Setting<Integer> getREPLICATION_LEADER_THREADPOOL_QUEUE_SIZE() {
            return REPLICATION_LEADER_THREADPOOL_QUEUE_SIZE;
        }

        @NotNull
        public final Setting<ByteSizeValue> getREPLICATION_FOLLOWER_RECOVERY_CHUNK_SIZE() {
            return REPLICATION_FOLLOWER_RECOVERY_CHUNK_SIZE;
        }

        @NotNull
        public final Setting<Integer> getREPLICATION_FOLLOWER_RECOVERY_PARALLEL_CHUNKS() {
            return REPLICATION_FOLLOWER_RECOVERY_PARALLEL_CHUNKS;
        }

        public final Setting<Integer> getREPLICATION_FOLLOWER_CONCURRENT_READERS_PER_SHARD() {
            return REPLICATION_FOLLOWER_CONCURRENT_READERS_PER_SHARD;
        }

        public final Setting<Integer> getREPLICATION_FOLLOWER_CONCURRENT_WRITERS_PER_SHARD() {
            return REPLICATION_FOLLOWER_CONCURRENT_WRITERS_PER_SHARD;
        }

        public final Setting<TimeValue> getREPLICATION_PARALLEL_READ_POLL_INTERVAL() {
            return REPLICATION_PARALLEL_READ_POLL_INTERVAL;
        }

        public final Setting<TimeValue> getREPLICATION_AUTOFOLLOW_REMOTE_INDICES_POLL_INTERVAL() {
            return REPLICATION_AUTOFOLLOW_REMOTE_INDICES_POLL_INTERVAL;
        }

        public final Setting<TimeValue> getREPLICATION_AUTOFOLLOW_REMOTE_INDICES_RETRY_POLL_INTERVAL() {
            return REPLICATION_AUTOFOLLOW_REMOTE_INDICES_RETRY_POLL_INTERVAL;
        }

        public final Setting<TimeValue> getREPLICATION_METADATA_SYNC_INTERVAL() {
            return REPLICATION_METADATA_SYNC_INTERVAL;
        }

        public final Setting<TimeValue> getREPLICATION_RETENTION_LEASE_MAX_FAILURE_DURATION() {
            return REPLICATION_RETENTION_LEASE_MAX_FAILURE_DURATION;
        }

        @NotNull
        public final Setting<Boolean> getREPLICATION_INDEX_TRANSLOG_PRUNING_ENABLED_SETTING() {
            return REPLICATION_INDEX_TRANSLOG_PRUNING_ENABLED_SETTING;
        }

        @NotNull
        public final Setting<ByteSizeValue> getREPLICATION_INDEX_TRANSLOG_RETENTION_SIZE() {
            return REPLICATION_INDEX_TRANSLOG_RETENTION_SIZE;
        }

        @NotNull
        public final Setting<Boolean> getREPLICATION_FOLLOWER_BLOCK_START() {
            return REPLICATION_FOLLOWER_BLOCK_START;
        }

        @NotNull
        public final Setting<Integer> getREPLICATION_AUTOFOLLOW_CONCURRENT_REPLICATION_JOBS_TRIGGER_SIZE() {
            return REPLICATION_AUTOFOLLOW_CONCURRENT_REPLICATION_JOBS_TRIGGER_SIZE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

