/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import java.io.IOException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.ad.model.ADTask;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.core.common.Strings;

public class ADBatchAnomalyResultRequest
extends ActionRequest {
    private ADTask adTask;

    public ADBatchAnomalyResultRequest(StreamInput in) throws IOException {
        super(in);
        this.adTask = new ADTask(in);
    }

    public ADBatchAnomalyResultRequest(ADTask adTask) {
        this.adTask = adTask;
    }

    public ADTask getAdTask() {
        return this.adTask;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.adTask.writeTo(out);
    }

    public ActionRequestValidationException validate() {
        AnomalyDetector detector;
        ActionRequestValidationException validationException = null;
        if (Strings.isEmpty((CharSequence)this.adTask.getTaskId())) {
            validationException = ValidateActions.addValidationError((String)"Task id can't be null", validationException);
        }
        if (this.adTask.getDetectionDateRange() == null) {
            validationException = ValidateActions.addValidationError((String)"Detection date range can't be null for batch task", (ActionRequestValidationException)validationException);
        }
        if ((detector = this.adTask.getDetector()) == null) {
            validationException = ValidateActions.addValidationError((String)"Detector can't be null", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }
}

