/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.rest.handler;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.ad.model.AnomalyDetectorJob;
import org.opensearch.ad.rest.handler.AnomalyDetectorFunction;
import org.opensearch.ad.util.RestHandlerUtils;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.rest.RestStatus;

public class AnomalyDetectorActionHandler {
    private final Logger logger = LogManager.getLogger(AnomalyDetectorActionHandler.class);

    public void getDetectorJob(ClusterService clusterService, Client client, String detectorId, ActionListener listener, AnomalyDetectorFunction function, NamedXContentRegistry xContentRegistry) {
        if (clusterService.state().metadata().indices().containsKey(".opendistro-anomaly-detector-jobs")) {
            GetRequest request = new GetRequest(".opendistro-anomaly-detector-jobs").id(detectorId);
            client.get(request, ActionListener.wrap(response -> this.onGetAdJobResponseForWrite((GetResponse)response, listener, function, xContentRegistry), exception -> {
                this.logger.error("Fail to get anomaly detector job: " + detectorId, (Throwable)exception);
                listener.onFailure(exception);
            }));
        } else {
            function.execute();
        }
    }

    private void onGetAdJobResponseForWrite(GetResponse response, ActionListener listener, AnomalyDetectorFunction function, NamedXContentRegistry xContentRegistry) {
        String adJobId;
        if (response.isExists() && (adJobId = response.getId()) != null) {
            try (XContentParser parser = RestHandlerUtils.createXContentParserFromRegistry(xContentRegistry, response.getSourceAsBytesRef());){
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                AnomalyDetectorJob adJob = AnomalyDetectorJob.parse(parser);
                if (adJob.isEnabled()) {
                    listener.onFailure((Exception)new OpenSearchStatusException("Detector job is running: " + adJobId, RestStatus.BAD_REQUEST, new Object[0]));
                    return;
                }
            }
            catch (IOException e) {
                String message = "Failed to parse anomaly detector job " + adJobId;
                this.logger.error(message, (Throwable)e);
                listener.onFailure((Exception)new OpenSearchStatusException(message, RestStatus.BAD_REQUEST, new Object[0]));
            }
        }
        function.execute();
    }
}

