/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.feature;

import java.io.IOException;
import java.time.Clock;
import java.time.ZonedDateTime;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionListener;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.ad.common.exception.AnomalyDetectionException;
import org.opensearch.ad.dataprocessor.Interpolator;
import org.opensearch.ad.feature.AbstractRetriever;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.ad.model.Entity;
import org.opensearch.ad.model.IntervalTimeConfiguration;
import org.opensearch.ad.settings.AnomalyDetectorSettings;
import org.opensearch.ad.util.ParseUtils;
import org.opensearch.ad.util.SecurityClientUtil;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.RangeQueryBuilder;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.search.aggregations.Aggregation;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilders;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.search.aggregations.PipelineAggregationBuilder;
import org.opensearch.search.aggregations.PipelineAggregatorBuilders;
import org.opensearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.opensearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.opensearch.search.aggregations.bucket.composite.InternalComposite;
import org.opensearch.search.aggregations.bucket.composite.TermsValuesSourceBuilder;
import org.opensearch.search.aggregations.bucket.range.InternalDateRange;
import org.opensearch.search.aggregations.bucket.terms.Terms;
import org.opensearch.search.aggregations.metrics.Min;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.FieldSortBuilder;
import org.opensearch.search.sort.SortOrder;

public class SearchFeatureDao
extends AbstractRetriever {
    protected static final String AGG_NAME_MIN = "min_timefield";
    protected static final String AGG_NAME_TOP = "top_agg";
    private static final Logger logger = LogManager.getLogger(SearchFeatureDao.class);
    private final Client client;
    private final NamedXContentRegistry xContent;
    private final Interpolator interpolator;
    private final SecurityClientUtil clientUtil;
    private volatile int maxEntitiesForPreview;
    private volatile int pageSize;
    private final int minimumDocCountForPreview;
    private long previewTimeoutInMilliseconds;
    private Clock clock;

    public SearchFeatureDao(Client client, NamedXContentRegistry xContent, Interpolator interpolator, SecurityClientUtil clientUtil, Settings settings, ClusterService clusterService, int minimumDocCount, Clock clock, int maxEntitiesForPreview, int pageSize, long previewTimeoutInMilliseconds) {
        this.client = client;
        this.xContent = xContent;
        this.interpolator = interpolator;
        this.clientUtil = clientUtil;
        this.maxEntitiesForPreview = maxEntitiesForPreview;
        this.pageSize = pageSize;
        if (clusterService != null) {
            clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.MAX_ENTITIES_FOR_PREVIEW, it -> {
                this.maxEntitiesForPreview = it;
            });
            clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.PAGE_SIZE, it -> {
                this.pageSize = it;
            });
        }
        this.minimumDocCountForPreview = minimumDocCount;
        this.previewTimeoutInMilliseconds = previewTimeoutInMilliseconds;
        this.clock = clock;
    }

    public SearchFeatureDao(Client client, NamedXContentRegistry xContent, Interpolator interpolator, SecurityClientUtil clientUtil, Settings settings, ClusterService clusterService, int minimumDocCount) {
        this(client, xContent, interpolator, clientUtil, settings, clusterService, minimumDocCount, Clock.systemUTC(), (Integer)AnomalyDetectorSettings.MAX_ENTITIES_FOR_PREVIEW.get(settings), (Integer)AnomalyDetectorSettings.PAGE_SIZE.get(settings), 60000L);
    }

    public void getLatestDataTime(AnomalyDetector detector, ActionListener<Optional<Long>> listener) {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().aggregation((AggregationBuilder)AggregationBuilders.max((String)"max_timefield").field(detector.getTimeField())).size(0);
        SearchRequest searchRequest = new SearchRequest().indices(detector.getIndices().toArray(new String[0])).source(searchSourceBuilder);
        ActionListener searchResponseListener = ActionListener.wrap(response -> listener.onResponse(ParseUtils.getLatestDataTime(response)), arg_0 -> listener.onFailure(arg_0));
        this.clientUtil.asyncRequestWithInjectedSecurity(searchRequest, (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1), detector.getDetectorId(), this.client, searchResponseListener);
    }

    public void getHighestCountEntities(AnomalyDetector detector, long startTime, long endTime, ActionListener<List<Entity>> listener) {
        this.getHighestCountEntities(detector, startTime, endTime, this.maxEntitiesForPreview, this.minimumDocCountForPreview, this.pageSize, listener);
    }

    public void getHighestCountEntities(AnomalyDetector detector, long startTime, long endTime, int maxEntitiesSize, int minimumDocCount, int pageSize, ActionListener<List<Entity>> listener) {
        if (!detector.isMultientityDetector()) {
            listener.onResponse(null);
            return;
        }
        RangeQueryBuilder rangeQuery = new RangeQueryBuilder(detector.getTimeField()).from((Object)startTime).to((Object)endTime).format("epoch_millis").includeLower(true).includeUpper(false);
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery().filter((QueryBuilder)rangeQuery).filter(detector.getFilterQuery());
        Object bucketAggs = null;
        bucketAggs = detector.getCategoryField().size() == 1 ? AggregationBuilders.terms((String)AGG_NAME_TOP).size(maxEntitiesSize).field(detector.getCategoryField().get(0)) : AggregationBuilders.composite((String)AGG_NAME_TOP, detector.getCategoryField().stream().map(f -> (TermsValuesSourceBuilder)new TermsValuesSourceBuilder(f).field(f)).collect(Collectors.toList())).size(pageSize).subAggregation((PipelineAggregationBuilder)PipelineAggregatorBuilders.bucketSort((String)"bucketSort", Arrays.asList((FieldSortBuilder)new FieldSortBuilder("_count").order(SortOrder.DESC))).size(Integer.valueOf(maxEntitiesSize)));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)boolQueryBuilder).aggregation((AggregationBuilder)bucketAggs).trackTotalHits(false).size(0);
        SearchRequest searchRequest = new SearchRequest().indices(detector.getIndices().toArray(new String[0])).source(searchSourceBuilder);
        TopEntitiesListener searchResponseListener = new TopEntitiesListener(listener, detector, searchSourceBuilder, this.clock.millis() + this.previewTimeoutInMilliseconds, maxEntitiesSize, minimumDocCount);
        this.clientUtil.asyncRequestWithInjectedSecurity(searchRequest, (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1), detector.getDetectorId(), this.client, searchResponseListener);
    }

    public void getEntityMinDataTime(AnomalyDetector detector, Entity entity, ActionListener<Optional<Long>> listener) {
        BoolQueryBuilder internalFilterQuery = QueryBuilders.boolQuery();
        for (TermQueryBuilder term : entity.getTermQueryBuilders()) {
            internalFilterQuery.filter((QueryBuilder)term);
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)internalFilterQuery).aggregation((AggregationBuilder)AggregationBuilders.min((String)AGG_NAME_MIN).field(detector.getTimeField())).trackTotalHits(false).size(0);
        SearchRequest searchRequest = new SearchRequest().indices(detector.getIndices().toArray(new String[0])).source(searchSourceBuilder);
        ActionListener searchResponseListener = ActionListener.wrap(response -> listener.onResponse(this.parseMinDataTime((SearchResponse)response)), arg_0 -> listener.onFailure(arg_0));
        this.clientUtil.asyncRequestWithInjectedSecurity(searchRequest, (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1), detector.getDetectorId(), this.client, searchResponseListener);
    }

    private Optional<Long> parseMinDataTime(SearchResponse searchResponse) {
        Optional<Map> mapOptional = Optional.ofNullable(searchResponse).map(SearchResponse::getAggregations).map(aggs -> aggs.asMap());
        return mapOptional.map(map -> (Min)map.get(AGG_NAME_MIN)).map(agg -> (long)agg.getValue());
    }

    public void getFeaturesForPeriod(AnomalyDetector detector, long startTime, long endTime, ActionListener<Optional<double[]>> listener) {
        SearchRequest searchRequest = this.createFeatureSearchRequest(detector, startTime, endTime, Optional.empty());
        ActionListener searchResponseListener = ActionListener.wrap(response -> listener.onResponse(this.parseResponse((SearchResponse)response, detector.getEnabledFeatureIds())), arg_0 -> listener.onFailure(arg_0));
        this.clientUtil.asyncRequestWithInjectedSecurity(searchRequest, (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1), detector.getDetectorId(), this.client, searchResponseListener);
    }

    public void getFeaturesForPeriodByBatch(AnomalyDetector detector, Entity entity, long startTime, long endTime, ActionListener<Map<Long, Optional<double[]>>> listener) throws IOException {
        SearchSourceBuilder searchSourceBuilder = ParseUtils.batchFeatureQuery(detector, entity, startTime, endTime, this.xContent);
        logger.debug("Batch query for detector {}: {} ", (Object)detector.getDetectorId(), (Object)searchSourceBuilder);
        SearchRequest searchRequest = new SearchRequest(detector.getIndices().toArray(new String[0])).source(searchSourceBuilder);
        ActionListener searchResponseListener = ActionListener.wrap(response -> listener.onResponse(this.parseBucketAggregationResponse((SearchResponse)response, detector.getEnabledFeatureIds())), arg_0 -> listener.onFailure(arg_0));
        this.clientUtil.asyncRequestWithInjectedSecurity(searchRequest, (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1), detector.getDetectorId(), this.client, searchResponseListener);
    }

    private Map<Long, Optional<double[]>> parseBucketAggregationResponse(SearchResponse response, List<String> featureIds) {
        HashMap<Long, Optional<double[]>> dataPoints = new HashMap<Long, Optional<double[]>>();
        List aggregations = response.getAggregations().asList();
        logger.debug("Feature aggregation result size {}", (Object)aggregations.size());
        for (Aggregation agg : aggregations) {
            List buckets = ((InternalComposite)agg).getBuckets();
            buckets.forEach(bucket -> {
                Optional<double[]> featureData = this.parseAggregations(Optional.ofNullable(bucket.getAggregations()), featureIds);
                dataPoints.put((Long)bucket.getKey().get("date_histogram"), featureData);
            });
        }
        return dataPoints;
    }

    public Optional<double[]> parseResponse(SearchResponse response, List<String> featureIds) {
        return this.parseAggregations(Optional.ofNullable(response).map(resp -> resp.getAggregations()), featureIds);
    }

    public void getFeatureSamplesForPeriods(AnomalyDetector detector, List<Map.Entry<Long, Long>> ranges, ActionListener<List<Optional<double[]>>> listener) throws IOException {
        SearchRequest request = this.createPreviewSearchRequest(detector, ranges);
        ActionListener searchResponseListener = ActionListener.wrap(response -> {
            Aggregations aggs = response.getAggregations();
            if (aggs == null) {
                listener.onResponse(Collections.emptyList());
                return;
            }
            listener.onResponse(aggs.asList().stream().filter(InternalDateRange.class::isInstance).flatMap(agg -> ((InternalDateRange)agg).getBuckets().stream()).map(bucket -> this.parseBucket((MultiBucketsAggregation.Bucket)bucket, detector.getEnabledFeatureIds())).collect(Collectors.toList()));
        }, arg_0 -> listener.onFailure(arg_0));
        this.clientUtil.asyncRequestWithInjectedSecurity(request, (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1), detector.getDetectorId(), this.client, searchResponseListener);
    }

    public void getFeaturesForSampledPeriods(AnomalyDetector detector, int maxSamples, int maxStride, long endTime, ActionListener<Optional<Map.Entry<double[][], Integer>>> listener) {
        HashMap<Long, double[]> cache = new HashMap<Long, double[]>();
        logger.info(String.format(Locale.ROOT, "Getting features for detector %s ending at %d", detector.getDetectorId(), endTime));
        this.getFeatureSamplesWithCache(detector, maxSamples, maxStride, endTime, cache, maxStride, listener);
    }

    private void getFeatureSamplesWithCache(AnomalyDetector detector, int maxSamples, int maxStride, long endTime, Map<Long, double[]> cache, int currentStride, ActionListener<Optional<Map.Entry<double[][], Integer>>> listener) {
        this.getFeatureSamplesForStride(detector, maxSamples, maxStride, currentStride, endTime, cache, (ActionListener<Optional<double[][]>>)ActionListener.wrap(features -> this.processFeatureSamplesForStride((Optional<double[][]>)features, detector, maxSamples, maxStride, currentStride, endTime, cache, listener), arg_0 -> listener.onFailure(arg_0)));
    }

    private void processFeatureSamplesForStride(Optional<double[][]> features, AnomalyDetector detector, int maxSamples, int maxStride, int currentStride, long endTime, Map<Long, double[]> cache, ActionListener<Optional<Map.Entry<double[][], Integer>>> listener) {
        if (!features.isPresent()) {
            logger.info(String.format(Locale.ROOT, "Get features for detector %s finishes without any features present, current stride %d", detector.getDetectorId(), currentStride));
            listener.onResponse(Optional.empty());
        } else if (features.get().length > maxSamples / 2 || currentStride == 1) {
            logger.info(String.format(Locale.ROOT, "Get features for detector %s finishes with %d samples, current stride %d", detector.getDetectorId(), features.get().length, currentStride));
            listener.onResponse(Optional.of(new AbstractMap.SimpleEntry<double[][], Integer>(features.get(), currentStride)));
        } else {
            this.getFeatureSamplesWithCache(detector, maxSamples, maxStride, endTime, cache, currentStride / 2, listener);
        }
    }

    private void getFeatureSamplesForStride(AnomalyDetector detector, int maxSamples, int maxStride, int currentStride, long endTime, Map<Long, double[]> cache, ActionListener<Optional<double[][]>> listener) {
        ArrayDeque<double[]> sampledFeatures = new ArrayDeque<double[]>(maxSamples);
        boolean isInterpolatable = currentStride < maxStride;
        long span = ((IntervalTimeConfiguration)detector.getDetectionInterval()).toDuration().toMillis();
        this.sampleForIteration(detector, cache, maxSamples, endTime, span, currentStride, sampledFeatures, isInterpolatable, 0, listener);
    }

    private void sampleForIteration(AnomalyDetector detector, Map<Long, double[]> cache, int maxSamples, long endTime, long span, int stride, ArrayDeque<double[]> sampledFeatures, boolean isInterpolatable, int iteration, ActionListener<Optional<double[][]>> listener) {
        if (iteration < maxSamples) {
            long end = endTime - span * (long)stride * (long)iteration;
            if (cache.containsKey(end)) {
                sampledFeatures.addFirst(cache.get(end));
                this.sampleForIteration(detector, cache, maxSamples, endTime, span, stride, sampledFeatures, isInterpolatable, iteration + 1, listener);
            } else {
                this.getFeaturesForPeriod(detector, end - span, end, (ActionListener<Optional<double[]>>)ActionListener.wrap(features -> {
                    if (features.isPresent()) {
                        cache.put(end, (double[])features.get());
                        sampledFeatures.addFirst((double[])features.get());
                        this.sampleForIteration(detector, cache, maxSamples, endTime, span, stride, sampledFeatures, isInterpolatable, iteration + 1, listener);
                    } else if (isInterpolatable) {
                        Optional<double[]> previous = Optional.ofNullable((double[])cache.get(end - span * (long)stride));
                        Optional<double[]> next = Optional.ofNullable((double[])cache.get(end + span * (long)stride));
                        if (previous.isPresent() && next.isPresent()) {
                            double[] interpolants = this.getInterpolants(previous.get(), next.get());
                            cache.put(end, interpolants);
                            sampledFeatures.addFirst(interpolants);
                            this.sampleForIteration(detector, cache, maxSamples, endTime, span, stride, sampledFeatures, isInterpolatable, iteration + 1, listener);
                        } else {
                            listener.onResponse(this.toMatrix(sampledFeatures));
                        }
                    } else {
                        listener.onResponse(this.toMatrix(sampledFeatures));
                    }
                }, arg_0 -> listener.onFailure(arg_0)));
            }
        } else {
            listener.onResponse(this.toMatrix(sampledFeatures));
        }
    }

    private Optional<double[][]> toMatrix(ArrayDeque<double[]> sampledFeatures) {
        Optional<double[][]> samples = sampledFeatures.isEmpty() ? Optional.empty() : Optional.of((double[][])sampledFeatures.toArray((T[])new double[0][0]));
        return samples;
    }

    private double[] getInterpolants(double[] previous, double[] next) {
        return this.transpose(this.interpolator.interpolate(this.transpose(new double[][]{previous, next}), 3))[1];
    }

    private double[][] transpose(double[][] matrix) {
        return MatrixUtils.createRealMatrix((double[][])matrix).transpose().getData();
    }

    private SearchRequest createFeatureSearchRequest(AnomalyDetector detector, long startTime, long endTime, Optional<String> preference) {
        try {
            SearchSourceBuilder searchSourceBuilder = ParseUtils.generateInternalFeatureQuery(detector, startTime, endTime, this.xContent);
            return new SearchRequest(detector.getIndices().toArray(new String[0]), searchSourceBuilder).preference((String)preference.orElse(null));
        }
        catch (IOException e) {
            logger.warn("Failed to create feature search request for " + detector.getDetectorId() + " from " + startTime + " to " + endTime, (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private SearchRequest createPreviewSearchRequest(AnomalyDetector detector, List<Map.Entry<Long, Long>> ranges) throws IOException {
        try {
            SearchSourceBuilder searchSourceBuilder = ParseUtils.generatePreviewQuery(detector, ranges, this.xContent);
            return new SearchRequest(detector.getIndices().toArray(new String[0]), searchSourceBuilder);
        }
        catch (IOException e) {
            logger.warn("Failed to create feature search request for " + detector.getDetectorId() + " for preview", (Throwable)e);
            throw e;
        }
    }

    public void getColdStartSamplesForPeriods(AnomalyDetector detector, List<Map.Entry<Long, Long>> ranges, Entity entity, boolean includesEmptyBucket, ActionListener<List<Optional<double[]>>> listener) {
        SearchRequest request = this.createColdStartFeatureSearchRequest(detector, ranges, entity);
        ActionListener searchResponseListener = ActionListener.wrap(response -> {
            Aggregations aggs = response.getAggregations();
            if (aggs == null) {
                listener.onResponse(Collections.emptyList());
                return;
            }
            long docCountThreshold = includesEmptyBucket ? -1L : 0L;
            listener.onResponse(aggs.asList().stream().filter(InternalDateRange.class::isInstance).flatMap(agg -> ((InternalDateRange)agg).getBuckets().stream()).filter(bucket -> bucket.getFrom() != null && bucket.getFrom() instanceof ZonedDateTime).filter(bucket -> bucket.getDocCount() > docCountThreshold).sorted(Comparator.comparing(bucket -> (ZonedDateTime)bucket.getFrom())).map(bucket -> this.parseBucket((MultiBucketsAggregation.Bucket)bucket, detector.getEnabledFeatureIds())).collect(Collectors.toList()));
        }, arg_0 -> listener.onFailure(arg_0));
        this.clientUtil.asyncRequestWithInjectedSecurity(request, (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1), detector.getDetectorId(), this.client, searchResponseListener);
    }

    private SearchRequest createColdStartFeatureSearchRequest(AnomalyDetector detector, List<Map.Entry<Long, Long>> ranges, Entity entity) {
        try {
            SearchSourceBuilder searchSourceBuilder = ParseUtils.generateEntityColdStartQuery(detector, ranges, entity, this.xContent);
            return new SearchRequest(detector.getIndices().toArray(new String[0]), searchSourceBuilder);
        }
        catch (IOException e) {
            logger.warn("Failed to create cold start feature search request for " + detector.getDetectorId() + " from " + ranges.get(0).getKey() + " to " + ranges.get(ranges.size() - 1).getKey(), (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Optional<double[]> parseBucket(MultiBucketsAggregation.Bucket bucket, List<String> featureIds) {
        return this.parseAggregations(Optional.ofNullable(bucket).map(b -> b.getAggregations()), featureIds);
    }

    class TopEntitiesListener
    implements ActionListener<SearchResponse> {
        private ActionListener<List<Entity>> listener;
        private AnomalyDetector detector;
        private List<Entity> topEntities;
        private SearchSourceBuilder searchSourceBuilder;
        private long expirationEpochMs;
        private long minimumDocCount;
        private int maxEntitiesSize;

        TopEntitiesListener(ActionListener<List<Entity>> listener, AnomalyDetector detector, SearchSourceBuilder searchSourceBuilder, long expirationEpochMs, int maxEntitiesSize, int minimumDocCount) {
            this.listener = listener;
            this.detector = detector;
            this.topEntities = new ArrayList<Entity>();
            this.searchSourceBuilder = searchSourceBuilder;
            this.expirationEpochMs = expirationEpochMs;
            this.maxEntitiesSize = maxEntitiesSize;
            this.minimumDocCount = minimumDocCount;
        }

        public void onResponse(SearchResponse response) {
            try {
                Aggregations aggs = response.getAggregations();
                if (aggs == null) {
                    logger.warn("Unexpected null aggregation.");
                    this.listener.onResponse(this.topEntities);
                    return;
                }
                Aggregation aggrResult = aggs.get(SearchFeatureDao.AGG_NAME_TOP);
                if (aggrResult == null) {
                    this.listener.onFailure((Exception)new IllegalArgumentException("Fail to find valid aggregation result"));
                    return;
                }
                if (this.detector.getCategoryField().size() == 1) {
                    this.topEntities = ((Terms)aggrResult).getBuckets().stream().map(bucket -> bucket.getKeyAsString()).collect(Collectors.toList()).stream().map(entityValue -> Entity.createSingleAttributeEntity(this.detector.getCategoryField().get(0), entityValue)).collect(Collectors.toList());
                    this.listener.onResponse(this.topEntities);
                } else {
                    CompositeAggregation compositeAgg = (CompositeAggregation)aggrResult;
                    List pageResults = compositeAgg.getBuckets().stream().filter(bucket -> bucket.getDocCount() >= this.minimumDocCount).map(bucket -> Entity.createEntityByReordering(bucket.getKey())).collect(Collectors.toList());
                    int amountToWrite = this.maxEntitiesSize - this.topEntities.size();
                    for (int i = 0; i < amountToWrite && i < pageResults.size(); ++i) {
                        this.topEntities.add((Entity)pageResults.get(i));
                    }
                    Map afterKey = compositeAgg.afterKey();
                    if (this.topEntities.size() >= this.maxEntitiesSize || afterKey == null) {
                        this.listener.onResponse(this.topEntities);
                    } else if (this.expirationEpochMs < SearchFeatureDao.this.clock.millis()) {
                        if (this.topEntities.isEmpty()) {
                            this.listener.onFailure((Exception)new AnomalyDetectionException("timeout to get preview results.  Please retry later."));
                        } else {
                            logger.info("timeout to get preview results. Send whatever we have.");
                            this.listener.onResponse(this.topEntities);
                        }
                    } else {
                        SearchFeatureDao.this.updateSourceAfterKey(afterKey, this.searchSourceBuilder);
                        SearchFeatureDao.this.clientUtil.asyncRequestWithInjectedSecurity(new SearchRequest().indices(this.detector.getIndices().toArray(new String[0])).source(this.searchSourceBuilder), (arg_0, arg_1) -> ((Client)SearchFeatureDao.this.client).search(arg_0, arg_1), this.detector.getDetectorId(), SearchFeatureDao.this.client, this);
                    }
                }
            }
            catch (Exception e) {
                this.onFailure(e);
            }
        }

        public void onFailure(Exception e) {
            logger.error("Fail to paginate", (Throwable)e);
            this.listener.onFailure(e);
        }
    }
}

