/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import java.net.ConnectException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.util.Supplier;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchTimeoutException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionListenerResponseHandler;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.search.SearchPhaseExecutionException;
import org.opensearch.action.search.ShardSearchFailure;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.ThreadedActionListener;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.ad.NodeStateManager;
import org.opensearch.ad.breaker.ADCircuitBreakerService;
import org.opensearch.ad.cluster.HashRing;
import org.opensearch.ad.common.exception.AnomalyDetectionException;
import org.opensearch.ad.common.exception.ClientException;
import org.opensearch.ad.common.exception.EndRunException;
import org.opensearch.ad.common.exception.InternalFailure;
import org.opensearch.ad.common.exception.LimitExceededException;
import org.opensearch.ad.common.exception.NotSerializedADExceptionName;
import org.opensearch.ad.common.exception.ResourceNotFoundException;
import org.opensearch.ad.feature.CompositeRetriever;
import org.opensearch.ad.feature.FeatureManager;
import org.opensearch.ad.feature.SinglePointFeatures;
import org.opensearch.ad.ml.ModelManager;
import org.opensearch.ad.ml.SingleStreamModelIdMapper;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.ad.model.Entity;
import org.opensearch.ad.model.FeatureData;
import org.opensearch.ad.model.IntervalTimeConfiguration;
import org.opensearch.ad.settings.AnomalyDetectorSettings;
import org.opensearch.ad.settings.EnabledSetting;
import org.opensearch.ad.stats.ADStats;
import org.opensearch.ad.stats.StatNames;
import org.opensearch.ad.task.ADTaskManager;
import org.opensearch.ad.transport.AnomalyResultAction;
import org.opensearch.ad.transport.AnomalyResultRequest;
import org.opensearch.ad.transport.AnomalyResultResponse;
import org.opensearch.ad.transport.EntityResultAction;
import org.opensearch.ad.transport.EntityResultRequest;
import org.opensearch.ad.transport.RCFResultAction;
import org.opensearch.ad.transport.RCFResultRequest;
import org.opensearch.ad.transport.RCFResultResponse;
import org.opensearch.ad.util.ExceptionUtil;
import org.opensearch.ad.util.ParseUtils;
import org.opensearch.client.Client;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.io.stream.NotSerializableExceptionWrapper;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.transport.NetworkExceptionHelper;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.node.NodeClosedException;
import org.opensearch.rest.RestStatus;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.ActionNotFoundTransportException;
import org.opensearch.transport.ConnectTransportException;
import org.opensearch.transport.NodeNotConnectedException;
import org.opensearch.transport.ReceiveTimeoutTransportException;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportRequestOptions;
import org.opensearch.transport.TransportResponseHandler;
import org.opensearch.transport.TransportService;

public class AnomalyResultTransportAction
extends HandledTransportAction<ActionRequest, AnomalyResultResponse> {
    private static final Logger LOG = LogManager.getLogger(AnomalyResultTransportAction.class);
    static final String NO_MODEL_ERR_MSG = "No RCF models are available either because RCF models are not ready or all nodes are unresponsive or the system might have bugs.";
    static final String WAIT_FOR_THRESHOLD_ERR_MSG = "Exception in waiting for threshold result";
    static final String NODE_UNRESPONSIVE_ERR_MSG = "Model node is unresponsive.  Mute node";
    static final String READ_WRITE_BLOCKED = "Cannot read/write due to global block.";
    static final String INDEX_READ_BLOCKED = "Cannot read user index due to read block.";
    static final String NULL_RESPONSE = "Received null response from";
    static final String TROUBLE_QUERYING_ERR_MSG = "Having trouble querying data: ";
    static final String NO_ACK_ERR = "no acknowledgements from model hosting nodes.";
    private final TransportService transportService;
    private final NodeStateManager stateManager;
    private final FeatureManager featureManager;
    private final ModelManager modelManager;
    private final HashRing hashRing;
    private final TransportRequestOptions option;
    private final ClusterService clusterService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final ADStats adStats;
    private final ADCircuitBreakerService adCircuitBreakerService;
    private final ThreadPool threadPool;
    private final Client client;
    private final ADTaskManager adTaskManager;
    private final Set<String> hcDetectors;
    private NamedXContentRegistry xContentRegistry;
    private Settings settings;
    private final float intervalRatioForRequest;
    private int maxEntitiesPerInterval;
    private int pageSize;

    @Inject
    public AnomalyResultTransportAction(ActionFilters actionFilters, TransportService transportService, Settings settings, Client client, NodeStateManager manager, FeatureManager featureManager, ModelManager modelManager, HashRing hashRing, ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver, ADCircuitBreakerService adCircuitBreakerService, ADStats adStats, ThreadPool threadPool, NamedXContentRegistry xContentRegistry, ADTaskManager adTaskManager) {
        super(AnomalyResultAction.NAME, transportService, actionFilters, AnomalyResultRequest::new);
        this.transportService = transportService;
        this.settings = settings;
        this.client = client;
        this.stateManager = manager;
        this.featureManager = featureManager;
        this.modelManager = modelManager;
        this.hashRing = hashRing;
        this.option = TransportRequestOptions.builder().withType(TransportRequestOptions.Type.REG).withTimeout((TimeValue)AnomalyDetectorSettings.REQUEST_TIMEOUT.get(settings)).build();
        this.clusterService = clusterService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.adCircuitBreakerService = adCircuitBreakerService;
        this.adStats = adStats;
        this.threadPool = threadPool;
        this.hcDetectors = new HashSet<String>();
        this.xContentRegistry = xContentRegistry;
        this.intervalRatioForRequest = 0.9f;
        this.maxEntitiesPerInterval = (Integer)AnomalyDetectorSettings.MAX_ENTITIES_PER_QUERY.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.MAX_ENTITIES_PER_QUERY, it -> {
            this.maxEntitiesPerInterval = it;
        });
        this.pageSize = (Integer)AnomalyDetectorSettings.PAGE_SIZE.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.PAGE_SIZE, it -> {
            this.pageSize = it;
        });
        this.adTaskManager = adTaskManager;
    }

    protected void doExecute(Task task, ActionRequest actionRequest, ActionListener<AnomalyResultResponse> listener) {
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            AnomalyResultRequest request = AnomalyResultRequest.fromActionRequest(actionRequest);
            String adID = request.getAdID();
            ActionListener original = listener;
            listener = ActionListener.wrap(r -> {
                this.hcDetectors.remove(adID);
                original.onResponse((Object)r);
            }, e -> {
                if (!(e instanceof AnomalyDetectionException) || ((AnomalyDetectionException)e).isCountedInStats()) {
                    this.adStats.getStat(StatNames.AD_EXECUTE_FAIL_COUNT.getName()).increment();
                    if (this.hcDetectors.contains(adID)) {
                        this.adStats.getStat(StatNames.AD_HC_EXECUTE_FAIL_COUNT.getName()).increment();
                    }
                }
                this.hcDetectors.remove(adID);
                original.onFailure(e);
            });
            if (!EnabledSetting.isADPluginEnabled()) {
                throw new EndRunException(adID, "AD plugin is disabled. To enable update plugins.anomaly_detection.enabled to true", true).countedInStats(false);
            }
            this.adStats.getStat(StatNames.AD_EXECUTE_REQUEST_COUNT.getName()).increment();
            if (this.adCircuitBreakerService.isOpen().booleanValue()) {
                listener.onFailure((Exception)new LimitExceededException(adID, "AD memory circuit is broken.", false));
                return;
            }
            try {
                this.stateManager.getAnomalyDetector(adID, this.onGetDetector((ActionListener<AnomalyResultResponse>)listener, adID, request));
            }
            catch (Exception ex) {
                this.handleExecuteException(ex, (ActionListener<AnomalyResultResponse>)listener, adID);
            }
        }
        catch (Exception e2) {
            LOG.error((Object)e2);
            listener.onFailure(e2);
        }
    }

    private ActionListener<Optional<AnomalyDetector>> onGetDetector(ActionListener<AnomalyResultResponse> listener, String adID, AnomalyResultRequest request) {
        return ActionListener.wrap(detectorOptional -> {
            if (!detectorOptional.isPresent()) {
                listener.onFailure((Exception)new EndRunException(adID, "AnomalyDetector is not available.", true));
                return;
            }
            AnomalyDetector anomalyDetector = (AnomalyDetector)detectorOptional.get();
            if (anomalyDetector.isMultientityDetector()) {
                this.hcDetectors.add(adID);
                this.adStats.getStat(StatNames.AD_HC_EXECUTE_REQUEST_COUNT.getName()).increment();
            }
            long delayMillis = Optional.ofNullable((IntervalTimeConfiguration)anomalyDetector.getWindowDelay()).map(t -> t.toDuration().toMillis()).orElse(0L);
            long dataStartTime = request.getStart() - delayMillis;
            long dataEndTime = request.getEnd() - delayMillis;
            this.adTaskManager.initRealtimeTaskCacheAndCleanupStaleCache(adID, anomalyDetector, this.transportService, (ActionListener<Boolean>)ActionListener.runAfter(this.initRealtimeTaskCacheListener(adID), () -> this.executeAnomalyDetection(listener, adID, request, anomalyDetector, dataStartTime, dataEndTime)));
        }, exception -> this.handleExecuteException((Exception)exception, listener, adID));
    }

    private ActionListener<Boolean> initRealtimeTaskCacheListener(String detectorId) {
        return ActionListener.wrap(r -> {
            if (r.booleanValue()) {
                LOG.debug("Realtime task cache initied for detector {}", (Object)detectorId);
            }
        }, e -> LOG.error("Failed to init realtime task cache for " + detectorId, (Throwable)e));
    }

    private void executeAnomalyDetection(ActionListener<AnomalyResultResponse> listener, String adID, AnomalyResultRequest request, AnomalyDetector anomalyDetector, long dataStartTime, long dataEndTime) {
        if (anomalyDetector.isMultientityDetector()) {
            Optional<Exception> previousException = this.stateManager.fetchExceptionAndClear(adID);
            if (previousException.isPresent()) {
                EndRunException endRunException;
                Exception exception = previousException.get();
                LOG.error((Message)new ParameterizedMessage("Previous exception of [{}]", (Object)adID), (Throwable)exception);
                if (exception instanceof EndRunException && (endRunException = (EndRunException)exception).isEndNow()) {
                    listener.onFailure(exception);
                    return;
                }
            }
            long nextDetectionStartTime = request.getEnd() + (long)((float)anomalyDetector.getDetectorIntervalInMilliseconds() * this.intervalRatioForRequest);
            CompositeRetriever compositeRetriever = new CompositeRetriever(dataStartTime, dataEndTime, anomalyDetector, this.xContentRegistry, this.client, nextDetectionStartTime, this.settings, this.maxEntitiesPerInterval, this.pageSize, this.indexNameExpressionResolver, this.clusterService);
            CompositeRetriever.PageIterator pageIterator = null;
            try {
                pageIterator = compositeRetriever.iterator();
            }
            catch (Exception e) {
                listener.onFailure((Exception)new EndRunException(anomalyDetector.getDetectorId(), "Invalid search query.", e, false));
                return;
            }
            PageListener getEntityFeatureslistener = new PageListener(pageIterator, adID, dataStartTime, dataEndTime);
            if (pageIterator.hasNext()) {
                pageIterator.next(getEntityFeatureslistener);
            }
            if (previousException.isPresent()) {
                listener.onFailure(previousException.get());
            } else {
                listener.onResponse((Object)new AnomalyResultResponse(new ArrayList<FeatureData>(), null, null, anomalyDetector.getDetectorIntervalInMinutes(), true));
            }
            return;
        }
        String rcfModelID = SingleStreamModelIdMapper.getRcfModelId(adID, 0);
        Optional<DiscoveryNode> asRCFNode = this.hashRing.getOwningNodeWithSameLocalAdVersionForRealtimeAD(rcfModelID);
        if (!asRCFNode.isPresent()) {
            listener.onFailure((Exception)new InternalFailure(adID, "RCF model node is not available."));
            return;
        }
        DiscoveryNode rcfNode = asRCFNode.get();
        if (!this.shouldStart(listener, adID, anomalyDetector, rcfNode.getId(), rcfModelID)) {
            return;
        }
        this.featureManager.getCurrentFeatures(anomalyDetector, dataStartTime, dataEndTime, this.onFeatureResponseForSingleEntityDetector(adID, anomalyDetector, listener, rcfModelID, rcfNode, dataStartTime, dataEndTime));
    }

    private ActionListener<SinglePointFeatures> onFeatureResponseForSingleEntityDetector(String adID, AnomalyDetector detector, ActionListener<AnomalyResultResponse> listener, String rcfModelId, DiscoveryNode rcfNode, long dataStartTime, long dataEndTime) {
        return ActionListener.wrap(featureOptional -> {
            List<FeatureData> featureInResponse = null;
            if (featureOptional.getUnprocessedFeatures().isPresent()) {
                featureInResponse = ParseUtils.getFeatureData(featureOptional.getUnprocessedFeatures().get(), detector);
            }
            if (!featureOptional.getProcessedFeatures().isPresent()) {
                Optional<Exception> exception = this.coldStartIfNoCheckPoint(detector);
                if (exception.isPresent()) {
                    listener.onFailure(exception.get());
                    return;
                }
                if (!featureOptional.getUnprocessedFeatures().isPresent()) {
                    LOG.debug("No data in current detection window between {} and {} for {}", (Object)dataStartTime, (Object)dataEndTime, (Object)adID);
                    listener.onResponse((Object)new AnomalyResultResponse(new ArrayList<FeatureData>(), "No data in current detection window", null, null, false));
                } else {
                    LOG.debug("Return at least current feature value between {} and {} for {}", (Object)dataStartTime, (Object)dataEndTime, (Object)adID);
                    listener.onResponse((Object)new AnomalyResultResponse(featureInResponse, "No full shingle in current detection window", null, null, false));
                }
                return;
            }
            AtomicReference<Exception> failure = new AtomicReference<Exception>();
            LOG.info("Sending RCF request to {} for model {}", (Object)rcfNode.getId(), (Object)rcfModelId);
            RCFActionListener rcfListener = new RCFActionListener(rcfModelId, failure, rcfNode.getId(), detector, listener, featureInResponse, adID);
            this.transportService.sendRequest(rcfNode, RCFResultAction.NAME, (TransportRequest)new RCFResultRequest(adID, rcfModelId, featureOptional.getProcessedFeatures().get()), this.option, (TransportResponseHandler)new ActionListenerResponseHandler((ActionListener)rcfListener, RCFResultResponse::new));
        }, exception -> this.handleQueryFailure((Exception)exception, listener, adID));
    }

    private void handleQueryFailure(Exception exception, ActionListener<AnomalyResultResponse> listener, String adID) {
        Exception convertedQueryFailureException = this.convertedQueryFailureException(exception, adID);
        if (convertedQueryFailureException instanceof EndRunException) {
            listener.onFailure(convertedQueryFailureException);
        } else {
            this.handleExecuteException(convertedQueryFailureException, listener, adID);
        }
    }

    private Exception convertedQueryFailureException(Exception exception, String adID) {
        if (ExceptionUtil.isIndexNotAvailable(exception)) {
            return new EndRunException(adID, TROUBLE_QUERYING_ERR_MSG + exception.getMessage(), false).countedInStats(false);
        }
        if (exception instanceof SearchPhaseExecutionException && this.invalidQuery((SearchPhaseExecutionException)exception)) {
            return new EndRunException(adID, "Invalid search query. " + ((SearchPhaseExecutionException)exception).getDetailedMessage(), exception, false).countedInStats(false);
        }
        return exception;
    }

    private Exception coldStartIfNoModel(AtomicReference<Exception> failure, AnomalyDetector detector) throws Exception {
        Exception exp = failure.get();
        if (exp == null) {
            return null;
        }
        if (!(exp instanceof ResourceNotFoundException)) {
            return exp;
        }
        String adID = detector.getDetectorId();
        Optional<Exception> previousException = this.stateManager.fetchExceptionAndClear(adID);
        if (previousException.isPresent()) {
            Exception exception = previousException.get();
            LOG.error("Previous exception of {}: {}", new Supplier[]{() -> adID, () -> exception});
            if (exception instanceof EndRunException && ((EndRunException)exception).isEndNow()) {
                return exception;
            }
        }
        LOG.info("Trigger cold start for {}", (Object)detector.getDetectorId());
        this.coldStart(detector);
        return previousException.orElse(new InternalFailure(adID, NO_MODEL_ERR_MSG));
    }

    private void findException(Throwable cause, String adID, AtomicReference<Exception> failure, String nodeId) {
        if (cause == null) {
            LOG.error((Message)new ParameterizedMessage("Null input exception", new Object[0]));
            return;
        }
        if (cause instanceof Error) {
            LOG.error((Message)new ParameterizedMessage("Error during prediction for {}: ", (Object)adID), cause);
            return;
        }
        Exception causeException = (Exception)cause;
        if (causeException instanceof AnomalyDetectionException) {
            failure.set(causeException);
        } else if (causeException instanceof NotSerializableExceptionWrapper) {
            Optional<AnomalyDetectionException> actualException = NotSerializedADExceptionName.convertWrappedAnomalyDetectionException((NotSerializableExceptionWrapper)causeException, adID);
            if (actualException.isPresent()) {
                AnomalyDetectionException adException = actualException.get();
                failure.set(adException);
                if (adException instanceof ResourceNotFoundException) {
                    this.stateManager.addPressure(nodeId, adID);
                }
            } else {
                failure.set(new EndRunException(adID, "We might have bugs.", causeException, false));
            }
        } else if (causeException instanceof IndexNotFoundException && causeException.getMessage().contains(".opendistro-anomaly-checkpoints")) {
            failure.set(new ResourceNotFoundException(adID, causeException.getMessage()));
        } else if (causeException instanceof OpenSearchTimeoutException) {
            failure.set(new InternalFailure(adID, causeException));
        } else if (causeException instanceof IllegalArgumentException) {
            failure.set(new InternalFailure(adID, causeException));
        } else {
            failure.set(new EndRunException(adID, "We might have bugs.", causeException, false));
        }
    }

    void handleExecuteException(Exception ex, ActionListener<AnomalyResultResponse> listener, String adID) {
        if (ex instanceof ClientException) {
            listener.onFailure(ex);
        } else if (ex instanceof AnomalyDetectionException) {
            listener.onFailure((Exception)new InternalFailure((AnomalyDetectionException)ex));
        } else {
            Throwable cause = ExceptionsHelper.unwrapCause((Throwable)ex);
            listener.onFailure((Exception)new InternalFailure(adID, cause));
        }
    }

    private boolean invalidQuery(SearchPhaseExecutionException ex) {
        for (ShardSearchFailure failure : ex.shardFailures()) {
            if (RestStatus.BAD_REQUEST == failure.status() && failure.getCause() instanceof IllegalArgumentException) continue;
            return false;
        }
        return true;
    }

    private void handlePredictionFailure(Exception e, String adID, String nodeID, AtomicReference<Exception> failure) {
        LOG.error((Message)new ParameterizedMessage("Received an error from node {} while doing model inference for {}", (Object)nodeID, (Object)adID), (Throwable)e);
        if (e == null) {
            return;
        }
        Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
        if (this.hasConnectionIssue(cause)) {
            this.handleConnectionException(nodeID, adID);
        } else {
            this.findException(cause, adID, failure, nodeID);
        }
    }

    private boolean hasConnectionIssue(Throwable e) {
        return e instanceof ConnectTransportException || e instanceof NodeClosedException || e instanceof ReceiveTimeoutTransportException || e instanceof NodeNotConnectedException || e instanceof ConnectException || NetworkExceptionHelper.isCloseConnectionException((Throwable)e) || e instanceof ActionNotFoundTransportException;
    }

    private void handleConnectionException(String node, String detectorId) {
        DiscoveryNodes nodes = this.clusterService.state().nodes();
        if (!nodes.nodeExists(node)) {
            this.hashRing.buildCirclesForRealtimeAD();
            return;
        }
        this.stateManager.addPressure(node, detectorId);
    }

    private boolean checkGlobalBlock(ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.READ) != null || state.blocks().globalBlockedException(ClusterBlockLevel.WRITE) != null;
    }

    private boolean checkIndicesBlocked(ClusterState state, ClusterBlockLevel level, String ... indices) {
        String[] concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(state, IndicesOptions.lenientExpandOpen(), indices);
        return state.blocks().indicesBlockedException(level, concreteIndices) != null;
    }

    private boolean shouldStart(ActionListener<AnomalyResultResponse> listener, String adID, AnomalyDetector detector, String rcfNodeId, String rcfModelID) {
        ClusterState state = this.clusterService.state();
        if (this.checkGlobalBlock(state)) {
            listener.onFailure((Exception)new InternalFailure(adID, READ_WRITE_BLOCKED));
            return false;
        }
        if (this.stateManager.isMuted(rcfNodeId, adID)) {
            listener.onFailure((Exception)new InternalFailure(adID, String.format(Locale.ROOT, "Model node is unresponsive.  Mute node %s for rcf model %s", rcfNodeId, rcfModelID)));
            return false;
        }
        if (this.checkIndicesBlocked(state, ClusterBlockLevel.READ, detector.getIndices().toArray(new String[0]))) {
            listener.onFailure((Exception)new InternalFailure(adID, INDEX_READ_BLOCKED));
            return false;
        }
        return true;
    }

    private void coldStart(AnomalyDetector detector) {
        String detectorId = detector.getDetectorId();
        if (this.stateManager.isColdStartRunning(detectorId)) {
            return;
        }
        Releasable coldStartFinishingCallback = this.stateManager.markColdStartRunning(detectorId);
        ActionListener listener = ActionListener.wrap(trainingData -> {
            if (trainingData.isPresent()) {
                double[][] dataPoints = (double[][])trainingData.get();
                ActionListener trainModelListener = ActionListener.wrap(res -> LOG.info("Succeeded in training {}", (Object)detectorId), exception -> {
                    if (exception instanceof AnomalyDetectionException) {
                        this.stateManager.setException(detectorId, (Exception)exception);
                    } else if (exception instanceof IllegalArgumentException) {
                        this.stateManager.setException(detectorId, new EndRunException(detectorId, "Invalid training data", (Throwable)exception, false));
                    } else if (exception instanceof OpenSearchTimeoutException) {
                        this.stateManager.setException(detectorId, new InternalFailure(detectorId, "Time out while indexing cold start checkpoint", (Throwable)exception));
                    } else {
                        this.stateManager.setException(detectorId, new EndRunException(detectorId, "Error while training model", (Throwable)exception, false));
                    }
                });
                this.modelManager.trainModel(detector, dataPoints, (ActionListener<Void>)new ThreadedActionListener(LOG, this.threadPool, "ad-threadpool", trainModelListener, false));
            } else {
                this.stateManager.setException(detectorId, new EndRunException(detectorId, "Cannot get training data", false));
            }
        }, exception -> {
            if (exception instanceof OpenSearchTimeoutException) {
                this.stateManager.setException(detectorId, new InternalFailure(detectorId, "Time out while getting training data", (Throwable)exception));
            } else if (exception instanceof AnomalyDetectionException) {
                this.stateManager.setException(detectorId, (Exception)exception);
            } else {
                this.stateManager.setException(detectorId, new EndRunException(detectorId, "Error while cold start", (Throwable)exception, false));
            }
        });
        ActionListener listenerWithReleaseCallback = ActionListener.runAfter((ActionListener)listener, () -> ((Releasable)coldStartFinishingCallback).close());
        this.threadPool.executor("ad-threadpool").execute(() -> this.featureManager.getColdStartData(detector, (ActionListener<Optional<double[][]>>)new ThreadedActionListener(LOG, this.threadPool, "ad-threadpool", listenerWithReleaseCallback, false)));
    }

    private Optional<Exception> coldStartIfNoCheckPoint(AnomalyDetector detector) {
        String detectorId = detector.getDetectorId();
        Optional<Exception> previousException = this.stateManager.fetchExceptionAndClear(detectorId);
        if (previousException.isPresent()) {
            Exception exception2 = previousException.get();
            LOG.error((Message)new ParameterizedMessage("Previous exception of {}:", (Object)detectorId), (Throwable)exception2);
            if (exception2 instanceof EndRunException && ((EndRunException)exception2).isEndNow()) {
                return previousException;
            }
        }
        this.stateManager.getDetectorCheckpoint(detectorId, (ActionListener<Boolean>)ActionListener.wrap(checkpointExists -> {
            if (!checkpointExists.booleanValue()) {
                LOG.info("Trigger cold start for {}", (Object)detectorId);
                this.coldStart(detector);
            }
        }, exception -> {
            Throwable cause = ExceptionsHelper.unwrapCause((Throwable)exception);
            if (cause instanceof IndexNotFoundException) {
                LOG.info("Trigger cold start for {}", (Object)detectorId);
                this.coldStart(detector);
            } else {
                String errorMsg = String.format(Locale.ROOT, "Fail to get checkpoint state for %s", detectorId);
                LOG.error(errorMsg, (Throwable)exception);
                this.stateManager.setException(detectorId, new AnomalyDetectionException(errorMsg, (Throwable)exception));
            }
        }));
        return previousException;
    }

    class PageListener
    implements ActionListener<CompositeRetriever.Page> {
        private CompositeRetriever.PageIterator pageIterator;
        private String detectorId;
        private long dataStartTime;
        private long dataEndTime;

        PageListener(CompositeRetriever.PageIterator pageIterator, String detectorId, long dataStartTime, long dataEndTime) {
            this.pageIterator = pageIterator;
            this.detectorId = detectorId;
            this.dataStartTime = dataStartTime;
            this.dataEndTime = dataEndTime;
        }

        public void onResponse(CompositeRetriever.Page entityFeatures) {
            if (this.pageIterator.hasNext()) {
                this.pageIterator.next(this);
            }
            if (entityFeatures != null && !entityFeatures.isEmpty()) {
                AnomalyResultTransportAction.this.threadPool.executor("ad-threadpool").execute(() -> {
                    try {
                        Set<Map.Entry<DiscoveryNode, Map<Entity, double[]>>> node2Entities = entityFeatures.getResults().entrySet().stream().filter(e -> AnomalyResultTransportAction.this.hashRing.getOwningNodeWithSameLocalAdVersionForRealtimeAD(((Entity)e.getKey()).toString()).isPresent()).collect(Collectors.groupingBy(e -> AnomalyResultTransportAction.this.hashRing.getOwningNodeWithSameLocalAdVersionForRealtimeAD(((Entity)e.getKey()).toString()).get(), Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).entrySet();
                        Iterator<Map.Entry<DiscoveryNode, Map<Entity, double[]>>> iterator = node2Entities.iterator();
                        while (iterator.hasNext()) {
                            Map.Entry<DiscoveryNode, Map<Entity, double[]>> entry = iterator.next();
                            DiscoveryNode modelNode = entry.getKey();
                            if (modelNode == null) {
                                iterator.remove();
                                continue;
                            }
                            String modelNodeId = modelNode.getId();
                            if (!AnomalyResultTransportAction.this.stateManager.isMuted(modelNodeId, this.detectorId)) continue;
                            LOG.info(String.format(Locale.ROOT, "Model node is unresponsive.  Mute node %s for detector %s", modelNodeId, this.detectorId));
                            iterator.remove();
                        }
                        AtomicReference failure = new AtomicReference();
                        node2Entities.stream().forEach(nodeEntity -> {
                            DiscoveryNode node = (DiscoveryNode)nodeEntity.getKey();
                            AnomalyResultTransportAction.this.transportService.sendRequest(node, EntityResultAction.NAME, (TransportRequest)new EntityResultRequest(this.detectorId, (Map)nodeEntity.getValue(), this.dataStartTime, this.dataEndTime), AnomalyResultTransportAction.this.option, (TransportResponseHandler)new ActionListenerResponseHandler((ActionListener)new EntityResultListener(node.getId(), this.detectorId, failure), AcknowledgedResponse::new, "same"));
                        });
                    }
                    catch (Exception e2) {
                        LOG.error("Unexpected exception", (Throwable)e2);
                        this.handleException(e2);
                    }
                });
            }
        }

        public void onFailure(Exception e) {
            LOG.error("Unexpetected exception", (Throwable)e);
            this.handleException(e);
        }

        private void handleException(Exception e) {
            Exception convertedException = AnomalyResultTransportAction.this.convertedQueryFailureException(e, this.detectorId);
            if (!(convertedException instanceof AnomalyDetectionException)) {
                Throwable cause = ExceptionsHelper.unwrapCause((Throwable)convertedException);
                convertedException = new InternalFailure(this.detectorId, cause);
            }
            AnomalyResultTransportAction.this.stateManager.setException(this.detectorId, convertedException);
        }
    }

    class RCFActionListener
    implements ActionListener<RCFResultResponse> {
        private String modelID;
        private AtomicReference<Exception> failure;
        private String rcfNodeID;
        private AnomalyDetector detector;
        private ActionListener<AnomalyResultResponse> listener;
        private List<FeatureData> featureInResponse;
        private final String adID;

        RCFActionListener(String modelID, AtomicReference<Exception> failure, String rcfNodeID, AnomalyDetector detector, ActionListener<AnomalyResultResponse> listener, List<FeatureData> features, String adID) {
            this.modelID = modelID;
            this.failure = failure;
            this.rcfNodeID = rcfNodeID;
            this.detector = detector;
            this.listener = listener;
            this.featureInResponse = features;
            this.adID = adID;
        }

        public void onResponse(RCFResultResponse response) {
            try {
                AnomalyResultTransportAction.this.stateManager.resetBackpressureCounter(this.rcfNodeID, this.adID);
                if (response != null) {
                    this.listener.onResponse((Object)new AnomalyResultResponse(response.getAnomalyGrade(), response.getConfidence(), response.getRCFScore(), this.featureInResponse, null, response.getTotalUpdates(), this.detector.getDetectorIntervalInMinutes(), false, response.getRelativeIndex(), response.getAttribution(), response.getPastValues(), response.getExpectedValuesList(), response.getLikelihoodOfValues(), response.getThreshold()));
                } else {
                    LOG.warn("Received null response from {} for {}", (Object)this.modelID, (Object)this.rcfNodeID);
                    this.listener.onFailure((Exception)new InternalFailure(this.adID, AnomalyResultTransportAction.NO_MODEL_ERR_MSG));
                }
            }
            catch (Exception ex) {
                LOG.error((Message)new ParameterizedMessage("Unexpected exception for [{}]", (Object)this.adID), (Throwable)ex);
                AnomalyResultTransportAction.this.handleExecuteException(ex, this.listener, this.adID);
            }
        }

        public void onFailure(Exception e) {
            try {
                AnomalyResultTransportAction.this.handlePredictionFailure(e, this.adID, this.rcfNodeID, this.failure);
                Exception exception = AnomalyResultTransportAction.this.coldStartIfNoModel(this.failure, this.detector);
                if (exception != null) {
                    this.listener.onFailure(exception);
                } else {
                    this.listener.onFailure((Exception)new InternalFailure(this.adID, "Node connection problem or unexpected exception"));
                }
            }
            catch (Exception ex) {
                LOG.error((Message)new ParameterizedMessage("Unexpected exception for [{}]", (Object)this.adID), (Throwable)ex);
                AnomalyResultTransportAction.this.handleExecuteException(ex, this.listener, this.adID);
            }
        }
    }

    class EntityResultListener
    implements ActionListener<AcknowledgedResponse> {
        private String nodeId;
        private final String adID;
        private AtomicReference<Exception> failure;

        EntityResultListener(String nodeId, String adID, AtomicReference<Exception> failure) {
            this.nodeId = nodeId;
            this.adID = adID;
            this.failure = failure;
        }

        public void onResponse(AcknowledgedResponse response) {
            try {
                if (!response.isAcknowledged()) {
                    LOG.error("Cannot send entities' features to {} for {}", (Object)this.nodeId, (Object)this.adID);
                    AnomalyResultTransportAction.this.stateManager.addPressure(this.nodeId, this.adID);
                } else {
                    AnomalyResultTransportAction.this.stateManager.resetBackpressureCounter(this.nodeId, this.adID);
                }
            }
            catch (Exception ex) {
                LOG.error("Unexpected exception: {} for {}", (Object)ex, (Object)this.adID);
                this.handleException(ex);
            }
        }

        public void onFailure(Exception e) {
            try {
                LOG.error((Message)new ParameterizedMessage("Cannot send entities' features to {} for {}", (Object)this.nodeId, (Object)this.adID), (Throwable)e);
                this.handleException(e);
            }
            catch (Exception ex) {
                LOG.error("Unexpected exception: {} for {}", (Object)ex, (Object)this.adID);
                this.handleException(ex);
            }
        }

        private void handleException(Exception e) {
            AnomalyResultTransportAction.this.handlePredictionFailure(e, this.adID, this.nodeId, this.failure);
            if (this.failure.get() != null) {
                AnomalyResultTransportAction.this.stateManager.setException(this.adID, this.failure.get());
            }
        }
    }
}

