/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.common.exception;

import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.OpenSearchException;
import org.opensearch.ad.common.exception.ADTaskCancelledException;
import org.opensearch.ad.common.exception.ADValidationException;
import org.opensearch.ad.common.exception.ADVersionException;
import org.opensearch.ad.common.exception.AnomalyDetectionException;
import org.opensearch.ad.common.exception.ClientException;
import org.opensearch.ad.common.exception.DuplicateTaskException;
import org.opensearch.ad.common.exception.EndRunException;
import org.opensearch.ad.common.exception.InternalFailure;
import org.opensearch.ad.common.exception.LimitExceededException;
import org.opensearch.ad.common.exception.ResourceNotFoundException;
import org.opensearch.core.common.io.stream.NotSerializableExceptionWrapper;

public enum NotSerializedADExceptionName {
    RESOURCE_NOT_FOUND_EXCEPTION_NAME_UNDERSCORE(OpenSearchException.getExceptionName((Throwable)new ResourceNotFoundException("", ""))),
    LIMIT_EXCEEDED_EXCEPTION_NAME_UNDERSCORE(OpenSearchException.getExceptionName((Throwable)new LimitExceededException("", "", false))),
    END_RUN_EXCEPTION_NAME_UNDERSCORE(OpenSearchException.getExceptionName((Throwable)new EndRunException("", "", false))),
    ANOMALY_DETECTION_EXCEPTION_NAME_UNDERSCORE(OpenSearchException.getExceptionName((Throwable)new AnomalyDetectionException("", ""))),
    INTERNAL_FAILURE_NAME_UNDERSCORE(OpenSearchException.getExceptionName((Throwable)new InternalFailure("", ""))),
    CLIENT_EXCEPTION_NAME_UNDERSCORE(OpenSearchException.getExceptionName((Throwable)new ClientException("", ""))),
    CANCELLATION_EXCEPTION_NAME_UNDERSCORE(OpenSearchException.getExceptionName((Throwable)new ADTaskCancelledException("", ""))),
    DUPLICATE_TASK_EXCEPTION_NAME_UNDERSCORE(OpenSearchException.getExceptionName((Throwable)new DuplicateTaskException(""))),
    AD_VERSION_EXCEPTION_NAME_UNDERSCORE(OpenSearchException.getExceptionName((Throwable)new ADVersionException(""))),
    AD_VALIDATION_EXCEPTION_NAME_UNDERSCORE(OpenSearchException.getExceptionName((Throwable)new ADValidationException("", null, null)));

    private static final Logger LOG;
    private final String name;

    private NotSerializedADExceptionName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static Optional<AnomalyDetectionException> convertWrappedAnomalyDetectionException(NotSerializableExceptionWrapper exception, String adID) {
        String exceptionMsg = exception.getMessage().trim();
        AnomalyDetectionException convertedException = null;
        block12: for (NotSerializedADExceptionName adException : NotSerializedADExceptionName.values()) {
            if (!exceptionMsg.startsWith(adException.getName())) continue;
            switch (adException.ordinal()) {
                case 0: {
                    convertedException = new ResourceNotFoundException(adID, exceptionMsg);
                    continue block12;
                }
                case 1: {
                    convertedException = new LimitExceededException(adID, exceptionMsg, false);
                    continue block12;
                }
                case 2: {
                    convertedException = new EndRunException(adID, exceptionMsg, false);
                    continue block12;
                }
                case 3: {
                    convertedException = new AnomalyDetectionException(adID, exceptionMsg);
                    continue block12;
                }
                case 4: {
                    convertedException = new InternalFailure(adID, exceptionMsg);
                    continue block12;
                }
                case 5: {
                    convertedException = new ClientException(adID, exceptionMsg);
                    continue block12;
                }
                case 6: {
                    convertedException = new ADTaskCancelledException(exceptionMsg, "");
                    continue block12;
                }
                case 7: {
                    convertedException = new DuplicateTaskException(exceptionMsg);
                    continue block12;
                }
                case 8: {
                    convertedException = new ADVersionException(exceptionMsg);
                    continue block12;
                }
                case 9: {
                    convertedException = new ADValidationException(exceptionMsg, null, null);
                    continue block12;
                }
                default: {
                    LOG.warn((Message)new ParameterizedMessage("Unexpected AD exception {}", (Object)adException));
                }
            }
        }
        return Optional.ofNullable(convertedException);
    }

    static {
        LOG = LogManager.getLogger(NotSerializedADExceptionName.class);
    }
}

