/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.join.ScoreMode;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.ad.AbstractProfileRunner;
import org.opensearch.ad.constant.CommonErrorMessages;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.ad.model.AnomalyDetectorJob;
import org.opensearch.ad.model.Entity;
import org.opensearch.ad.model.EntityProfile;
import org.opensearch.ad.model.EntityProfileName;
import org.opensearch.ad.model.EntityState;
import org.opensearch.ad.model.InitProgressProfile;
import org.opensearch.ad.model.IntervalTimeConfiguration;
import org.opensearch.ad.settings.NumericSetting;
import org.opensearch.ad.transport.EntityProfileAction;
import org.opensearch.ad.transport.EntityProfileRequest;
import org.opensearch.ad.transport.EntityProfileResponse;
import org.opensearch.ad.util.MultiResponsesDelegateActionListener;
import org.opensearch.ad.util.ParseUtils;
import org.opensearch.ad.util.SecurityClientUtil;
import org.opensearch.client.Client;
import org.opensearch.cluster.routing.Preference;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.NestedQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilders;
import org.opensearch.search.builder.SearchSourceBuilder;

public class EntityProfileRunner
extends AbstractProfileRunner {
    private final Logger logger = LogManager.getLogger(EntityProfileRunner.class);
    static final String NOT_HC_DETECTOR_ERR_MSG = "This is not a high cardinality detector";
    static final String EMPTY_ENTITY_ATTRIBUTES = "Empty entity attributes";
    static final String NO_ENTITY = "Cannot find entity";
    private Client client;
    private SecurityClientUtil clientUtil;
    private NamedXContentRegistry xContentRegistry;

    public EntityProfileRunner(Client client, SecurityClientUtil clientUtil, NamedXContentRegistry xContentRegistry, long requiredSamples) {
        super(requiredSamples);
        this.client = client;
        this.clientUtil = clientUtil;
        this.xContentRegistry = xContentRegistry;
    }

    public void profile(String detectorId, Entity entityValue, Set<EntityProfileName> profilesToCollect, ActionListener<EntityProfile> listener) {
        if (profilesToCollect == null || profilesToCollect.size() == 0) {
            listener.onFailure((Exception)new IllegalArgumentException(CommonErrorMessages.EMPTY_PROFILES_COLLECT));
            return;
        }
        GetRequest getDetectorRequest = new GetRequest(".opendistro-anomaly-detectors", detectorId);
        this.client.get(getDetectorRequest, ActionListener.wrap(getResponse -> {
            if (getResponse != null && getResponse.isExists()) {
                try (XContentParser parser = XContentType.JSON.xContent().createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, getResponse.getSourceAsString());){
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                    AnomalyDetector detector = AnomalyDetector.parse(parser, detectorId);
                    List<String> categoryFields = detector.getCategoryField();
                    int maxCategoryFields = NumericSetting.maxCategoricalFields();
                    if (categoryFields == null || categoryFields.size() == 0) {
                        listener.onFailure((Exception)new IllegalArgumentException(NOT_HC_DETECTOR_ERR_MSG));
                    } else if (categoryFields.size() > maxCategoryFields) {
                        listener.onFailure((Exception)new IllegalArgumentException(CommonErrorMessages.getTooManyCategoricalFieldErr(maxCategoryFields)));
                    } else {
                        this.validateEntity(entityValue, categoryFields, detectorId, profilesToCollect, detector, listener);
                    }
                }
                catch (Exception t) {
                    listener.onFailure(t);
                }
            } else {
                listener.onFailure((Exception)new IllegalArgumentException(CommonErrorMessages.FAIL_TO_FIND_DETECTOR_MSG + detectorId));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void validateEntity(Entity entity, List<String> categoryFields, String detectorId, Set<EntityProfileName> profilesToCollect, AnomalyDetector detector, ActionListener<EntityProfile> listener) {
        Map<String, String> attributes = entity.getAttributes();
        if (attributes == null || attributes.size() != categoryFields.size()) {
            listener.onFailure((Exception)new IllegalArgumentException(EMPTY_ENTITY_ATTRIBUTES));
            return;
        }
        for (String string : categoryFields) {
            if (attributes.containsKey(string)) continue;
            listener.onFailure((Exception)new IllegalArgumentException("Cannot find " + string));
            return;
        }
        BoolQueryBuilder internalFilterQuery = QueryBuilders.boolQuery().filter(detector.getFilterQuery());
        for (TermQueryBuilder term : entity.getTermQueryBuilders()) {
            internalFilterQuery.filter((QueryBuilder)term);
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)internalFilterQuery).size(1);
        SearchRequest searchRequest = new SearchRequest(detector.getIndices().toArray(new String[0]), searchSourceBuilder).preference(Preference.LOCAL.toString());
        ActionListener searchResponseListener = ActionListener.wrap(searchResponse -> {
            try {
                if (searchResponse.getHits().getHits().length == 0) {
                    listener.onFailure((Exception)new IllegalArgumentException(NO_ENTITY));
                    return;
                }
                this.prepareEntityProfile(listener, detectorId, entity, profilesToCollect, detector, (String)categoryFields.get(0));
            }
            catch (Exception e) {
                listener.onFailure((Exception)new IllegalArgumentException(NO_ENTITY));
                return;
            }
        }, e -> listener.onFailure((Exception)new IllegalArgumentException(NO_ENTITY)));
        this.clientUtil.asyncRequestWithInjectedSecurity(searchRequest, (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1), detector.getDetectorId(), this.client, searchResponseListener);
    }

    private void prepareEntityProfile(ActionListener<EntityProfile> listener, String detectorId, Entity entityValue, Set<EntityProfileName> profilesToCollect, AnomalyDetector detector, String categoryField) {
        EntityProfileRequest request = new EntityProfileRequest(detectorId, entityValue, profilesToCollect);
        this.client.execute((ActionType)EntityProfileAction.INSTANCE, (ActionRequest)request, ActionListener.wrap(r -> this.getJob(detectorId, entityValue, profilesToCollect, detector, (EntityProfileResponse)((Object)r), listener), arg_0 -> listener.onFailure(arg_0)));
    }

    private void getJob(String detectorId, Entity entityValue, Set<EntityProfileName> profilesToCollect, AnomalyDetector detector, EntityProfileResponse entityProfileResponse, ActionListener<EntityProfile> listener) {
        GetRequest getRequest = new GetRequest(".opendistro-anomaly-detector-jobs", detectorId);
        this.client.get(getRequest, ActionListener.wrap(getResponse -> {
            if (getResponse != null && getResponse.isExists()) {
                try (XContentParser parser = XContentType.JSON.xContent().createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, getResponse.getSourceAsString());){
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                    AnomalyDetectorJob job = AnomalyDetectorJob.parse(parser);
                    int totalResponsesToWait = 0;
                    if (profilesToCollect.contains(EntityProfileName.INIT_PROGRESS) || profilesToCollect.contains(EntityProfileName.STATE)) {
                        ++totalResponsesToWait;
                    }
                    if (profilesToCollect.contains(EntityProfileName.ENTITY_INFO)) {
                        ++totalResponsesToWait;
                    }
                    if (profilesToCollect.contains(EntityProfileName.MODELS)) {
                        ++totalResponsesToWait;
                    }
                    MultiResponsesDelegateActionListener<EntityProfile> delegateListener = new MultiResponsesDelegateActionListener<EntityProfile>(listener, totalResponsesToWait, CommonErrorMessages.FAIL_FETCH_ERR_MSG + String.valueOf(entityValue) + " of detector " + detectorId, false);
                    if (profilesToCollect.contains(EntityProfileName.MODELS)) {
                        EntityProfile.Builder builder = new EntityProfile.Builder();
                        if (!job.isEnabled()) {
                            delegateListener.onResponse(builder.build());
                        } else {
                            delegateListener.onResponse(builder.modelProfile(entityProfileResponse.getModelProfile()).build());
                        }
                    }
                    if (profilesToCollect.contains(EntityProfileName.INIT_PROGRESS) || profilesToCollect.contains(EntityProfileName.STATE)) {
                        this.profileStateRelated(entityProfileResponse.getTotalUpdates(), detectorId, entityValue, profilesToCollect, detector, job, delegateListener);
                    }
                    if (profilesToCollect.contains(EntityProfileName.ENTITY_INFO)) {
                        long enabledTimeMs = job.getEnabledTime().toEpochMilli();
                        SearchRequest lastSampleTimeRequest = this.createLastSampleTimeRequest(detectorId, enabledTimeMs, entityValue, detector.getResultIndex());
                        EntityProfile.Builder builder = new EntityProfile.Builder();
                        Optional<Boolean> isActiveOp = entityProfileResponse.isActive();
                        if (isActiveOp.isPresent()) {
                            builder.isActive(isActiveOp.get());
                        }
                        builder.lastActiveTimestampMs(entityProfileResponse.getLastActiveMs());
                        this.client.search(lastSampleTimeRequest, ActionListener.wrap(searchResponse -> {
                            Optional<Long> latestSampleTimeMs = ParseUtils.getLatestDataTime(searchResponse);
                            if (latestSampleTimeMs.isPresent()) {
                                builder.lastSampleTimestampMs(latestSampleTimeMs.get());
                            }
                            delegateListener.onResponse(builder.build());
                        }, exception -> {
                            if (exception instanceof IndexNotFoundException) {
                                this.logger.info("Result index hasn't been created", (Object)exception.getMessage());
                            } else {
                                this.logger.warn("fail to get last sample time", (Throwable)exception);
                            }
                            delegateListener.onResponse(builder.build());
                        }));
                    }
                }
                catch (Exception e) {
                    this.logger.error(CommonErrorMessages.FAIL_TO_GET_PROFILE_MSG, (Throwable)e);
                    listener.onFailure(e);
                }
            } else {
                this.sendUnknownState(profilesToCollect, entityValue, true, listener);
            }
        }, exception -> {
            if (exception instanceof IndexNotFoundException) {
                this.logger.info(exception.getMessage());
                this.sendUnknownState(profilesToCollect, entityValue, true, listener);
            } else {
                this.logger.error(CommonErrorMessages.FAIL_TO_GET_PROFILE_MSG + detectorId, (Throwable)exception);
                listener.onFailure(exception);
            }
        }));
    }

    private void profileStateRelated(long totalUpdates, String detectorId, Entity entityValue, Set<EntityProfileName> profilesToCollect, AnomalyDetector detector, AnomalyDetectorJob job, MultiResponsesDelegateActionListener<EntityProfile> delegateListener) {
        if (totalUpdates == 0L) {
            this.sendUnknownState(profilesToCollect, entityValue, false, delegateListener);
        } else if (!job.isEnabled()) {
            this.sendUnknownState(profilesToCollect, entityValue, false, delegateListener);
        } else if (totalUpdates >= this.requiredSamples) {
            this.sendRunningState(profilesToCollect, entityValue, delegateListener);
        } else {
            this.sendInitState(profilesToCollect, entityValue, detector, totalUpdates, delegateListener);
        }
    }

    private void sendUnknownState(Set<EntityProfileName> profilesToCollect, Entity entityValue, boolean immediate, ActionListener<EntityProfile> delegateListener) {
        EntityProfile.Builder builder = new EntityProfile.Builder();
        if (profilesToCollect.contains(EntityProfileName.STATE)) {
            builder.state(EntityState.UNKNOWN);
        }
        if (immediate) {
            delegateListener.onResponse((Object)builder.build());
        } else {
            delegateListener.onResponse((Object)builder.build());
        }
    }

    private void sendRunningState(Set<EntityProfileName> profilesToCollect, Entity entityValue, MultiResponsesDelegateActionListener<EntityProfile> delegateListener) {
        EntityProfile.Builder builder = new EntityProfile.Builder();
        if (profilesToCollect.contains(EntityProfileName.STATE)) {
            builder.state(EntityState.RUNNING);
        }
        if (profilesToCollect.contains(EntityProfileName.INIT_PROGRESS)) {
            InitProgressProfile initProgress = new InitProgressProfile("100%", 0L, 0);
            builder.initProgress(initProgress);
        }
        delegateListener.onResponse(builder.build());
    }

    private void sendInitState(Set<EntityProfileName> profilesToCollect, Entity entityValue, AnomalyDetector detector, long updates, MultiResponsesDelegateActionListener<EntityProfile> delegateListener) {
        EntityProfile.Builder builder = new EntityProfile.Builder();
        if (profilesToCollect.contains(EntityProfileName.STATE)) {
            builder.state(EntityState.INIT);
        }
        if (profilesToCollect.contains(EntityProfileName.INIT_PROGRESS)) {
            long intervalMins = ((IntervalTimeConfiguration)detector.getDetectionInterval()).toDuration().toMinutes();
            InitProgressProfile initProgress = this.computeInitProgressProfile(updates, intervalMins);
            builder.initProgress(initProgress);
        }
        delegateListener.onResponse(builder.build());
    }

    private SearchRequest createLastSampleTimeRequest(String detectorId, long enabledTime, Entity entity, String resultIndex) {
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        String path = "entity";
        String entityName = path + ".name";
        String entityValue = path + ".value";
        for (Map.Entry<String, String> attribute : entity.getAttributes().entrySet()) {
            BoolQueryBuilder nestedBoolQueryBuilder = new BoolQueryBuilder();
            TermQueryBuilder entityNameFilterQuery = QueryBuilders.termQuery((String)entityName, (String)attribute.getKey());
            nestedBoolQueryBuilder.filter((QueryBuilder)entityNameFilterQuery);
            TermQueryBuilder entityValueFilterQuery = QueryBuilders.termQuery((String)entityValue, (String)attribute.getValue());
            nestedBoolQueryBuilder.filter((QueryBuilder)entityValueFilterQuery);
            NestedQueryBuilder nestedNameQueryBuilder = new NestedQueryBuilder(path, (QueryBuilder)nestedBoolQueryBuilder, ScoreMode.None);
            boolQueryBuilder.filter((QueryBuilder)nestedNameQueryBuilder);
        }
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"detector_id", (String)detectorId));
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"execution_end_time").gte((Object)enabledTime));
        SearchSourceBuilder source = new SearchSourceBuilder().query((QueryBuilder)boolQueryBuilder).aggregation((AggregationBuilder)AggregationBuilders.max((String)"max_timefield").field("execution_end_time")).trackTotalHits(false).size(0);
        SearchRequest request = new SearchRequest(new String[]{".opendistro-anomaly-results"});
        request.source(source);
        if (resultIndex != null) {
            request.indices(new String[]{resultIndex});
        }
        return request;
    }
}

