/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.util;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.join.ScoreMode;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.ad.common.exception.AnomalyDetectionException;
import org.opensearch.ad.common.exception.ResourceNotFoundException;
import org.opensearch.ad.constant.CommonErrorMessages;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.ad.model.Entity;
import org.opensearch.ad.model.Feature;
import org.opensearch.ad.model.FeatureData;
import org.opensearch.ad.model.IntervalTimeConfiguration;
import org.opensearch.ad.transport.GetAnomalyDetectorResponse;
import org.opensearch.ad.util.RestHandlerUtils;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.NestedQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.RangeQueryBuilder;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.index.query.TermsQueryBuilder;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilders;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.BaseAggregationBuilder;
import org.opensearch.search.aggregations.PipelineAggregationBuilder;
import org.opensearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.opensearch.search.aggregations.bucket.composite.DateHistogramValuesSourceBuilder;
import org.opensearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.opensearch.search.aggregations.bucket.range.DateRangeAggregationBuilder;
import org.opensearch.search.aggregations.metrics.Max;
import org.opensearch.search.builder.SearchSourceBuilder;

public final class ParseUtils {
    private static final Logger logger = LogManager.getLogger(ParseUtils.class);

    private ParseUtils() {
    }

    public static Instant toInstant(XContentParser parser) throws IOException {
        if (parser.currentToken() == null || parser.currentToken() == XContentParser.Token.VALUE_NULL) {
            return null;
        }
        if (parser.currentToken().isValue()) {
            return Instant.ofEpochMilli(parser.longValue());
        }
        return null;
    }

    public static AggregationBuilder toAggregationBuilder(XContentParser parser) throws IOException {
        AggregatorFactories.Builder parsed = AggregatorFactories.parseAggregators((XContentParser)parser);
        return (AggregationBuilder)parsed.getAggregatorFactories().iterator().next();
    }

    public static XContentParser parser(String content, NamedXContentRegistry contentRegistry) throws IOException {
        XContentParser parser = XContentType.JSON.xContent().createParser(contentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, content);
        parser.nextToken();
        return parser;
    }

    public static AggregatorFactories.Builder parseAggregators(String aggQuery, NamedXContentRegistry xContentRegistry, String aggName) throws IOException {
        XContentParser parser = ParseUtils.parser(aggQuery, xContentRegistry);
        return ParseUtils.parseAggregators(parser, aggName);
    }

    public static AggregatorFactories.Builder parseAggregators(XContentParser parser, String aggName) throws IOException {
        return ParseUtils.parseAggregators(parser, 0, aggName);
    }

    public static AggregatorFactories.Builder parseAggregators(XContentParser parser, int level, String aggName) throws IOException {
        Matcher validAggMatcher = AggregatorFactories.VALID_AGG_NAME.matcher("");
        AggregatorFactories.Builder factories = new AggregatorFactories.Builder();
        XContentParser.Token token = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            String aggregationName;
            if (token != XContentParser.Token.FIELD_NAME) {
                throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + String.valueOf(token) + " in [aggs]: aggregations definitions must start with the name of the aggregation.", new Object[0]);
            }
            String string = aggregationName = aggName == null ? parser.currentName() : aggName;
            if (!validAggMatcher.reset(aggregationName).matches()) {
                throw new ParsingException(parser.getTokenLocation(), "Invalid aggregation name [" + aggregationName + "]. Aggregation names must be alpha-numeric and can only contain '_' and '-'", new Object[0]);
            }
            token = parser.nextToken();
            if (token != XContentParser.Token.START_OBJECT) {
                throw new ParsingException(parser.getTokenLocation(), "Aggregation definition for [" + aggregationName + " starts with a [" + String.valueOf(token) + "], expected a [" + String.valueOf(XContentParser.Token.START_OBJECT) + "].", new Object[0]);
            }
            BaseAggregationBuilder aggBuilder = null;
            AggregatorFactories.Builder subFactories = null;
            Map metaData = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token != XContentParser.Token.FIELD_NAME) {
                    throw new ParsingException(parser.getTokenLocation(), "Expected [" + String.valueOf(XContentParser.Token.FIELD_NAME) + "] under a [" + String.valueOf(XContentParser.Token.START_OBJECT) + "], but got a [" + String.valueOf(token) + "] in [" + aggregationName + "]", new Object[]{parser.getTokenLocation()});
                }
                String fieldName = parser.currentName();
                token = parser.nextToken();
                if (token == XContentParser.Token.START_OBJECT) {
                    switch (fieldName) {
                        case "meta": {
                            metaData = parser.map();
                            break;
                        }
                        case "aggregations": 
                        case "aggs": {
                            if (subFactories != null) {
                                throw new ParsingException(parser.getTokenLocation(), "Found two sub aggregation definitions under [" + aggregationName + "]", new Object[0]);
                            }
                            subFactories = ParseUtils.parseAggregators(parser, level + 1, null);
                            break;
                        }
                        default: {
                            if (aggBuilder != null) {
                                throw new ParsingException(parser.getTokenLocation(), "Found two aggregation type definitions in [" + aggregationName + "]: [" + aggBuilder.getType() + "] and [" + fieldName + "]", new Object[0]);
                            }
                            aggBuilder = (BaseAggregationBuilder)parser.namedObject(BaseAggregationBuilder.class, fieldName, (Object)aggregationName);
                            break;
                        }
                    }
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Expected [" + String.valueOf(XContentParser.Token.START_OBJECT) + "] under [" + fieldName + "], but got a [" + String.valueOf(token) + "] in [" + aggregationName + "]", new Object[0]);
            }
            if (aggBuilder == null) {
                throw new ParsingException(parser.getTokenLocation(), "Missing definition for aggregation [" + aggregationName + "]", new Object[]{parser.getTokenLocation()});
            }
            if (metaData != null) {
                aggBuilder.setMetadata(metaData);
            }
            if (subFactories != null) {
                aggBuilder.subAggregations(subFactories);
            }
            if (aggBuilder instanceof AggregationBuilder) {
                factories.addAggregator((AggregationBuilder)aggBuilder);
                continue;
            }
            factories.addPipelineAggregator((PipelineAggregationBuilder)aggBuilder);
        }
        return factories;
    }

    public static SearchSourceBuilder generateInternalFeatureQuery(AnomalyDetector detector, long startTime, long endTime, NamedXContentRegistry xContentRegistry) throws IOException {
        RangeQueryBuilder rangeQuery = new RangeQueryBuilder(detector.getTimeField()).from((Object)startTime).to((Object)endTime).format("epoch_millis").includeLower(true).includeUpper(false);
        BoolQueryBuilder internalFilterQuery = QueryBuilders.boolQuery().must((QueryBuilder)rangeQuery).must(detector.getFilterQuery());
        SearchSourceBuilder internalSearchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)internalFilterQuery);
        if (detector.getFeatureAttributes() != null) {
            for (Feature feature : detector.getFeatureAttributes()) {
                AggregatorFactories.Builder internalAgg = ParseUtils.parseAggregators(feature.getAggregation().toString(), xContentRegistry, feature.getId());
                internalSearchSourceBuilder.aggregation((AggregationBuilder)internalAgg.getAggregatorFactories().iterator().next());
            }
        }
        return internalSearchSourceBuilder;
    }

    public static SearchSourceBuilder generatePreviewQuery(AnomalyDetector detector, List<Map.Entry<Long, Long>> ranges, NamedXContentRegistry xContentRegistry) throws IOException {
        DateRangeAggregationBuilder dateRangeBuilder = (DateRangeAggregationBuilder)((DateRangeAggregationBuilder)AggregationBuilders.dateRange((String)"date_range").field(detector.getTimeField())).format("epoch_millis");
        for (Map.Entry<Long, Long> range : ranges) {
            dateRangeBuilder.addRange((double)range.getKey().longValue(), (double)range.getValue().longValue());
        }
        if (detector.getFeatureAttributes() != null) {
            for (Feature feature : detector.getFeatureAttributes()) {
                AggregatorFactories.Builder internalAgg = ParseUtils.parseAggregators(feature.getAggregation().toString(), xContentRegistry, feature.getId());
                dateRangeBuilder.subAggregation((AggregationBuilder)internalAgg.getAggregatorFactories().iterator().next());
            }
        }
        return new SearchSourceBuilder().query(detector.getFilterQuery()).size(0).aggregation((AggregationBuilder)dateRangeBuilder);
    }

    public static String generateInternalFeatureQueryTemplate(AnomalyDetector detector, NamedXContentRegistry xContentRegistry) throws IOException {
        RangeQueryBuilder rangeQuery = new RangeQueryBuilder(detector.getTimeField()).from((Object)"{{period_start}}").to((Object)"{{period_end}}");
        BoolQueryBuilder internalFilterQuery = QueryBuilders.boolQuery().must((QueryBuilder)rangeQuery).must(detector.getFilterQuery());
        SearchSourceBuilder internalSearchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)internalFilterQuery);
        if (detector.getFeatureAttributes() != null) {
            for (Feature feature : detector.getFeatureAttributes()) {
                AggregatorFactories.Builder internalAgg = ParseUtils.parseAggregators(feature.getAggregation().toString(), xContentRegistry, feature.getId());
                internalSearchSourceBuilder.aggregation((AggregationBuilder)internalAgg.getAggregatorFactories().iterator().next());
            }
        }
        return internalSearchSourceBuilder.toString();
    }

    public static SearchSourceBuilder generateEntityColdStartQuery(AnomalyDetector detector, List<Map.Entry<Long, Long>> ranges, Entity entity, NamedXContentRegistry xContentRegistry) throws IOException {
        BoolQueryBuilder internalFilterQuery = QueryBuilders.boolQuery().filter(detector.getFilterQuery());
        for (TermQueryBuilder term : entity.getTermQueryBuilders()) {
            internalFilterQuery.filter((QueryBuilder)term);
        }
        DateRangeAggregationBuilder dateRangeBuilder = (DateRangeAggregationBuilder)((DateRangeAggregationBuilder)AggregationBuilders.dateRange((String)"date_range").field(detector.getTimeField())).format("epoch_millis");
        for (Map.Entry<Long, Long> range : ranges) {
            dateRangeBuilder.addRange((double)range.getKey().longValue(), (double)range.getValue().longValue());
        }
        if (detector.getFeatureAttributes() != null) {
            for (Feature feature : detector.getFeatureAttributes()) {
                AggregatorFactories.Builder internalAgg = ParseUtils.parseAggregators(feature.getAggregation().toString(), xContentRegistry, feature.getId());
                dateRangeBuilder.subAggregation((AggregationBuilder)internalAgg.getAggregatorFactories().iterator().next());
            }
        }
        return new SearchSourceBuilder().query((QueryBuilder)internalFilterQuery).size(0).aggregation((AggregationBuilder)dateRangeBuilder);
    }

    public static List<FeatureData> getFeatureData(double[] currentFeature, AnomalyDetector detector) {
        List<String> featureIds = detector.getEnabledFeatureIds();
        List<String> featureNames = detector.getEnabledFeatureNames();
        int featureLen = featureIds.size();
        ArrayList<FeatureData> featureData = new ArrayList<FeatureData>();
        for (int i = 0; i < featureLen; ++i) {
            featureData.add(new FeatureData(featureIds.get(i), featureNames.get(i), currentFeature[i]));
        }
        return featureData;
    }

    public static SearchSourceBuilder addUserBackendRolesFilter(User user, SearchSourceBuilder searchSourceBuilder) {
        if (user == null) {
            return searchSourceBuilder;
        }
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        String userFieldName = "user";
        String userBackendRoleFieldName = "user.backend_roles.keyword";
        Object backendRoles = user.getBackendRoles() != null ? user.getBackendRoles() : ImmutableList.of();
        TermsQueryBuilder userRolesFilterQuery = QueryBuilders.termsQuery((String)userBackendRoleFieldName, (Collection)backendRoles);
        NestedQueryBuilder nestedQueryBuilder = new NestedQueryBuilder(userFieldName, (QueryBuilder)userRolesFilterQuery, ScoreMode.None);
        boolQueryBuilder.must((QueryBuilder)nestedQueryBuilder);
        QueryBuilder query = searchSourceBuilder.query();
        if (query == null) {
            searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
        } else if (query instanceof BoolQueryBuilder) {
            ((BoolQueryBuilder)query).filter((QueryBuilder)boolQueryBuilder);
        } else {
            throw new AnomalyDetectionException("Search API does not support queries other than BoolQuery");
        }
        return searchSourceBuilder;
    }

    public static User getUserContext(Client client) {
        String userStr = (String)client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info");
        logger.debug("Filtering result by " + userStr);
        return User.parse((String)userStr);
    }

    public static void resolveUserAndExecute(User requestedUser, String detectorId, boolean filterByEnabled, ActionListener listener, Consumer<AnomalyDetector> function, Client client, ClusterService clusterService, NamedXContentRegistry xContentRegistry) {
        try {
            if (requestedUser == null || detectorId == null) {
                function.accept(null);
            } else {
                ParseUtils.getDetector(requestedUser, detectorId, listener, function, client, clusterService, xContentRegistry, filterByEnabled);
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public static void getDetector(User requestUser, String detectorId, ActionListener listener, Consumer<AnomalyDetector> function, Client client, ClusterService clusterService, NamedXContentRegistry xContentRegistry, boolean filterByBackendRole) {
        if (clusterService.state().metadata().indices().containsKey(".opendistro-anomaly-detectors")) {
            GetRequest request = new GetRequest(".opendistro-anomaly-detectors").id(detectorId);
            client.get(request, ActionListener.wrap(response -> ParseUtils.onGetAdResponse(response, requestUser, detectorId, (ActionListener<GetAnomalyDetectorResponse>)listener, function, xContentRegistry, filterByBackendRole), exception -> {
                logger.error("Failed to get anomaly detector: " + detectorId, (Throwable)exception);
                listener.onFailure(exception);
            }));
        } else {
            listener.onFailure((Exception)new IndexNotFoundException(".opendistro-anomaly-detectors"));
        }
    }

    public static void onGetAdResponse(GetResponse response, User requestUser, String detectorId, ActionListener<GetAnomalyDetectorResponse> listener, Consumer<AnomalyDetector> function, NamedXContentRegistry xContentRegistry, boolean filterByBackendRole) {
        if (response.isExists()) {
            try (XContentParser parser = RestHandlerUtils.createXContentParserFromRegistry(xContentRegistry, response.getSourceAsBytesRef());){
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                AnomalyDetector detector = AnomalyDetector.parse(parser);
                User resourceUser = detector.getUser();
                if (!filterByBackendRole || ParseUtils.checkUserPermissions(requestUser, resourceUser, detectorId) || ParseUtils.isAdmin(requestUser)) {
                    function.accept(detector);
                } else {
                    logger.debug("User: " + requestUser.getName() + " does not have permissions to access detector: " + detectorId);
                    listener.onFailure((Exception)new AnomalyDetectionException(CommonErrorMessages.NO_PERMISSION_TO_ACCESS_DETECTOR + detectorId));
                }
            }
            catch (Exception e) {
                listener.onFailure((Exception)new AnomalyDetectionException(CommonErrorMessages.FAIL_TO_GET_USER_INFO + detectorId));
            }
        } else {
            listener.onFailure((Exception)new ResourceNotFoundException(detectorId, CommonErrorMessages.FAIL_TO_FIND_DETECTOR_MSG + detectorId));
        }
    }

    public static boolean isAdmin(User user) {
        if (user == null) {
            return false;
        }
        return user.getRoles().contains("all_access");
    }

    private static boolean checkUserPermissions(User requestedUser, User resourceUser, String detectorId) throws Exception {
        if (resourceUser.getBackendRoles() == null || requestedUser.getBackendRoles() == null) {
            return false;
        }
        for (String backendRole : requestedUser.getBackendRoles()) {
            if (!resourceUser.getBackendRoles().contains(backendRole)) continue;
            logger.debug("User: " + requestedUser.getName() + " has backend role: " + backendRole + " permissions to access detector: " + detectorId);
            return true;
        }
        return false;
    }

    public static boolean checkFilterByBackendRoles(User requestedUser, ActionListener listener) {
        if (requestedUser == null) {
            return false;
        }
        if (requestedUser.getBackendRoles().isEmpty()) {
            listener.onFailure((Exception)new AnomalyDetectionException("Filter by backend roles is enabled and User " + requestedUser.getName() + " does not have backend roles configured"));
            return false;
        }
        return true;
    }

    public static Optional<Long> getLatestDataTime(SearchResponse searchResponse) {
        return Optional.ofNullable(searchResponse).map(SearchResponse::getAggregations).map(aggs -> aggs.asMap()).map(map -> (Max)map.get("max_timefield")).map(agg -> (long)agg.getValue());
    }

    public static SearchSourceBuilder batchFeatureQuery(AnomalyDetector detector, Entity entity, long startTime, long endTime, NamedXContentRegistry xContentRegistry) throws IOException {
        RangeQueryBuilder rangeQuery = new RangeQueryBuilder(detector.getTimeField()).from((Object)startTime).to((Object)endTime).format("epoch_millis").includeLower(true).includeUpper(false);
        BoolQueryBuilder internalFilterQuery = QueryBuilders.boolQuery().must((QueryBuilder)rangeQuery).must(detector.getFilterQuery());
        if (detector.isMultientityDetector() && entity != null && entity.getAttributes().size() > 0) {
            entity.getAttributes().entrySet().forEach(attr -> internalFilterQuery.filter((QueryBuilder)new TermQueryBuilder((String)attr.getKey(), (String)attr.getValue())));
        }
        long intervalSeconds = ((IntervalTimeConfiguration)detector.getDetectionInterval()).toDuration().getSeconds();
        ArrayList<DateHistogramValuesSourceBuilder> sources = new ArrayList<DateHistogramValuesSourceBuilder>();
        sources.add(((DateHistogramValuesSourceBuilder)new DateHistogramValuesSourceBuilder("date_histogram").field(detector.getTimeField())).fixedInterval(DateHistogramInterval.seconds((int)((int)intervalSeconds))));
        CompositeAggregationBuilder aggregationBuilder = new CompositeAggregationBuilder("feature_aggs", sources).size(10000);
        if (detector.getEnabledFeatureIds().size() == 0) {
            throw new AnomalyDetectionException("No enabled feature configured").countedInStats(false);
        }
        for (Feature feature : detector.getFeatureAttributes()) {
            if (!feature.getEnabled().booleanValue()) continue;
            AggregatorFactories.Builder internalAgg = ParseUtils.parseAggregators(feature.getAggregation().toString(), xContentRegistry, feature.getId());
            aggregationBuilder.subAggregation((AggregationBuilder)internalAgg.getAggregatorFactories().iterator().next());
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.aggregation((AggregationBuilder)aggregationBuilder);
        searchSourceBuilder.query((QueryBuilder)internalFilterQuery);
        searchSourceBuilder.size(0);
        return searchSourceBuilder;
    }

    public static <T> boolean isNullOrEmpty(Collection<T> collection) {
        return collection == null || collection.size() == 0;
    }

    public static <S, T> boolean isNullOrEmpty(Map<S, T> map) {
        return map == null || map.size() == 0;
    }

    public static boolean listEqualsWithoutConsideringOrder(List<String> list1, List<String> list2) {
        HashSet<String> set1 = new HashSet<String>();
        HashSet<String> set2 = new HashSet<String>();
        if (list1 != null) {
            set1.addAll(list1);
        }
        if (list2 != null) {
            set2.addAll(list2);
        }
        return Objects.equals(set1, set2);
    }

    public static double[] parseDoubleArray(XContentParser parser) throws IOException {
        ArrayList<Double> oldValList = new ArrayList<Double>();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            oldValList.add(parser.doubleValue());
        }
        return oldValList.stream().mapToDouble(Double::doubleValue).toArray();
    }

    public static List<String> parseAggregationRequest(XContentParser parser) throws IOException {
        XContentParser.Token token;
        ArrayList<String> fieldNames = new ArrayList<String>();
        block6: while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            String field;
            if (token != XContentParser.Token.FIELD_NAME) continue;
            switch (field = parser.currentName()) {
                case "field": {
                    parser.nextToken();
                    fieldNames.add(parser.textOrNull());
                    continue block6;
                }
            }
            parser.skipChildren();
        }
        return fieldNames;
    }

    public static List<String> getFeatureFieldNames(AnomalyDetector detector, NamedXContentRegistry xContentRegistry) throws IOException {
        ArrayList<String> featureFields = new ArrayList<String>();
        for (Feature feature : detector.getFeatureAttributes()) {
            featureFields.add(ParseUtils.getFieldNamesForFeature(feature, xContentRegistry).get(0));
        }
        return featureFields;
    }

    public static List<String> getFieldNamesForFeature(Feature feature, NamedXContentRegistry xContentRegistry) throws IOException {
        ParseUtils.parseAggregators(feature.getAggregation().toString(), xContentRegistry, feature.getId());
        XContentParser parser = XContentType.JSON.xContent().createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, feature.getAggregation().toString());
        parser.nextToken();
        return ParseUtils.parseAggregationRequest(parser);
    }
}

