/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.ad.NodeStateManager;
import org.opensearch.ad.feature.FeatureManager;
import org.opensearch.ad.model.ADTask;
import org.opensearch.ad.model.ADTaskAction;
import org.opensearch.ad.model.ADTaskState;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.ad.model.DetectionDateRange;
import org.opensearch.ad.task.ADTaskCacheManager;
import org.opensearch.ad.task.ADTaskManager;
import org.opensearch.ad.transport.AnomalyDetectorJobResponse;
import org.opensearch.ad.transport.ForwardADTaskAction;
import org.opensearch.ad.transport.ForwardADTaskRequest;
import org.opensearch.common.inject.Inject;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class ForwardADTaskTransportAction
extends HandledTransportAction<ForwardADTaskRequest, AnomalyDetectorJobResponse> {
    private final Logger logger = LogManager.getLogger(ForwardADTaskTransportAction.class);
    private final TransportService transportService;
    private final ADTaskManager adTaskManager;
    private final ADTaskCacheManager adTaskCacheManager;
    private final NodeStateManager stateManager;
    private final FeatureManager featureManager;

    @Inject
    public ForwardADTaskTransportAction(ActionFilters actionFilters, TransportService transportService, ADTaskManager adTaskManager, ADTaskCacheManager adTaskCacheManager, FeatureManager featureManager, NodeStateManager stateManager) {
        super(ForwardADTaskAction.NAME, transportService, actionFilters, ForwardADTaskRequest::new);
        this.adTaskManager = adTaskManager;
        this.transportService = transportService;
        this.adTaskCacheManager = adTaskCacheManager;
        this.featureManager = featureManager;
        this.stateManager = stateManager;
    }

    protected void doExecute(Task task, ForwardADTaskRequest request, ActionListener<AnomalyDetectorJobResponse> listener) {
        ADTaskAction adTaskAction = request.getAdTaskAction();
        AnomalyDetector detector = request.getDetector();
        DetectionDateRange detectionDateRange = request.getDetectionDateRange();
        String detectorId = detector.getDetectorId();
        ADTask adTask = request.getAdTask();
        User user = request.getUser();
        Integer availableTaskSlots = request.getAvailableTaskSLots();
        String entityValue = this.adTaskManager.convertEntityToString(adTask);
        switch (adTaskAction) {
            case APPLY_FOR_TASK_SLOTS: {
                this.logger.debug("Received APPLY_FOR_TASK_SLOTS action for detector {}", (Object)detectorId);
                this.adTaskManager.checkTaskSlots(adTask, detector, detectionDateRange, user, ADTaskAction.START, this.transportService, listener);
                break;
            }
            case CHECK_AVAILABLE_TASK_SLOTS: {
                this.logger.debug("Received CHECK_AVAILABLE_TASK_SLOTS action for detector {}", (Object)detectorId);
                this.adTaskManager.checkTaskSlots(adTask, detector, detectionDateRange, user, ADTaskAction.SCALE_ENTITY_TASK_SLOTS, this.transportService, listener);
                break;
            }
            case START: {
                this.logger.debug("Received START action for detector {}", (Object)detectorId);
                this.adTaskManager.startDetector(detector, detectionDateRange, user, this.transportService, (ActionListener<AnomalyDetectorJobResponse>)ActionListener.wrap(r -> {
                    this.adTaskCacheManager.setDetectorTaskSlots(detector.getDetectorId(), availableTaskSlots);
                    listener.onResponse((Object)r);
                }, e -> listener.onFailure(e)));
                break;
            }
            case NEXT_ENTITY: {
                this.logger.debug("Received NEXT_ENTITY action for detector {}, task {}", (Object)detectorId, (Object)adTask.getTaskId());
                if (detector.isMultientityDetector()) {
                    this.adTaskCacheManager.removeRunningEntity(detectorId, entityValue);
                    if (!this.adTaskCacheManager.hasEntity(detectorId)) {
                        this.adTaskCacheManager.setDetectorTaskSlots(detectorId, 0);
                        this.logger.info("Historical HC detector done, will remove from cache, detector id:{}", (Object)detectorId);
                        listener.onResponse((Object)new AnomalyDetectorJobResponse(detectorId, 0L, 0L, 0L, RestStatus.OK));
                        ADTaskState state = !adTask.isEntityTask() && adTask.getError() != null ? ADTaskState.FAILED : ADTaskState.FINISHED;
                        this.adTaskManager.setHCDetectorTaskDone(adTask, state, listener);
                        break;
                    }
                    this.logger.debug("Run next entity for detector " + detectorId);
                    this.adTaskManager.runNextEntityForHCADHistorical(adTask, this.transportService, listener);
                    this.adTaskManager.updateADHCDetectorTask(detectorId, adTask.getParentTaskId(), (Map<String, Object>)ImmutableMap.of((Object)"state", (Object)ADTaskState.RUNNING.name(), (Object)"task_progress", (Object)Float.valueOf(this.adTaskManager.hcDetectorProgress(detectorId)), (Object)"error", (Object)(adTask.getError() != null ? adTask.getError() : "")));
                    break;
                }
                this.logger.warn("Can only handle HC entity task for NEXT_ENTITY action, taskId:{} , taskType:{}", (Object)adTask.getTaskId(), (Object)adTask.getTaskType());
                listener.onFailure((Exception)new IllegalArgumentException("Unsupported task"));
                break;
            }
            case PUSH_BACK_ENTITY: {
                this.logger.debug("Received PUSH_BACK_ENTITY action for detector {}, task {}", (Object)detectorId, (Object)adTask.getTaskId());
                if (adTask.isEntityTask()) {
                    this.adTaskCacheManager.removeRunningEntity(detectorId, entityValue);
                    if (this.adTaskManager.isRetryableError(adTask.getError()) && !this.adTaskCacheManager.exceedRetryLimit(adTask.getDetectorId(), adTask.getTaskId())) {
                        this.adTaskCacheManager.pushBackEntity(adTask.getTaskId(), adTask.getDetectorId(), entityValue);
                    } else {
                        this.adTaskCacheManager.removeEntity(adTask.getDetectorId(), entityValue);
                        this.logger.warn("Entity task failed, task id: {}, entity: {}", (Object)adTask.getTaskId(), (Object)adTask.getEntity().toString());
                    }
                    if (!this.adTaskCacheManager.hasEntity(detectorId)) {
                        this.adTaskCacheManager.setDetectorTaskSlots(detectorId, 0);
                        this.adTaskManager.setHCDetectorTaskDone(adTask, ADTaskState.FINISHED, listener);
                        break;
                    }
                    this.logger.debug("scale task slots for PUSH_BACK_ENTITY, detector {} task {}", (Object)detectorId, (Object)adTask.getTaskId());
                    int taskSlots = this.adTaskCacheManager.scaleDownHCDetectorTaskSlots(detectorId, 1);
                    if (taskSlots == 1) {
                        this.logger.debug("After scale down, only 1 task slot reserved for detector {}, run next entity", (Object)detectorId);
                        this.adTaskManager.runNextEntityForHCADHistorical(adTask, this.transportService, listener);
                    }
                    listener.onResponse((Object)new AnomalyDetectorJobResponse(adTask.getTaskId(), 0L, 0L, 0L, RestStatus.ACCEPTED));
                    break;
                }
                this.logger.warn("Can only push back entity task");
                listener.onFailure((Exception)new IllegalArgumentException("Can only push back entity task"));
                break;
            }
            case SCALE_ENTITY_TASK_SLOTS: {
                int newSlots;
                this.logger.debug("Received SCALE_ENTITY_TASK_LANE action for detector {}", (Object)detectorId);
                if (availableTaskSlots != null && availableTaskSlots > 0 && (newSlots = Math.min(availableTaskSlots, this.adTaskManager.detectorTaskSlotScaleDelta(detectorId))) > 0) {
                    this.adTaskCacheManager.setAllowedRunningEntities(detectorId, newSlots);
                    this.adTaskCacheManager.scaleUpDetectorTaskSlots(detectorId, newSlots);
                }
                listener.onResponse((Object)new AnomalyDetectorJobResponse(detector.getDetectorId(), 0L, 0L, 0L, RestStatus.OK));
                break;
            }
            case CANCEL: {
                this.logger.debug("Received CANCEL action for detector {}", (Object)detectorId);
                if (detector.isMultientityDetector()) {
                    this.adTaskCacheManager.clearPendingEntities(detectorId);
                    this.adTaskCacheManager.removeRunningEntity(detectorId, entityValue);
                    if (!this.adTaskCacheManager.hasEntity(detectorId) || !adTask.isEntityTask()) {
                        this.adTaskManager.setHCDetectorTaskDone(adTask, ADTaskState.STOPPED, listener);
                    }
                    listener.onResponse((Object)new AnomalyDetectorJobResponse(adTask.getTaskId(), 0L, 0L, 0L, RestStatus.OK));
                    break;
                }
                listener.onFailure((Exception)new IllegalArgumentException("Only support cancel HC now"));
                break;
            }
            case CLEAN_STALE_RUNNING_ENTITIES: {
                this.logger.debug("Received CLEAN_STALE_RUNNING_ENTITIES action for detector {}", (Object)detectorId);
                List<String> staleRunningEntities = request.getStaleRunningEntities();
                this.logger.debug("Clean stale running entities of task {}, staleRunningEntities: {}", (Object)adTask.getTaskId(), (Object)Arrays.toString(staleRunningEntities.toArray(new String[0])));
                for (String entity : staleRunningEntities) {
                    this.adTaskManager.removeStaleRunningEntity(adTask, entity, this.transportService, listener);
                }
                listener.onResponse((Object)new AnomalyDetectorJobResponse(adTask.getTaskId(), 0L, 0L, 0L, RestStatus.OK));
                break;
            }
            case CLEAN_CACHE: {
                boolean historicalTask = adTask.isHistoricalTask();
                this.logger.debug("Received CLEAN_CACHE action for detector {}, taskId: {}, historical: {}", (Object)detectorId, (Object)adTask.getTaskId(), (Object)historicalTask);
                if (historicalTask) {
                    this.adTaskCacheManager.removeHistoricalTaskCacheIfNoRunningEntity(detectorId);
                } else {
                    this.adTaskCacheManager.removeRealtimeTaskCache(detectorId);
                    this.stateManager.clear(detectorId);
                    this.featureManager.clear(detectorId);
                }
                listener.onResponse((Object)new AnomalyDetectorJobResponse(detector.getDetectorId(), 0L, 0L, 0L, RestStatus.OK));
                break;
            }
            default: {
                listener.onFailure((Exception)new OpenSearchStatusException("Unsupported AD task action " + String.valueOf((Object)adTaskAction), RestStatus.BAD_REQUEST, new Object[0]));
            }
        }
    }
}

