/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.feature;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.opensearch.ad.common.exception.EndRunException;
import org.opensearch.search.aggregations.Aggregation;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.search.aggregations.InternalAggregations;
import org.opensearch.search.aggregations.bucket.InternalSingleBucketAggregation;
import org.opensearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.opensearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.opensearch.search.aggregations.metrics.InternalTDigestPercentiles;
import org.opensearch.search.aggregations.metrics.NumericMetricsAggregation;
import org.opensearch.search.aggregations.metrics.Percentile;
import org.opensearch.search.builder.SearchSourceBuilder;

public abstract class AbstractRetriever {
    protected double parseAggregation(Aggregation aggregationToParse) {
        Iterator percentile;
        Aggregation aggregation;
        List aggrs;
        InternalAggregations bucket;
        Double result = null;
        if (aggregationToParse instanceof InternalSingleBucketAggregation && (bucket = ((InternalSingleBucketAggregation)aggregationToParse).getAggregations()) != null && (aggrs = bucket.asList()).size() == 1) {
            aggregationToParse = (Aggregation)aggrs.get(0);
        }
        if ((aggregation = aggregationToParse) instanceof NumericMetricsAggregation.SingleValue) {
            result = ((NumericMetricsAggregation.SingleValue)aggregation).value();
        } else if (aggregation instanceof InternalTDigestPercentiles && (percentile = ((InternalTDigestPercentiles)aggregation).iterator()).hasNext()) {
            result = ((Percentile)percentile.next()).getValue();
        }
        return Optional.ofNullable(result).orElseThrow(() -> new EndRunException("Failed to parse aggregation " + String.valueOf(aggregation), true).countedInStats(false));
    }

    protected Optional<double[]> parseBucket(MultiBucketsAggregation.Bucket bucket, List<String> featureIds) {
        return this.parseAggregations(Optional.ofNullable(bucket).map(b -> b.getAggregations()), featureIds);
    }

    protected Optional<double[]> parseAggregations(Optional<Aggregations> aggregations, List<String> featureIds) {
        return aggregations.map(aggs -> aggs.asMap()).map(map -> featureIds.stream().mapToDouble(id -> Optional.ofNullable((Aggregation)map.get(id)).map(this::parseAggregation).orElse(Double.NaN)).toArray()).filter(result -> Arrays.stream(result).noneMatch(d -> Double.isNaN(d) || Double.isInfinite(d)));
    }

    protected void updateSourceAfterKey(Map<String, Object> afterKey, SearchSourceBuilder search) {
        AggregationBuilder aggBuilder = (AggregationBuilder)search.aggregations().getAggregatorFactories().iterator().next();
        if (!(aggBuilder instanceof CompositeAggregationBuilder)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Invalid client request; expected a composite builder but instead got {}", aggBuilder));
        }
        CompositeAggregationBuilder comp = (CompositeAggregationBuilder)aggBuilder;
        comp.aggregateAfter(afterKey);
    }
}

