/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport.handler;

import java.util.Iterator;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.bulk.BackoffPolicy;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.ad.common.exception.AnomalyDetectionException;
import org.opensearch.ad.common.exception.EndRunException;
import org.opensearch.ad.constant.CommonErrorMessages;
import org.opensearch.ad.indices.AnomalyDetectionIndices;
import org.opensearch.ad.settings.AnomalyDetectorSettings;
import org.opensearch.ad.util.BulkUtil;
import org.opensearch.ad.util.ClientUtil;
import org.opensearch.ad.util.IndexUtils;
import org.opensearch.ad.util.RestHandlerUtils;
import org.opensearch.client.Client;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.concurrency.OpenSearchRejectedExecutionException;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.threadpool.ThreadPool;

public class AnomalyIndexHandler<T extends ToXContentObject> {
    private static final Logger LOG = LogManager.getLogger(AnomalyIndexHandler.class);
    static final String FAIL_TO_SAVE_ERR_MSG = "Fail to save %s: ";
    static final String SUCCESS_SAVING_MSG = "Succeed in saving %s";
    static final String CANNOT_SAVE_ERR_MSG = "Cannot save %s due to write block.";
    static final String RETRY_SAVING_ERR_MSG = "Retry in saving %s: ";
    protected final Client client;
    protected final ThreadPool threadPool;
    protected final BackoffPolicy savingBackoffPolicy;
    protected final String indexName;
    protected final AnomalyDetectionIndices anomalyDetectionIndices;
    protected boolean fixedDoc;
    protected final ClientUtil clientUtil;
    protected final IndexUtils indexUtils;
    protected final ClusterService clusterService;

    public AnomalyIndexHandler(Client client, Settings settings, ThreadPool threadPool, String indexName, AnomalyDetectionIndices anomalyDetectionIndices, ClientUtil clientUtil, IndexUtils indexUtils, ClusterService clusterService) {
        this.client = client;
        this.threadPool = threadPool;
        this.savingBackoffPolicy = BackoffPolicy.exponentialBackoff((TimeValue)((TimeValue)AnomalyDetectorSettings.BACKOFF_INITIAL_DELAY.get(settings)), (int)((Integer)AnomalyDetectorSettings.MAX_RETRY_FOR_BACKOFF.get(settings)));
        this.indexName = indexName;
        this.anomalyDetectionIndices = anomalyDetectionIndices;
        this.fixedDoc = false;
        this.clientUtil = clientUtil;
        this.indexUtils = indexUtils;
        this.clusterService = clusterService;
    }

    public void setFixedDoc(boolean fixedDoc) {
        this.fixedDoc = fixedDoc;
    }

    public void index(T toSave, String detectorId, String customIndexName) {
        if (this.indexUtils.checkIndicesBlocked(this.clusterService.state(), ClusterBlockLevel.WRITE, this.indexName)) {
            LOG.warn(String.format(Locale.ROOT, CANNOT_SAVE_ERR_MSG, detectorId));
            return;
        }
        try {
            if (customIndexName != null) {
                if (!this.anomalyDetectionIndices.doesIndexExist(customIndexName)) {
                    throw new EndRunException(detectorId, CommonErrorMessages.CAN_NOT_FIND_RESULT_INDEX + customIndexName, true);
                }
                if (!this.anomalyDetectionIndices.isValidResultIndexMapping(customIndexName)) {
                    throw new EndRunException(detectorId, "wrong index mapping of custom AD result index", true);
                }
                this.save(toSave, detectorId, customIndexName);
                return;
            }
            if (!this.anomalyDetectionIndices.doesDefaultAnomalyResultIndexExist()) {
                this.anomalyDetectionIndices.initDefaultAnomalyResultIndexDirectly((ActionListener<CreateIndexResponse>)ActionListener.wrap(initResponse -> this.onCreateIndexResponse((CreateIndexResponse)initResponse, toSave, detectorId), exception -> {
                    if (!(ExceptionsHelper.unwrapCause((Throwable)exception) instanceof ResourceAlreadyExistsException)) {
                        throw new AnomalyDetectionException(detectorId, String.format(Locale.ROOT, "Unexpected error creating index %s", this.indexName), (Throwable)exception);
                    }
                    this.save(toSave, detectorId);
                }));
            } else {
                this.save(toSave, detectorId);
            }
        }
        catch (Exception e) {
            throw new AnomalyDetectionException(detectorId, String.format(Locale.ROOT, "Error in saving %s for detector %s", this.indexName, detectorId), e);
        }
    }

    private void onCreateIndexResponse(CreateIndexResponse response, T toSave, String detectorId) {
        if (!response.isAcknowledged()) {
            throw new AnomalyDetectionException(detectorId, String.format(Locale.ROOT, "Creating %s with mappings call not acknowledged.", this.indexName));
        }
        this.save(toSave, detectorId);
    }

    protected void save(T toSave, String detectorId) {
        this.save(toSave, detectorId, this.indexName);
    }

    protected void save(T toSave, String detectorId, String indexName) {
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            IndexRequest indexRequest = new IndexRequest(indexName).source(toSave.toXContent(builder, (ToXContent.Params)RestHandlerUtils.XCONTENT_WITH_TYPE));
            if (this.fixedDoc) {
                indexRequest.id(detectorId);
            }
            this.saveIteration(indexRequest, detectorId, this.savingBackoffPolicy.iterator());
        }
        catch (Exception e) {
            LOG.error(String.format(Locale.ROOT, "Failed to save %s", indexName), (Throwable)e);
            throw new AnomalyDetectionException(detectorId, String.format(Locale.ROOT, "Cannot save %s", indexName));
        }
    }

    void saveIteration(IndexRequest indexRequest, String detectorId, Iterator<TimeValue> backoff) {
        this.clientUtil.asyncRequest(indexRequest, (arg_0, arg_1) -> ((Client)this.client).index(arg_0, arg_1), ActionListener.wrap(response -> LOG.debug(String.format(Locale.ROOT, SUCCESS_SAVING_MSG, detectorId)), exception -> {
            Throwable cause = ExceptionsHelper.unwrapCause((Throwable)exception);
            if (!(cause instanceof OpenSearchRejectedExecutionException) || !backoff.hasNext()) {
                LOG.error(String.format(Locale.ROOT, FAIL_TO_SAVE_ERR_MSG, detectorId), cause);
            } else {
                TimeValue nextDelay = (TimeValue)backoff.next();
                LOG.warn(String.format(Locale.ROOT, RETRY_SAVING_ERR_MSG, detectorId), cause);
                this.threadPool.schedule(() -> this.saveIteration(BulkUtil.cloneIndexRequest(indexRequest), detectorId, backoff), nextDelay, "same");
            }
        }));
    }
}

