/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public enum ModelAccessMode {
    PUBLIC("public"),
    PRIVATE("private"),
    RESTRICTED("restricted");

    private String value;
    private static final Map<String, ModelAccessMode> cache;

    private ModelAccessMode(String value) {
        this.value = value;
    }

    public static ModelAccessMode from(String value) {
        try {
            return cache.get(value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Wrong access value");
        }
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    static {
        cache = new HashMap<String, ModelAccessMode>();
        for (ModelAccessMode modelAccessMode : ModelAccessMode.values()) {
            cache.put(modelAccessMode.value, modelAccessMode);
        }
    }
}

