/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.authuser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.opensearch.client.Response;
import org.opensearch.common.Nullable;
import org.opensearch.common.Strings;
import org.opensearch.common.inject.internal.ToStringBuilder;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public final class User
implements Writeable,
ToXContent {
    public static final String NAME_FIELD = "name";
    public static final String BACKEND_ROLES_FIELD = "backend_roles";
    public static final String ROLES_FIELD = "roles";
    public static final String CUSTOM_ATTRIBUTE_NAMES_FIELD = "custom_attribute_names";
    public static final String REQUESTED_TENANT_FIELD = "user_requested_tenant";
    private final String name;
    private final List<String> backendRoles;
    private final List<String> roles;
    private final List<String> customAttNames;
    @Nullable
    private final String requestedTenant;

    public User() {
        this.name = "";
        this.backendRoles = new ArrayList<String>();
        this.roles = new ArrayList<String>();
        this.customAttNames = new ArrayList<String>();
        this.requestedTenant = null;
    }

    public User(String name, List<String> backendRoles, List<String> roles, List<String> customAttNames) {
        this.name = name;
        this.backendRoles = backendRoles;
        this.roles = roles;
        this.customAttNames = customAttNames;
        this.requestedTenant = null;
    }

    public User(String name, List<String> backendRoles, List<String> roles, List<String> customAttNames, @Nullable String requestedTenant) {
        this.name = name;
        this.backendRoles = backendRoles;
        this.roles = roles;
        this.customAttNames = customAttNames;
        this.requestedTenant = requestedTenant;
    }

    public User(Response response) throws IOException {
        this(EntityUtils.toString((HttpEntity)response.getEntity()));
    }

    public User(String json) {
        if (Strings.isNullOrEmpty((String)json)) {
            throw new IllegalArgumentException("Response json cannot be null");
        }
        Map mapValue = XContentHelper.convertToMap((XContent)JsonXContent.jsonXContent, (String)json, (boolean)false);
        this.name = (String)mapValue.get("user_name");
        this.backendRoles = (List)mapValue.get(BACKEND_ROLES_FIELD);
        this.roles = (List)mapValue.get(ROLES_FIELD);
        this.customAttNames = (List)mapValue.get(CUSTOM_ATTRIBUTE_NAMES_FIELD);
        this.requestedTenant = mapValue.getOrDefault(REQUESTED_TENANT_FIELD, null);
    }

    public User(StreamInput in) throws IOException {
        this.name = in.readString();
        this.backendRoles = in.readStringList();
        this.roles = in.readStringList();
        this.customAttNames = in.readStringList();
        this.requestedTenant = in.readOptionalString();
    }

    public static User parse(XContentParser parser) throws IOException {
        String name = "";
        ArrayList<String> backendRoles = new ArrayList<String>();
        ArrayList<String> roles = new ArrayList<String>();
        ArrayList<String> customAttNames = new ArrayList<String>();
        String requestedTenant = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "name": {
                    name = parser.text();
                    break;
                }
                case "backend_roles": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        backendRoles.add(parser.text());
                    }
                    break;
                }
                case "roles": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        roles.add(parser.text());
                    }
                    break;
                }
                case "custom_attribute_names": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        customAttNames.add(parser.text());
                    }
                    break;
                }
                case "user_requested_tenant": {
                    requestedTenant = parser.textOrNull();
                    break;
                }
            }
        }
        return new User(name, backendRoles, roles, customAttNames, requestedTenant);
    }

    public static User parse(String userString) {
        if (Strings.isNullOrEmpty((String)userString)) {
            return null;
        }
        String[] strs = userString.split("\\|");
        if (strs.length == 0 || Strings.isNullOrEmpty((String)strs[0])) {
            return null;
        }
        String userName = strs[0].trim();
        ArrayList<String> backendRoles = new ArrayList<String>();
        ArrayList<String> roles = new ArrayList<String>();
        String requestedTenant = null;
        if (strs.length > 1 && !Strings.isNullOrEmpty((String)strs[1])) {
            backendRoles.addAll(Arrays.asList(strs[1].split(",")));
        }
        if (strs.length > 2 && !Strings.isNullOrEmpty((String)strs[2])) {
            roles.addAll(Arrays.asList(strs[2].split(",")));
        }
        if (strs.length > 3 && !Strings.isNullOrEmpty((String)strs[3])) {
            requestedTenant = strs[3].trim();
        }
        return new User(userName, backendRoles, roles, Arrays.asList(new String[0]), requestedTenant);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field(NAME_FIELD, this.name).field(BACKEND_ROLES_FIELD, this.backendRoles).field(ROLES_FIELD, this.roles).field(CUSTOM_ATTRIBUTE_NAMES_FIELD, this.customAttNames).field(REQUESTED_TENANT_FIELD, this.requestedTenant);
        return builder.endObject();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeStringCollection(this.backendRoles);
        out.writeStringCollection(this.roles);
        out.writeStringCollection(this.customAttNames);
        out.writeOptionalString(this.requestedTenant);
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this.getClass());
        builder.add(NAME_FIELD, (Object)this.name);
        builder.add(BACKEND_ROLES_FIELD, this.backendRoles);
        builder.add(ROLES_FIELD, this.roles);
        builder.add(CUSTOM_ATTRIBUTE_NAMES_FIELD, this.customAttNames);
        builder.add(REQUESTED_TENANT_FIELD, (Object)this.requestedTenant);
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof User)) {
            return false;
        }
        User that = (User)obj;
        return this.name.equals(that.name) && this.getBackendRoles().equals(that.backendRoles) && this.getRoles().equals(that.roles) && this.getCustomAttNames().equals(that.customAttNames) && Objects.equals(this.requestedTenant, that.requestedTenant);
    }

    public String getName() {
        return this.name;
    }

    public List<String> getBackendRoles() {
        return this.backendRoles;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public List<String> getCustomAttNames() {
        return this.customAttNames;
    }

    @Nullable
    public String getRequestedTenant() {
        return this.requestedTenant;
    }
}

