/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.alerting.model;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.validator.routines.UrlValidator;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.commons.alerting.model.ClusterMetricsInputKt;
import org.opensearch.commons.alerting.model.Input;
import org.opensearch.core.ParseField;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 82\u00020\u0001:\u000278B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\tJ\t\u0010\u001a\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0006H\u00c6\u0003J\b\u0010\u001d\u001a\u00020\u000fH\u0002J'\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u00d6\u0003J\u0010\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u0006H\u0002J\t\u0010%\u001a\u00020&H\u00d6\u0001J\b\u0010'\u001a\u00020\u0006H\u0016J\b\u0010(\u001a\u00020)H\u0002J\u0006\u0010*\u001a\u00020\u0006J\b\u0010+\u001a\u00020\u000fH\u0002J\t\u0010,\u001a\u00020\u0006H\u00d6\u0001J\u0018\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.2\u0006\u00100\u001a\u000201H\u0016J\b\u00102\u001a\u00020 H\u0002J\b\u00103\u001a\u00020 H\u0002J\u0010\u00104\u001a\u00020)2\u0006\u00105\u001a\u000206H\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0007\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0013\"\u0004\b\u0017\u0010\u0015R\u001a\u0010\b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0013\"\u0004\b\u0019\u0010\u0015\u00a8\u00069"}, d2={"Lorg/opensearch/commons/alerting/model/ClusterMetricsInput;", "Lorg/opensearch/commons/alerting/model/Input;", "sin", "Lorg/opensearch/common/io/stream/StreamInput;", "(Lorg/opensearch/common/io/stream/StreamInput;)V", "path", "", "pathParams", "url", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "clusterMetricType", "Lorg/opensearch/commons/alerting/model/ClusterMetricsInput$ClusterMetricType;", "getClusterMetricType", "()Lorg/opensearch/commons/alerting/model/ClusterMetricsInput$ClusterMetricType;", "constructedUri", "Ljava/net/URI;", "getConstructedUri", "()Ljava/net/URI;", "getPath", "()Ljava/lang/String;", "setPath", "(Ljava/lang/String;)V", "getPathParams", "setPathParams", "getUrl", "setUrl", "component1", "component2", "component3", "constructUrlFromInputs", "copy", "equals", "", "other", "", "findApiType", "uriPath", "hashCode", "", "name", "parseEmptyFields", "", "parsePathParams", "toConstructedUri", "toString", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "validateFields", "validateFieldsNotEmpty", "writeTo", "out", "Lorg/opensearch/common/io/stream/StreamOutput;", "ClusterMetricType", "Companion", "common-utils"})
public final class ClusterMetricsInput
implements Input {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String path;
    @NotNull
    private String pathParams;
    @NotNull
    private String url;
    @NotNull
    private final ClusterMetricType clusterMetricType;
    @NotNull
    private final URI constructedUri;
    @NotNull
    public static final String SUPPORTED_SCHEME = "http";
    @NotNull
    public static final String SUPPORTED_HOST = "localhost";
    public static final int SUPPORTED_PORT = 9200;
    @NotNull
    public static final String API_TYPE_FIELD = "api_type";
    @NotNull
    public static final String PATH_FIELD = "path";
    @NotNull
    public static final String PATH_PARAMS_FIELD = "path_params";
    @NotNull
    public static final String URL_FIELD = "url";
    @NotNull
    public static final String URI_FIELD = "uri";
    @NotNull
    private static final NamedXContentRegistry.Entry XCONTENT_REGISTRY = new NamedXContentRegistry.Entry(Input.class, new ParseField("uri", new String[0]), ClusterMetricsInput::XCONTENT_REGISTRY$lambda-8);

    public ClusterMetricsInput(@NotNull String path, @NotNull String pathParams, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)path, (String)PATH_FIELD);
        Intrinsics.checkNotNullParameter((Object)pathParams, (String)"pathParams");
        Intrinsics.checkNotNullParameter((Object)url, (String)URL_FIELD);
        this.path = path;
        this.pathParams = pathParams;
        this.url = url;
        if (!this.validateFields()) {
            boolean bl = false;
            String string = "The uri.api_type field, uri.path field, or uri.uri field must be defined.";
            throw new IllegalArgumentException(string.toString());
        }
        Object object = new String[]{SUPPORTED_SCHEME, "https"};
        UrlValidator urlValidator = new UrlValidator((String[])object, 8L);
        this.constructedUri = this.toConstructedUri();
        if (!urlValidator.isValid(this.constructedUri.toString())) {
            boolean $i$a$-require-ClusterMetricsInput$62 = false;
            String $i$a$-require-ClusterMetricsInput$62 = "Invalid URI constructed from the path and path_params inputs, or the url input.";
            throw new IllegalArgumentException($i$a$-require-ClusterMetricsInput$62.toString());
        }
        if (((CharSequence)this.url).length() > 0 && this.validateFieldsNotEmpty() && !Intrinsics.areEqual((Object)this.constructedUri, (Object)this.constructUrlFromInputs())) {
            boolean $i$a$-require-ClusterMetricsInput$72 = false;
            String $i$a$-require-ClusterMetricsInput$72 = "The provided URL and URI fields form different URLs.";
            throw new IllegalArgumentException($i$a$-require-ClusterMetricsInput$72.toString());
        }
        object = this.constructedUri.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"constructedUri.host");
        String $i$a$-require-ClusterMetricsInput$72 = ((String)object).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)$i$a$-require-ClusterMetricsInput$72, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        if (!Intrinsics.areEqual((Object)$i$a$-require-ClusterMetricsInput$72, (Object)SUPPORTED_HOST)) {
            boolean $i$a$-require-ClusterMetricsInput$82 = false;
            String $i$a$-require-ClusterMetricsInput$82 = "Only host 'localhost' is supported.";
            throw new IllegalArgumentException($i$a$-require-ClusterMetricsInput$82.toString());
        }
        if (!(this.constructedUri.getPort() == 9200)) {
            boolean bl = false;
            String string = "Only port '9200' is supported.";
            throw new IllegalArgumentException(string.toString());
        }
        object = this.constructedUri.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"constructedUri.path");
        this.clusterMetricType = this.findApiType((String)object);
        this.parseEmptyFields();
    }

    public /* synthetic */ ClusterMetricsInput(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        this(string, string2, string3);
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    public final void setPath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.path = string;
    }

    @NotNull
    public final String getPathParams() {
        return this.pathParams;
    }

    public final void setPathParams(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.pathParams = string;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    public final void setUrl(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.url = string;
    }

    @NotNull
    public final ClusterMetricType getClusterMetricType() {
        return this.clusterMetricType;
    }

    @NotNull
    public final URI getConstructedUri() {
        return this.constructedUri;
    }

    public ClusterMetricsInput(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        String string = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sin.readString()");
        String string2 = string;
        string = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sin.readString()");
        String string3 = string;
        string = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sin.readString()");
        this(string2, string3, string);
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        XContentBuilder xContentBuilder = builder.startObject().startObject(URI_FIELD).field(API_TYPE_FIELD, (Object)this.clusterMetricType).field(PATH_FIELD, this.path).field(PATH_PARAMS_FIELD, this.pathParams).field(URL_FIELD, this.url).endObject().endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"builder.startObject()\n  \u2026\n            .endObject()");
        return xContentBuilder;
    }

    @Override
    @NotNull
    public String name() {
        return URI_FIELD;
    }

    public void writeTo(@NotNull StreamOutput out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.clusterMetricType.toString());
        out.writeString(this.path);
        out.writeString(this.pathParams);
        out.writeString(this.url);
    }

    private final URI toConstructedUri() {
        URI uRI;
        if (((CharSequence)this.url).length() == 0) {
            uRI = this.constructUrlFromInputs();
        } else {
            URI uRI2 = new URIBuilder(this.url).build();
            Intrinsics.checkNotNullExpressionValue((Object)uRI2, (String)"{\n            URIBuilder(url).build()\n        }");
            uRI = uRI2;
        }
        return uRI;
    }

    @NotNull
    public final String parsePathParams() {
        Object prependPath;
        String path = this.constructedUri.getPath();
        ClusterMetricType apiType = this.clusterMetricType;
        String pathParams = null;
        if (((CharSequence)this.pathParams).length() > 0) {
            pathParams = this.pathParams;
        } else {
            prependPath = apiType.getSupportsPathParams() ? apiType.getPrependPath() : apiType.getDefaultPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)PATH_FIELD);
            pathParams = StringsKt.removePrefix((String)path, (CharSequence)((CharSequence)prependPath));
            pathParams = StringsKt.removeSuffix((String)pathParams, (CharSequence)apiType.getAppendPath());
        }
        if (((CharSequence)pathParams).length() > 0) {
            prependPath = new char[1];
            prependPath[0] = 47;
            pathParams = StringsKt.trim((String)pathParams, (char[])prependPath);
            Character[] $this$forEach$iv = ClusterMetricsInputKt.getILLEGAL_PATH_PARAMETER_CHARACTERS();
            boolean $i$f$forEach = false;
            for (Character element$iv : $this$forEach$iv) {
                char character = element$iv.charValue();
                boolean bl = false;
                if (!StringsKt.contains$default((CharSequence)pathParams, (char)character, (boolean)false, (int)2, null)) continue;
                throw new IllegalArgumentException("The provided path parameters contain invalid characters or spaces. Please omit: " + ArraysKt.joinToString$default((Object[])ClusterMetricsInputKt.getILLEGAL_PATH_PARAMETER_CHARACTERS(), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
            }
        }
        if (apiType.getRequiresPathParams() && ((CharSequence)pathParams).length() == 0) {
            throw new IllegalArgumentException("The API requires path parameters.");
        }
        if (!apiType.getSupportsPathParams() && ((CharSequence)pathParams).length() > 0) {
            throw new IllegalArgumentException("The API does not use path parameters.");
        }
        return pathParams;
    }

    /*
     * WARNING - void declaration
     */
    private final ClusterMetricType findApiType(String uriPath) {
        void $this$filterTo$iv$iv;
        ClusterMetricType apiType = null;
        apiType = ClusterMetricType.BLANK;
        ClusterMetricType[] $this$filter$iv = ClusterMetricType.values();
        boolean $i$f$filter = false;
        ClusterMetricType[] clusterMetricTypeArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            void option = element$iv$iv;
            boolean bl = false;
            if (!(option != ClusterMetricType.BLANK)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ClusterMetricType option = (ClusterMetricType)((Object)element$iv);
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)uriPath, (String)option.getPrependPath(), (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)uriPath, (String)option.getDefaultPath(), (boolean)false, (int)2, null)) continue;
            apiType = option;
        }
        if (apiType.isBlank()) {
            throw new IllegalArgumentException("The API could not be determined from the provided URI.");
        }
        return apiType;
    }

    private final URI constructUrlFromInputs() {
        URIBuilder uriBuilder = new URIBuilder().setScheme(SUPPORTED_SCHEME).setHost(SUPPORTED_HOST).setPort(9200).setPath(this.path + this.pathParams);
        URI uRI = uriBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"uriBuilder.build()");
        return uRI;
    }

    private final void parseEmptyFields() {
        if (((CharSequence)this.pathParams).length() == 0) {
            this.pathParams = this.parsePathParams();
        }
        if (((CharSequence)this.path).length() == 0) {
            this.path = ((CharSequence)this.pathParams).length() == 0 ? this.clusterMetricType.getDefaultPath() : this.clusterMetricType.getPrependPath();
        }
        if (((CharSequence)this.url).length() == 0) {
            String string = this.constructedUri.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"constructedUri.toString()");
            this.url = string;
        }
    }

    private final boolean validateFields() {
        return ((CharSequence)this.url).length() > 0 || this.validateFieldsNotEmpty();
    }

    private final boolean validateFieldsNotEmpty() {
        return ((CharSequence)this.path).length() > 0;
    }

    @NotNull
    public final String component1() {
        return this.path;
    }

    @NotNull
    public final String component2() {
        return this.pathParams;
    }

    @NotNull
    public final String component3() {
        return this.url;
    }

    @NotNull
    public final ClusterMetricsInput copy(@NotNull String path, @NotNull String pathParams, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)path, (String)PATH_FIELD);
        Intrinsics.checkNotNullParameter((Object)pathParams, (String)"pathParams");
        Intrinsics.checkNotNullParameter((Object)url, (String)URL_FIELD);
        return new ClusterMetricsInput(path, pathParams, url);
    }

    public static /* synthetic */ ClusterMetricsInput copy$default(ClusterMetricsInput clusterMetricsInput, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = clusterMetricsInput.path;
        }
        if ((n & 2) != 0) {
            string2 = clusterMetricsInput.pathParams;
        }
        if ((n & 4) != 0) {
            string3 = clusterMetricsInput.url;
        }
        return clusterMetricsInput.copy(string, string2, string3);
    }

    @NotNull
    public String toString() {
        return "ClusterMetricsInput(path=" + this.path + ", pathParams=" + this.pathParams + ", url=" + this.url + ")";
    }

    public int hashCode() {
        int result = this.path.hashCode();
        result = result * 31 + this.pathParams.hashCode();
        result = result * 31 + this.url.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ClusterMetricsInput)) {
            return false;
        }
        ClusterMetricsInput clusterMetricsInput = (ClusterMetricsInput)other;
        if (!Intrinsics.areEqual((Object)this.path, (Object)clusterMetricsInput.path)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.pathParams, (Object)clusterMetricsInput.pathParams)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.url, (Object)clusterMetricsInput.url);
    }

    private static final ClusterMetricsInput XCONTENT_REGISTRY$lambda-8(XContentParser it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return Companion.parseInner(it);
    }

    @JvmStatic
    @NotNull
    public static final ClusterMetricsInput parseInner(@NotNull XContentParser xcp) throws IOException {
        return Companion.parseInner(xcp);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lorg/opensearch/commons/alerting/model/ClusterMetricsInput$Companion;", "", "()V", "API_TYPE_FIELD", "", "PATH_FIELD", "PATH_PARAMS_FIELD", "SUPPORTED_HOST", "SUPPORTED_PORT", "", "SUPPORTED_SCHEME", "URI_FIELD", "URL_FIELD", "XCONTENT_REGISTRY", "Lorg/opensearch/core/xcontent/NamedXContentRegistry$Entry;", "getXCONTENT_REGISTRY", "()Lorg/opensearch/core/xcontent/NamedXContentRegistry$Entry;", "parseInner", "Lorg/opensearch/commons/alerting/model/ClusterMetricsInput;", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "common-utils"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NamedXContentRegistry.Entry getXCONTENT_REGISTRY() {
            return XCONTENT_REGISTRY;
        }

        @JvmStatic
        @NotNull
        public final ClusterMetricsInput parseInner(@NotNull XContentParser xcp) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            String path = "";
            String pathParams = "";
            String url = "";
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = xcp.currentName();
                xcp.nextToken();
                String string = fieldName;
                if (string == null) continue;
                int n = -1;
                switch (string.hashCode()) {
                    case 3433509: {
                        if (string.equals(ClusterMetricsInput.PATH_FIELD)) {
                            n = 1;
                        }
                        break;
                    }
                    case 2088341216: {
                        if (string.equals(ClusterMetricsInput.PATH_PARAMS_FIELD)) {
                            n = 2;
                        }
                        break;
                    }
                    case 116079: {
                        if (string.equals(ClusterMetricsInput.URL_FIELD)) {
                            n = 3;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 1: {
                        String string2 = xcp.text();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"xcp.text()");
                        path = string2;
                        break;
                    }
                    case 2: {
                        String string2 = xcp.text();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"xcp.text()");
                        pathParams = string2;
                        break;
                    }
                    case 3: {
                        String string2 = xcp.text();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"xcp.text()");
                        url = string2;
                    }
                }
            }
            return new ClusterMetricsInput(path, pathParams, url);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0014\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B/\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0011\u001a\u00020\u0007R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fj\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001a\u00a8\u0006\u001b"}, d2={"Lorg/opensearch/commons/alerting/model/ClusterMetricsInput$ClusterMetricType;", "", "defaultPath", "", "prependPath", "appendPath", "supportsPathParams", "", "requiresPathParams", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;ZZ)V", "getAppendPath", "()Ljava/lang/String;", "getDefaultPath", "getPrependPath", "getRequiresPathParams", "()Z", "getSupportsPathParams", "isBlank", "BLANK", "CAT_PENDING_TASKS", "CAT_RECOVERY", "CAT_SNAPSHOTS", "CAT_TASKS", "CLUSTER_HEALTH", "CLUSTER_SETTINGS", "CLUSTER_STATS", "NODES_STATS", "common-utils"})
    public static final class ClusterMetricType
    extends Enum<ClusterMetricType> {
        @NotNull
        private final String defaultPath;
        @NotNull
        private final String prependPath;
        @NotNull
        private final String appendPath;
        private final boolean supportsPathParams;
        private final boolean requiresPathParams;
        public static final /* enum */ ClusterMetricType BLANK = new ClusterMetricType("", "", "", false, false);
        public static final /* enum */ ClusterMetricType CAT_PENDING_TASKS = new ClusterMetricType("/_cat/pending_tasks", "/_cat/pending_tasks", "", false, false);
        public static final /* enum */ ClusterMetricType CAT_RECOVERY = new ClusterMetricType("/_cat/recovery", "/_cat/recovery", "", true, false);
        public static final /* enum */ ClusterMetricType CAT_SNAPSHOTS = new ClusterMetricType("/_cat/snapshots", "/_cat/snapshots", "", true, true);
        public static final /* enum */ ClusterMetricType CAT_TASKS = new ClusterMetricType("/_cat/tasks", "/_cat/tasks", "", false, false);
        public static final /* enum */ ClusterMetricType CLUSTER_HEALTH = new ClusterMetricType("/_cluster/health", "/_cluster/health", "", true, false);
        public static final /* enum */ ClusterMetricType CLUSTER_SETTINGS = new ClusterMetricType("/_cluster/settings", "/_cluster/settings", "", false, false);
        public static final /* enum */ ClusterMetricType CLUSTER_STATS = new ClusterMetricType("/_cluster/stats", "/_cluster/stats", "", true, false);
        public static final /* enum */ ClusterMetricType NODES_STATS = new ClusterMetricType("/_nodes/stats", "/_nodes", "", false, false);
        private static final /* synthetic */ ClusterMetricType[] $VALUES;

        private ClusterMetricType(String defaultPath, String prependPath, String appendPath, boolean supportsPathParams, boolean requiresPathParams) {
            this.defaultPath = defaultPath;
            this.prependPath = prependPath;
            this.appendPath = appendPath;
            this.supportsPathParams = supportsPathParams;
            this.requiresPathParams = requiresPathParams;
        }

        @NotNull
        public final String getDefaultPath() {
            return this.defaultPath;
        }

        @NotNull
        public final String getPrependPath() {
            return this.prependPath;
        }

        @NotNull
        public final String getAppendPath() {
            return this.appendPath;
        }

        public final boolean getSupportsPathParams() {
            return this.supportsPathParams;
        }

        public final boolean getRequiresPathParams() {
            return this.requiresPathParams;
        }

        public final boolean isBlank() {
            return this == BLANK;
        }

        public static ClusterMetricType[] values() {
            return (ClusterMetricType[])$VALUES.clone();
        }

        public static ClusterMetricType valueOf(String value) {
            return Enum.valueOf(ClusterMetricType.class, value);
        }

        static {
            $VALUES = clusterMetricTypeArray = new ClusterMetricType[]{ClusterMetricType.BLANK, ClusterMetricType.CAT_PENDING_TASKS, ClusterMetricType.CAT_RECOVERY, ClusterMetricType.CAT_SNAPSHOTS, ClusterMetricType.CAT_TASKS, ClusterMetricType.CLUSTER_HEALTH, ClusterMetricType.CLUSTER_SETTINGS, ClusterMetricType.CLUSTER_STATS, ClusterMetricType.NODES_STATS};
        }
    }
}

