/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons;

import java.util.List;
import java.util.StringJoiner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.Strings;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;

public class InjectSecurity
implements AutoCloseable {
    private String id;
    private ThreadContext.StoredContext ctx = null;
    private ThreadContext threadContext;
    private Settings settings;
    private final Logger log = LogManager.getLogger(this.getClass());

    public InjectSecurity(String id, Settings settings, ThreadContext tc) {
        this.id = id;
        this.settings = settings;
        this.threadContext = tc;
        this.ctx = tc.newStoredContext(true);
        this.log.trace("{}, InjectSecurity constructor: {}", (Object)Thread.currentThread().getName(), (Object)id);
    }

    public void inject(String user, List<String> roles) {
        boolean injectUser = this.settings.getAsBoolean("plugins.security_use_injected_user_for_plugins", Boolean.valueOf(false));
        if (injectUser) {
            this.injectUser(user);
        } else {
            this.injectRoles(roles);
        }
    }

    public void injectUser(String user) {
        if (Strings.isNullOrEmpty((String)user)) {
            return;
        }
        if (this.threadContext.getTransient("injected_user") == null) {
            this.threadContext.putTransient("injected_user", (Object)user);
            this.log.debug("{}, InjectSecurity - inject roles: {}", (Object)Thread.currentThread().getName(), (Object)this.id);
        } else {
            this.log.error("{}, InjectSecurity - most likely thread context corruption : {}", (Object)Thread.currentThread().getName(), (Object)this.id);
        }
    }

    public void injectUserInfo(User user) {
        if (user == null) {
            return;
        }
        String userObjectAsString = (String)this.threadContext.getTransient("_opendistro_security_user_info");
        if (userObjectAsString != null) {
            this.log.error("{}, InjectSecurity - id: [{}] found existing user_info: {}", (Object)Thread.currentThread().getName(), (Object)this.id, (Object)userObjectAsString);
            return;
        }
        StringJoiner joiner = new StringJoiner("|");
        joiner.add(user.getName());
        joiner.add(String.join((CharSequence)",", user.getBackendRoles()));
        joiner.add(String.join((CharSequence)",", user.getRoles()));
        String requestedTenant = user.getRequestedTenant();
        if (!Strings.isNullOrEmpty((String)requestedTenant)) {
            joiner.add(requestedTenant);
        }
        this.threadContext.putTransient("_opendistro_security_user_info", (Object)joiner.toString());
    }

    public void injectRoles(List<String> roles) {
        if (roles == null || roles.size() == 0) {
            return;
        }
        String rolesStr = String.join((CharSequence)",", roles);
        String injectStr = "plugin|" + rolesStr;
        if (this.threadContext.getTransient("opendistro_security_injected_roles") == null) {
            this.threadContext.putTransient("opendistro_security_injected_roles", (Object)injectStr);
            this.log.debug("{}, InjectSecurity - inject roles: {}", (Object)Thread.currentThread().getName(), (Object)this.id);
        } else {
            this.log.error("{}, InjectSecurity- most likely thread context corruption : {}", (Object)Thread.currentThread().getName(), (Object)this.id);
        }
    }

    public boolean injectProperty(String property, Object value) {
        if (Strings.isNullOrEmpty((String)property) || value == null || this.threadContext.getTransient(property) != null) {
            this.log.debug("{}, InjectSecurity - cannot inject property: {}", (Object)Thread.currentThread().getName(), (Object)this.id);
            return false;
        }
        this.threadContext.putTransient(property, value);
        this.log.debug("{}, InjectSecurity - inject property: {}", (Object)Thread.currentThread().getName(), (Object)this.id);
        return true;
    }

    @Override
    public void close() {
        if (this.ctx != null) {
            this.ctx.close();
            this.log.trace("{}, InjectSecurity close : {}", (Object)Thread.currentThread().getName(), (Object)this.id);
        }
    }
}

