/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import com.fasterxml.jackson.core.JsonParseException;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.opensearch.common.Explicit;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.support.XContentMapValues;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.fielddata.FieldData;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.index.fielddata.IndexNumericFieldData;
import org.opensearch.index.fielddata.LeafNumericFieldData;
import org.opensearch.index.fielddata.NumericDoubleValues;
import org.opensearch.index.fielddata.ScriptDocValues;
import org.opensearch.index.fielddata.SortedBinaryDocValues;
import org.opensearch.index.fielddata.SortedNumericDoubleValues;
import org.opensearch.index.fielddata.plain.SortedNumericIndexFieldData;
import org.opensearch.index.mapper.DocValueFetcher;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.NumberFieldMapper;
import org.opensearch.index.mapper.ParametrizedFieldMapper;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.index.mapper.SimpleMappedFieldType;
import org.opensearch.index.mapper.SourceValueFetcher;
import org.opensearch.index.mapper.TextSearchInfo;
import org.opensearch.index.mapper.ValueFetcher;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.aggregations.support.ValuesSourceType;
import org.opensearch.search.lookup.SearchLookup;

public class ScaledFloatFieldMapper
extends ParametrizedFieldMapper {
    public static final String CONTENT_TYPE = "scaled_float";
    private static final Setting<Boolean> COERCE_SETTING = NumberFieldMapper.COERCE_SETTING;
    public static final ParametrizedFieldMapper.TypeParser PARSER = new ParametrizedFieldMapper.TypeParser((n, c) -> new Builder((String)n, c.getSettings()));
    private final Explicit<Boolean> ignoreMalformed;
    private final Explicit<Boolean> coerce;
    private final boolean indexed;
    private final boolean hasDocValues;
    private final boolean stored;
    private final Double nullValue;
    private final double scalingFactor;
    private final boolean ignoreMalformedByDefault;
    private final boolean coerceByDefault;

    private static ScaledFloatFieldMapper toType(FieldMapper in) {
        return (ScaledFloatFieldMapper)in;
    }

    private ScaledFloatFieldMapper(String simpleName, ScaledFloatFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Builder builder) {
        super(simpleName, (MappedFieldType)mappedFieldType, multiFields, copyTo);
        this.indexed = (Boolean)builder.indexed.getValue();
        this.hasDocValues = (Boolean)builder.hasDocValues.getValue();
        this.stored = (Boolean)builder.stored.getValue();
        this.scalingFactor = (Double)builder.scalingFactor.getValue();
        this.nullValue = (Double)builder.nullValue.getValue();
        this.ignoreMalformed = (Explicit)builder.ignoreMalformed.getValue();
        this.coerce = (Explicit)builder.coerce.getValue();
        this.ignoreMalformedByDefault = (Boolean)((Explicit)builder.ignoreMalformed.getDefaultValue()).value();
        this.coerceByDefault = (Boolean)((Explicit)builder.coerce.getDefaultValue()).value();
    }

    boolean coerce() {
        return (Boolean)this.coerce.value();
    }

    boolean ignoreMalformed() {
        return (Boolean)this.ignoreMalformed.value();
    }

    public ScaledFloatFieldType fieldType() {
        return (ScaledFloatFieldType)super.fieldType();
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.ignoreMalformedByDefault, this.coerceByDefault).init((FieldMapper)this);
    }

    protected ScaledFloatFieldMapper clone() {
        return (ScaledFloatFieldMapper)super.clone();
    }

    protected void parseCreateField(ParseContext context) throws IOException {
        double doubleValue;
        Object value;
        XContentParser parser = context.parser();
        Number numericValue = null;
        if (context.externalValueSet()) {
            value = context.externalValue();
        } else if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
            value = null;
        } else if (((Boolean)this.coerce.value()).booleanValue() && parser.currentToken() == XContentParser.Token.VALUE_STRING && parser.textLength() == 0) {
            value = null;
        } else {
            try {
                numericValue = ScaledFloatFieldMapper.parse(parser, (Boolean)this.coerce.value());
            }
            catch (JsonParseException | IllegalArgumentException e) {
                if (((Boolean)this.ignoreMalformed.value()).booleanValue()) {
                    return;
                }
                throw e;
            }
            value = numericValue;
        }
        if (value == null) {
            value = this.nullValue;
        }
        if (value == null) {
            return;
        }
        if (numericValue == null) {
            numericValue = ScaledFloatFieldMapper.parse(value);
        }
        if (!Double.isFinite(doubleValue = numericValue.doubleValue())) {
            if (((Boolean)this.ignoreMalformed.value()).booleanValue()) {
                return;
            }
            throw new IllegalArgumentException("[scaled_float] only supports finite values, but got [" + doubleValue + "]");
        }
        long scaledValue = Math.round(doubleValue * this.scalingFactor);
        List fields = NumberFieldMapper.NumberType.LONG.createFields(this.fieldType().name(), (Number)scaledValue, this.indexed, this.hasDocValues, this.stored);
        context.doc().addAll(fields);
        if (!this.hasDocValues && (this.indexed || this.stored)) {
            this.createFieldNamesField(context);
        }
    }

    static Double parse(Object value) {
        return ScaledFloatFieldMapper.objectToDouble(value);
    }

    private static Double parse(XContentParser parser, boolean coerce) throws IOException {
        return parser.doubleValue(coerce);
    }

    private static double objectToDouble(Object value) {
        double doubleValue = value instanceof Number ? ((Number)value).doubleValue() : (value instanceof BytesRef ? Double.parseDouble(((BytesRef)value).utf8ToString()) : Double.parseDouble(value.toString()));
        return doubleValue;
    }

    public static class Builder
    extends ParametrizedFieldMapper.Builder {
        private final ParametrizedFieldMapper.Parameter<Boolean> indexed = ParametrizedFieldMapper.Parameter.indexParam(m -> ScaledFloatFieldMapper.toType((FieldMapper)m).indexed, (boolean)true);
        private final ParametrizedFieldMapper.Parameter<Boolean> hasDocValues = ParametrizedFieldMapper.Parameter.docValuesParam(m -> ScaledFloatFieldMapper.toType((FieldMapper)m).hasDocValues, (boolean)true);
        private final ParametrizedFieldMapper.Parameter<Boolean> stored = ParametrizedFieldMapper.Parameter.storeParam(m -> ScaledFloatFieldMapper.toType((FieldMapper)m).stored, (boolean)false);
        private final ParametrizedFieldMapper.Parameter<Explicit<Boolean>> ignoreMalformed;
        private final ParametrizedFieldMapper.Parameter<Explicit<Boolean>> coerce;
        private final ParametrizedFieldMapper.Parameter<Double> scalingFactor = new ParametrizedFieldMapper.Parameter("scaling_factor", false, () -> null, (n, c, o) -> XContentMapValues.nodeDoubleValue((Object)o), m -> ScaledFloatFieldMapper.toType((FieldMapper)m).scalingFactor).setValidator(v -> {
            if (v == null) {
                throw new IllegalArgumentException("Field [scaling_factor] is required");
            }
            if (!Double.isFinite(v) || v <= 0.0) {
                throw new IllegalArgumentException("[scaling_factor] must be a positive number, got [" + v + "]");
            }
        });
        private final ParametrizedFieldMapper.Parameter<Double> nullValue = new ParametrizedFieldMapper.Parameter("null_value", false, () -> null, (n, c, o) -> o == null ? null : Double.valueOf(XContentMapValues.nodeDoubleValue((Object)o)), m -> ScaledFloatFieldMapper.toType((FieldMapper)m).nullValue).acceptsNull();
        private final ParametrizedFieldMapper.Parameter<Map<String, String>> meta = ParametrizedFieldMapper.Parameter.metaParam();

        public Builder(String name, Settings settings) {
            this(name, (Boolean)FieldMapper.IGNORE_MALFORMED_SETTING.get(settings), (Boolean)COERCE_SETTING.get(settings));
        }

        public Builder(String name, boolean ignoreMalformedByDefault, boolean coerceByDefault) {
            super(name);
            this.ignoreMalformed = ParametrizedFieldMapper.Parameter.explicitBoolParam((String)"ignore_malformed", (boolean)true, m -> ScaledFloatFieldMapper.toType((FieldMapper)m).ignoreMalformed, (boolean)ignoreMalformedByDefault);
            this.coerce = ParametrizedFieldMapper.Parameter.explicitBoolParam((String)"coerce", (boolean)true, m -> ScaledFloatFieldMapper.toType((FieldMapper)m).coerce, (boolean)coerceByDefault);
        }

        Builder scalingFactor(double scalingFactor) {
            this.scalingFactor.setValue((Object)scalingFactor);
            return this;
        }

        Builder nullValue(double nullValue) {
            this.nullValue.setValue((Object)nullValue);
            return this;
        }

        protected List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.indexed, this.hasDocValues, this.stored, this.ignoreMalformed, this.meta, this.scalingFactor, this.coerce, this.nullValue);
        }

        public ScaledFloatFieldMapper build(Mapper.BuilderContext context) {
            ScaledFloatFieldType type = new ScaledFloatFieldType(this.buildFullName(context), (Boolean)this.indexed.getValue(), (Boolean)this.stored.getValue(), (Boolean)this.hasDocValues.getValue(), (Map)this.meta.getValue(), (Double)this.scalingFactor.getValue(), (Double)this.nullValue.getValue());
            return new ScaledFloatFieldMapper(this.name, type, this.multiFieldsBuilder.build((Mapper.Builder)this, context), this.copyTo.build(), this);
        }
    }

    public static final class ScaledFloatFieldType
    extends SimpleMappedFieldType {
        private final double scalingFactor;
        private final Double nullValue;

        public ScaledFloatFieldType(String name, boolean indexed, boolean stored, boolean hasDocValues, Map<String, String> meta, double scalingFactor, Double nullValue) {
            super(name, indexed, stored, hasDocValues, TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
            this.scalingFactor = scalingFactor;
            this.nullValue = nullValue;
        }

        public ScaledFloatFieldType(String name, double scalingFactor) {
            this(name, true, false, true, Collections.emptyMap(), scalingFactor, null);
        }

        public double getScalingFactor() {
            return this.scalingFactor;
        }

        public String typeName() {
            return ScaledFloatFieldMapper.CONTENT_TYPE;
        }

        public Query termQuery(Object value, QueryShardContext context) {
            this.failIfNotIndexedAndNoDocValues();
            long scaledValue = Math.round(this.scale(value));
            Query query = NumberFieldMapper.NumberType.LONG.termQuery(this.name(), (Object)scaledValue, this.hasDocValues(), this.isSearchable());
            if (this.boost() != 1.0f) {
                query = new BoostQuery(query, this.boost());
            }
            return query;
        }

        public Query termsQuery(List<?> values, QueryShardContext context) {
            this.failIfNotIndexedAndNoDocValues();
            ArrayList<Long> scaledValues = new ArrayList<Long>(values.size());
            for (Object value : values) {
                long scaledValue = Math.round(this.scale(value));
                scaledValues.add(scaledValue);
            }
            Query query = NumberFieldMapper.NumberType.LONG.termsQuery(this.name(), Collections.unmodifiableList(scaledValues), this.hasDocValues(), this.isSearchable());
            if (this.boost() != 1.0f) {
                query = new BoostQuery(query, this.boost());
            }
            return query;
        }

        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, QueryShardContext context) {
            this.failIfNotIndexedAndNoDocValues();
            Long lo = null;
            if (lowerTerm != null) {
                double dValue = this.scale(lowerTerm);
                if (!includeLower) {
                    dValue = Math.nextUp(dValue);
                }
                lo = Math.round(Math.ceil(dValue));
            }
            Long hi = null;
            if (upperTerm != null) {
                double dValue = this.scale(upperTerm);
                if (!includeUpper) {
                    dValue = Math.nextDown(dValue);
                }
                hi = Math.round(Math.floor(dValue));
            }
            Query query = NumberFieldMapper.NumberType.LONG.rangeQuery(this.name(), (Object)lo, (Object)hi, true, true, this.hasDocValues(), this.isSearchable(), context);
            if (this.boost() != 1.0f) {
                query = new BoostQuery(query, this.boost());
            }
            return query;
        }

        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return (cache, breakerService) -> {
                SortedNumericIndexFieldData scaledValues = new SortedNumericIndexFieldData.Builder(this.name(), IndexNumericFieldData.NumericType.LONG).build(cache, breakerService);
                return new ScaledFloatIndexFieldData((IndexNumericFieldData)scaledValues, this.scalingFactor);
            };
        }

        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return new SourceValueFetcher(this.name(), context){

                protected Double parseSourceValue(Object value) {
                    double doubleValue;
                    if (value.equals("")) {
                        if (nullValue == null) {
                            return null;
                        }
                        doubleValue = nullValue;
                    } else {
                        doubleValue = ScaledFloatFieldMapper.objectToDouble(value);
                    }
                    double scalingFactor = this.getScalingFactor();
                    return (double)Math.round(doubleValue * scalingFactor) / scalingFactor;
                }
            };
        }

        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            return (double)((Number)value).longValue() / this.scalingFactor;
        }

        public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
            if (timeZone != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom time zones");
            }
            if (format == null) {
                return DocValueFormat.RAW;
            }
            return new DocValueFormat.Decimal(format);
        }

        private double scale(Object input) {
            return new BigDecimal(Double.toString(ScaledFloatFieldMapper.parse(input))).multiply(BigDecimal.valueOf(this.scalingFactor)).doubleValue();
        }
    }

    private static class ScaledFloatLeafFieldData
    implements LeafNumericFieldData {
        private final LeafNumericFieldData scaledFieldData;
        private final double scalingFactorInverse;

        ScaledFloatLeafFieldData(LeafNumericFieldData scaledFieldData, double scalingFactor) {
            this.scaledFieldData = scaledFieldData;
            this.scalingFactorInverse = 1.0 / scalingFactor;
        }

        public ScriptDocValues.Doubles getScriptValues() {
            return new ScriptDocValues.Doubles(this.getDoubleValues());
        }

        public SortedBinaryDocValues getBytesValues() {
            return FieldData.toString((SortedNumericDoubleValues)this.getDoubleValues());
        }

        public long ramBytesUsed() {
            return this.scaledFieldData.ramBytesUsed();
        }

        public void close() {
            this.scaledFieldData.close();
        }

        public SortedNumericDocValues getLongValues() {
            return FieldData.castToLong((SortedNumericDoubleValues)this.getDoubleValues());
        }

        public SortedNumericDoubleValues getDoubleValues() {
            final SortedNumericDocValues values = this.scaledFieldData.getLongValues();
            final NumericDocValues singleValues = DocValues.unwrapSingleton((SortedNumericDocValues)values);
            if (singleValues != null) {
                return FieldData.singleton((NumericDoubleValues)new NumericDoubleValues(){

                    public boolean advanceExact(int doc) throws IOException {
                        return singleValues.advanceExact(doc);
                    }

                    public double doubleValue() throws IOException {
                        return (double)singleValues.longValue() * scalingFactorInverse;
                    }
                });
            }
            return new SortedNumericDoubleValues(){

                public boolean advanceExact(int target) throws IOException {
                    return values.advanceExact(target);
                }

                public double nextValue() throws IOException {
                    return (double)values.nextValue() * scalingFactorInverse;
                }

                public int docValueCount() {
                    return values.docValueCount();
                }
            };
        }

        public DocValueFetcher.Leaf getLeafValueFetcher(final DocValueFormat format) {
            final SortedNumericDoubleValues values = this.getDoubleValues();
            return new DocValueFetcher.Leaf(){

                public boolean advanceExact(int docId) throws IOException {
                    return values.advanceExact(docId);
                }

                public int docValueCount() throws IOException {
                    return values.docValueCount();
                }

                public Object nextValue() throws IOException {
                    return format.format(values.nextValue());
                }
            };
        }
    }

    private static class ScaledFloatIndexFieldData
    extends IndexNumericFieldData {
        private final IndexNumericFieldData scaledFieldData;
        private final double scalingFactor;

        ScaledFloatIndexFieldData(IndexNumericFieldData scaledFieldData, double scalingFactor) {
            this.scaledFieldData = scaledFieldData;
            this.scalingFactor = scalingFactor;
        }

        public String getFieldName() {
            return this.scaledFieldData.getFieldName();
        }

        public ValuesSourceType getValuesSourceType() {
            return this.scaledFieldData.getValuesSourceType();
        }

        public LeafNumericFieldData load(LeafReaderContext context) {
            return new ScaledFloatLeafFieldData((LeafNumericFieldData)this.scaledFieldData.load(context), this.scalingFactor);
        }

        public LeafNumericFieldData loadDirect(LeafReaderContext context) throws Exception {
            return new ScaledFloatLeafFieldData((LeafNumericFieldData)this.scaledFieldData.loadDirect(context), this.scalingFactor);
        }

        protected boolean sortRequiresCustomComparator() {
            return true;
        }

        public IndexNumericFieldData.NumericType getNumericType() {
            return IndexNumericFieldData.NumericType.DOUBLE;
        }
    }
}

