/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.stats.upload;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.nodes.BaseNodesResponse;
import org.opensearch.cluster.ClusterName;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.geospatial.stats.upload.UploadStats;
import org.opensearch.geospatial.stats.upload.UploadStatsNodeResponse;
import org.opensearch.geospatial.stats.upload.UploadStatsService;

public class UploadStatsResponse
extends BaseNodesResponse<UploadStatsNodeResponse>
implements Writeable,
ToXContentObject {
    public UploadStatsResponse(StreamInput in) throws IOException {
        super(new ClusterName(in), in.readList(UploadStatsNodeResponse::new), in.readList(FailedNodeException::new));
    }

    public UploadStatsResponse(ClusterName clusterName, List<UploadStatsNodeResponse> nodes, List<FailedNodeException> failures) {
        super(clusterName, nodes, failures);
    }

    protected List<UploadStatsNodeResponse> readNodesFrom(StreamInput in) throws IOException {
        return in.readList(UploadStatsNodeResponse::new);
    }

    protected void writeNodesTo(StreamOutput out, List<UploadStatsNodeResponse> nodeResponses) throws IOException {
        out.writeList(nodeResponses);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Map<String, UploadStats> nodeIDStatsMap = this.getNodes().stream().collect(Collectors.toMap(response -> response.getNode().getId(), UploadStatsNodeResponse::getUploadStats));
        UploadStatsService uploadStatsService = new UploadStatsService(nodeIDStatsMap);
        return uploadStatsService.toXContent(builder, params);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        UploadStatsResponse otherResponse = (UploadStatsResponse)((Object)o);
        return Objects.equals(this.getNodes(), otherResponse.getNodes()) && Objects.equals(this.failures(), otherResponse.failures());
    }

    public int hashCode() {
        return Objects.hash(this.getNodes(), this.failures());
    }
}

