/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.index.mapper.xypoint;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.opensearch.OpenSearchParseException;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.geometry.Geometry;
import org.opensearch.geometry.Point;
import org.opensearch.geometry.ShapeType;
import org.opensearch.geometry.utils.GeometryValidator;
import org.opensearch.geometry.utils.StandardValidator;
import org.opensearch.geometry.utils.WellKnownText;
import org.opensearch.index.mapper.AbstractGeometryFieldMapper;
import org.opensearch.index.mapper.AbstractPointGeometryFieldMapper;

public class XYPoint
implements AbstractPointGeometryFieldMapper.ParsedPoint,
ToXContentFragment {
    private double x;
    private double y;
    private static final String POINT_PRIMITIVE = "point";
    private static final String X_PARAMETER = "x";
    private static final String Y_PARAMETER = "y";
    private static final String XY_POINT = "XY_POINT";

    public XYPoint reset(double x, double y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public void validate(String fieldName) {
    }

    public void normalize(String fieldName) {
    }

    public void resetCoords(double x, double y) {
        this.reset(x, y);
    }

    public Point asGeometry() {
        return new Point(this.getX(), this.getY());
    }

    public XYPoint resetFromString(String value, boolean ignoreZValue) {
        Objects.requireNonNull(value, "input string which needs to be parsed should not be null");
        if (value.toLowerCase(Locale.ROOT).contains(POINT_PRIMITIVE)) {
            return this.resetFromWKT(value, ignoreZValue);
        }
        return this.resetFromCoordinates(value, ignoreZValue);
    }

    public XYPoint resetFromCoordinates(String value, boolean ignoreZValue) {
        Objects.requireNonNull(value, "input string which needs to be parsed should not be null");
        String[] values = value.split(",");
        int numOfValues = values.length;
        if (numOfValues > 3) {
            throw new OpenSearchParseException("expected 2 or 3 coordinates, but found: [{}]", new Object[]{values.length});
        }
        if (numOfValues > 2) {
            XYPoint.assertZValue(ignoreZValue, Double.parseDouble(values[2].trim()));
        }
        double x = this.parseCoordinate(values[0], X_PARAMETER);
        double y = this.parseCoordinate(values[1], Y_PARAMETER);
        return this.reset(x, y);
    }

    private double parseCoordinate(String value, String parameter) {
        try {
            return Double.parseDouble(value.trim());
        }
        catch (NumberFormatException ex) {
            throw new OpenSearchParseException("[{}] must be a number", new Object[]{parameter, ex});
        }
    }

    private XYPoint resetFromWKT(String value, boolean ignoreZValue) {
        Geometry geometry;
        try {
            geometry = new WellKnownText(false, (GeometryValidator)new StandardValidator(ignoreZValue)).fromWKT(value);
        }
        catch (Exception e) {
            throw new OpenSearchParseException("Invalid WKT format, [{}]", new Object[]{value, e});
        }
        if (geometry.type() != ShapeType.POINT) {
            throw new OpenSearchParseException("[xy_point] supports only POINT among WKT primitives, but found [{}]", new Object[]{geometry.type()});
        }
        Point point = (Point)geometry;
        return this.reset(point.getX(), point.getY());
    }

    public static void assertZValue(boolean ignoreZValue, double zValue) {
        if (!ignoreZValue) {
            throw new OpenSearchParseException("Exception parsing coordinates: found Z value [{}] but [{}] parameter is [{}]", new Object[]{zValue, AbstractGeometryFieldMapper.Names.IGNORE_Z_VALUE, ignoreZValue});
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof XYPoint)) {
            return false;
        }
        XYPoint point = (XYPoint)obj;
        return point.x == this.x && point.y == this.y;
    }

    public int hashCode() {
        int result = Double.hashCode(this.x);
        result = 31 * result + Double.hashCode(this.y);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(XY_POINT);
        sb.append('(');
        sb.append(this.x);
        sb.append(",");
        sb.append(this.y);
        sb.append(')');
        return sb.toString();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field(X_PARAMETER, this.x).field(Y_PARAMETER, this.y).endObject();
    }

    public XYPoint(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public XYPoint() {
    }
}

