/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.processor;

import java.util.Map;
import org.opensearch.geospatial.geojson.Feature;
import org.opensearch.geospatial.geojson.FeatureFactory;
import org.opensearch.ingest.AbstractProcessor;
import org.opensearch.ingest.ConfigurationUtils;
import org.opensearch.ingest.IngestDocument;
import org.opensearch.ingest.Processor;

public class FeatureProcessor
extends AbstractProcessor {
    public static final String FIELD_KEY = "field";
    public static final String TYPE = "geojson-feature";
    private final String geoShapeField;

    public FeatureProcessor(String tag, String description, String geoShapeField) {
        super(tag, description);
        this.geoShapeField = geoShapeField;
    }

    public IngestDocument execute(IngestDocument ingestDocument) {
        Feature feature = FeatureFactory.create(ingestDocument.getSourceAndMetadata());
        ingestDocument.removeField("type");
        feature.getProperties().forEach((k, v) -> ingestDocument.setFieldValue(k, v));
        if (ingestDocument.hasField("properties")) {
            ingestDocument.removeField("properties");
        }
        ingestDocument.setFieldValue(this.geoShapeField, feature.getGeometry());
        ingestDocument.removeField("geometry");
        return ingestDocument;
    }

    public String getType() {
        return TYPE;
    }

    public static final class Factory
    implements Processor.Factory {
        public FeatureProcessor create(Map<String, Processor.Factory> registry, String processorTag, String description, Map<String, Object> config) {
            String geoShapeField = ConfigurationUtils.readStringProperty((String)FeatureProcessor.TYPE, (String)processorTag, config, (String)FeatureProcessor.FIELD_KEY);
            return new FeatureProcessor(processorTag, description, geoShapeField);
        }
    }
}

