/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.geojson;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.geospatial.GeospatialParser;

public final class FeatureCollection {
    public static final String TYPE = "FeatureCollection";
    public static final String FEATURES_KEY = "features";
    public static final String TYPE_KEY = "type";
    private final List<Map<String, Object>> features = new ArrayList<Map<String, Object>>();

    private FeatureCollection() {
    }

    public List<Map<String, Object>> getFeatures() {
        return this.features;
    }

    public void addFeature(Map<String, Object> featureMap) {
        Objects.requireNonNull(featureMap, "cannot add null to features");
        this.features.add(featureMap);
    }

    public static FeatureCollection create(Map<String, Object> input) {
        Objects.requireNonNull(input, "input cannot be null");
        Object geoJSONType = input.get(TYPE_KEY);
        if (geoJSONType == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        if (!TYPE.equalsIgnoreCase(geoJSONType.toString())) {
            throw new IllegalArgumentException("Unknown type [ " + geoJSONType + " ], expected type [ FeatureCollection ]");
        }
        return FeatureCollection.extract(input);
    }

    private static FeatureCollection extract(Map<String, Object> input) {
        FeatureCollection collection = new FeatureCollection();
        Object featureObject = input.get(FEATURES_KEY);
        if (featureObject == null) {
            return collection;
        }
        if (!(featureObject instanceof List)) {
            throw new IllegalArgumentException("features is not an instance of type List, but of type [ " + featureObject.getClass().getName() + " ]");
        }
        List featureArray = (List)featureObject;
        featureArray.stream().map(GeospatialParser::toStringObjectMap).forEach(collection::addFeature);
        return collection;
    }
}

