/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.discovery.ec2;

import com.amazonaws.util.EC2MetadataUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.SuppressForbidden;
import org.opensearch.common.network.NetworkService;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.discovery.ec2.SocketAccess;

class Ec2NameResolver
implements NetworkService.CustomNameResolver {
    private static final Logger logger = LogManager.getLogger(Ec2NameResolver.class);

    Ec2NameResolver() {
    }

    @SuppressForbidden(reason="We call getInputStream in doPrivileged and provide SocketPermission")
    public InetAddress[] resolve(Ec2HostnameType type) throws IOException {
        InetAddress[] inetAddressArray;
        InputStream in = null;
        String metadataUrl = EC2MetadataUtils.getHostAddressForEC2MetadataService() + "/latest/meta-data/" + type.ec2Name;
        try {
            URL url = new URL(metadataUrl);
            logger.debug("obtaining ec2 hostname from ec2 meta-data url {}", (Object)url);
            URLConnection urlConnection = SocketAccess.doPrivilegedIOException(url::openConnection);
            urlConnection.setConnectTimeout(2000);
            in = SocketAccess.doPrivilegedIOException(urlConnection::getInputStream);
            BufferedReader urlReader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
            String metadataResult = urlReader.readLine();
            if (metadataResult == null || metadataResult.length() == 0) {
                throw new IOException("no gce metadata returned from [" + url + "] for [" + type.configName + "]");
            }
            inetAddressArray = new InetAddress[]{InetAddress.getByName(metadataResult)};
        }
        catch (IOException e) {
            try {
                throw new IOException("IOException caught when fetching InetAddress from [" + metadataUrl + "]", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeWhileHandlingException(in);
                throw throwable;
            }
        }
        IOUtils.closeWhileHandlingException((Closeable)in);
        return inetAddressArray;
    }

    public InetAddress[] resolveDefault() {
        return null;
    }

    public InetAddress[] resolveIfPossible(String value) throws IOException {
        for (Ec2HostnameType type : Ec2HostnameType.values()) {
            if (!type.configName.equals(value)) continue;
            return this.resolve(type);
        }
        return null;
    }

    private static enum Ec2HostnameType {
        PRIVATE_IPv4("ec2:privateIpv4", "local-ipv4"),
        PRIVATE_DNS("ec2:privateDns", "local-hostname"),
        PUBLIC_IPv4("ec2:publicIpv4", "public-ipv4"),
        PUBLIC_DNS("ec2:publicDns", "public-hostname"),
        PUBLIC_IP("ec2:publicIp", Ec2HostnameType.PUBLIC_IPv4.ec2Name),
        PRIVATE_IP("ec2:privateIp", Ec2HostnameType.PRIVATE_IPv4.ec2Name),
        EC2("ec2", Ec2HostnameType.PRIVATE_IPv4.ec2Name);

        final String configName;
        final String ec2Name;

        private Ec2HostnameType(String configName, String ec2Name) {
            this.configName = configName;
            this.ec2Name = ec2Name;
        }
    }
}

