/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.discovery.ec2;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.opensearch.SpecialPermission;

final class SocketAccess {
    private SocketAccess() {
    }

    public static <T> T doPrivileged(PrivilegedAction<T> operation) {
        SpecialPermission.check();
        return AccessController.doPrivileged(operation);
    }

    public static <T> T doPrivilegedIOException(PrivilegedExceptionAction<T> operation) throws IOException {
        SpecialPermission.check();
        try {
            return AccessController.doPrivileged(operation);
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }
}

