/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.noop.action.bulk;

import org.opensearch.action.ActionListener;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.common.inject.Inject;
import org.opensearch.index.shard.ShardId;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class TransportNoopBulkAction
extends HandledTransportAction<BulkRequest, BulkResponse> {
    private static final BulkItemResponse ITEM_RESPONSE = new BulkItemResponse(1, DocWriteRequest.OpType.UPDATE, (DocWriteResponse)new UpdateResponse(new ShardId("mock", "", 1), "mock_type", "1", 0L, 1L, 1L, DocWriteResponse.Result.CREATED));

    @Inject
    public TransportNoopBulkAction(TransportService transportService, ActionFilters actionFilters) {
        super("mock:data/write/bulk", transportService, actionFilters, BulkRequest::new);
    }

    protected void doExecute(Task task, BulkRequest request, ActionListener<BulkResponse> listener) {
        int itemCount = request.requests().size();
        BulkItemResponse[] bulkItemResponses = new BulkItemResponse[itemCount];
        for (int idx = 0; idx < itemCount; ++idx) {
            bulkItemResponses[idx] = ITEM_RESPONSE;
        }
        listener.onResponse((Object)new BulkResponse(bulkItemResponses, 0L));
    }
}

