/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cache.store.disk;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.function.ToLongBiFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.ehcache.Cache;
import org.ehcache.CachePersistenceException;
import org.ehcache.PersistentCacheManager;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheEventListenerConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.PooledExecutionServiceConfigurationBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.core.spi.service.FileBasedPersistenceContext;
import org.ehcache.event.CacheEvent;
import org.ehcache.event.CacheEventListener;
import org.ehcache.event.EventType;
import org.ehcache.expiry.ExpiryPolicy;
import org.ehcache.impl.config.store.disk.OffHeapDiskStoreConfiguration;
import org.ehcache.spi.loaderwriter.CacheLoadingException;
import org.ehcache.spi.loaderwriter.CacheWritingException;
import org.ehcache.spi.serialization.SerializerException;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceCreationConfiguration;
import org.opensearch.OpenSearchException;
import org.opensearch.cache.EhcacheDiskCacheSettings;
import org.opensearch.common.SuppressForbidden;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.cache.CacheType;
import org.opensearch.common.cache.ICache;
import org.opensearch.common.cache.ICacheKey;
import org.opensearch.common.cache.LoadAwareCacheLoader;
import org.opensearch.common.cache.RemovalListener;
import org.opensearch.common.cache.RemovalNotification;
import org.opensearch.common.cache.RemovalReason;
import org.opensearch.common.cache.serializer.ICacheKeySerializer;
import org.opensearch.common.cache.serializer.Serializer;
import org.opensearch.common.cache.stats.CacheStatsHolder;
import org.opensearch.common.cache.stats.DefaultCacheStatsHolder;
import org.opensearch.common.cache.stats.ImmutableCacheStatsHolder;
import org.opensearch.common.cache.stats.NoopCacheStatsHolder;
import org.opensearch.common.cache.store.builders.ICacheBuilder;
import org.opensearch.common.cache.store.config.CacheConfig;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.io.IOUtils;

@ExperimentalApi
public class EhcacheDiskCache<K, V>
implements ICache<K, V> {
    private static final Logger logger = LogManager.getLogger(EhcacheDiskCache.class);
    private static final String UNIQUE_ID = UUID.randomUUID().toString();
    private static final String THREAD_POOL_ALIAS_PREFIX = "ehcachePool";
    private static final int MINIMUM_MAX_SIZE_IN_BYTES = 102400;
    private final PersistentCacheManager cacheManager;
    private Cache<ICacheKey, ByteArrayWrapper> cache;
    private final long maxWeightInBytes;
    private final String storagePath;
    private final Class<K> keyType;
    private final Class<V> valueType;
    private final TimeValue expireAfterAccess;
    private final CacheStatsHolder cacheStatsHolder;
    private final EhCacheEventListener ehCacheEventListener;
    private final String threadPoolAlias;
    private final Settings settings;
    private final RemovalListener<ICacheKey<K>, V> removalListener;
    private final CacheType cacheType;
    private final String diskCacheAlias;
    private final Serializer<K, byte[]> keySerializer;
    private final Serializer<V, byte[]> valueSerializer;
    Map<ICacheKey<K>, CompletableFuture<Tuple<ICacheKey<K>, V>>> completableFutureMap = new ConcurrentHashMap<ICacheKey<K>, CompletableFuture<Tuple<ICacheKey<K>, V>>>();

    private EhcacheDiskCache(Builder<K, V> builder) {
        this.keyType = Objects.requireNonNull(builder.keyType, "Key type shouldn't be null");
        this.valueType = Objects.requireNonNull(builder.valueType, "Value type shouldn't be null");
        this.expireAfterAccess = Objects.requireNonNull(builder.getExpireAfterAcess(), "ExpireAfterAccess value shouldn't be null");
        this.maxWeightInBytes = builder.getMaxWeightInBytes();
        if (this.maxWeightInBytes <= 102400L) {
            throw new IllegalArgumentException("Ehcache Disk tier cache size should be greater than 102400");
        }
        this.cacheType = Objects.requireNonNull(builder.cacheType, "Cache type shouldn't be null");
        this.diskCacheAlias = builder.diskCacheAlias == null || builder.diskCacheAlias.isBlank() ? "ehcacheDiskCache#" + String.valueOf(this.cacheType) : builder.diskCacheAlias;
        this.storagePath = builder.storagePath;
        if (this.storagePath == null || this.storagePath.isBlank()) {
            throw new IllegalArgumentException("Storage path shouldn't be null or empty");
        }
        this.threadPoolAlias = builder.threadPoolAlias == null || builder.threadPoolAlias.isBlank() ? "ehcachePoolDiskWrite#" + UNIQUE_ID : builder.threadPoolAlias;
        this.settings = Objects.requireNonNull(builder.getSettings(), "Settings objects shouldn't be null");
        this.keySerializer = Objects.requireNonNull(builder.keySerializer, "Key serializer shouldn't be null");
        this.valueSerializer = Objects.requireNonNull(builder.valueSerializer, "Value serializer shouldn't be null");
        this.cacheManager = this.buildCacheManager();
        Objects.requireNonNull(builder.getRemovalListener(), "Removal listener can't be null");
        this.removalListener = builder.getRemovalListener();
        Objects.requireNonNull(builder.getWeigher(), "Weigher can't be null");
        this.ehCacheEventListener = new EhCacheEventListener(builder.getRemovalListener(), builder.getWeigher());
        this.cache = this.buildCache(Duration.ofMillis(this.expireAfterAccess.getMillis()), builder);
        List<String> dimensionNames = Objects.requireNonNull(builder.dimensionNames, "Dimension names can't be null");
        this.cacheStatsHolder = builder.getStatsTrackingEnabled() ? new DefaultCacheStatsHolder(dimensionNames, "ehcache_disk") : NoopCacheStatsHolder.getInstance();
    }

    private Cache<ICacheKey, ByteArrayWrapper> buildCache(final Duration expireAfterAccess, Builder<K, V> builder) {
        try {
            return this.cacheManager.createCache(this.diskCacheAlias, (org.ehcache.config.Builder)((CacheConfigurationBuilder)CacheConfigurationBuilder.newCacheConfigurationBuilder(ICacheKey.class, ByteArrayWrapper.class, (org.ehcache.config.Builder)ResourcePoolsBuilder.newResourcePoolsBuilder().disk(this.maxWeightInBytes, MemoryUnit.B)).withExpiry((ExpiryPolicy)new ExpiryPolicy<ICacheKey, ByteArrayWrapper>(){

                public Duration getExpiryForCreation(ICacheKey key, ByteArrayWrapper value) {
                    return INFINITE;
                }

                public Duration getExpiryForAccess(ICacheKey key, Supplier<? extends ByteArrayWrapper> value) {
                    return expireAfterAccess;
                }

                public Duration getExpiryForUpdate(ICacheKey key, Supplier<? extends ByteArrayWrapper> oldValue, ByteArrayWrapper newValue) {
                    return INFINITE;
                }
            }).withService((org.ehcache.config.Builder)this.getListenerConfiguration(builder))).withService((ServiceConfiguration)new OffHeapDiskStoreConfiguration(this.threadPoolAlias, ((Integer)EhcacheDiskCacheSettings.getSettingListForCacheType(this.cacheType).get("disk_write_concurrency").get(this.settings)).intValue(), ((Integer)EhcacheDiskCacheSettings.getSettingListForCacheType(this.cacheType).get("disk_segment").get(this.settings)).intValue())).withKeySerializer((org.ehcache.spi.serialization.Serializer)new KeySerializerWrapper(this.keySerializer)).withValueSerializer((org.ehcache.spi.serialization.Serializer)new ByteArrayWrapperSerializer()));
        }
        catch (IllegalArgumentException ex) {
            logger.error("Ehcache disk cache initialization failed due to illegal argument: {}", (Object)ex.getMessage());
            throw ex;
        }
        catch (IllegalStateException ex) {
            logger.error("Ehcache disk cache initialization failed: {}", (Object)ex.getMessage());
            throw ex;
        }
    }

    private CacheEventListenerConfigurationBuilder getListenerConfiguration(Builder<K, V> builder) {
        CacheEventListenerConfigurationBuilder configurationBuilder = CacheEventListenerConfigurationBuilder.newEventListenerConfiguration((CacheEventListener)this.ehCacheEventListener, (EventType)EventType.EVICTED, (EventType[])new EventType[]{EventType.EXPIRED, EventType.REMOVED, EventType.UPDATED, EventType.CREATED}).unordered();
        if (builder.isEventListenerModeSync) {
            return configurationBuilder.synchronous();
        }
        return configurationBuilder.asynchronous();
    }

    Map<ICacheKey<K>, CompletableFuture<Tuple<ICacheKey<K>, V>>> getCompletableFutureMap() {
        return this.completableFutureMap;
    }

    @SuppressForbidden(reason="Ehcache uses File.io")
    private PersistentCacheManager buildCacheManager() {
        return (PersistentCacheManager)CacheManagerBuilder.newCacheManagerBuilder().with(CacheManagerBuilder.persistence((File)new File(this.storagePath))).using((ServiceCreationConfiguration)PooledExecutionServiceConfigurationBuilder.newPooledExecutionServiceConfigurationBuilder().defaultPool("ehcachePoolDefault#" + UNIQUE_ID, 1, 3).pool(this.threadPoolAlias, ((Integer)EhcacheDiskCacheSettings.getSettingListForCacheType(this.cacheType).get("disk_write_min_threads").get(this.settings)).intValue(), ((Integer)EhcacheDiskCacheSettings.getSettingListForCacheType(this.cacheType).get("disk_write_max_threads").get(this.settings)).intValue()).build()).build(true);
    }

    public V get(ICacheKey<K> key) {
        V value;
        if (key == null) {
            throw new IllegalArgumentException("Key passed to ehcache disk cache was null.");
        }
        try {
            value = this.deserializeValue((ByteArrayWrapper)this.cache.get(key));
        }
        catch (CacheLoadingException ex) {
            throw new OpenSearchException("Exception occurred while trying to fetch item from ehcache disk cache", new Object[0]);
        }
        if (value != null) {
            this.cacheStatsHolder.incrementHits(key.dimensions);
        } else {
            this.cacheStatsHolder.incrementMisses(key.dimensions);
        }
        return value;
    }

    public void put(ICacheKey<K> key, V value) {
        try {
            this.cache.put(key, (Object)this.serializeValue(value));
        }
        catch (CacheWritingException ex) {
            throw new OpenSearchException("Exception occurred while put item to ehcache disk cache", new Object[0]);
        }
    }

    public V computeIfAbsent(ICacheKey<K> key, LoadAwareCacheLoader<ICacheKey<K>, V> loader) throws Exception {
        V value = this.deserializeValue((ByteArrayWrapper)this.cache.get(key));
        if (value == null) {
            value = this.compute(key, loader);
        }
        if (!loader.isLoaded()) {
            this.cacheStatsHolder.incrementHits(key.dimensions);
        } else {
            this.cacheStatsHolder.incrementMisses(key.dimensions);
        }
        return value;
    }

    private V compute(ICacheKey<K> key, LoadAwareCacheLoader<ICacheKey<K>, V> loader) throws Exception {
        Object value;
        CompletionStage completableValue;
        CompletableFuture completableFuture = new CompletableFuture();
        CompletableFuture<Tuple> future = this.completableFutureMap.putIfAbsent(key, completableFuture);
        BiFunction<Tuple, Throwable, Object> handler = (pair, ex) -> {
            Object value = null;
            if (pair != null) {
                this.cache.put((Object)((ICacheKey)pair.v1()), (Object)this.serializeValue(pair.v2()));
                value = pair.v2();
            }
            this.completableFutureMap.remove(key);
            return value;
        };
        if (future == null) {
            future = completableFuture;
            completableValue = future.handle(handler);
            try {
                value = loader.load(key);
            }
            catch (Exception ex2) {
                future.completeExceptionally(ex2);
                throw new ExecutionException(ex2);
            }
            if (value == null) {
                NullPointerException npe = new NullPointerException("loader returned a null value");
                future.completeExceptionally(npe);
                throw new ExecutionException(npe);
            }
            future.complete(new Tuple(key, value));
        } else {
            completableValue = future.handle(handler);
        }
        try {
            value = ((CompletableFuture)completableValue).get();
            if (future.isCompletedExceptionally()) {
                future.get();
                throw new IllegalStateException("Future completed exceptionally but no error thrown");
            }
        }
        catch (InterruptedException ex3) {
            throw new IllegalStateException(ex3);
        }
        return (V)value;
    }

    public void invalidate(ICacheKey<K> key) {
        try {
            if (key.getDropStatsForDimensions()) {
                this.cacheStatsHolder.removeDimensions(key.dimensions);
            }
            if (key.key != null) {
                this.cache.remove(key);
            }
        }
        catch (CacheWritingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void invalidateAll() {
        this.cache.clear();
        this.cacheStatsHolder.reset();
    }

    public Iterable<ICacheKey<K>> keys() {
        return () -> new EhCacheKeyIterator(this.cache.iterator());
    }

    public long count() {
        return this.cacheStatsHolder.count();
    }

    public void refresh() {
    }

    @SuppressForbidden(reason="Ehcache uses File.io")
    public void close() {
        this.cacheManager.removeCache(this.diskCacheAlias);
        this.cacheManager.close();
        try {
            this.cacheManager.destroyCache(this.diskCacheAlias);
            Path ehcacheDirectory = Paths.get(this.storagePath, new String[0]);
            if (Files.exists(ehcacheDirectory, new LinkOption[0])) {
                IOUtils.rm((Path[])new Path[]{ehcacheDirectory});
            }
        }
        catch (CachePersistenceException e) {
            throw new OpenSearchException("Exception occurred while destroying ehcache and associated data", (Throwable)e, new Object[0]);
        }
        catch (IOException e) {
            logger.error(() -> new ParameterizedMessage("Failed to delete ehcache disk cache data under path: {}", (Object)this.storagePath));
        }
    }

    public ImmutableCacheStatsHolder stats(String[] levels) {
        return this.cacheStatsHolder.getImmutableCacheStatsHolder(levels);
    }

    private ByteArrayWrapper serializeValue(V value) {
        return new ByteArrayWrapper((byte[])this.valueSerializer.serialize(value));
    }

    private V deserializeValue(ByteArrayWrapper binary) {
        if (binary == null) {
            return null;
        }
        return (V)this.valueSerializer.deserialize((Object)binary.value);
    }

    public static class Builder<K, V>
    extends ICacheBuilder<K, V> {
        private CacheType cacheType;
        private String storagePath;
        private String threadPoolAlias;
        private String diskCacheAlias;
        private boolean isEventListenerModeSync;
        private Class<K> keyType;
        private Class<V> valueType;
        private List<String> dimensionNames;
        private Serializer<K, byte[]> keySerializer;
        private Serializer<V, byte[]> valueSerializer;

        public Builder<K, V> setCacheType(CacheType cacheType) {
            this.cacheType = cacheType;
            return this;
        }

        public Builder<K, V> setKeyType(Class<K> keyType) {
            this.keyType = keyType;
            return this;
        }

        public Builder<K, V> setValueType(Class<V> valueType) {
            this.valueType = valueType;
            return this;
        }

        public Builder<K, V> setStoragePath(String storagePath) {
            this.storagePath = storagePath;
            return this;
        }

        public Builder<K, V> setThreadPoolAlias(String threadPoolAlias) {
            this.threadPoolAlias = threadPoolAlias;
            return this;
        }

        public Builder<K, V> setDiskCacheAlias(String diskCacheAlias) {
            this.diskCacheAlias = diskCacheAlias;
            return this;
        }

        public Builder<K, V> setIsEventListenerModeSync(boolean isEventListenerModeSync) {
            this.isEventListenerModeSync = isEventListenerModeSync;
            return this;
        }

        public Builder<K, V> setDimensionNames(List<String> dimensionNames) {
            this.dimensionNames = dimensionNames;
            return this;
        }

        public Builder<K, V> setKeySerializer(Serializer<K, byte[]> keySerializer) {
            this.keySerializer = keySerializer;
            return this;
        }

        public Builder<K, V> setValueSerializer(Serializer<V, byte[]> valueSerializer) {
            this.valueSerializer = valueSerializer;
            return this;
        }

        public EhcacheDiskCache<K, V> build() {
            return new EhcacheDiskCache(this);
        }
    }

    class EhCacheEventListener
    implements CacheEventListener<ICacheKey<K>, ByteArrayWrapper> {
        private final RemovalListener<ICacheKey<K>, V> removalListener;
        private ToLongBiFunction<ICacheKey<K>, V> weigher;

        EhCacheEventListener(RemovalListener<ICacheKey<K>, V> removalListener, ToLongBiFunction<ICacheKey<K>, V> weigher) {
            this.removalListener = removalListener;
            this.weigher = weigher;
        }

        private long getOldValuePairSize(CacheEvent<? extends ICacheKey<K>, ? extends ByteArrayWrapper> event) {
            return this.weigher.applyAsLong((ICacheKey)event.getKey(), EhcacheDiskCache.this.deserializeValue((ByteArrayWrapper)event.getOldValue()));
        }

        private long getNewValuePairSize(CacheEvent<? extends ICacheKey<K>, ? extends ByteArrayWrapper> event) {
            return this.weigher.applyAsLong((ICacheKey)event.getKey(), EhcacheDiskCache.this.deserializeValue((ByteArrayWrapper)event.getNewValue()));
        }

        public void onEvent(CacheEvent<? extends ICacheKey<K>, ? extends ByteArrayWrapper> event) {
            switch (event.getType()) {
                case CREATED: {
                    EhcacheDiskCache.this.cacheStatsHolder.incrementItems(((ICacheKey)event.getKey()).dimensions);
                    EhcacheDiskCache.this.cacheStatsHolder.incrementSizeInBytes(((ICacheKey)event.getKey()).dimensions, this.getNewValuePairSize(event));
                    assert (event.getOldValue() == null);
                    break;
                }
                case EVICTED: {
                    this.removalListener.onRemoval(new RemovalNotification((Object)((ICacheKey)event.getKey()), EhcacheDiskCache.this.deserializeValue((ByteArrayWrapper)event.getOldValue()), RemovalReason.EVICTED));
                    EhcacheDiskCache.this.cacheStatsHolder.decrementItems(((ICacheKey)event.getKey()).dimensions);
                    EhcacheDiskCache.this.cacheStatsHolder.decrementSizeInBytes(((ICacheKey)event.getKey()).dimensions, this.getOldValuePairSize(event));
                    EhcacheDiskCache.this.cacheStatsHolder.incrementEvictions(((ICacheKey)event.getKey()).dimensions);
                    assert (event.getNewValue() == null);
                    break;
                }
                case REMOVED: {
                    this.removalListener.onRemoval(new RemovalNotification((Object)((ICacheKey)event.getKey()), EhcacheDiskCache.this.deserializeValue((ByteArrayWrapper)event.getOldValue()), RemovalReason.EXPLICIT));
                    EhcacheDiskCache.this.cacheStatsHolder.decrementItems(((ICacheKey)event.getKey()).dimensions);
                    EhcacheDiskCache.this.cacheStatsHolder.decrementSizeInBytes(((ICacheKey)event.getKey()).dimensions, this.getOldValuePairSize(event));
                    assert (event.getNewValue() == null);
                    break;
                }
                case EXPIRED: {
                    this.removalListener.onRemoval(new RemovalNotification((Object)((ICacheKey)event.getKey()), EhcacheDiskCache.this.deserializeValue((ByteArrayWrapper)event.getOldValue()), RemovalReason.INVALIDATED));
                    EhcacheDiskCache.this.cacheStatsHolder.decrementItems(((ICacheKey)event.getKey()).dimensions);
                    EhcacheDiskCache.this.cacheStatsHolder.decrementSizeInBytes(((ICacheKey)event.getKey()).dimensions, this.getOldValuePairSize(event));
                    assert (event.getNewValue() == null);
                    break;
                }
                case UPDATED: {
                    long newSize = this.getNewValuePairSize(event);
                    long oldSize = this.getOldValuePairSize(event);
                    EhcacheDiskCache.this.cacheStatsHolder.incrementSizeInBytes(((ICacheKey)event.getKey()).dimensions, newSize - oldSize);
                    break;
                }
            }
        }
    }

    public static class EhcacheDiskCacheFactory
    implements ICache.Factory {
        public static final String EHCACHE_DISK_CACHE_NAME = "ehcache_disk";

        public <K, V> ICache<K, V> create(CacheConfig<K, V> config, CacheType cacheType, Map<String, ICache.Factory> cacheFactories) {
            Map<String, Setting<?>> settingList = EhcacheDiskCacheSettings.getSettingListForCacheType(cacheType);
            Settings settings = config.getSettings();
            Serializer keySerializer = null;
            try {
                keySerializer = config.getKeySerializer();
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("EhcacheDiskCache requires a key serializer of type Serializer<K, byte[]>");
            }
            Serializer valueSerializer = null;
            try {
                valueSerializer = config.getValueSerializer();
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("EhcacheDiskCache requires a value serializer of type Serializer<V, byte[]>");
            }
            return new Builder().setStoragePath((String)settingList.get("disk_storage_path").get(settings)).setDiskCacheAlias((String)settingList.get("disk_cache_alias").get(settings)).setIsEventListenerModeSync((Boolean)settingList.get("disk_listener_mode").get(settings)).setCacheType(cacheType).setKeyType(config.getKeyType()).setValueType(config.getValueType()).setKeySerializer(keySerializer).setValueSerializer(valueSerializer).setDimensionNames(config.getDimensionNames()).setWeigher(config.getWeigher()).setRemovalListener(config.getRemovalListener()).setExpireAfterAccess((TimeValue)settingList.get("disk_cache_expire_after_access_key").get(settings)).setMaximumWeightInBytes(((Long)settingList.get("max_size_in_bytes").get(settings)).longValue()).setSettings(settings).build();
        }

        public String getCacheName() {
            return EHCACHE_DISK_CACHE_NAME;
        }
    }

    static class ByteArrayWrapper {
        private final byte[] value;

        public ByteArrayWrapper(byte[] value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != ByteArrayWrapper.class) {
                return false;
            }
            ByteArrayWrapper other = (ByteArrayWrapper)o;
            return Arrays.equals(this.value, other.value);
        }

        public int hashCode() {
            return Arrays.hashCode(this.value);
        }
    }

    private class KeySerializerWrapper
    implements org.ehcache.spi.serialization.Serializer<ICacheKey> {
        private ICacheKeySerializer<K> serializer;

        public KeySerializerWrapper(Serializer<K, byte[]> internalKeySerializer) {
            this.serializer = new ICacheKeySerializer(internalKeySerializer);
        }

        public KeySerializerWrapper(ClassLoader classLoader, FileBasedPersistenceContext persistenceContext) {
        }

        public ByteBuffer serialize(ICacheKey object) throws SerializerException {
            return ByteBuffer.wrap(this.serializer.serialize(object));
        }

        public ICacheKey<K> read(ByteBuffer binary) throws ClassNotFoundException, SerializerException {
            byte[] arr = new byte[binary.remaining()];
            binary.get(arr);
            return this.serializer.deserialize(arr);
        }

        public boolean equals(ICacheKey object, ByteBuffer binary) throws ClassNotFoundException, SerializerException {
            byte[] arr = new byte[binary.remaining()];
            binary.get(arr);
            return this.serializer.equals(object, arr);
        }
    }

    private static class ByteArrayWrapperSerializer
    implements org.ehcache.spi.serialization.Serializer<ByteArrayWrapper> {
        public ByteArrayWrapperSerializer() {
        }

        public ByteArrayWrapperSerializer(ClassLoader classLoader, FileBasedPersistenceContext persistenceContext) {
        }

        public ByteBuffer serialize(ByteArrayWrapper object) throws SerializerException {
            return ByteBuffer.wrap(object.value);
        }

        public ByteArrayWrapper read(ByteBuffer binary) throws ClassNotFoundException, SerializerException {
            byte[] arr = new byte[binary.remaining()];
            binary.get(arr);
            return new ByteArrayWrapper(arr);
        }

        public boolean equals(ByteArrayWrapper object, ByteBuffer binary) throws ClassNotFoundException, SerializerException {
            byte[] arr = new byte[binary.remaining()];
            binary.get(arr);
            return Arrays.equals(arr, object.value);
        }
    }

    class EhCacheKeyIterator<K>
    implements Iterator<ICacheKey<K>> {
        Iterator<Cache.Entry<ICacheKey, ByteArrayWrapper>> iterator;

        EhCacheKeyIterator(Iterator<Cache.Entry<ICacheKey, ByteArrayWrapper>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public ICacheKey<K> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return (ICacheKey)this.iterator.next().getKey();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

