/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cache;

import java.util.HashMap;
import java.util.Map;
import org.opensearch.common.cache.CacheType;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.unit.TimeValue;

public class EhcacheDiskCacheSettings {
    public static final long DEFAULT_CACHE_SIZE_IN_BYTES = 0x40000000L;
    public static final Setting.AffixSetting<Integer> DISK_WRITE_MINIMUM_THREADS_SETTING = Setting.suffixKeySetting((String)"ehcache_disk.min_threads", key -> Setting.intSetting((String)key, (int)2, (int)1, (int)5, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
    public static final Setting.AffixSetting<Integer> DISK_WRITE_MAXIMUM_THREADS_SETTING = Setting.suffixKeySetting((String)"ehcache_disk.max_threads", key -> Setting.intSetting((String)key, (int)2, (int)1, (int)20, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
    public static final Setting.AffixSetting<Integer> DISK_WRITE_CONCURRENCY_SETTING = Setting.suffixKeySetting((String)"ehcache_disk.concurrency", key -> Setting.intSetting((String)key, (int)1, (int)1, (int)3, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
    public static final Setting.AffixSetting<Integer> DISK_SEGMENTS_SETTING = Setting.suffixKeySetting((String)"ehcache_disk.segments", key -> Setting.intSetting((String)key, (int)16, (int)1, (int)32, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
    public static final Setting.AffixSetting<String> DISK_STORAGE_PATH_SETTING = Setting.suffixKeySetting((String)"ehcache_disk.storage.path", key -> Setting.simpleString((String)key, (String)"", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
    public static final Setting.AffixSetting<String> DISK_CACHE_ALIAS_SETTING = Setting.suffixKeySetting((String)"ehcache_disk.alias", key -> Setting.simpleString((String)key, (String)"", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
    public static final Setting.AffixSetting<TimeValue> DISK_CACHE_EXPIRE_AFTER_ACCESS_SETTING = Setting.suffixKeySetting((String)"ehcache_disk.expire_after_access", key -> Setting.positiveTimeSetting((String)key, (TimeValue)TimeValue.MAX_VALUE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
    public static final Setting.AffixSetting<Long> DISK_CACHE_MAX_SIZE_IN_BYTES_SETTING = Setting.suffixKeySetting((String)"ehcache_disk.max_size_in_bytes", key -> Setting.longSetting((String)key, (long)0x40000000L, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
    public static final Setting.AffixSetting<Boolean> DISK_CACHE_LISTENER_MODE_SYNC_SETTING = Setting.suffixKeySetting((String)"ehcache_disk.is_event_listener_sync", key -> Setting.boolSetting((String)key, (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
    public static final String DISK_SEGMENT_KEY = "disk_segment";
    public static final String DISK_MAX_SIZE_IN_BYTES_KEY = "max_size_in_bytes";
    public static final String DISK_CACHE_EXPIRE_AFTER_ACCESS_KEY = "disk_cache_expire_after_access_key";
    public static final String DISK_CACHE_ALIAS_KEY = "disk_cache_alias";
    public static final String DISK_SEGMENTS_KEY = "disk_segments";
    public static final String DISK_WRITE_CONCURRENCY_KEY = "disk_write_concurrency";
    public static final String DISK_WRITE_MAXIMUM_THREADS_KEY = "disk_write_max_threads";
    public static final String DISK_WRITE_MIN_THREADS_KEY = "disk_write_min_threads";
    public static final String DISK_STORAGE_PATH_KEY = "disk_storage_path";
    public static final String DISK_LISTENER_MODE_SYNC_KEY = "disk_listener_mode";
    private static final Map<String, Setting.AffixSetting<?>> KEY_SETTING_MAP = Map.of("disk_segment", DISK_SEGMENTS_SETTING, "disk_cache_expire_after_access_key", DISK_CACHE_EXPIRE_AFTER_ACCESS_SETTING, "disk_cache_alias", DISK_CACHE_ALIAS_SETTING, "disk_write_concurrency", DISK_WRITE_CONCURRENCY_SETTING, "disk_write_max_threads", DISK_WRITE_MAXIMUM_THREADS_SETTING, "disk_write_min_threads", DISK_WRITE_MINIMUM_THREADS_SETTING, "disk_storage_path", DISK_STORAGE_PATH_SETTING, "max_size_in_bytes", DISK_CACHE_MAX_SIZE_IN_BYTES_SETTING, "disk_listener_mode", DISK_CACHE_LISTENER_MODE_SYNC_SETTING);
    public static final Map<CacheType, Map<String, Setting<?>>> CACHE_TYPE_MAP = EhcacheDiskCacheSettings.getCacheTypeMap();

    private static final Map<CacheType, Map<String, Setting<?>>> getCacheTypeMap() {
        HashMap cacheTypeMap = new HashMap();
        for (CacheType cacheType : CacheType.values()) {
            HashMap<String, Setting> settingMap = new HashMap<String, Setting>();
            for (Map.Entry<String, Setting.AffixSetting<?>> entry : KEY_SETTING_MAP.entrySet()) {
                settingMap.put(entry.getKey(), entry.getValue().getConcreteSettingForNamespace(cacheType.getSettingPrefix()));
            }
            cacheTypeMap.put(cacheType, settingMap);
        }
        return cacheTypeMap;
    }

    public static final Map<String, Setting<?>> getSettingListForCacheType(CacheType cacheType) {
        Map<String, Setting<?>> cacheTypeSettings = CACHE_TYPE_MAP.get(cacheType);
        if (cacheTypeSettings == null) {
            throw new IllegalArgumentException("No settings exist for cache store name: ehcache_diskassociated with cache type: " + String.valueOf(cacheType));
        }
        return cacheTypeSettings;
    }
}

