/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.analysis.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.ar.ArabicAnalyzer;
import org.apache.lucene.analysis.ar.ArabicNormalizationFilter;
import org.apache.lucene.analysis.ar.ArabicStemFilter;
import org.apache.lucene.analysis.bg.BulgarianAnalyzer;
import org.apache.lucene.analysis.bn.BengaliAnalyzer;
import org.apache.lucene.analysis.bn.BengaliNormalizationFilter;
import org.apache.lucene.analysis.br.BrazilianAnalyzer;
import org.apache.lucene.analysis.br.BrazilianStemFilter;
import org.apache.lucene.analysis.ca.CatalanAnalyzer;
import org.apache.lucene.analysis.charfilter.HTMLStripCharFilter;
import org.apache.lucene.analysis.cjk.CJKAnalyzer;
import org.apache.lucene.analysis.cjk.CJKBigramFilter;
import org.apache.lucene.analysis.cjk.CJKWidthFilter;
import org.apache.lucene.analysis.ckb.SoraniAnalyzer;
import org.apache.lucene.analysis.ckb.SoraniNormalizationFilter;
import org.apache.lucene.analysis.commongrams.CommonGramsFilter;
import org.apache.lucene.analysis.core.DecimalDigitFilter;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.core.LetterTokenizer;
import org.apache.lucene.analysis.core.UpperCaseFilter;
import org.apache.lucene.analysis.core.WhitespaceTokenizer;
import org.apache.lucene.analysis.cz.CzechAnalyzer;
import org.apache.lucene.analysis.cz.CzechStemFilter;
import org.apache.lucene.analysis.da.DanishAnalyzer;
import org.apache.lucene.analysis.de.GermanAnalyzer;
import org.apache.lucene.analysis.de.GermanNormalizationFilter;
import org.apache.lucene.analysis.de.GermanStemFilter;
import org.apache.lucene.analysis.el.GreekAnalyzer;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.analysis.en.KStemFilter;
import org.apache.lucene.analysis.en.PorterStemFilter;
import org.apache.lucene.analysis.es.SpanishAnalyzer;
import org.apache.lucene.analysis.et.EstonianAnalyzer;
import org.apache.lucene.analysis.eu.BasqueAnalyzer;
import org.apache.lucene.analysis.fa.PersianAnalyzer;
import org.apache.lucene.analysis.fa.PersianNormalizationFilter;
import org.apache.lucene.analysis.fi.FinnishAnalyzer;
import org.apache.lucene.analysis.fr.FrenchAnalyzer;
import org.apache.lucene.analysis.ga.IrishAnalyzer;
import org.apache.lucene.analysis.gl.GalicianAnalyzer;
import org.apache.lucene.analysis.hi.HindiAnalyzer;
import org.apache.lucene.analysis.hi.HindiNormalizationFilter;
import org.apache.lucene.analysis.hu.HungarianAnalyzer;
import org.apache.lucene.analysis.hy.ArmenianAnalyzer;
import org.apache.lucene.analysis.id.IndonesianAnalyzer;
import org.apache.lucene.analysis.in.IndicNormalizationFilter;
import org.apache.lucene.analysis.it.ItalianAnalyzer;
import org.apache.lucene.analysis.lt.LithuanianAnalyzer;
import org.apache.lucene.analysis.lv.LatvianAnalyzer;
import org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilter;
import org.apache.lucene.analysis.miscellaneous.DisableGraphAttribute;
import org.apache.lucene.analysis.miscellaneous.KeywordRepeatFilter;
import org.apache.lucene.analysis.miscellaneous.LengthFilter;
import org.apache.lucene.analysis.miscellaneous.LimitTokenCountFilter;
import org.apache.lucene.analysis.miscellaneous.ScandinavianFoldingFilter;
import org.apache.lucene.analysis.miscellaneous.ScandinavianNormalizationFilter;
import org.apache.lucene.analysis.miscellaneous.TrimFilter;
import org.apache.lucene.analysis.miscellaneous.TruncateTokenFilter;
import org.apache.lucene.analysis.miscellaneous.WordDelimiterFilter;
import org.apache.lucene.analysis.miscellaneous.WordDelimiterGraphFilter;
import org.apache.lucene.analysis.miscellaneous.WordDelimiterIterator;
import org.apache.lucene.analysis.ngram.EdgeNGramTokenFilter;
import org.apache.lucene.analysis.ngram.EdgeNGramTokenizer;
import org.apache.lucene.analysis.ngram.NGramTokenFilter;
import org.apache.lucene.analysis.ngram.NGramTokenizer;
import org.apache.lucene.analysis.nl.DutchAnalyzer;
import org.apache.lucene.analysis.no.NorwegianAnalyzer;
import org.apache.lucene.analysis.path.PathHierarchyTokenizer;
import org.apache.lucene.analysis.pattern.PatternTokenizer;
import org.apache.lucene.analysis.payloads.DelimitedPayloadTokenFilter;
import org.apache.lucene.analysis.payloads.TypeAsPayloadTokenFilter;
import org.apache.lucene.analysis.pt.PortugueseAnalyzer;
import org.apache.lucene.analysis.reverse.ReverseStringFilter;
import org.apache.lucene.analysis.ro.RomanianAnalyzer;
import org.apache.lucene.analysis.ru.RussianAnalyzer;
import org.apache.lucene.analysis.shingle.ShingleFilter;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.apache.lucene.analysis.standard.ClassicFilter;
import org.apache.lucene.analysis.standard.ClassicTokenizer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.standard.UAX29URLEmailTokenizer;
import org.apache.lucene.analysis.sv.SwedishAnalyzer;
import org.apache.lucene.analysis.th.ThaiAnalyzer;
import org.apache.lucene.analysis.th.ThaiTokenizer;
import org.apache.lucene.analysis.tr.ApostropheFilter;
import org.apache.lucene.analysis.tr.TurkishAnalyzer;
import org.apache.lucene.analysis.util.ElisionFilter;
import org.apache.lucene.util.SetOnce;
import org.opensearch.LegacyESVersion;
import org.opensearch.Version;
import org.opensearch.analysis.common.ASCIIFoldingTokenFilterFactory;
import org.opensearch.analysis.common.AnalysisPredicateScript;
import org.opensearch.analysis.common.ApostropheFilterFactory;
import org.opensearch.analysis.common.ArabicAnalyzerProvider;
import org.opensearch.analysis.common.ArabicNormalizationFilterFactory;
import org.opensearch.analysis.common.ArabicStemTokenFilterFactory;
import org.opensearch.analysis.common.ArmenianAnalyzerProvider;
import org.opensearch.analysis.common.BasqueAnalyzerProvider;
import org.opensearch.analysis.common.BengaliAnalyzerProvider;
import org.opensearch.analysis.common.BengaliNormalizationFilterFactory;
import org.opensearch.analysis.common.BrazilianAnalyzerProvider;
import org.opensearch.analysis.common.BrazilianStemTokenFilterFactory;
import org.opensearch.analysis.common.BulgarianAnalyzerProvider;
import org.opensearch.analysis.common.CJKBigramFilterFactory;
import org.opensearch.analysis.common.CJKWidthFilterFactory;
import org.opensearch.analysis.common.CatalanAnalyzerProvider;
import org.opensearch.analysis.common.CharGroupTokenizerFactory;
import org.opensearch.analysis.common.ChineseAnalyzerProvider;
import org.opensearch.analysis.common.CjkAnalyzerProvider;
import org.opensearch.analysis.common.ClassicFilterFactory;
import org.opensearch.analysis.common.ClassicTokenizerFactory;
import org.opensearch.analysis.common.CommonGramsTokenFilterFactory;
import org.opensearch.analysis.common.ConcatenateGraphTokenFilterFactory;
import org.opensearch.analysis.common.CzechAnalyzerProvider;
import org.opensearch.analysis.common.CzechStemTokenFilterFactory;
import org.opensearch.analysis.common.DanishAnalyzerProvider;
import org.opensearch.analysis.common.DecimalDigitFilterFactory;
import org.opensearch.analysis.common.DelimitedPayloadTokenFilterFactory;
import org.opensearch.analysis.common.DictionaryCompoundWordTokenFilterFactory;
import org.opensearch.analysis.common.DutchAnalyzerProvider;
import org.opensearch.analysis.common.DutchStemTokenFilterFactory;
import org.opensearch.analysis.common.EdgeNGramTokenFilterFactory;
import org.opensearch.analysis.common.EdgeNGramTokenizerFactory;
import org.opensearch.analysis.common.ElisionTokenFilterFactory;
import org.opensearch.analysis.common.EnglishAnalyzerProvider;
import org.opensearch.analysis.common.EstonianAnalyzerProvider;
import org.opensearch.analysis.common.FingerprintAnalyzerProvider;
import org.opensearch.analysis.common.FingerprintTokenFilterFactory;
import org.opensearch.analysis.common.FinnishAnalyzerProvider;
import org.opensearch.analysis.common.FlattenGraphTokenFilterFactory;
import org.opensearch.analysis.common.FrenchAnalyzerProvider;
import org.opensearch.analysis.common.FrenchStemTokenFilterFactory;
import org.opensearch.analysis.common.GalicianAnalyzerProvider;
import org.opensearch.analysis.common.GermanAnalyzerProvider;
import org.opensearch.analysis.common.GermanNormalizationFilterFactory;
import org.opensearch.analysis.common.GermanStemTokenFilterFactory;
import org.opensearch.analysis.common.GreekAnalyzerProvider;
import org.opensearch.analysis.common.HindiAnalyzerProvider;
import org.opensearch.analysis.common.HindiNormalizationFilterFactory;
import org.opensearch.analysis.common.HtmlStripCharFilterFactory;
import org.opensearch.analysis.common.HungarianAnalyzerProvider;
import org.opensearch.analysis.common.HyphenationCompoundWordTokenFilterFactory;
import org.opensearch.analysis.common.IndicNormalizationFilterFactory;
import org.opensearch.analysis.common.IndonesianAnalyzerProvider;
import org.opensearch.analysis.common.IrishAnalyzerProvider;
import org.opensearch.analysis.common.ItalianAnalyzerProvider;
import org.opensearch.analysis.common.KStemTokenFilterFactory;
import org.opensearch.analysis.common.KeepTypesFilterFactory;
import org.opensearch.analysis.common.KeepWordFilterFactory;
import org.opensearch.analysis.common.KeywordMarkerTokenFilterFactory;
import org.opensearch.analysis.common.KeywordTokenizerFactory;
import org.opensearch.analysis.common.LatvianAnalyzerProvider;
import org.opensearch.analysis.common.LegacyDelimitedPayloadTokenFilterFactory;
import org.opensearch.analysis.common.LengthTokenFilterFactory;
import org.opensearch.analysis.common.LetterTokenizerFactory;
import org.opensearch.analysis.common.LimitTokenCountFilterFactory;
import org.opensearch.analysis.common.LithuanianAnalyzerProvider;
import org.opensearch.analysis.common.LowerCaseTokenFilterFactory;
import org.opensearch.analysis.common.MappingCharFilterFactory;
import org.opensearch.analysis.common.MinHashTokenFilterFactory;
import org.opensearch.analysis.common.MultiplexerTokenFilterFactory;
import org.opensearch.analysis.common.NGramTokenFilterFactory;
import org.opensearch.analysis.common.NGramTokenizerFactory;
import org.opensearch.analysis.common.NorwegianAnalyzerProvider;
import org.opensearch.analysis.common.PathHierarchyTokenizerFactory;
import org.opensearch.analysis.common.PatternAnalyzer;
import org.opensearch.analysis.common.PatternAnalyzerProvider;
import org.opensearch.analysis.common.PatternCaptureGroupTokenFilterFactory;
import org.opensearch.analysis.common.PatternReplaceCharFilterFactory;
import org.opensearch.analysis.common.PatternReplaceTokenFilterFactory;
import org.opensearch.analysis.common.PatternTokenizerFactory;
import org.opensearch.analysis.common.PersianAnalyzerProvider;
import org.opensearch.analysis.common.PersianNormalizationFilterFactory;
import org.opensearch.analysis.common.PorterStemTokenFilterFactory;
import org.opensearch.analysis.common.PortugueseAnalyzerProvider;
import org.opensearch.analysis.common.PredicateTokenFilterScriptFactory;
import org.opensearch.analysis.common.RemoveDuplicatesTokenFilterFactory;
import org.opensearch.analysis.common.ReverseTokenFilterFactory;
import org.opensearch.analysis.common.RomanianAnalyzerProvider;
import org.opensearch.analysis.common.RussianAnalyzerProvider;
import org.opensearch.analysis.common.RussianStemTokenFilterFactory;
import org.opensearch.analysis.common.ScandinavianFoldingFilterFactory;
import org.opensearch.analysis.common.ScandinavianNormalizationFilterFactory;
import org.opensearch.analysis.common.ScriptedConditionTokenFilterFactory;
import org.opensearch.analysis.common.SerbianNormalizationFilterFactory;
import org.opensearch.analysis.common.SimplePatternSplitTokenizerFactory;
import org.opensearch.analysis.common.SimplePatternTokenizerFactory;
import org.opensearch.analysis.common.SnowballAnalyzer;
import org.opensearch.analysis.common.SnowballAnalyzerProvider;
import org.opensearch.analysis.common.SnowballTokenFilterFactory;
import org.opensearch.analysis.common.SoraniAnalyzerProvider;
import org.opensearch.analysis.common.SoraniNormalizationFilterFactory;
import org.opensearch.analysis.common.SpanishAnalyzerProvider;
import org.opensearch.analysis.common.StandardHtmlStripAnalyzer;
import org.opensearch.analysis.common.StandardHtmlStripAnalyzerProvider;
import org.opensearch.analysis.common.StemmerOverrideTokenFilterFactory;
import org.opensearch.analysis.common.StemmerTokenFilterFactory;
import org.opensearch.analysis.common.SwedishAnalyzerProvider;
import org.opensearch.analysis.common.SynonymGraphTokenFilterFactory;
import org.opensearch.analysis.common.SynonymTokenFilterFactory;
import org.opensearch.analysis.common.ThaiAnalyzerProvider;
import org.opensearch.analysis.common.ThaiTokenizerFactory;
import org.opensearch.analysis.common.TrimTokenFilterFactory;
import org.opensearch.analysis.common.TruncateTokenFilterFactory;
import org.opensearch.analysis.common.TurkishAnalyzerProvider;
import org.opensearch.analysis.common.UAX29URLEmailTokenizerFactory;
import org.opensearch.analysis.common.UniqueTokenFilter;
import org.opensearch.analysis.common.UniqueTokenFilterFactory;
import org.opensearch.analysis.common.UpperCaseTokenFilterFactory;
import org.opensearch.analysis.common.WhitespaceTokenizerFactory;
import org.opensearch.analysis.common.WordDelimiterGraphTokenFilterFactory;
import org.opensearch.analysis.common.WordDelimiterTokenFilterFactory;
import org.opensearch.analysis.common.XLowerCaseTokenizer;
import org.opensearch.analysis.common.XLowerCaseTokenizerFactory;
import org.opensearch.client.Client;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.io.stream.NamedWriteableRegistry;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.common.regex.Regex;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.env.Environment;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.index.analysis.AnalyzerProvider;
import org.opensearch.index.analysis.CharFilterFactory;
import org.opensearch.index.analysis.PreBuiltAnalyzerProviderFactory;
import org.opensearch.index.analysis.PreConfiguredCharFilter;
import org.opensearch.index.analysis.PreConfiguredTokenFilter;
import org.opensearch.index.analysis.PreConfiguredTokenizer;
import org.opensearch.index.analysis.TokenFilterFactory;
import org.opensearch.index.analysis.TokenizerFactory;
import org.opensearch.indices.analysis.AnalysisModule;
import org.opensearch.indices.analysis.PreBuiltCacheFactory;
import org.opensearch.plugins.AnalysisPlugin;
import org.opensearch.plugins.Plugin;
import org.opensearch.plugins.ScriptPlugin;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.script.ScriptContext;
import org.opensearch.script.ScriptService;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.watcher.ResourceWatcherService;
import org.tartarus.snowball.SnowballProgram;
import org.tartarus.snowball.ext.DutchStemmer;
import org.tartarus.snowball.ext.FrenchStemmer;

public class CommonAnalysisPlugin
extends Plugin
implements AnalysisPlugin,
ScriptPlugin {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(CommonAnalysisPlugin.class);
    private final SetOnce<ScriptService> scriptService = new SetOnce();

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver expressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        this.scriptService.set((Object)scriptService);
        return Collections.emptyList();
    }

    public List<ScriptContext<?>> getContexts() {
        return Collections.singletonList(AnalysisPredicateScript.CONTEXT);
    }

    public Map<String, AnalysisModule.AnalysisProvider<AnalyzerProvider<? extends Analyzer>>> getAnalyzers() {
        TreeMap<String, AnalysisModule.AnalysisProvider<AnalyzerProvider<? extends Analyzer>>> analyzers = new TreeMap<String, AnalysisModule.AnalysisProvider<AnalyzerProvider<? extends Analyzer>>>();
        analyzers.put("fingerprint", FingerprintAnalyzerProvider::new);
        analyzers.put("standard_html_strip", StandardHtmlStripAnalyzerProvider::new);
        analyzers.put("pattern", PatternAnalyzerProvider::new);
        analyzers.put("snowball", SnowballAnalyzerProvider::new);
        analyzers.put("arabic", ArabicAnalyzerProvider::new);
        analyzers.put("armenian", ArmenianAnalyzerProvider::new);
        analyzers.put("basque", BasqueAnalyzerProvider::new);
        analyzers.put("bengali", BengaliAnalyzerProvider::new);
        analyzers.put("brazilian", BrazilianAnalyzerProvider::new);
        analyzers.put("bulgarian", BulgarianAnalyzerProvider::new);
        analyzers.put("catalan", CatalanAnalyzerProvider::new);
        analyzers.put("chinese", ChineseAnalyzerProvider::new);
        analyzers.put("cjk", CjkAnalyzerProvider::new);
        analyzers.put("czech", CzechAnalyzerProvider::new);
        analyzers.put("danish", DanishAnalyzerProvider::new);
        analyzers.put("dutch", DutchAnalyzerProvider::new);
        analyzers.put("english", EnglishAnalyzerProvider::new);
        analyzers.put("estonian", EstonianAnalyzerProvider::new);
        analyzers.put("finnish", FinnishAnalyzerProvider::new);
        analyzers.put("french", FrenchAnalyzerProvider::new);
        analyzers.put("galician", GalicianAnalyzerProvider::new);
        analyzers.put("german", GermanAnalyzerProvider::new);
        analyzers.put("greek", GreekAnalyzerProvider::new);
        analyzers.put("hindi", HindiAnalyzerProvider::new);
        analyzers.put("hungarian", HungarianAnalyzerProvider::new);
        analyzers.put("indonesian", IndonesianAnalyzerProvider::new);
        analyzers.put("irish", IrishAnalyzerProvider::new);
        analyzers.put("italian", ItalianAnalyzerProvider::new);
        analyzers.put("latvian", LatvianAnalyzerProvider::new);
        analyzers.put("lithuanian", LithuanianAnalyzerProvider::new);
        analyzers.put("norwegian", NorwegianAnalyzerProvider::new);
        analyzers.put("persian", PersianAnalyzerProvider::new);
        analyzers.put("portuguese", PortugueseAnalyzerProvider::new);
        analyzers.put("romanian", RomanianAnalyzerProvider::new);
        analyzers.put("russian", RussianAnalyzerProvider::new);
        analyzers.put("sorani", SoraniAnalyzerProvider::new);
        analyzers.put("spanish", SpanishAnalyzerProvider::new);
        analyzers.put("swedish", SwedishAnalyzerProvider::new);
        analyzers.put("turkish", TurkishAnalyzerProvider::new);
        analyzers.put("thai", ThaiAnalyzerProvider::new);
        return analyzers;
    }

    public Map<String, AnalysisModule.AnalysisProvider<TokenFilterFactory>> getTokenFilters() {
        TreeMap<String, AnalysisModule.AnalysisProvider<TokenFilterFactory>> filters = new TreeMap<String, AnalysisModule.AnalysisProvider<TokenFilterFactory>>();
        filters.put("apostrophe", ApostropheFilterFactory::new);
        filters.put("arabic_normalization", ArabicNormalizationFilterFactory::new);
        filters.put("arabic_stem", ArabicStemTokenFilterFactory::new);
        filters.put("asciifolding", ASCIIFoldingTokenFilterFactory::new);
        filters.put("bengali_normalization", BengaliNormalizationFilterFactory::new);
        filters.put("brazilian_stem", BrazilianStemTokenFilterFactory::new);
        filters.put("cjk_bigram", CJKBigramFilterFactory::new);
        filters.put("cjk_width", CJKWidthFilterFactory::new);
        filters.put("classic", ClassicFilterFactory::new);
        filters.put("czech_stem", CzechStemTokenFilterFactory::new);
        filters.put("common_grams", AnalysisPlugin.requiresAnalysisSettings(CommonGramsTokenFilterFactory::new));
        filters.put("concatenate_graph", ConcatenateGraphTokenFilterFactory::new);
        filters.put("condition", AnalysisPlugin.requiresAnalysisSettings((i, e, n, s) -> new ScriptedConditionTokenFilterFactory(i, n, s, (ScriptService)this.scriptService.get())));
        filters.put("decimal_digit", DecimalDigitFilterFactory::new);
        filters.put("delimited_payload_filter", LegacyDelimitedPayloadTokenFilterFactory::new);
        filters.put("delimited_payload", DelimitedPayloadTokenFilterFactory::new);
        filters.put("dictionary_decompounder", AnalysisPlugin.requiresAnalysisSettings(DictionaryCompoundWordTokenFilterFactory::new));
        filters.put("dutch_stem", DutchStemTokenFilterFactory::new);
        filters.put("edge_ngram", EdgeNGramTokenFilterFactory::new);
        filters.put("edgeNGram", (indexSettings, environment, name, settings) -> {
            deprecationLogger.deprecate("edgeNGram_deprecation", "The [edgeNGram] token filter name is deprecated and will be removed in a future version. Please change the filter name to [edge_ngram] instead.", new Object[0]);
            return new EdgeNGramTokenFilterFactory(indexSettings, environment, name, settings);
        });
        filters.put("elision", AnalysisPlugin.requiresAnalysisSettings(ElisionTokenFilterFactory::new));
        filters.put("fingerprint", FingerprintTokenFilterFactory::new);
        filters.put("flatten_graph", FlattenGraphTokenFilterFactory::new);
        filters.put("french_stem", FrenchStemTokenFilterFactory::new);
        filters.put("german_normalization", GermanNormalizationFilterFactory::new);
        filters.put("german_stem", GermanStemTokenFilterFactory::new);
        filters.put("hindi_normalization", HindiNormalizationFilterFactory::new);
        filters.put("hyphenation_decompounder", AnalysisPlugin.requiresAnalysisSettings(HyphenationCompoundWordTokenFilterFactory::new));
        filters.put("indic_normalization", IndicNormalizationFilterFactory::new);
        filters.put("keep", AnalysisPlugin.requiresAnalysisSettings(KeepWordFilterFactory::new));
        filters.put("keep_types", AnalysisPlugin.requiresAnalysisSettings(KeepTypesFilterFactory::new));
        filters.put("keyword_marker", AnalysisPlugin.requiresAnalysisSettings(KeywordMarkerTokenFilterFactory::new));
        filters.put("kstem", KStemTokenFilterFactory::new);
        filters.put("length", LengthTokenFilterFactory::new);
        filters.put("limit", LimitTokenCountFilterFactory::new);
        filters.put("lowercase", LowerCaseTokenFilterFactory::new);
        filters.put("min_hash", MinHashTokenFilterFactory::new);
        filters.put("multiplexer", MultiplexerTokenFilterFactory::new);
        filters.put("ngram", NGramTokenFilterFactory::new);
        filters.put("nGram", (indexSettings, environment, name, settings) -> {
            deprecationLogger.deprecate("nGram_deprecation", "The [nGram] token filter name is deprecated and will be removed in a future version. Please change the filter name to [ngram] instead.", new Object[0]);
            return new NGramTokenFilterFactory(indexSettings, environment, name, settings);
        });
        filters.put("pattern_capture", AnalysisPlugin.requiresAnalysisSettings(PatternCaptureGroupTokenFilterFactory::new));
        filters.put("pattern_replace", AnalysisPlugin.requiresAnalysisSettings(PatternReplaceTokenFilterFactory::new));
        filters.put("persian_normalization", PersianNormalizationFilterFactory::new);
        filters.put("porter_stem", PorterStemTokenFilterFactory::new);
        filters.put("predicate_token_filter", AnalysisPlugin.requiresAnalysisSettings((i, e, n, s) -> new PredicateTokenFilterScriptFactory(i, n, s, (ScriptService)this.scriptService.get())));
        filters.put("remove_duplicates", RemoveDuplicatesTokenFilterFactory::new);
        filters.put("reverse", ReverseTokenFilterFactory::new);
        filters.put("russian_stem", RussianStemTokenFilterFactory::new);
        filters.put("scandinavian_folding", ScandinavianFoldingFilterFactory::new);
        filters.put("scandinavian_normalization", ScandinavianNormalizationFilterFactory::new);
        filters.put("serbian_normalization", SerbianNormalizationFilterFactory::new);
        filters.put("snowball", SnowballTokenFilterFactory::new);
        filters.put("sorani_normalization", SoraniNormalizationFilterFactory::new);
        filters.put("stemmer_override", AnalysisPlugin.requiresAnalysisSettings(StemmerOverrideTokenFilterFactory::new));
        filters.put("stemmer", StemmerTokenFilterFactory::new);
        filters.put("synonym", AnalysisPlugin.requiresAnalysisSettings(SynonymTokenFilterFactory::new));
        filters.put("synonym_graph", AnalysisPlugin.requiresAnalysisSettings(SynonymGraphTokenFilterFactory::new));
        filters.put("trim", TrimTokenFilterFactory::new);
        filters.put("truncate", AnalysisPlugin.requiresAnalysisSettings(TruncateTokenFilterFactory::new));
        filters.put("unique", UniqueTokenFilterFactory::new);
        filters.put("uppercase", UpperCaseTokenFilterFactory::new);
        filters.put("word_delimiter_graph", WordDelimiterGraphTokenFilterFactory::new);
        filters.put("word_delimiter", WordDelimiterTokenFilterFactory::new);
        return filters;
    }

    public Map<String, AnalysisModule.AnalysisProvider<CharFilterFactory>> getCharFilters() {
        TreeMap<String, AnalysisModule.AnalysisProvider<CharFilterFactory>> filters = new TreeMap<String, AnalysisModule.AnalysisProvider<CharFilterFactory>>();
        filters.put("html_strip", HtmlStripCharFilterFactory::new);
        filters.put("pattern_replace", AnalysisPlugin.requiresAnalysisSettings(PatternReplaceCharFilterFactory::new));
        filters.put("mapping", AnalysisPlugin.requiresAnalysisSettings(MappingCharFilterFactory::new));
        return filters;
    }

    public Map<String, AnalysisModule.AnalysisProvider<TokenizerFactory>> getTokenizers() {
        TreeMap<String, AnalysisModule.AnalysisProvider<TokenizerFactory>> tokenizers = new TreeMap<String, AnalysisModule.AnalysisProvider<TokenizerFactory>>();
        tokenizers.put("simple_pattern", SimplePatternTokenizerFactory::new);
        tokenizers.put("simple_pattern_split", SimplePatternSplitTokenizerFactory::new);
        tokenizers.put("thai", ThaiTokenizerFactory::new);
        tokenizers.put("nGram", (indexSettings, environment, name, settings) -> {
            if (indexSettings.getIndexVersionCreated().onOrAfter((Version)LegacyESVersion.V_7_6_0)) {
                deprecationLogger.deprecate("nGram_tokenizer_deprecation", "The [nGram] tokenizer name is deprecated and will be removed in a future version. Please change the tokenizer name to [ngram] instead.", new Object[0]);
            }
            return new NGramTokenizerFactory(indexSettings, environment, name, settings);
        });
        tokenizers.put("ngram", NGramTokenizerFactory::new);
        tokenizers.put("edgeNGram", (indexSettings, environment, name, settings) -> {
            if (indexSettings.getIndexVersionCreated().onOrAfter((Version)LegacyESVersion.V_7_6_0)) {
                deprecationLogger.deprecate("edgeNGram_tokenizer_deprecation", "The [edgeNGram] tokenizer name is deprecated and will be removed in a future version. Please change the tokenizer name to [edge_ngram] instead.", new Object[0]);
            }
            return new EdgeNGramTokenizerFactory(indexSettings, environment, name, settings);
        });
        tokenizers.put("edge_ngram", EdgeNGramTokenizerFactory::new);
        tokenizers.put("char_group", CharGroupTokenizerFactory::new);
        tokenizers.put("classic", ClassicTokenizerFactory::new);
        tokenizers.put("letter", LetterTokenizerFactory::new);
        tokenizers.put("lowercase", XLowerCaseTokenizerFactory::new);
        tokenizers.put("path_hierarchy", PathHierarchyTokenizerFactory::new);
        tokenizers.put("PathHierarchy", PathHierarchyTokenizerFactory::new);
        tokenizers.put("pattern", PatternTokenizerFactory::new);
        tokenizers.put("uax_url_email", UAX29URLEmailTokenizerFactory::new);
        tokenizers.put("whitespace", WhitespaceTokenizerFactory::new);
        tokenizers.put("keyword", KeywordTokenizerFactory::new);
        return tokenizers;
    }

    public List<PreBuiltAnalyzerProviderFactory> getPreBuiltAnalyzerProviderFactories() {
        ArrayList<PreBuiltAnalyzerProviderFactory> analyzers = new ArrayList<PreBuiltAnalyzerProviderFactory>();
        analyzers.add(new PreBuiltAnalyzerProviderFactory("standard_html_strip", PreBuiltCacheFactory.CachingStrategy.OPENSEARCH, () -> new StandardHtmlStripAnalyzer(CharArraySet.EMPTY_SET)));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("pattern", PreBuiltCacheFactory.CachingStrategy.OPENSEARCH, () -> new PatternAnalyzer(Regex.compile((String)"\\W+", null), true, CharArraySet.EMPTY_SET)));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("snowball", PreBuiltCacheFactory.CachingStrategy.LUCENE, () -> new SnowballAnalyzer("English", EnglishAnalyzer.ENGLISH_STOP_WORDS_SET)));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("arabic", PreBuiltCacheFactory.CachingStrategy.LUCENE, ArabicAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("armenian", PreBuiltCacheFactory.CachingStrategy.LUCENE, ArmenianAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("basque", PreBuiltCacheFactory.CachingStrategy.LUCENE, BasqueAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("bengali", PreBuiltCacheFactory.CachingStrategy.LUCENE, BengaliAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("brazilian", PreBuiltCacheFactory.CachingStrategy.LUCENE, BrazilianAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("bulgarian", PreBuiltCacheFactory.CachingStrategy.LUCENE, BulgarianAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("catalan", PreBuiltCacheFactory.CachingStrategy.LUCENE, CatalanAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("chinese", PreBuiltCacheFactory.CachingStrategy.ONE, () -> new StandardAnalyzer(EnglishAnalyzer.ENGLISH_STOP_WORDS_SET)));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("cjk", PreBuiltCacheFactory.CachingStrategy.LUCENE, CJKAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("czech", PreBuiltCacheFactory.CachingStrategy.LUCENE, CzechAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("danish", PreBuiltCacheFactory.CachingStrategy.LUCENE, DanishAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("dutch", PreBuiltCacheFactory.CachingStrategy.LUCENE, DutchAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("english", PreBuiltCacheFactory.CachingStrategy.LUCENE, EnglishAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("estonian", PreBuiltCacheFactory.CachingStrategy.LUCENE, EstonianAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("finnish", PreBuiltCacheFactory.CachingStrategy.LUCENE, FinnishAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("french", PreBuiltCacheFactory.CachingStrategy.LUCENE, FrenchAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("galician", PreBuiltCacheFactory.CachingStrategy.LUCENE, GalicianAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("german", PreBuiltCacheFactory.CachingStrategy.LUCENE, GermanAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("greek", PreBuiltCacheFactory.CachingStrategy.LUCENE, GreekAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("hindi", PreBuiltCacheFactory.CachingStrategy.LUCENE, HindiAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("hungarian", PreBuiltCacheFactory.CachingStrategy.LUCENE, HungarianAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("indonesian", PreBuiltCacheFactory.CachingStrategy.LUCENE, IndonesianAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("irish", PreBuiltCacheFactory.CachingStrategy.LUCENE, IrishAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("italian", PreBuiltCacheFactory.CachingStrategy.LUCENE, ItalianAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("latvian", PreBuiltCacheFactory.CachingStrategy.LUCENE, LatvianAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("lithuanian", PreBuiltCacheFactory.CachingStrategy.LUCENE, LithuanianAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("norwegian", PreBuiltCacheFactory.CachingStrategy.LUCENE, NorwegianAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("persian", PreBuiltCacheFactory.CachingStrategy.LUCENE, PersianAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("portuguese", PreBuiltCacheFactory.CachingStrategy.LUCENE, PortugueseAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("romanian", PreBuiltCacheFactory.CachingStrategy.LUCENE, RomanianAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("russian", PreBuiltCacheFactory.CachingStrategy.LUCENE, RussianAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("sorani", PreBuiltCacheFactory.CachingStrategy.LUCENE, SoraniAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("spanish", PreBuiltCacheFactory.CachingStrategy.LUCENE, SpanishAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("swedish", PreBuiltCacheFactory.CachingStrategy.LUCENE, SwedishAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("turkish", PreBuiltCacheFactory.CachingStrategy.LUCENE, TurkishAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("thai", PreBuiltCacheFactory.CachingStrategy.LUCENE, ThaiAnalyzer::new));
        return analyzers;
    }

    public List<PreConfiguredCharFilter> getPreConfiguredCharFilters() {
        ArrayList<PreConfiguredCharFilter> filters = new ArrayList<PreConfiguredCharFilter>();
        filters.add(PreConfiguredCharFilter.singleton((String)"html_strip", (boolean)false, HTMLStripCharFilter::new));
        filters.add(PreConfiguredCharFilter.openSearchVersion((String)"htmlStrip", (boolean)false, (reader, version) -> {
            if (version.onOrAfter((Version)LegacyESVersion.V_6_3_0)) {
                deprecationLogger.deprecate("htmlStrip_deprecation", "The [htmpStrip] char filter name is deprecated and will be removed in a future version. Please change the filter name to [html_strip] instead.", new Object[0]);
            }
            return new HTMLStripCharFilter(reader);
        }));
        return filters;
    }

    public List<PreConfiguredTokenFilter> getPreConfiguredTokenFilters() {
        ArrayList<PreConfiguredTokenFilter> filters = new ArrayList<PreConfiguredTokenFilter>();
        filters.add(PreConfiguredTokenFilter.singleton((String)"apostrophe", (boolean)false, ApostropheFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"arabic_normalization", (boolean)true, ArabicNormalizationFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"arabic_stem", (boolean)false, ArabicStemFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"asciifolding", (boolean)true, ASCIIFoldingFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"bengali_normalization", (boolean)true, BengaliNormalizationFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"brazilian_stem", (boolean)false, BrazilianStemFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"cjk_bigram", (boolean)false, CJKBigramFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"cjk_width", (boolean)true, CJKWidthFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"classic", (boolean)false, ClassicFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"common_grams", (boolean)false, (boolean)false, input -> new CommonGramsFilter(input, CharArraySet.EMPTY_SET)));
        filters.add(PreConfiguredTokenFilter.singleton((String)"czech_stem", (boolean)false, CzechStemFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"decimal_digit", (boolean)true, DecimalDigitFilter::new));
        filters.add(PreConfiguredTokenFilter.openSearchVersion((String)"delimited_payload_filter", (boolean)false, (input, version) -> {
            if (version.onOrAfter((Version)LegacyESVersion.V_7_0_0)) {
                throw new IllegalArgumentException("[delimited_payload_filter] is not supported for new indices, use [delimited_payload] instead");
            }
            if (version.onOrAfter((Version)LegacyESVersion.V_6_2_0)) {
                deprecationLogger.deprecate("analysis_delimited_payload_filter", "Deprecated [delimited_payload_filter] used, replaced by [delimited_payload]", new Object[0]);
            }
            return new DelimitedPayloadTokenFilter(input, '|', DelimitedPayloadTokenFilterFactory.DEFAULT_ENCODER);
        }));
        filters.add(PreConfiguredTokenFilter.singleton((String)"delimited_payload", (boolean)false, input -> new DelimitedPayloadTokenFilter(input, '|', DelimitedPayloadTokenFilterFactory.DEFAULT_ENCODER)));
        filters.add(PreConfiguredTokenFilter.singleton((String)"dutch_stem", (boolean)false, input -> new SnowballFilter(input, (SnowballProgram)new DutchStemmer())));
        filters.add(PreConfiguredTokenFilter.singleton((String)"edge_ngram", (boolean)false, (boolean)false, input -> new EdgeNGramTokenFilter(input, 1)));
        filters.add(PreConfiguredTokenFilter.openSearchVersion((String)"edgeNGram", (boolean)false, (boolean)false, (reader, version) -> {
            if (version.onOrAfter((Version)LegacyESVersion.V_7_0_0)) {
                throw new IllegalArgumentException("The [edgeNGram] token filter name was deprecated in 6.4 and cannot be used in new indices. Please change the filter name to [edge_ngram] instead.");
            }
            deprecationLogger.deprecate("edgeNGram_deprecation", "The [edgeNGram] token filter name is deprecated and will be removed in a future version. Please change the filter name to [edge_ngram] instead.", new Object[0]);
            return new EdgeNGramTokenFilter(reader, 1);
        }));
        filters.add(PreConfiguredTokenFilter.singleton((String)"elision", (boolean)true, input -> new ElisionFilter(input, FrenchAnalyzer.DEFAULT_ARTICLES)));
        filters.add(PreConfiguredTokenFilter.singleton((String)"french_stem", (boolean)false, input -> new SnowballFilter(input, (SnowballProgram)new FrenchStemmer())));
        filters.add(PreConfiguredTokenFilter.singleton((String)"german_normalization", (boolean)true, GermanNormalizationFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"german_stem", (boolean)false, GermanStemFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"hindi_normalization", (boolean)true, HindiNormalizationFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"indic_normalization", (boolean)true, IndicNormalizationFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"keyword_repeat", (boolean)false, (boolean)false, KeywordRepeatFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"kstem", (boolean)false, KStemFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"length", (boolean)false, input -> new LengthFilter(input, 0, Integer.MAX_VALUE)));
        filters.add(PreConfiguredTokenFilter.singleton((String)"limit", (boolean)false, input -> new LimitTokenCountFilter(input, 1, false)));
        filters.add(PreConfiguredTokenFilter.singleton((String)"ngram", (boolean)false, (boolean)false, reader -> new NGramTokenFilter(reader, 1, 2, false)));
        filters.add(PreConfiguredTokenFilter.openSearchVersion((String)"nGram", (boolean)false, (boolean)false, (reader, version) -> {
            if (version.onOrAfter((Version)LegacyESVersion.V_7_0_0)) {
                throw new IllegalArgumentException("The [nGram] token filter name was deprecated in 6.4 and cannot be used in new indices. Please change the filter name to [ngram] instead.");
            }
            deprecationLogger.deprecate("nGram_deprecation", "The [nGram] token filter name is deprecated and will be removed in a future version. Please change the filter name to [ngram] instead.", new Object[0]);
            return new NGramTokenFilter(reader, 1, 2, false);
        }));
        filters.add(PreConfiguredTokenFilter.singleton((String)"persian_normalization", (boolean)true, PersianNormalizationFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"porter_stem", (boolean)false, PorterStemFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"reverse", (boolean)false, ReverseStringFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"russian_stem", (boolean)false, input -> new SnowballFilter(input, "Russian")));
        filters.add(PreConfiguredTokenFilter.singleton((String)"scandinavian_folding", (boolean)true, ScandinavianFoldingFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"scandinavian_normalization", (boolean)true, ScandinavianNormalizationFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"shingle", (boolean)false, (boolean)false, input -> {
            ShingleFilter ts = new ShingleFilter(input);
            ts.addAttribute(DisableGraphAttribute.class);
            return ts;
        }));
        filters.add(PreConfiguredTokenFilter.singleton((String)"snowball", (boolean)false, input -> new SnowballFilter(input, "English")));
        filters.add(PreConfiguredTokenFilter.singleton((String)"sorani_normalization", (boolean)true, SoraniNormalizationFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"stemmer", (boolean)false, PorterStemFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"stop", (boolean)false, input -> new StopFilter(input, EnglishAnalyzer.ENGLISH_STOP_WORDS_SET)));
        filters.add(PreConfiguredTokenFilter.singleton((String)"trim", (boolean)true, TrimFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"truncate", (boolean)false, input -> new TruncateTokenFilter(input, 10)));
        filters.add(PreConfiguredTokenFilter.singleton((String)"type_as_payload", (boolean)false, TypeAsPayloadTokenFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"unique", (boolean)false, UniqueTokenFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"uppercase", (boolean)true, UpperCaseFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"word_delimiter", (boolean)false, (boolean)false, input -> new WordDelimiterFilter(input, 451, null)));
        filters.add(PreConfiguredTokenFilter.openSearchVersion((String)"word_delimiter_graph", (boolean)false, (boolean)false, (input, version) -> {
            boolean adjustOffsets = version.onOrAfter((Version)LegacyESVersion.V_7_3_0);
            return new WordDelimiterGraphFilter(input, adjustOffsets, WordDelimiterIterator.DEFAULT_WORD_DELIM_TABLE, 451, null);
        }));
        return filters;
    }

    public List<PreConfiguredTokenizer> getPreConfiguredTokenizers() {
        ArrayList<PreConfiguredTokenizer> tokenizers = new ArrayList<PreConfiguredTokenizer>();
        tokenizers.add(PreConfiguredTokenizer.singleton((String)"keyword", KeywordTokenizer::new));
        tokenizers.add(PreConfiguredTokenizer.singleton((String)"classic", ClassicTokenizer::new));
        tokenizers.add(PreConfiguredTokenizer.singleton((String)"uax_url_email", UAX29URLEmailTokenizer::new));
        tokenizers.add(PreConfiguredTokenizer.singleton((String)"path_hierarchy", PathHierarchyTokenizer::new));
        tokenizers.add(PreConfiguredTokenizer.singleton((String)"letter", LetterTokenizer::new));
        tokenizers.add(PreConfiguredTokenizer.singleton((String)"whitespace", WhitespaceTokenizer::new));
        tokenizers.add(PreConfiguredTokenizer.singleton((String)"ngram", NGramTokenizer::new));
        tokenizers.add(PreConfiguredTokenizer.openSearchVersion((String)"edge_ngram", version -> {
            if (version.onOrAfter((Version)LegacyESVersion.V_7_3_0)) {
                return new EdgeNGramTokenizer(1, 2);
            }
            return new EdgeNGramTokenizer(1, 1);
        }));
        tokenizers.add(PreConfiguredTokenizer.singleton((String)"pattern", () -> new PatternTokenizer(Regex.compile((String)"\\W+", null), -1)));
        tokenizers.add(PreConfiguredTokenizer.singleton((String)"thai", ThaiTokenizer::new));
        tokenizers.add(PreConfiguredTokenizer.singleton((String)"lowercase", XLowerCaseTokenizer::new));
        tokenizers.add(PreConfiguredTokenizer.openSearchVersion((String)"nGram", version -> {
            if (version.onOrAfter((Version)LegacyESVersion.V_7_6_0)) {
                deprecationLogger.deprecate("nGram_tokenizer_deprecation", "The [nGram] tokenizer name is deprecated and will be removed in a future version. Please change the tokenizer name to [ngram] instead.", new Object[0]);
            }
            return new NGramTokenizer();
        }));
        tokenizers.add(PreConfiguredTokenizer.openSearchVersion((String)"edgeNGram", version -> {
            if (version.onOrAfter((Version)LegacyESVersion.V_7_6_0)) {
                deprecationLogger.deprecate("edgeNGram_tokenizer_deprecation", "The [edgeNGram] tokenizer name is deprecated and will be removed in a future version. Please change the tokenizer name to [edge_ngram] instead.", new Object[0]);
            }
            if (version.onOrAfter((Version)LegacyESVersion.V_7_3_0)) {
                return new EdgeNGramTokenizer(1, 2);
            }
            return new EdgeNGramTokenizer(1, 1);
        }));
        tokenizers.add(PreConfiguredTokenizer.singleton((String)"PathHierarchy", PathHierarchyTokenizer::new));
        return tokenizers;
    }
}

