/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.util;

import java.io.Closeable;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.get.GetResponse;
import org.opensearch.alerting.util.AlertingException;
import org.opensearch.alerting.util.ScheduledJobUtilsKt;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.alerting.model.Monitor;
import org.opensearch.commons.alerting.model.ScheduledJob;
import org.opensearch.commons.alerting.model.Workflow;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.rest.RestStatus;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/opensearch/alerting/util/ScheduledJobUtils;", "", "()V", "Companion", "opensearch-alerting"})
public final class ScheduledJobUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String WORKFLOW_DELEGATE_PATH = "workflow.inputs.composite_input.sequence.delegates";
    @NotNull
    public static final String WORKFLOW_MONITOR_PATH = "workflow.inputs.composite_input.sequence.delegates.monitor_id";

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/opensearch/alerting/util/ScheduledJobUtils$Companion;", "", "()V", "WORKFLOW_DELEGATE_PATH", "", "WORKFLOW_MONITOR_PATH", "parseMonitorFromScheduledJobDocSource", "Lorg/opensearch/commons/alerting/model/Monitor;", "xContentRegistry", "Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "response", "Lorg/opensearch/action/get/GetResponse;", "parseWorkflowFromScheduledJobDocSource", "Lorg/opensearch/commons/alerting/model/Workflow;", "opensearch-alerting"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @NotNull
        public final Workflow parseWorkflowFromScheduledJobDocSource(@NotNull NamedXContentRegistry xContentRegistry, @NotNull GetResponse response2) {
            Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
            Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
            Closeable closeable = (Closeable)XContentHelper.createParser((NamedXContentRegistry)xContentRegistry, (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)response2.getSourceAsBytesRef(), (MediaType)((MediaType)XContentType.JSON));
            Throwable throwable = null;
            try {
                block9: {
                    XContentParser xcp = (XContentParser)closeable;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)xcp, (String)"xcp");
                    String string = response2.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.id");
                    ScheduledJob workflow = ScheduledJob.Companion.parse(xcp, string, response2.getVersion());
                    if (!(workflow instanceof Workflow)) break block9;
                    Workflow workflow2 = (Workflow)workflow;
                    return workflow2;
                    {
                        catch (Exception e) {
                            throw new AlertingException("Unable to parse workflow from " + response2.getSource(), RestStatus.INTERNAL_SERVER_ERROR, e);
                        }
                    }
                }
                try {
                    ScheduledJobUtilsKt.access$getLog$p().error("Unable to parse workflow from " + response2.getSource());
                    throw new OpenSearchStatusException("Unable to parse workflow from " + response2.getSource(), RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @NotNull
        public final Monitor parseMonitorFromScheduledJobDocSource(@NotNull NamedXContentRegistry xContentRegistry, @NotNull GetResponse response2) {
            Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
            Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
            Closeable closeable = (Closeable)XContentHelper.createParser((NamedXContentRegistry)xContentRegistry, (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)response2.getSourceAsBytesRef(), (MediaType)((MediaType)XContentType.JSON));
            Throwable throwable = null;
            try {
                block9: {
                    XContentParser xcp = (XContentParser)closeable;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)xcp, (String)"xcp");
                    String string = response2.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.id");
                    ScheduledJob monitor = ScheduledJob.Companion.parse(xcp, string, response2.getVersion());
                    if (!(monitor instanceof Monitor)) break block9;
                    Monitor monitor2 = (Monitor)monitor;
                    return monitor2;
                    {
                        catch (Exception e) {
                            throw new AlertingException("Unable to parse monitor from " + response2.getSource(), RestStatus.INTERNAL_SERVER_ERROR, e);
                        }
                    }
                }
                try {
                    ScheduledJobUtilsKt.access$getLog$p().error("Unable to parse monitor from " + response2.getSource());
                    throw new OpenSearchStatusException("Unable to parse monitor from " + response2.getSource(), RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

